/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class ReflectionIncreaseAccessibility
extends OpcodeStackDetector {
    private boolean securityCheck = false;
    private boolean fieldNameUnderGet = false;
    private final BugAccumulator bugAccumulator;

    public ReflectionIncreaseAccessibility(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Method met) {
        this.securityCheck = false;
        super.visit(met);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        this.fieldNameUnderGet = false;
        if (seen != 182 || !this.getThisClass().isPublic() || !this.getMethod().isPublic()) {
            return;
        }
        OpcodeStack.Item obj = this.stack.getItemMethodInvokedOn(this);
        try {
            JavaClass cls = obj.getJavaClass();
            if (cls == null) {
                return;
            }
            XMethod met = this.getXMethodOperand();
            if (!this.securityCheck && obj.isInitialParameter() && obj.getXField() == null && "java.lang.Class".equals(cls.getClassName()) && "newInstance".equals(met.getName()) && "()Ljava/lang/Object;".equals(met.getSignature())) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "REFLC_REFLECTION_MAY_INCREASE_ACCESSIBILITY_OF_CLASS", 2).addClassAndMethod(this), this);
            } else if ("java.lang.Class".equals(cls.getClassName()) && "getDeclaredField".equals(met.getName()) && "(Ljava/lang/String;)Ljava/lang/reflect/Field;".equals(met.getSignature())) {
                OpcodeStack.Item param = this.stack.getStackItem(0);
                this.fieldNameUnderGet = param.isInitialParameter() && param.getXField() == null;
            } else if (!this.securityCheck && "java.lang.reflect.Field".equals(cls.getClassName()) && met.getName().startsWith("set")) {
                Boolean fieldIsFromParam = (Boolean)obj.getUserValue();
                if (fieldIsFromParam != null && fieldIsFromParam.booleanValue()) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "REFLF_REFLECTION_MAY_INCREASE_ACCESSIBILITY_OF_FIELD", 2).addClassAndMethod(this), this);
                }
            } else if ("java.lang.SecurityManager".equals(cls.getClassName()) && "checkPackageAccess".equals(met.getName()) && "(Ljava/lang/String;)V".equals(met.getSignature()) && this.getPackageName().equals((String)this.stack.getStackItem(0).getConstant())) {
                this.securityCheck = true;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
    }

    @Override
    public void afterOpcode(int seen) {
        super.afterOpcode(seen);
        if (this.fieldNameUnderGet) {
            this.stack.getStackItem(0).setUserValue(true);
        }
    }
}

