/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class SynchronizeOnClassLiteralNotGetClass
extends OpcodeStackDetector {
    BugReporter bugReporter;
    int state = 0;
    boolean seenPutStatic;
    boolean seenGetStatic;
    BugInstance pendingBug;

    public SynchronizeOnClassLiteralNotGetClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code code) {
        boolean interesting;
        boolean bl = interesting = !this.getMethod().isStatic() && !this.getThisClass().isFinal();
        if (interesting) {
            this.pendingBug = null;
            super.visit(code);
            assert (this.pendingBug == null);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.pendingBug != null) {
            if (seen == 179) {
                String thisClassName;
                String classConstantOperand = this.getClassConstantOperand();
                if (classConstantOperand.equals(thisClassName = ClassName.toSlashedClassName(this.getThisClass().getClassName()))) {
                    this.seenPutStatic = true;
                }
            } else if (seen == 178) {
                String thisClassName;
                String classConstantOperand = this.getClassConstantOperand();
                if (classConstantOperand.equals(thisClassName = ClassName.toSlashedClassName(this.getThisClass().getClassName()))) {
                    this.seenGetStatic = true;
                }
            } else if (seen == 195) {
                int priority = 3;
                if (this.seenPutStatic || this.seenGetStatic) {
                    --priority;
                }
                try {
                    Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                    Set<ClassDescriptor> directSubtypes = subtypes2.getDirectSubtypes(this.getClassDescriptor());
                    if (!directSubtypes.isEmpty()) {
                        for (ClassDescriptor sub : directSubtypes) {
                            this.pendingBug.addClass(sub).describe("CLASS_SUBCLASS");
                        }
                        --priority;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
                this.pendingBug.setPriority(priority);
                this.bugReporter.reportBug(this.pendingBug);
                this.pendingBug = null;
            }
            return;
        }
        switch (this.state) {
            case 0: {
                if (seen != 42) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 182 && "getClass".equals(this.getNameConstantOperand()) && "()Ljava/lang/Class;".equals(this.getSigConstantOperand())) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if (seen == 89) {
                    this.state = 3;
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (this.isRegisterStore()) {
                    this.state = 4;
                    break;
                }
                this.state = 0;
                break;
            }
            case 4: {
                if (seen == 194) {
                    this.pendingBug = new BugInstance(this, "WL_USING_GETCLASS_RATHER_THAN_CLASS_LITERAL", 2).addClassAndMethod(this).addSourceLine(this);
                }
                this.state = 0;
                this.seenPutStatic = false;
                this.seenGetStatic = false;
                break;
            }
        }
    }
}

