/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.commons.lang3.StringUtils;

public class ThrowingExceptions
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    private String exceptionThrown = null;

    public ThrowingExceptions(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        Optional<String> exception;
        ExceptionTable exceptionTable;
        String[] exceptions;
        this.exceptionThrown = null;
        if (obj.isSynthetic()) {
            return;
        }
        Stream<String> exceptionStream = null;
        String signature = obj.getGenericSignature();
        if (signature != null && (exceptions = StringUtils.substringsBetween((String)signature, (String)"^", (String)";")) != null) {
            exceptionStream = Arrays.stream(exceptions).filter(s -> s.charAt(0) == 'L').map(s -> ClassName.toDottedClassName(s.substring(1)));
        }
        if ((signature == null || exceptionStream == null) && (exceptionTable = obj.getExceptionTable()) != null) {
            exceptionStream = Arrays.stream(exceptionTable.getExceptionNames());
        }
        if (exceptionStream != null && (exception = exceptionStream.filter(s -> "java.lang.Exception".equals(s) || "java.lang.Throwable".equals(s)).findAny()).isPresent() && !this.parentThrows(this.getThisClass(), obj, exception.get())) {
            this.exceptionThrown = exception.get();
        }
        if (obj.getCode() == null && this.exceptionThrown != null) {
            this.reportBug("java.lang.Exception".equals(this.exceptionThrown) ? "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION" : "THROWS_METHOD_THROWS_CLAUSE_THROWABLE", this.getXMethod());
        }
    }

    @Override
    public void visitAfter(Code obj) {
        if (this.exceptionThrown != null) {
            this.reportBug("java.lang.Exception".equals(this.exceptionThrown) ? "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION" : "THROWS_METHOD_THROWS_CLAUSE_THROWABLE", this.getXMethod());
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 191) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            if (item != null && "Ljava/lang/RuntimeException;".equals(item.getSignature())) {
                this.bugReporter.reportBug(new BugInstance(this, "THROWS_METHOD_THROWS_RUNTIMEEXCEPTION", 3).addClass(this).addMethod(this.getXMethod()).addSourceLine(this));
            }
        } else if (this.exceptionThrown != null && (seen == 182 || seen == 185 || seen == 184)) {
            XMethod calledMethod = this.getXMethodOperand();
            if (calledMethod == null) {
                return;
            }
            String[] thrownExceptions = calledMethod.getThrownExceptions();
            if (thrownExceptions != null) {
                if (Arrays.stream(thrownExceptions).map(ClassName::toDottedClassName).anyMatch(this.exceptionThrown::equals)) {
                    this.exceptionThrown = null;
                }
            }
        }
    }

    private void reportBug(String bugName, XMethod method) {
        this.bugReporter.reportBug(new BugInstance(this, bugName, 3).addClass(this).addMethod(method));
    }

    private boolean parentThrows(@NonNull JavaClass clazz, @NonNull Method method, @DottedClassName String exception) {
        boolean throwsEx = false;
        try {
            JavaClass ancestor = clazz.getSuperClass();
            if (ancestor != null) {
                Optional<Method> superMethod = Arrays.stream(ancestor.getMethods()).filter(m -> method.getName().equals(m.getName()) && this.signatureMatches(method, (Method)m)).findAny();
                throwsEx = superMethod.isPresent() ? this.doesThrowException(superMethod.get(), exception) : this.parentThrows(ancestor, method, exception);
            }
            for (JavaClass intf : clazz.getInterfaces()) {
                Optional<Method> superMethod = Arrays.stream(intf.getMethods()).filter(m -> method.getName().equals(m.getName()) && this.signatureMatches(method, (Method)m)).findAny();
                if (superMethod.isPresent()) {
                    throwsEx |= this.doesThrowException(superMethod.get(), exception);
                    continue;
                }
                throwsEx |= this.parentThrows(intf, method, exception);
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return throwsEx;
    }

    private boolean doesThrowException(Method m, @DottedClassName String exception) {
        ExceptionTable exceptionTable = m.getExceptionTable();
        return exceptionTable != null && Arrays.asList(exceptionTable.getExceptionNames()).contains(exception);
    }

    private boolean signatureMatches(Method child, Method parent) {
        String genSig = parent.getGenericSignature();
        if (genSig == null) {
            return child.getSignature().equals(parent.getSignature());
        }
        String sig = child.getSignature();
        GenericSignatureParser genSP = new GenericSignatureParser(genSig);
        GenericSignatureParser sp = new GenericSignatureParser(sig);
        if (genSP.getNumParameters() != sp.getNumParameters()) {
            return false;
        }
        String[] gArgs = genSP.getArguments();
        String[] args = sp.getArguments();
        for (int i = 0; i < sp.getNumParameters(); ++i) {
            if (!(gArgs[i].charAt(0) == 'T' ? args[i].charAt(0) != 'L' : !gArgs[i].equals(args[i]))) continue;
            return false;
        }
        String gRet = genSP.getReturnTypeSignature();
        String ret = sp.getReturnTypeSignature();
        return gRet.charAt(0) == 'T' && ret.charAt(0) == 'L' || gRet.equals(ret);
    }
}

