/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Arrays;
import java.util.List;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Signature;

public class URLProblems
extends OpcodeStackDetector {
    private static final MethodDescriptor URL_EQUALS = new MethodDescriptor("java/net/URL", "equals", "(Ljava/lang/Object;)Z");
    private static final MethodDescriptor URL_HASHCODE = new MethodDescriptor("java/net/URL", "hashCode", "()I");
    static final String[] BAD_SIGNATURES = new String[]{"Hashtable<Ljava/net/URL", "Map<Ljava/net/URL", "Set<Ljava/net/URL"};
    private static final String[] HASHSET_KEY_METHODS = new String[]{"add", "contains", "remove"};
    private static final String[] HASHMAP_KEY_METHODS = new String[]{"containsKey", "get", "remove"};
    private static final String[] HASHMAP_TWO_ARG_KEY_METHODS = new String[]{"put"};
    private static final List<MethodDescriptor> methods = List.of(URL_EQUALS, URL_HASHCODE, new MethodDescriptor("", "add", "(Ljava/lang/Object;)Z"), new MethodDescriptor("", "contains", "(Ljava/lang/Object;)Z"), new MethodDescriptor("", "remove", "(Ljava/lang/Object;)Z"), new MethodDescriptor("", "containsKey", "(Ljava/lang/Object;)Z"), new MethodDescriptor("", "get", "(Ljava/lang/Object;)Ljava/lang/Object;"), new MethodDescriptor("", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;"), new MethodDescriptor("", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"));
    private final BugReporter bugReporter;
    private final BugAccumulator accumulator;
    private boolean hasInterestingMethodCalls;

    public URLProblems(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.hasInterestingMethodCalls = URLProblems.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), methods);
        super.visitClassContext(classContext);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.accumulator.reportAccumulatedBugs();
    }

    @Override
    public void visit(Code obj) {
        if (this.hasInterestingMethodCalls) {
            super.visit(obj);
        }
    }

    @Override
    public void visit(Signature obj) {
        String sig = obj.getSignature();
        for (String s : BAD_SIGNATURES) {
            if (sig.indexOf(s) < 0) continue;
            if (this.visitingField()) {
                this.bugReporter.reportBug(new BugInstance(this, "DMI_COLLECTION_OF_URLS", 1).addClass(this).addVisitedField(this));
                continue;
            }
            if (this.visitingMethod()) {
                this.bugReporter.reportBug(new BugInstance(this, "DMI_COLLECTION_OF_URLS", 1).addClassAndMethod(this));
                continue;
            }
            this.bugReporter.reportBug(new BugInstance(this, "DMI_COLLECTION_OF_URLS", 1).addClass(this).addClass(this));
        }
    }

    void check(String className, String[] methodNames, int target, int url) {
        if (Arrays.binarySearch(methodNames, this.getNameConstantOperand()) < 0) {
            return;
        }
        if (this.stack.getStackDepth() <= target) {
            return;
        }
        OpcodeStack.Item targetItem = this.stack.getStackItem(target);
        OpcodeStack.Item urlItem = this.stack.getStackItem(url);
        if (!"Ljava/net/URL;".equals(urlItem.getSignature())) {
            return;
        }
        if (!targetItem.getSignature().equals(className)) {
            return;
        }
        this.accumulator.accumulateBug(new BugInstance(this, "DMI_COLLECTION_OF_URLS", 1).addClassAndMethod(this).addCalledMethod(this), this);
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182 || seen == 185) {
            this.check("Ljava/util/HashSet;", HASHSET_KEY_METHODS, 1, 0);
            this.check("Ljava/util/HashMap;", HASHMAP_KEY_METHODS, 1, 0);
            this.check("Ljava/util/HashMap;", HASHMAP_TWO_ARG_KEY_METHODS, 2, 1);
        }
        if (seen == 182 && (this.getMethodDescriptorOperand().equals(URL_EQUALS) || this.getMethodDescriptorOperand().equals(URL_HASHCODE))) {
            this.accumulator.accumulateBug(new BugInstance(this, "DMI_BLOCKING_METHODS_ON_URL", 1).addClassAndMethod(this).addCalledMethod(this), this);
        }
    }
}

