/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.StringSetMatch;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugMatcher
implements Matcher {
    private static final Logger LOG = LoggerFactory.getLogger(BugMatcher.class);
    private final StringSetMatch codes;
    private final StringSetMatch patterns;
    private final StringSetMatch categories;

    public BugMatcher(String codes, String patterns, String categories) {
        this.codes = new StringSetMatch(codes);
        this.patterns = new StringSetMatch(patterns);
        this.categories = new StringSetMatch(categories);
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        boolean result1 = this.codes.match(bugInstance.getAbbrev());
        boolean result2 = this.patterns.match(bugInstance.getType());
        boolean result3 = this.categories.match(bugInstance.getBugPattern().getCategory());
        LOG.debug("Matching {}/{}/{} with {}, result = {}/{}/{}", new Object[]{bugInstance.getAbbrev(), bugInstance.getType(), bugInstance.getBugPattern().getCategory(), this, result1, result2, result3});
        return result1 || result2 || result3;
    }

    public int hashCode() {
        return this.codes.hashCode() + this.patterns.hashCode() + this.categories.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugMatcher)) {
            return false;
        }
        BugMatcher other = (BugMatcher)o;
        return this.codes.equals(other.codes) && this.patterns.equals(other.patterns) && this.categories.equals(other.categories);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        xmlOutput.startTag("Bug");
        if (disabled) {
            xmlOutput.addAttribute("disabled", "true");
        }
        this.addAttribute(xmlOutput, "code", this.codes);
        this.addAttribute(xmlOutput, "pattern", this.patterns);
        this.addAttribute(xmlOutput, "category", this.categories);
        xmlOutput.stopTag(true);
    }

    public void addAttribute(XMLOutput xmlOutput, String name, StringSetMatch matches) throws IOException {
        String value = matches.toString();
        if (!value.isEmpty()) {
            xmlOutput.addAttribute(name, value);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Bug(");
        if (!this.codes.isEmpty()) {
            buf.append("code = \"").append(this.codes).append("\" ");
        }
        if (!this.patterns.isEmpty()) {
            buf.append("pattern = \"").append(this.patterns).append("\" ");
        }
        if (!this.categories.isEmpty()) {
            buf.append("category = \"").append(this.categories).append("\" ");
        }
        buf.setLength(buf.length() - 1);
        buf.append(")");
        return buf.toString();
    }
}

