/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.graph.Graph;
import edu.umd.cs.findbugs.graph.GraphEdge;
import edu.umd.cs.findbugs.graph.GraphToolkit;
import edu.umd.cs.findbugs.graph.GraphVertex;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class Transpose<GraphType extends Graph<EdgeType, VertexType>, EdgeType extends GraphEdge<EdgeType, VertexType>, VertexType extends GraphVertex<VertexType>> {
    private final IdentityHashMap<VertexType, VertexType> m_origToTransposeMap = new IdentityHashMap();
    private final IdentityHashMap<VertexType, VertexType> m_transposeToOrigMap = new IdentityHashMap();

    public GraphType transpose(GraphType orig, GraphToolkit<GraphType, EdgeType, VertexType> toolkit) {
        GraphType trans = toolkit.createGraph();
        Iterator<Object> i = orig.vertexIterator();
        while (i.hasNext()) {
            GraphVertex v = (GraphVertex)i.next();
            GraphVertex dupVertex = toolkit.duplicateVertex(v);
            dupVertex.setLabel(v.getLabel());
            trans.addVertex((GraphVertex)v);
            this.m_origToTransposeMap.put(v, dupVertex);
            this.m_transposeToOrigMap.put(dupVertex, v);
        }
        trans.setNumVertexLabels(orig.getNumVertexLabels());
        i = orig.edgeIterator();
        while (i.hasNext()) {
            GraphEdge e = (GraphEdge)i.next();
            GraphVertex transSource = (GraphVertex)this.m_origToTransposeMap.get(e.getTarget());
            GraphVertex transTarget = (GraphVertex)this.m_origToTransposeMap.get(e.getSource());
            Object dupEdge = trans.createEdge((GraphVertex)transSource, (GraphVertex)transTarget);
            dupEdge.setLabel(e.getLabel());
            toolkit.copyEdge(e, (GraphEdge)dupEdge);
        }
        trans.setNumEdgeLabels(orig.getNumEdgeLabels());
        return trans;
    }

    public VertexType getTransposedGraphVertex(VertexType v) {
        return (VertexType)((GraphVertex)this.m_origToTransposeMap.get(v));
    }

    public VertexType getOriginalGraphVertex(VertexType v) {
        return (VertexType)((GraphVertex)this.m_transposeToOrigMap.get(v));
    }
}

