/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.ApplyNewFilter;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.FilterFromBugPicker;
import edu.umd.cs.findbugs.gui2.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewFilterFromBug
extends FBDialog {
    private static final List<NewFilterFromBug> listOfAllFrames = new ArrayList<NewFilterFromBug>();

    public NewFilterFromBug(FilterFromBugPicker filterFromBugPicker, ApplyNewFilter applyNewFilter) {
        this.setModal(true);
        listOfAllFrames.add(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Filter out all bugs whose..."), "North");
        JPanel center = filterFromBugPicker.pickerPanel();
        this.add((Component)center, "Center");
        JPanel south = new JPanel();
        JButton okButton = new JButton(L10N.getLocalString("dlg.ok_btn", "OK"));
        okButton.addActionListener(evt -> {
            Matcher matcherFromSelection = filterFromBugPicker.makeMatcherFromSelection();
            applyNewFilter.fromMatcher(matcherFromSelection);
            this.closeDialog();
        });
        JButton cancelButton = new JButton(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
        cancelButton.addActionListener(evt -> this.closeDialog());
        GuiUtil.addOkAndCancelButtons(south, okButton, cancelButton);
        this.add((Component)south, "South");
        this.pack();
        this.setVisible(true);
    }

    private final void closeDialog() {
        this.dispose();
    }

    static void closeAll() {
        for (NewFilterFromBug frame : listOfAllFrames) {
            frame.dispose();
        }
        listOfAllFrames.clear();
    }
}

