/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import edu.umd.cs.findbugs.BugRankCategory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.cwe.WeaknessSeverity;

enum Level {
    WARNING,
    ERROR,
    NOTE,
    NONE;


    public String toJsonString() {
        return this.name().toLowerCase();
    }

    @NonNull
    static Level fromBugRank(int bugRank) {
        BugRankCategory category = BugRankCategory.getRank(bugRank);
        switch (category) {
            case SCARIEST: 
            case SCARY: {
                return ERROR;
            }
            case TROUBLING: {
                return WARNING;
            }
            case OF_CONCERN: {
                return NOTE;
            }
        }
        throw new IllegalArgumentException("Illegal bugRank given: " + bugRank);
    }

    @NonNull
    static Level fromWeaknessSeverity(WeaknessSeverity severity) {
        switch (severity) {
            case HIGH: {
                return ERROR;
            }
            case MEDIUM: {
                return WARNING;
            }
            case LOW: {
                return NOTE;
            }
        }
        return NONE;
    }
}

