/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.cwe.WeaknessCatalog;
import edu.umd.cs.findbugs.sarif.GUIDCalculator;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

final class Rule {
    @NonNull
    final String id;
    @NonNull
    final String shortDescription;
    @NonNull
    final String fullDescription;
    @NonNull
    final String defaultText;
    @Nullable
    final URI helpUri;
    @NonNull
    final List<String> tags;
    @NonNull
    final int cweid;

    Rule(@NonNull String id, @NonNull String shortDescription, @NonNull String fullDescription, @NonNull String defaultText, @Nullable URI helpUri, @NonNull List<String> tags, @NonNull int cweid) {
        this.id = Objects.requireNonNull(id);
        this.shortDescription = Objects.requireNonNull(shortDescription);
        this.fullDescription = Objects.requireNonNull(fullDescription);
        this.defaultText = Objects.requireNonNull(defaultText);
        this.helpUri = helpUri;
        this.tags = Collections.unmodifiableList(tags);
        this.cweid = cweid;
    }

    JsonObject toJsonObject() {
        Object textEndsWithPeriod = this.defaultText.endsWith(".") ? this.defaultText : this.defaultText + ".";
        Object shortDescriptionEndsWithPeriod = this.shortDescription.endsWith(".") ? this.shortDescription : this.shortDescription + ".";
        JsonObject textJson = new JsonObject();
        textJson.addProperty("text", (String)textEndsWithPeriod);
        JsonObject shortDescJson = new JsonObject();
        shortDescJson.addProperty("text", (String)shortDescriptionEndsWithPeriod);
        JsonObject messageStrings = new JsonObject();
        messageStrings.add("default", (JsonElement)textJson);
        JsonObject result = new JsonObject();
        result.addProperty("id", this.id);
        result.add("shortDescription", (JsonElement)shortDescJson);
        result.add("messageStrings", (JsonElement)messageStrings);
        if (this.helpUri != null) {
            result.addProperty("helpUri", this.helpUri.toString());
        }
        if (!this.tags.isEmpty()) {
            JsonArray propertyArray = new JsonArray();
            this.tags.forEach(arg_0 -> ((JsonArray)propertyArray).add(arg_0));
            JsonObject propertyBag = new JsonObject();
            propertyBag.add("tags", (JsonElement)propertyArray);
            result.add("properties", (JsonElement)propertyBag);
        }
        if (this.cweid > 0) {
            JsonArray relationships = new JsonArray();
            relationships.add((JsonElement)this.createCweRelationship());
            result.add("relationships", (JsonElement)relationships);
        }
        return result;
    }

    private JsonObject createCweRelationship() {
        WeaknessCatalog weaknessCatalog = WeaknessCatalog.getInstance();
        String cweId = String.valueOf(this.cweid);
        String name = weaknessCatalog.getName();
        String version = weaknessCatalog.getVersion();
        UUID guidOfCweTaxonomy = GUIDCalculator.fromString(name + version);
        UUID guidOfCweTaxon = GUIDCalculator.fromNamespaceAndString(guidOfCweTaxonomy, cweId.toString());
        JsonObject cweRelationship = new JsonObject();
        JsonObject target = new JsonObject();
        target.addProperty("id", cweId);
        target.addProperty("guid", guidOfCweTaxon.toString());
        JsonObject toolComponent = new JsonObject();
        toolComponent.addProperty("name", name);
        toolComponent.addProperty("guid", guidOfCweTaxonomy.toString());
        target.add("toolComponent", (JsonElement)toolComponent);
        JsonArray kinds = new JsonArray();
        kinds.add("superset");
        cweRelationship.add("target", (JsonElement)target);
        cweRelationship.add("kinds", (JsonElement)kinds);
        return cweRelationship;
    }

    @NonNull
    static Rule fromBugPattern(BugPattern bugPattern, String formattedMessage) {
        URI helpUri = bugPattern.getUri().orElse(null);
        String category = bugPattern.getCategory();
        List<Object> tags = StringUtils.isEmpty((CharSequence)category) ? Collections.emptyList() : Collections.singletonList(category);
        return new Rule(bugPattern.getType(), bugPattern.getShortDescription(), bugPattern.getDetailText(), formattedMessage, helpUri, tags, bugPattern.getCWEid());
    }
}

