/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.util.JavaWebStart;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class LaunchBrowser {
    private static Pattern validExec = Pattern.compile("[a-zA-Z0-9-_/]+");
    public static final String execCommand = SystemProperties.getProperty("findbugs.execCommand");
    public static final boolean launchViaExec = execCommand != null && validExec.matcher(execCommand).matches() && "Linux".equals(SystemProperties.getProperty("os.name"));
    private static Object desktopObject;
    private static Method desktopBrowseMethod;
    private static boolean launchViaExecFailed;
    static boolean DEBUG;
    static final Exception desktopException;

    static boolean desktopFeasible() {
        return desktopObject != null && desktopBrowseMethod != null;
    }

    static boolean webstartFeasible() {
        return JavaWebStart.jnlpShowDocumentMethod != null && JavaWebStart.jnlpBasicService != null;
    }

    static boolean showDocumentViaDesktop(URL u) {
        if (desktopObject != null && desktopBrowseMethod != null) {
            try {
                if (DEBUG) {
                    JOptionPane.showMessageDialog(null, "Trying desktop browse");
                }
                LaunchBrowser.viaDesktop(u.toURI());
                if (DEBUG) {
                    JOptionPane.showMessageDialog(null, "desktop browse succeeded");
                }
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return false;
    }

    static void viaDesktop(URI u) throws IllegalAccessException, InvocationTargetException {
        if (desktopBrowseMethod == null) {
            throw new UnsupportedOperationException("Launch via desktop not available");
        }
        desktopBrowseMethod.invoke(desktopObject, u);
    }

    static boolean showDocumentViaExec(URL url) {
        if (launchViaExec && !launchViaExecFailed) {
            if (DEBUG) {
                JOptionPane.showMessageDialog(null, "Trying exec browse");
            }
            try {
                Process p = LaunchBrowser.launchViaExec(url);
                Thread.sleep(90L);
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    launchViaExecFailed = true;
                    if (DEBUG) {
                        JOptionPane.showMessageDialog(null, "exec browse launch failed with exit code " + exitValue);
                    }
                    return false;
                }
                if (DEBUG) {
                    JOptionPane.showMessageDialog(null, "exec browse succeeded");
                }
                return true;
            }
            catch (IllegalThreadStateException e) {
                if (DEBUG) {
                    JOptionPane.showMessageDialog(null, "exec browse succeeded but not done");
                }
                return true;
            }
            catch (Exception e) {
                if (DEBUG) {
                    JOptionPane.showMessageDialog(null, "exec browse failed" + e.getMessage());
                }
                launchViaExecFailed = true;
            }
        }
        return false;
    }

    static Process launchViaExec(URL url) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(execCommand, url.toString());
        return builder.start();
    }

    public static boolean showDocument(URL url) {
        return LaunchBrowser.showDocumentViaDesktop(url) || LaunchBrowser.showDocumentViaExec(url) || JavaWebStart.showViaWebStart(url);
    }

    static {
        launchViaExecFailed = false;
        DEBUG = SystemProperties.getBoolean("findbugs.launchBrowser.debug");
        Exception toStore = null;
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            desktopObject = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopBrowseMethod = desktopClass.getMethod("browse", URI.class);
        }
        catch (Exception e) {
            toStore = e;
        }
        desktopException = toStore;
    }
}

