# tactical-exploitation
[![](https://img.shields.io/github/stars/0xdea/tactical-exploitation.svg?style=flat&color=yellow)](https://github.com/0xdea/tactical-exploitation)
[![](https://img.shields.io/github/forks/0xdea/tactical-exploitation.svg?style=flat&color=green)](https://github.com/0xdea/tactical-exploitation)
[![](https://img.shields.io/github/watchers/0xdea/tactical-exploitation.svg?style=flat&color=red)](https://github.com/0xdea/tactical-exploitation)
[![](https://img.shields.io/badge/twitter-%400xdea-blue.svg)](https://twitter.com/0xdea)
[![](https://img.shields.io/badge/mastodon-%40raptor-purple.svg)](https://infosec.exchange/@raptor)

> "The Other Way to Pen-Test" 
>
> -- HD Moore & Valsmith

I've always been a big proponent of a tactical approach to penetration testing that does not focus on exploiting known software vulnerabilities, but relies on old school techniques such as information gathering and brute force. While being able to appreciate the occasional usefulness of a well-timed 0day, as a veteran penetration tester I favor an exploit-less approach. Tactical exploitation provides a smoother and more reliable way of compromising targets by leveraging process vulnerabilities, while minimizing attack detection and other undesired side effects.

This repository aims to provide a tactical exploitation toolkit to assist penetration testers during their assignments. The tools currently released are described below. See also http://www.0xdeadbeef.info/ for some older tools and techniques.

Related blog posts:  
https://web.archive.org/web/20200509050017/https://techblog.mediaservice.net/2017/10/in-praise-of-tactical-exploitation/  
https://web.archive.org/web/20200702153318/https://techblog.mediaservice.net/2017/11/how-a-unix-hacker-discovered-the-windows-powershell/  
https://hnsecurity.it/blog/letme-go-a-minimalistic-meterpreter-stager-written-in-go/  
https://hnsecurity.it/blog/learning-rust-for-fun-and-backdoo-rs/

See also:  
https://github.com/0xdea/backdoo-rs  

*These tools are proofs of concept. They are functional but may be buggy or incomplete. Use at your own risk.*

## easywin.py

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/easywin.jpg)

Easywin is a Python script that provides a toolkit for exploit-less attacks aimed at Windows and Active Directory environments, by leveraging information gathering and brute force capabilities against the SMB protocol.

## letmein.ps1

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/letmein.jpg)

Letmein is a pure PowerShell implementation of the staging protocols used by the Metasploit Framework. Start an exploit/multi/handler (Generic Payload Handler) instance on your attack box configured to handle one of the supported Meterpreter payloads, run letmein.ps1 (ideally as Administrator) on a compromised Windows box, and wait for your session. This technique is quite effective in order to bypass the antivirus and obtain a Meterpreter shell on Windows. An alternative Python implementation is also provided for educational purposes, however its use is not recommended in the field.

## letme.go

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/letmego.png)

Letme.go is a minimalistic Go implementation of the main staging protocols used by the Metasploit Framework. Start an exploit/multi/handler instance on the attack box configured to handle one of the supported Meterpreter payloads, run letme.exe on the target Windows system, and enjoy your session! See also [backdoor-rs](https://github.com/0xdea/backdoo-rs) for a Rust variant.

## poriluk.py

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/poriluk.png)

Poriluk is a helper script that provides a comfortable interface to exploit common information leakage vulnerabilities. At the moment, the following attacks are supported: dictionary-based user enumeration via SMTP VRFY/EXPN/RCPT and HTTP Apache mod_userdir.

## botshot.py

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/botshot.png)

Botshot is a Python script that captures screenshots of websites from the command line. It is useful to automate mapping of the web attack surface of large networks.

## verbal.py

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/verbal.jpg)

Verbal is a HTTP request method security scanner. It tries a series of interesting HTTP methods against a list of website paths, in order to determine which methods are available and accessible. The following HTTP methods are currently supported: GET, OPTIONS, TRACE, DEBUG, PUT.

## netdork.py

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/netdork.jpg)

Netdork is a Python script that uses the Google Custom Search Engine API to collect interesting information on public networks and stealthily map the available attack surface. The following attacks are supported: network search sweep based on target CIDRs and subdomain discovery via search engine.

## seitan.py

![](https://raw.githubusercontent.com/0xdea/tactical-exploitation/master/img/seitan.jpg)

Seitan is a Python script that uses the Shodan.io API search to collect open source intelligence on targets. The following attacks are currently supported: ipaddr (view all available information for an IP address) and domain (search services related to a domain or host name).
