
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/triton" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/tritonTargets.cmake")

set(TRITON_ARCHIVE              "/usr/lib/libtriton.a")
set(TRITON_BITWUZLA_INTERFACE   OFF)
set(TRITON_BOOST_INTERFACE      OFF)
set(TRITON_BUILD_SHARED_LIBS    ON)
set(TRITON_INCLUDE_DIRS         "/usr/include")
set(TRITON_INSTALL_PREFIX       /usr)
set(TRITON_LIBRARIES            "triton;;z3;;;capstone")
set(TRITON_LIBRARY              "/usr/lib/libtriton.so")
set(TRITON_LLVM_INTERFACE       OFF)
set(TRITON_MSVC_STATIC          OFF)
set(TRITON_PYTHON_BINDINGS      ON)
set(TRITON_VERSION              1.0)
set(TRITON_Z3_INTERFACE         ON)

message(STATUS "Found Triton: ${CMAKE_CURRENT_LIST_DIR}/tritonConfig.cmake (found version ${TRITON_VERSION})")

include(CMakeFindDependencyMacro)

# Boost includes
if (TRITON_BOOST_INTERFACE)
  find_dependency(Boost)
endif()

# Triton include
include_directories("/usr/include")
link_directories(BEFORE "/usr/lib")

# Capstone include
include_directories("/usr/include;/usr/include")
link_directories(BEFORE "/usr/lib")

# Python include directories
if (TRITON_PYTHON_BINDINGS)
    include_directories("")
    link_directories(BEFORE "")
endif()

# LLVM include and lib directories
if (TRITON_LLVM_INTERFACE)
    include_directories("")
    link_directories(BEFORE "")
endif()

# Z3 include directories
if (TRITON_Z3_INTERFACE)
    include_directories("/usr/include;/usr/include")
    link_directories(BEFORE "/usr/lib")
endif()

# Bitwuzla include directories
if (TRITON_BITWUZLA_INTERFACE)
    include_directories("")
    link_directories(BEFORE "")
endif()
