# frozen_string_literal: true

Sequel.migration do
  up do
    create_table :credentials do
      primary_key :id
      foreign_key :workspace_id, :workspaces

      column :username, :string, size: 250
      column :password, :string, size: 250
      column :host, :string, size: 250, null: false
      column :port, :int, null: false
      column :created_at, :datetime
    end
  end

  down do
    drop_table :credentials
  end
end
