# frozen_string_literal: true

module Wpxf
  module Utility
    # A URL inflater for module references.
    class ReferenceInflater
      # Initializes a new {ReferenceInflater}.
      # @param type [String] the reference type identifier.
      # @raise [ArgumentError] if the reference type identifier is not recognised.
      def initialize(type)
        raise ArgumentError, 'Unrecognised reference type' unless format_strings.key?(type)
        @type = type
      end

      # Generate the full reference URL from its identifier.
      # @param id [Object] the reference ID.
      # @return [String] the reference URL.
      def inflate(id)
        format(format_strings[@type], id.to_s)
      end

      # @return [Hash] the format strings for each reference type identifier.
      def format_strings
        {
          'WPVDB' => 'https://wpvulndb.com/vulnerabilities/%s',
          'OSVDB' => 'http://www.osvdb.org/%s',
          'CVE'   => 'http://www.cvedetails.com/cve/CVE-%s',
          'EDB'   => 'https://www.exploit-db.com/exploits/%s',
          'URL'   => '%s'
        }
      end
    end
  end
end
