# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::ModuleInfo do
  let(:subject) { (Class.new { include Wpxf::ModuleInfo }).new }

  before :each do
    subject.update_info(
      name: 'a',
      desc: 'c',
      author: %w(b d),
      date: '2016-01-01',
      references: [['URL', '127.0.0.1']]
    )
  end

  describe '#update_info' do
    it 'raises an error if name, desc, author or date are missing' do
      expect { subject.class.new.update_info({}) }.to raise_error(
        'Missing one or more required module info keys'
      )
    end

    it 'does not require name, desc author or date if they\'ve already been specified' do
      expect(subject.update_info({})).to be_a Hash
    end
  end

  describe '#module_name' do
    it 'returns the name value passed to #update_info' do
      expect(subject.module_name).to eq 'a'
    end
  end

  describe '#module_desc' do
    it 'returns the desc value passed to #update_info' do
      expect(subject.module_desc).to eq 'c'
    end
  end

  describe '#module_references' do
    it 'returns the references value passed to #update_info' do
      expect(subject.module_references).to eq [['URL', '127.0.0.1']]
    end
  end

  describe '#module_author' do
    it 'returns the author value passed to #update_info' do
      expect(subject.module_author).to eq %w(b d)
    end
  end

  describe '#module_date' do
    it 'returns the date value passed to #update_info' do
      expect(subject.module_date).to eq Date.parse('2016-01-01')
    end
  end
end
