package wlgmod::odt;

# OpenOffice word extract plugin

sub init {
    if(!eval "use OpenOffice::OODoc; 1") {
        return "Canont find module OpenOffice::OODoc (http://www.cpan.org/modules/index.html)";
    }
    else {
        return ""; # ok                                                                                    
    }
}
 
sub get_words {
    my $this = shift;
    my $filename = shift;
    my @words;

    my $doc = ooDocument(file => $filename) || die "Cannot open $filename: $!";
    my $text = $doc->getTextContent;

    foreach($text) {
	my @list = split (/\s/,$_);
	foreach my $word (@list) {
	    chomp $word;
	    $word =~ s/\s+//mg;
	    $word =~ s/[,.;:?]+//mg;

	    if($word ne "") {
                push @words, $word;
	    }
	}
    }

    return (@words);
}

1;
