# This file was automatically generated by bifcl from types.bif.

export {
##! Declaration of various types that the Zeek core uses internally.

type rpc_status: enum  {
	RPC_SUCCESS,
	RPC_PROG_UNAVAIL,
	RPC_PROG_MISMATCH,
	RPC_PROC_UNAVAIL,
	RPC_GARBAGE_ARGS,
	RPC_SYSTEM_ERR,
	RPC_TIMEOUT,
	RPC_VERS_MISMATCH,
	RPC_AUTH_ERROR,
	RPC_UNKNOWN_ERROR,
} ;


module MOUNT3;


type proc_t: enum  { 
	PROC_NULL = 0,  
	PROC_MNT = 1,  
	PROC_DUMP = 2,  
	PROC_UMNT = 3,  
	PROC_UMNT_ALL = 4,  
	PROC_EXPORT = 5,  
	PROC_END_OF_PROCS = 6,	
} ;


type status_t: enum  { 
	MNT3_OK = 0,
	MNT3ERR_PERM = 1,
	MNT3ERR_NOENT = 2,
	MNT3ERR_IO = 5,
	MNT3ERR_ACCES = 13,
	MNT3ERR_NOTDIR = 20,
	MNT3ERR_INVAL = 22,
	MNT3ERR_NAMETOOLONG = 63,
	MNT3ERR_NOTSUPP = 10004,
	MNT3ERR_SERVERFAULT = 10006,
	MOUNT3ERR_UNKNOWN = 0xffffffff,
} ;


type auth_flavor_t: enum  { 
	AUTH_NULL = 0,
	AUTH_UNIX = 1,
	AUTH_SHORT = 2,
	AUTH_DES = 3,
} ;






module NFS3;


type proc_t: enum  {	
	PROC_NULL = 0,	
	PROC_GETATTR = 1,	
	PROC_SETATTR = 2,	
	PROC_LOOKUP = 3,	
	PROC_ACCESS = 4,	
	PROC_READLINK = 5,	
	PROC_READ = 6,	
	PROC_WRITE = 7,	
	PROC_CREATE = 8,	
	PROC_MKDIR = 9,	
	PROC_SYMLINK = 10,	
	PROC_MKNOD = 11,	
	PROC_REMOVE = 12,	
	PROC_RMDIR = 13,	
	PROC_RENAME = 14,	
	PROC_LINK = 15,	
	PROC_READDIR = 16,	
	PROC_READDIRPLUS = 17,	
	PROC_FSSTAT = 18,	
	PROC_FSINFO = 19,	
	PROC_PATHCONF = 20,	
	PROC_COMMIT = 21,	
	PROC_END_OF_PROCS = 22,	
} ;


type status_t: enum  {	
	NFS3ERR_OK = 0,
	NFS3ERR_PERM = 1,
	NFS3ERR_NOENT = 2,
	NFS3ERR_IO = 5,
	NFS3ERR_NXIO = 6,
	NFS3ERR_ACCES = 13,
	NFS3ERR_EXIST = 17,
	NFS3ERR_XDEV = 18,
	NFS3ERR_NODEV = 19,
	NFS3ERR_NOTDIR = 20,
	NFS3ERR_ISDIR = 21,
	NFS3ERR_INVAL = 22,
	NFS3ERR_FBIG = 27,
	NFS3ERR_NOSPC = 28,
	NFS3ERR_ROFS = 30,
	NFS3ERR_MLINK = 31,
	NFS3ERR_NAMETOOLONG = 63,
	NFS3ERR_NOTEMPTY = 66,
	NFS3ERR_DQUOT = 69,
	NFS3ERR_STALE = 70,
	NFS3ERR_REMOTE = 71,
	NFS3ERR_BADHANDLE = 10001,
	NFS3ERR_NOT_SYNC = 10002,
	NFS3ERR_BAD_COOKIE = 10003,
	NFS3ERR_NOTSUPP = 10004,
	NFS3ERR_TOOSMALL = 10005,
	NFS3ERR_SERVERFAULT = 10006,
	NFS3ERR_BADTYPE = 10007,
	NFS3ERR_JUKEBOX = 10008,
	NFS3ERR_UNKNOWN = 0xffffffff,
} ;


type time_how_t: enum  {
	DONT_CHANGE = 0,
	SET_TO_SERVER_TIME = 1,
	SET_TO_CLIENT_TIME = 2,
} ;


type file_type_t: enum  {
	FTYPE_REG = 1,
	FTYPE_DIR = 2,
	FTYPE_BLK = 3,
	FTYPE_CHR = 4,
	FTYPE_LNK = 5,
	FTYPE_SOCK = 6,
	FTYPE_FIFO = 7,
} ;



type stable_how_t: enum  {
	UNSTABLE = 0,
	DATA_SYNC = 1,
	FILE_SYNC = 2,
} ;


type createmode_t: enum  {
	UNCHECKED = 0,
	GUARDED = 1,
	EXCLUSIVE = 2,
} ;

































module GLOBAL;

















module Tunnel;

type Type: enum  {
	NONE,
	IP,
	AYIYA,
	TEREDO,
	SOCKS,
	GTPv1,
	HTTP,
	GRE,
	VXLAN,
	GENEVE,
} ;




module GLOBAL;


type link_encap: enum  {
	LINK_ETHERNET,
	LINK_UNKNOWN,
} ;


type layer3_proto: enum  {
	L3_IPV4,
	L3_IPV6,
	L3_ARP,
	L3_UNKNOWN,
} ;
















type TableChange: enum  {
	TABLE_ELEMENT_NEW,
	TABLE_ELEMENT_CHANGED,
	TABLE_ELEMENT_REMOVED,
	TABLE_ELEMENT_EXPIRED,
} ;


module Reporter;


type Level: enum  {
	INFO = 0,
	WARNING = 1,
	ERROR = 2,
} ;


module AF_Packet;


## Available fanout modes.
type FanoutMode: enum  {
	FANOUT_HASH, 
	FANOUT_CPU,  
	FANOUT_QM,   
	FANOUT_CBPF, 
	FANOUT_EBPF, 
} ;


## Available checksum validation modes.
type ChecksumMode: enum  {
	## Ignore checksums, i.e. always assume they are correct.
	CHECKSUM_OFF,
	## Let Zeek compute and verify checksums.
	CHECKSUM_ON,
	## Let the kernel handle checksum offloading.
	## Note: Semantics may depend on the kernel and driver version.
	CHECKSUM_KERNEL,
} ;


module GLOBAL;

} # end of export section
module GLOBAL;
