// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/gssapi/gssapi_pac.h"

namespace binpac {






namespace GSSAPI {
ContextGSSAPI::ContextGSSAPI(GSSAPI_Conn* connection, GSSAPI_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

ContextGSSAPI::~ContextGSSAPI() {
}

GSSAPI_Conn::GSSAPI_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new GSSAPI_Flow(this, true);
    downflow_ = new GSSAPI_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		ntlm = nullptr;
		krb5 = nullptr;
	
}

GSSAPI_Conn::~GSSAPI_Conn() {

		if ( ntlm )
			{
			ntlm->Done();
			delete ntlm;
			ntlm = nullptr;
			}

		if ( krb5 )
			{
			krb5->Done();
			delete krb5;
			krb5 = nullptr;
			}
	
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void GSSAPI_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void GSSAPI_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void GSSAPI_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool GSSAPI_Conn::is_first_byte(bytestring const& token, uint8 byte) {

		return token[0] == byte;
		
}

bool GSSAPI_Conn::forward_blob(GSSAPI_NEG_TOKEN_MECH_TOKEN* val, bool is_orig) {

		if ( val->has_ntlm() &&
		     val->ntlm().length() >= 7 &&
		     memcmp("NTLMSSP", val->ntlm().begin(), 7) == 0 )
			{
			// ntlmssp
			if ( ! ntlm )
				ntlm = zeek::analyzer_mgr->InstantiateAnalyzer("NTLM", zeek_analyzer()->Conn());

			if ( ntlm )
				ntlm->DeliverStream(val->ntlm().length(),
				                    val->ntlm().begin(), is_orig);
			}

		else if ( val->has_krb() )
			{
			if ( ! krb5 )
				krb5 = zeek::analyzer_mgr->InstantiateAnalyzer("KRB", zeek_analyzer()->Conn());

			if ( krb5 ) // accepting all KRB types (REQ, REP, etc)
				{
				krb5->DeliverPacket(val->krb()->blob().length(),
				                    val->krb()->blob().begin(),
				                    is_orig, 0, nullptr, 0);
				}
			}

		return true;
		
}

bool GSSAPI_Conn::proc_gssapi_neg_result(GSSAPI_NEG_TOKEN_RESP_Arg* val) {

		if ( gssapi_neg_result )
			{
			zeek::BifEvent::enqueue_gssapi_neg_result(zeek_analyzer(),
			                                    zeek_analyzer()->Conn(),
			                                    binary_to_int64(val->neg_state()->encoding()->content()));
			}

		return true;
		
}

GSSAPI_SELECT::GSSAPI_SELECT(bool is_orig) {
    wrapper_ = nullptr;
    token_case_index_ = -1;
    neg_token_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
    is_init_ = false;
    tok_id_ = 0;
}

GSSAPI_SELECT::~GSSAPI_SELECT() {
    delete wrapper_;
    wrapper_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( token_case_index() ) {
        case ((uint32)1028):
            // Clean up "mic_blob"
            {
                mic_blob_.free();
            }
            break;
        case ((uint32)1284):
            // Clean up "wrap_blob"
            {
                wrap_blob_.free();
            }
            break;
        default:
            // Clean up "neg_token"
            {
                delete neg_token_;
                neg_token_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int GSSAPI_SELECT::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    // Parse "wrapper"
    wrapper_ = new ASN1EncodingMeta();
    int t_wrapper__size;
    t_wrapper__size = wrapper_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_wrapper = t_begin_of_data + (t_wrapper__size);
    BINPAC_ASSERT(t_dataptr_after_wrapper <= t_end_of_data);
    // Parse "token"
    is_init_ = wrapper()->tag() == 0x60;
    tok_id_ =  ( wrapper()->tag() << 8 )  | wrapper()->len();
    int t_token__size;
    token_case_index_ = tok_id();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( token_case_index() ) {
        case ((uint32)1028):
            // Parse "mic_blob"
            {
                int t_mic_blob_string_length;
                t_mic_blob_string_length = (t_end_of_data) - (t_dataptr_after_wrapper);
                int t_mic_blob__size;
                t_mic_blob__size = t_mic_blob_string_length;
                // check for negative sizes
                if ( t_mic_blob_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:4", t_mic_blob_string_length);
                mic_blob_.init(t_dataptr_after_wrapper, t_mic_blob_string_length);
                t_token__size = t_mic_blob__size;
            }
            break;
        case ((uint32)1284):
            // Parse "wrap_blob"
            {
                int t_wrap_blob_string_length;
                t_wrap_blob_string_length = (t_end_of_data) - (t_dataptr_after_wrapper);
                int t_wrap_blob__size;
                t_wrap_blob__size = t_wrap_blob_string_length;
                // check for negative sizes
                if ( t_wrap_blob_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:5", t_wrap_blob_string_length);
                wrap_blob_.init(t_dataptr_after_wrapper, t_wrap_blob_string_length);
                t_token__size = t_wrap_blob__size;
            }
            break;
        default:
            // Parse "neg_token"
            {
                neg_token_ = new GSSAPI_NEG_TOKEN(is_orig(), is_init());
                int t_neg_token__size;
                t_neg_token__size = neg_token_->Parse(t_dataptr_after_wrapper, t_end_of_data, t_context);
                t_token__size = t_neg_token__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_GSSAPI_SELECT__size;
    const_byteptr const t_dataptr_after_token = t_dataptr_after_wrapper + (t_token__size);
    BINPAC_ASSERT(t_dataptr_after_token <= t_end_of_data);
    t_GSSAPI_SELECT__size = t_dataptr_after_token - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GSSAPI_SELECT__size) <= t_end_of_data);
    return t_GSSAPI_SELECT__size;
}

GSSAPI_NEG_TOKEN::GSSAPI_NEG_TOKEN(bool is_orig, bool is_init) {
    have_oid_case_index_ = -1;
    oid_ = nullptr;
    have_init_wrapper_case_index_ = -1;
    init_wrapper_ = nullptr;
    msg_type_case_index_ = -1;
    init_ = nullptr;
    resp_ = nullptr;
    is_orig_ = is_orig;
    is_init_ = is_init;
    byteorder_ = littleendian;
}

GSSAPI_NEG_TOKEN::~GSSAPI_NEG_TOKEN() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_oid_case_index() ) {
        case true:
            // Clean up "oid"
            {
                delete oid_;
                oid_ = nullptr;
            }
            break;
        case false:
            // Clean up "no_oid"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_init_wrapper_case_index() ) {
        case true:
            // Clean up "init_wrapper"
            {
                delete init_wrapper_;
                init_wrapper_ = nullptr;
            }
            break;
        case false:
            // Clean up "no_init_wrapper"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_type_case_index() ) {
        case true:
            // Clean up "init"
            {
                delete init_;
                init_ = nullptr;
            }
            break;
        case false:
            // Clean up "resp"
            {
                delete resp_;
                resp_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int GSSAPI_NEG_TOKEN::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    // Parse "have_oid"
    int t_have_oid__size;
    have_oid_case_index_ = is_init();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_oid_case_index() ) {
        case true:
            // Parse "oid"
            {
                oid_ = new ASN1Encoding();
                int t_oid__size;
                t_oid__size = oid_->Parse(t_begin_of_data, t_end_of_data);
                t_have_oid__size = t_oid__size;
            }
            break;
        case false:
            // Parse "no_oid"
            {
                t_have_oid__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("GSSAPI_NEG_TOKEN", (int64)have_oid_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_oid = t_begin_of_data + (t_have_oid__size);
    BINPAC_ASSERT(t_dataptr_after_have_oid <= t_end_of_data);
    // Parse "have_init_wrapper"
    int t_have_init_wrapper__size;
    have_init_wrapper_case_index_ = is_init();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_init_wrapper_case_index() ) {
        case true:
            // Parse "init_wrapper"
            {
                init_wrapper_ = new ASN1EncodingMeta();
                int t_init_wrapper__size;
                t_init_wrapper__size = init_wrapper_->Parse(t_dataptr_after_have_oid, t_end_of_data);
                t_have_init_wrapper__size = t_init_wrapper__size;
            }
            break;
        case false:
            // Parse "no_init_wrapper"
            {
                t_have_init_wrapper__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("GSSAPI_NEG_TOKEN", (int64)have_init_wrapper_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_init_wrapper = t_dataptr_after_have_oid + (t_have_init_wrapper__size);
    BINPAC_ASSERT(t_dataptr_after_have_init_wrapper <= t_end_of_data);
    // Parse "msg_type"
    int t_msg_type__size;
    msg_type_case_index_ = is_init();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_type_case_index() ) {
        case true:
            // Parse "init"
            {
                init_ = new GSSAPI_NEG_TOKEN_INIT();
                int t_init__size;
                t_init__size = init_->Parse(t_dataptr_after_have_init_wrapper, t_end_of_data, t_context);
                t_msg_type__size = t_init__size;
            }
            break;
        case false:
            // Parse "resp"
            {
                resp_ = new GSSAPI_NEG_TOKEN_RESP();
                int t_resp__size;
                t_resp__size = resp_->Parse(t_dataptr_after_have_init_wrapper, t_end_of_data, t_context);
                t_msg_type__size = t_resp__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("GSSAPI_NEG_TOKEN", (int64)msg_type_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_GSSAPI_NEG_TOKEN__size;
    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_have_init_wrapper + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    t_GSSAPI_NEG_TOKEN__size = t_dataptr_after_msg_type - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GSSAPI_NEG_TOKEN__size) <= t_end_of_data);
    return t_GSSAPI_NEG_TOKEN__size;
}

GSSAPI_NEG_TOKEN_INIT::GSSAPI_NEG_TOKEN_INIT() {
    seq_meta_ = nullptr;
    args_ = nullptr;
    args__elem_ = nullptr;
}

GSSAPI_NEG_TOKEN_INIT::~GSSAPI_NEG_TOKEN_INIT() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete args__elem_;
    args__elem_ = nullptr;
    if ( args() ) {
        for ( auto* args__elem_ : *args() ) {
            delete args__elem_;
            args__elem_ = nullptr;
        }
    }
    delete args_;
}

int GSSAPI_NEG_TOKEN_INIT::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args"
    int t_args__arraylength;
    t_args__arraylength = 0;
    args__elem_ = nullptr;
    int t_args__elem__it;
    t_args__elem__it = 0;
    int t_args__size;
    args_ = new vector<GSSAPI_NEG_TOKEN_INIT_Arg*>;
    const_byteptr t_args__elem__dataptr = t_dataptr_after_seq_meta;
    for (; /* forever */; ++t_args__elem__it) {
        // Check &until(args__elem__dataptr >= end_of_data)
        if ( t_args__elem__dataptr >= t_end_of_data ) {
            args__elem_ = nullptr;
            goto end_of_args;
        }
        args__elem_ = new GSSAPI_NEG_TOKEN_INIT_Arg();
        int t_args__elem__size;
        t_args__elem__size = args__elem_->Parse(t_args__elem__dataptr, t_end_of_data, t_context);
        args_->push_back(args__elem_);
        t_args__elem__dataptr += t_args__elem__size;
        BINPAC_ASSERT(t_args__elem__dataptr <= t_end_of_data);
        args__elem_ = nullptr;
    }
end_of_args: ;
    t_args__size = t_args__elem__dataptr - (t_dataptr_after_seq_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_GSSAPI_NEG_TOKEN_INIT__size;
    const_byteptr const t_dataptr_after_args = t_dataptr_after_seq_meta + (t_args__size);
    BINPAC_ASSERT(t_dataptr_after_args <= t_end_of_data);
    t_GSSAPI_NEG_TOKEN_INIT__size = t_dataptr_after_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GSSAPI_NEG_TOKEN_INIT__size) <= t_end_of_data);
    return t_GSSAPI_NEG_TOKEN_INIT__size;
}

GSSAPI_NEG_TOKEN_INIT_Arg::GSSAPI_NEG_TOKEN_INIT_Arg() {
    seq_meta_ = nullptr;
    args_ = nullptr;
}

GSSAPI_NEG_TOKEN_INIT_Arg::~GSSAPI_NEG_TOKEN_INIT_Arg() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete args_;
    args_ = nullptr;
}

int GSSAPI_NEG_TOKEN_INIT_Arg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args"
    args_ = new GSSAPI_NEG_TOKEN_INIT_Arg_Data(seq_meta()->index());
    int t_args__size;
    t_args__size = seq_meta()->length();
    // Checking out-of-bound for "GSSAPI_NEG_TOKEN_INIT_Arg:args"
    if ( t_dataptr_after_seq_meta + (t_args__size) > t_end_of_data || t_dataptr_after_seq_meta + (t_args__size) < t_dataptr_after_seq_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GSSAPI_NEG_TOKEN_INIT_Arg:args",
        	((t_dataptr_after_seq_meta - t_begin_of_data)) + (t_args__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_seq_meta + t_args__size;
        args_->Parse(t_dataptr_after_seq_meta, t_end_of_data, t_context);
    }

    int t_GSSAPI_NEG_TOKEN_INIT_Arg__size;
    const_byteptr const t_dataptr_after_args = t_dataptr_after_seq_meta + (t_args__size);
    BINPAC_ASSERT(t_dataptr_after_args <= t_end_of_data);
    t_GSSAPI_NEG_TOKEN_INIT_Arg__size = t_dataptr_after_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GSSAPI_NEG_TOKEN_INIT_Arg__size) <= t_end_of_data);
    return t_GSSAPI_NEG_TOKEN_INIT_Arg__size;
}

GSSAPI_NEG_TOKEN_INIT_Arg_Data::GSSAPI_NEG_TOKEN_INIT_Arg_Data(uint8 index) {
    val_case_index_ = -1;
    mech_type_list_ = nullptr;
    req_flags_ = nullptr;
    mech_token_ = nullptr;
    mech_list_mic_ = nullptr;
    index_ = index;
}

GSSAPI_NEG_TOKEN_INIT_Arg_Data::~GSSAPI_NEG_TOKEN_INIT_Arg_Data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Clean up "mech_type_list"
            {
                delete mech_type_list_;
                mech_type_list_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "req_flags"
            {
                delete req_flags_;
                req_flags_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "mech_token"
            {
                delete mech_token_;
                mech_token_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "mech_list_mic"
            {
                delete mech_list_mic_;
                mech_list_mic_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int GSSAPI_NEG_TOKEN_INIT_Arg_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    int t_val__size;
    val_case_index_ = index();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Parse "mech_type_list"
            {
                mech_type_list_ = new ASN1Encoding();
                int t_mech_type_list__size;
                t_mech_type_list__size = mech_type_list_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_mech_type_list__size;
            }
            break;
        case ((uint8)1):
            // Parse "req_flags"
            {
                req_flags_ = new ASN1Encoding();
                int t_req_flags__size;
                t_req_flags__size = req_flags_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_req_flags__size;
            }
            break;
        case ((uint8)2):
            // Parse "mech_token"
            {
                mech_token_ = new GSSAPI_NEG_TOKEN_MECH_TOKEN(true);
                int t_mech_token__size;
                t_mech_token__size = mech_token_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_mech_token__size;
            }
            break;
        case ((uint8)3):
            // Parse "mech_list_mic"
            {
                mech_list_mic_ = new ASN1OctetString();
                int t_mech_list_mic__size;
                t_mech_list_mic__size = mech_list_mic_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_mech_list_mic__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("GSSAPI_NEG_TOKEN_INIT_Arg_Data", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

GSSAPI_NEG_TOKEN_RESP::GSSAPI_NEG_TOKEN_RESP() {
    seq_meta_ = nullptr;
    args_ = nullptr;
    args__elem_ = nullptr;
}

GSSAPI_NEG_TOKEN_RESP::~GSSAPI_NEG_TOKEN_RESP() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete args__elem_;
    args__elem_ = nullptr;
    if ( args() ) {
        for ( auto* args__elem_ : *args() ) {
            delete args__elem_;
            args__elem_ = nullptr;
        }
    }
    delete args_;
}

int GSSAPI_NEG_TOKEN_RESP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args"
    int t_args__arraylength;
    t_args__arraylength = 0;
    args__elem_ = nullptr;
    int t_args__elem__it;
    t_args__elem__it = 0;
    int t_args__size;
    args_ = new vector<GSSAPI_NEG_TOKEN_RESP_Arg*>;
    const_byteptr t_args__elem__dataptr = t_dataptr_after_seq_meta;
    for (; /* forever */; ++t_args__elem__it) {
        // Check &until(args__elem__dataptr >= end_of_data)
        if ( t_args__elem__dataptr >= t_end_of_data ) {
            args__elem_ = nullptr;
            goto end_of_args;
        }
        args__elem_ = new GSSAPI_NEG_TOKEN_RESP_Arg();
        int t_args__elem__size;
        t_args__elem__size = args__elem_->Parse(t_args__elem__dataptr, t_end_of_data, t_context);
        args_->push_back(args__elem_);
        t_args__elem__dataptr += t_args__elem__size;
        BINPAC_ASSERT(t_args__elem__dataptr <= t_end_of_data);
        args__elem_ = nullptr;
    }
end_of_args: ;
    t_args__size = t_args__elem__dataptr - (t_dataptr_after_seq_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_GSSAPI_NEG_TOKEN_RESP__size;
    const_byteptr const t_dataptr_after_args = t_dataptr_after_seq_meta + (t_args__size);
    BINPAC_ASSERT(t_dataptr_after_args <= t_end_of_data);
    t_GSSAPI_NEG_TOKEN_RESP__size = t_dataptr_after_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GSSAPI_NEG_TOKEN_RESP__size) <= t_end_of_data);
    return t_GSSAPI_NEG_TOKEN_RESP__size;
}

GSSAPI_NEG_TOKEN_RESP_Arg::GSSAPI_NEG_TOKEN_RESP_Arg() {
    seq_meta_ = nullptr;
    args_case_index_ = -1;
    neg_state_ = nullptr;
    supported_mech_ = nullptr;
    response_token_ = nullptr;
    mech_list_mic_ = nullptr;
    proc_ = false;
    has_proc_ = false;
}

GSSAPI_NEG_TOKEN_RESP_Arg::~GSSAPI_NEG_TOKEN_RESP_Arg() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( args_case_index() ) {
        case ((uint8)0):
            // Clean up "neg_state"
            {
                delete neg_state_;
                neg_state_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "supported_mech"
            {
                delete supported_mech_;
                supported_mech_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "response_token"
            {
                delete response_token_;
                response_token_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "mech_list_mic"
            {
                delete mech_list_mic_;
                mech_list_mic_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int GSSAPI_NEG_TOKEN_RESP_Arg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args"
    int t_args__size;
    t_args__size = seq_meta()->length();
    // Checking out-of-bound for "GSSAPI_NEG_TOKEN_RESP_Arg:args"
    if ( t_dataptr_after_seq_meta + (t_args__size) > t_end_of_data || t_dataptr_after_seq_meta + (t_args__size) < t_dataptr_after_seq_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GSSAPI_NEG_TOKEN_RESP_Arg:args",
        	((t_dataptr_after_seq_meta - t_begin_of_data)) + (t_args__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_seq_meta + t_args__size;
        args_case_index_ = seq_meta()->index();
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( args_case_index() ) {
            case ((uint8)0):
                // Parse "neg_state"
                {
                    neg_state_ = new ASN1Integer();
                    int t_neg_state__size;
                    t_neg_state__size = neg_state_->Parse(t_dataptr_after_seq_meta, t_end_of_data);
                }
                break;
            case ((uint8)1):
                // Parse "supported_mech"
                {
                    supported_mech_ = new ASN1Encoding();
                    int t_supported_mech__size;
                    t_supported_mech__size = supported_mech_->Parse(t_dataptr_after_seq_meta, t_end_of_data);
                }
                break;
            case ((uint8)2):
                // Parse "response_token"
                {
                    response_token_ = new GSSAPI_NEG_TOKEN_MECH_TOKEN(false);
                    int t_response_token__size;
                    t_response_token__size = response_token_->Parse(t_dataptr_after_seq_meta, t_end_of_data, t_context);
                }
                break;
            case ((uint8)3):
                // Parse "mech_list_mic"
                {
                    mech_list_mic_ = new ASN1OctetString();
                    int t_mech_list_mic__size;
                    t_mech_list_mic__size = mech_list_mic_->Parse(t_dataptr_after_seq_meta, t_end_of_data);
                }
                break;
            default:
                throw binpac::ExceptionInvalidCaseIndex("GSSAPI_NEG_TOKEN_RESP_Arg", (int64)args_case_index());
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        // Evaluate 'let' and 'withinput' fields
    }

    int t_GSSAPI_NEG_TOKEN_RESP_Arg__size;
    const_byteptr const t_dataptr_after_args = t_dataptr_after_seq_meta + (t_args__size);
    BINPAC_ASSERT(t_dataptr_after_args <= t_end_of_data);
    t_GSSAPI_NEG_TOKEN_RESP_Arg__size = t_dataptr_after_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    has_proc_ =  ( seq_meta()->index() == 0 ) ;
    if ( has_proc() ) {
        proc_ = t_context->connection()->proc_gssapi_neg_result(this);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_GSSAPI_NEG_TOKEN_RESP_Arg__size) <= t_end_of_data);
    return t_GSSAPI_NEG_TOKEN_RESP_Arg__size;
}

GSSAPI_NEG_TOKEN_MECH_TOKEN::GSSAPI_NEG_TOKEN_MECH_TOKEN(bool is_orig) {
    meta_ = nullptr;
    is_orig_ = is_orig;
    has_ntlm_ = false;
    krb_ = nullptr;
    has_krb_ = false;
    fwd_ = false;
}

GSSAPI_NEG_TOKEN_MECH_TOKEN::~GSSAPI_NEG_TOKEN_MECH_TOKEN() {
    delete meta_;
    meta_ = nullptr;
    token_.free();
    ntlm_.free();
    delete krb_;
    krb_ = nullptr;
}

int GSSAPI_NEG_TOKEN_MECH_TOKEN::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "token"
    int t_token__size;
    t_token__size = meta()->length();
    // Checking out-of-bound for "GSSAPI_NEG_TOKEN_MECH_TOKEN:token"
    if ( t_dataptr_after_meta + (t_token__size) > t_end_of_data || t_dataptr_after_meta + (t_token__size) < t_dataptr_after_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GSSAPI_NEG_TOKEN_MECH_TOKEN:token",
        	((t_dataptr_after_meta - t_begin_of_data)) + (t_token__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_meta + t_token__size;
        int t_token_string_length;
        t_token_string_length = meta()->length();
        // check for negative sizes
        if ( t_token_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:62", t_token_string_length);
        token_.init(t_dataptr_after_meta, t_token_string_length);
    }

    int t_GSSAPI_NEG_TOKEN_MECH_TOKEN__size;
    const_byteptr const t_dataptr_after_token = t_dataptr_after_meta + (t_token__size);
    BINPAC_ASSERT(t_dataptr_after_token <= t_end_of_data);
    t_GSSAPI_NEG_TOKEN_MECH_TOKEN__size = t_dataptr_after_token - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    // Parse "ntlm"
    has_ntlm_ =  ( t_context->connection()->is_first_byte(token(), 0x4E) ) ;
    if ( has_ntlm() ) {
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(token(), &t_begin_of_data, &t_end_of_data);
        int t_ntlm_string_length;
        t_ntlm_string_length = (t_end_of_data) - (t_begin_of_data);
        int t_ntlm__size;
        t_ntlm__size = t_ntlm_string_length;
        // check for negative sizes
        if ( t_ntlm_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:64", t_ntlm_string_length);
        ntlm_.init(t_begin_of_data, t_ntlm_string_length);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "krb"
    has_krb_ =  ( t_context->connection()->is_first_byte(token(), 0x60) ) ;
    if ( has_krb() ) {
        krb_ = new KRB_BLOB();
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(token(), &t_begin_of_data, &t_end_of_data);
        int t_krb__size;
        t_krb__size = krb_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    fwd_ = t_context->connection()->forward_blob(this, is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_GSSAPI_NEG_TOKEN_MECH_TOKEN__size) <= t_end_of_data);
    return t_GSSAPI_NEG_TOKEN_MECH_TOKEN__size;
}

KRB_BLOB::KRB_BLOB() {
    meta_ = nullptr;
    oid_ = nullptr;
    token_id_ = 0;
}

KRB_BLOB::~KRB_BLOB() {
    delete meta_;
    meta_ = nullptr;
    delete oid_;
    oid_ = nullptr;
    blob_.free();
}

int KRB_BLOB::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "oid"
    oid_ = new ASN1OctetString();
    int t_oid__size;
    t_oid__size = oid_->Parse(t_dataptr_after_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_oid = t_dataptr_after_meta + (t_oid__size);
    BINPAC_ASSERT(t_dataptr_after_oid <= t_end_of_data);
    // Checking out-of-bound for "KRB_BLOB:token_id"
    if ( t_dataptr_after_oid + (2) > t_end_of_data || t_dataptr_after_oid + (2) < t_dataptr_after_oid ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_BLOB:token_id",
        	((t_dataptr_after_oid - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "token_id"
    token_id_ = FixByteOrder(littleendian, *(reinterpret_cast<uint16 const*>(t_dataptr_after_oid)));

    // Parse "blob"
    int t_blob_string_length;
    t_blob_string_length = (t_end_of_data) - ((t_dataptr_after_oid + 2));
    int t_blob__size;
    t_blob__size = t_blob_string_length;
    // check for negative sizes
    if ( t_blob_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:72", t_blob_string_length);
    blob_.init((t_dataptr_after_oid + 2), t_blob_string_length);

    int t_KRB_BLOB__size;
    const_byteptr const t_dataptr_after_blob = (t_dataptr_after_oid + 2) + (t_blob__size);
    BINPAC_ASSERT(t_dataptr_after_blob <= t_end_of_data);
    t_KRB_BLOB__size = t_dataptr_after_blob - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_BLOB__size) <= t_end_of_data);
    return t_KRB_BLOB__size;
}

ASN1Encoding::ASN1Encoding() {
    meta_ = nullptr;
}

ASN1Encoding::~ASN1Encoding() {
    delete meta_;
    meta_ = nullptr;
    content_.free();
}

int ASN1Encoding::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "content"
    int t_content__size;
    t_content__size = meta()->length();
    // Checking out-of-bound for "ASN1Encoding:content"
    if ( t_dataptr_after_meta + (t_content__size) > t_end_of_data || t_dataptr_after_meta + (t_content__size) < t_dataptr_after_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1Encoding:content",
        	((t_dataptr_after_meta - t_begin_of_data)) + (t_content__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_meta + t_content__size;
        int t_content_string_length;
        t_content_string_length = meta()->length();
        // check for negative sizes
        if ( t_content_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/../asn1/asn1.pac:28", t_content_string_length);
        content_.init(t_dataptr_after_meta, t_content_string_length);
    }

    int t_ASN1Encoding__size;
    const_byteptr const t_dataptr_after_content = t_dataptr_after_meta + (t_content__size);
    BINPAC_ASSERT(t_dataptr_after_content <= t_end_of_data);
    t_ASN1Encoding__size = t_dataptr_after_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Encoding__size) <= t_end_of_data);
    return t_ASN1Encoding__size;
}

ASN1EncodingMeta::ASN1EncodingMeta() {
    tag_ = 0;
    len_ = 0;
    long_len_ = false;
    length_ = 0;
    index_ = 0;
}

ASN1EncodingMeta::~ASN1EncodingMeta() {
    more_len_.free();
}

int ASN1EncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ASN1EncodingMeta:len"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:len",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tag"
    tag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "more_len"
    int t_more_len__size;
    long_len_ =  ( len() & 0x80 )  > 0;
    t_more_len__size = long_len() ? len() & 0x7f : 0;
    // Checking out-of-bound for "ASN1EncodingMeta:more_len"
    if ( (t_begin_of_data + 2) + (t_more_len__size) > t_end_of_data || (t_begin_of_data + 2) + (t_more_len__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:more_len",
        	(2) + (t_more_len__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_more_len__size;
        int t_more_len_string_length;
        t_more_len_string_length = long_len() ? len() & 0x7f : 0;
        // check for negative sizes
        if ( t_more_len_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/../asn1/asn1.pac:34", t_more_len_string_length);
        more_len_.init((t_begin_of_data + 2), t_more_len_string_length);
    }

    int t_ASN1EncodingMeta__size;
    const_byteptr const t_dataptr_after_more_len = (t_begin_of_data + 2) + (t_more_len__size);
    BINPAC_ASSERT(t_dataptr_after_more_len <= t_end_of_data);
    t_ASN1EncodingMeta__size = t_dataptr_after_more_len - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    length_ = long_len() ? binary_to_int64(more_len()) : len();
    index_ = tag() - ASN1_INDEX_TAG_OFFSET;
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1EncodingMeta__size) <= t_end_of_data);
    return t_ASN1EncodingMeta__size;
}

ASN1OptionalEncodingMeta::ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata) {
    val_case_index_ = -1;
    data_ = nullptr;
    is_present_ = is_present;
    previous_metadata_ = previous_metadata;
    length_ = 0;
}

ASN1OptionalEncodingMeta::~ASN1OptionalEncodingMeta() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ASN1OptionalEncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = is_present();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1EncodingMeta();
                int t_data__size;
                t_data__size = data_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_data__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_val__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ASN1OptionalEncodingMeta", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    length_ = is_present() ? data()->length() : previous_metadata()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ASN1SequenceMeta::ASN1SequenceMeta() {
    encoding_ = nullptr;
}

ASN1SequenceMeta::~ASN1SequenceMeta() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1SequenceMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1EncodingMeta();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1SequenceMeta__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1SequenceMeta__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1SequenceMeta__size) <= t_end_of_data);
    return t_ASN1SequenceMeta__size;
}

ASN1Integer::ASN1Integer() {
    encoding_ = nullptr;
}

ASN1Integer::~ASN1Integer() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Integer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Integer__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Integer__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Integer__size) <= t_end_of_data);
    return t_ASN1Integer__size;
}

ASN1OctetString::ASN1OctetString() {
    encoding_ = nullptr;
}

ASN1OctetString::~ASN1OctetString() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1OctetString::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1OctetString__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1OctetString__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1OctetString__size) <= t_end_of_data);
    return t_ASN1OctetString__size;
}

ASN1ObjectIdentifier::ASN1ObjectIdentifier() {
    encoding_ = nullptr;
}

ASN1ObjectIdentifier::~ASN1ObjectIdentifier() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1ObjectIdentifier::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1ObjectIdentifier__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1ObjectIdentifier__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1ObjectIdentifier__size) <= t_end_of_data);
    return t_ASN1ObjectIdentifier__size;
}

ASN1Boolean::ASN1Boolean() {
    encoding_ = nullptr;
}

ASN1Boolean::~ASN1Boolean() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Boolean::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Boolean__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Boolean__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Boolean__size) <= t_end_of_data);
    return t_ASN1Boolean__size;
}

ASN1Enumerated::ASN1Enumerated() {
    encoding_ = nullptr;
}

ASN1Enumerated::~ASN1Enumerated() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Enumerated::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Enumerated__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Enumerated__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Enumerated__size) <= t_end_of_data);
    return t_ASN1Enumerated__size;
}

SequenceElement::SequenceElement(bool grab_content) {
    index_meta_ = nullptr;
    have_content_case_index_ = -1;
    data_ = nullptr;
    meta_ = nullptr;
    grab_content_ = grab_content;
    index_ = 0;
    length_ = 0;
}

SequenceElement::~SequenceElement() {
    delete index_meta_;
    index_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "meta"
            {
                delete meta_;
                meta_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SequenceElement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "index_meta"
    index_meta_ = new ASN1EncodingMeta();
    int t_index_meta__size;
    t_index_meta__size = index_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_index_meta = t_begin_of_data + (t_index_meta__size);
    BINPAC_ASSERT(t_dataptr_after_index_meta <= t_end_of_data);
    // Parse "have_content"
    int t_have_content__size;
    have_content_case_index_ = grab_content();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1Encoding();
                int t_data__size;
                t_data__size = data_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_data__size;
            }
            break;
        case false:
            // Parse "meta"
            {
                meta_ = new ASN1EncodingMeta();
                int t_meta__size;
                t_meta__size = meta_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_meta__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SequenceElement", (int64)have_content_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SequenceElement__size;
    const_byteptr const t_dataptr_after_have_content = t_dataptr_after_index_meta + (t_have_content__size);
    BINPAC_ASSERT(t_dataptr_after_have_content <= t_end_of_data);
    t_SequenceElement__size = t_dataptr_after_have_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    index_ = index_meta()->index();
    length_ = index_meta()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_SequenceElement__size) <= t_end_of_data);
    return t_SequenceElement__size;
}

Array::Array() {
    array_meta_ = nullptr;
    data_ = nullptr;
    data__elem_ = nullptr;
}

Array::~Array() {
    delete array_meta_;
    array_meta_ = nullptr;
    delete data__elem_;
    data__elem_ = nullptr;
    if ( data() ) {
        for ( auto* data__elem_ : *data() ) {
            delete data__elem_;
            data__elem_ = nullptr;
        }
    }
    delete data_;
}

int Array::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "array_meta"
    array_meta_ = new ASN1EncodingMeta();
    int t_array_meta__size;
    t_array_meta__size = array_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_array_meta = t_begin_of_data + (t_array_meta__size);
    BINPAC_ASSERT(t_dataptr_after_array_meta <= t_end_of_data);
    // Parse "data"
    int t_data__arraylength;
    t_data__arraylength = 0;
    data__elem_ = nullptr;
    int t_data__elem__it;
    t_data__elem__it = 0;
    int t_data__size;
    data_ = new vector<ASN1Encoding*>;
    const_byteptr t_data__elem__dataptr = t_dataptr_after_array_meta;
    for (; /* forever */; ++t_data__elem__it) {
        // Check &until(data__elem__dataptr >= end_of_data)
        if ( t_data__elem__dataptr >= t_end_of_data ) {
            data__elem_ = nullptr;
            goto end_of_data;
        }
        data__elem_ = new ASN1Encoding();
        int t_data__elem__size;
        t_data__elem__size = data__elem_->Parse(t_data__elem__dataptr, t_end_of_data);
        data_->push_back(data__elem_);
        t_data__elem__dataptr += t_data__elem__size;
        BINPAC_ASSERT(t_data__elem__dataptr <= t_end_of_data);
        data__elem_ = nullptr;
    }
end_of_data: ;
    t_data__size = t_data__elem__dataptr - (t_dataptr_after_array_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_Array__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_array_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Array__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Array__size) <= t_end_of_data);
    return t_Array__size;
}

int64 binary_to_int64(bytestring const& bs) {

	int64 rval = 0;

	if ( bs.length() > 8 )
		{
		zeek::reporter->Weird("asn_binary_to_int64_shift_too_large", zeek::util::fmt("%d", bs.length()));
		return 0;
		}

	for ( int i = 0; i < bs.length(); ++i )
		{
		uint64 byte = bs[i];
		rval |= byte << (8 * (bs.length() - (i + 1)));
		}

	return rval;
	
}



zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t)
	{
	return asn1_integer_to_val(i->encoding(), t);
	}

zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t)
	{
	auto v = binary_to_int64(i->content());

	switch ( t ) {
	case zeek::TYPE_BOOL:
		return zeek::val_mgr->Bool(v);
	case zeek::TYPE_INT:
		return zeek::val_mgr->Int(v);
	case zeek::TYPE_COUNT:
		return zeek::val_mgr->Count(v);
	default:
		zeek::reporter->Error("bad asn1_integer_to_val tag: %s", zeek::type_name(t));
		return zeek::val_mgr->Count(v);
	}
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid)
	{
	return asn1_oid_to_val(oid->encoding());
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid)
	{
	vector<uint64> oid_components;
	vector<vector<uint8> > subidentifiers;
	vector<uint64> subidentifier_values;
	vector<uint8> subidentifier;
	bytestring const& bs = oid->content();

	for ( int i = 0; i < bs.length(); ++i )
		{
		if ( bs[i] & 0x80 )
			subidentifier.push_back(bs[i] & 0x7f);
		else
			{
			subidentifier.push_back(bs[i]);
			subidentifiers.push_back(subidentifier);
			subidentifier.clear();
			}
		}

	if ( ! subidentifier.empty() || subidentifiers.size() < 1 )
		// Underflow.
		return zeek::val_mgr->EmptyString();

	for ( const auto& subidentifier : subidentifiers )
		{
		uint64 value = 0;

		for ( size_t j = 0; j < subidentifier.size(); ++j )
			{
			uint64 byte = subidentifier[j];
			value |= byte << (7 * (subidentifier.size() - (j + 1)));
			}

		subidentifier_values.push_back(value);
		}

	string rval;

	for ( size_t i = 0; i < subidentifier_values.size(); ++i )
		{
		char tmp[32];

		if ( i > 0 )
			{
			snprintf(tmp, sizeof(tmp), ".%" PRIu64, subidentifier_values[i]);
			rval += tmp;
			}
		else
			{
			std::div_t result = std::div(subidentifier_values[i], 40);
			snprintf(tmp, sizeof(tmp), "%d.%d", result.quot, result.rem);
			rval += tmp;
			}
		}

	return zeek::make_intrusive<zeek::StringVal>(rval);
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s)
	{
	return asn1_octet_string_to_val(s->encoding());
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s)
	{
	bytestring const& bs = s->content();
	return zeek::make_intrusive<zeek::StringVal>(bs.length(), reinterpret_cast<const char*>(bs.data()));
	}

GSSAPI_Flow::GSSAPI_Flow(GSSAPI_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

GSSAPI_Flow::~GSSAPI_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void GSSAPI_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new GSSAPI_SELECT(is_orig());
        context_ = new ContextGSSAPI(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e;
    }
}

void GSSAPI_Flow::NewGap(int gap_length) {
}
void GSSAPI_Flow::FlowEOF() {
}
} // namespace GSSAPI
}  // namespace binpac
