// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/imap/imap.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/imap/imap_pac.h"

namespace binpac {






namespace IMAP {
ContextIMAP::ContextIMAP(IMAP_Conn* connection, IMAP_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

ContextIMAP::~ContextIMAP() {
}

IMAP_Conn::IMAP_Conn(IMAPAnalyzer const& zeek_analyzer) {
    upflow_ = new IMAP_Flow(this, true);
    downflow_ = new IMAP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

	
}

IMAP_Conn::~IMAP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void IMAP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void IMAP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void IMAP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

int IMAP_Conn::determine_command(bool is_orig, bytestring const& tag, bytestring const& command) {

		string cmdstr = std_str(command);
		std::ranges::transform(cmdstr, cmdstr.begin(), ::tolower);

		if ( !is_orig && cmdstr == "capability" && tag == "*" ) {
			return CMD_CAPABILITY;
		}

		return CMD_UNKNOWN;
		
}

int IMAP_Conn::strlen(bytestring const& str) {

		return str.length();
		
}

bool IMAP_Conn::proc_imap_token(bool is_orig, bytestring const& tag, bytestring const& command) {

		string commands = std_str(command);
		std::ranges::transform(commands, commands.begin(), ::tolower);

		string tags = std_str(tag);

		//printf("imap %s %s\n", commands.c_str(), tags.c_str());

		if ( !is_orig && tags == "*" && commands == "ok" )
			zeek_analyzer()->AnalyzerConfirmation();

		if ( is_orig && ( command == "capability" || commands == "starttls" ) )
			zeek_analyzer()->AnalyzerConfirmation();

		if ( command == "authenticate" || command == "login" || command == "examine" || command == "create" || command == "list" || command == "fetch" )
			{
			zeek_analyzer()->AnalyzerConfirmation();
			// Handshake has passed the phase where we should see StartTLS. Simply skip from hereon...
			zeek_analyzer()->SetSkip(true);
			return true;
			}

		if ( is_orig && commands == "starttls" )
			{
			if ( !client_starttls_id.empty() )
				zeek_analyzer()->Weird("IMAP: client sent duplicate StartTLS");

			client_starttls_id = tags;
			}

		if ( !is_orig && !client_starttls_id.empty() && tags == client_starttls_id )
			{
			if ( commands == "ok" )
				{
				zeek_analyzer()->StartTLS();

				if ( imap_starttls )
					zeek::BifEvent::enqueue_imap_starttls(zeek_analyzer(), zeek_analyzer()->Conn());
				}
			else
				zeek_analyzer()->Weird("IMAP: server refused StartTLS");
			}

		return true;
		
}

bool IMAP_Conn::proc_server_capability(vector<Capability*>* capabilities) {

		if ( ! imap_capabilities )
			return true;

		auto capv = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);

		for ( unsigned int i = 0; i< capabilities->size(); i++ )
			{
			const bytestring& capability = (*capabilities)[i]->cap();
			capv->Assign(i, zeek::make_intrusive<zeek::StringVal>(capability.length(), reinterpret_cast<const char*>(capability.data())));
			}

		zeek::BifEvent::enqueue_imap_capabilities(zeek_analyzer(), zeek_analyzer()->Conn(), std::move(capv));
		return true;
		
}

RegExMatcher TAG_re_001("[[:alnum:][:punct:]]+");

RegExMatcher CONTENT_re_002("[^\\r\\n]*");

RegExMatcher SPACING_re_003("[ ]+");

RegExMatcher OPTIONALSPACING_re_004("[ ]*");

RegExMatcher NEWLINE_re_005("[\\r\\n]+");

RegExMatcher OPTIONALNEWLINE_re_006("[\\r\\n]*");

IMAP_PDU::IMAP_PDU(bool is_orig) {
    val_ = nullptr;
    is_orig_ = is_orig;
    val__elem_ = nullptr;
}

IMAP_PDU::~IMAP_PDU() {
    delete val__elem_;
    val__elem_ = nullptr;
    if ( val() ) {
        for ( auto* val__elem_ : *val() ) {
            delete val__elem_;
            val__elem_ = nullptr;
        }
    }
    delete val_;
}

int IMAP_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextIMAP* t_context) {
    int t_val__arraylength;
    t_val__arraylength = 0;
    val__elem_ = nullptr;
    int t_val__elem__it;
    t_val__elem__it = 0;
    int t_val__size;
    val_ = new vector<ImapToken*>;
    const_byteptr t_val__elem__dataptr = t_begin_of_data;
    for (; /* forever */; ++t_val__elem__it) {
        // Check &until(val__elem__dataptr >= end_of_data)
        if ( t_val__elem__dataptr >= t_end_of_data ) {
            val__elem_ = nullptr;
            goto end_of_val;
        }
        val__elem_ = new ImapToken(is_orig());
        int t_val__elem__size;
        t_val__elem__size = val__elem_->Parse(t_val__elem__dataptr, t_end_of_data, t_context);
        val_->push_back(val__elem_);
        t_val__elem__dataptr += t_val__elem__size;
        BINPAC_ASSERT(t_val__elem__dataptr <= t_end_of_data);
        val__elem_ = nullptr;
    }
end_of_val: ;
    t_val__size = t_val__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ImapToken::ImapToken(bool is_orig) {
    client_or_server_case_index_ = -1;
    client_ = nullptr;
    server_ = nullptr;
    is_orig_ = is_orig;
    pcommand_ = 0;
    proc_ = false;
}

ImapToken::~ImapToken() {
    tag_.free();
    command_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( client_or_server_case_index() ) {
        case true:
            // Clean up "client"
            {
                delete client_;
                client_ = nullptr;
            }
            break;
        case false:
            // Clean up "server"
            {
                delete server_;
                server_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ImapToken::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextIMAP* t_context) {
    // Parse "tag"
    int t_tag_string_length;
    t_tag_string_length = 
        TAG_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_tag_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:18", "[[:alnum:][:punct:]]+", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_tag__size;
    t_tag__size = t_tag_string_length;
    // check for negative sizes
    if ( t_tag_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:18", t_tag_string_length);
    tag_.init(t_begin_of_data, t_tag_string_length);

    const_byteptr const t_dataptr_after_tag = t_begin_of_data + (t_tag__size);
    BINPAC_ASSERT(t_dataptr_after_tag <= t_end_of_data);
    // Parse "anonymous_field_007"
    bytestring anonymous_field_007_;
    int t_anonymous_field_007_string_length;
    t_anonymous_field_007_string_length = 
        SPACING_re_003.MatchPrefix(
            t_dataptr_after_tag,
            t_end_of_data - t_dataptr_after_tag);
    if ( t_anonymous_field_007_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:19", "[ ]+", string(reinterpret_cast<const char*>(t_dataptr_after_tag), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_007__size;
    t_anonymous_field_007__size = t_anonymous_field_007_string_length;
    anonymous_field_007_.free();

    const_byteptr const t_dataptr_after_anonymous_field_007 = t_dataptr_after_tag + (t_anonymous_field_007__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_007 <= t_end_of_data);
    // Parse "command"
    int t_command_string_length;
    t_command_string_length = 
        TAG_re_001.MatchPrefix(
            t_dataptr_after_anonymous_field_007,
            t_end_of_data - t_dataptr_after_anonymous_field_007);
    if ( t_command_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:20", "[[:alnum:][:punct:]]+", string(reinterpret_cast<const char*>(t_dataptr_after_anonymous_field_007), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_command__size;
    t_command__size = t_command_string_length;
    // check for negative sizes
    if ( t_command_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:20", t_command_string_length);
    command_.init(t_dataptr_after_anonymous_field_007, t_command_string_length);

    const_byteptr const t_dataptr_after_command = t_dataptr_after_anonymous_field_007 + (t_command__size);
    BINPAC_ASSERT(t_dataptr_after_command <= t_end_of_data);
    // Parse "anonymous_field_008"
    bytestring anonymous_field_008_;
    int t_anonymous_field_008_string_length;
    t_anonymous_field_008_string_length = 
        OPTIONALSPACING_re_004.MatchPrefix(
            t_dataptr_after_command,
            t_end_of_data - t_dataptr_after_command);
    if ( t_anonymous_field_008_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:21", "[ ]*", string(reinterpret_cast<const char*>(t_dataptr_after_command), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_008__size;
    t_anonymous_field_008__size = t_anonymous_field_008_string_length;
    anonymous_field_008_.free();

    const_byteptr const t_dataptr_after_anonymous_field_008 = t_dataptr_after_command + (t_anonymous_field_008__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_008 <= t_end_of_data);
    // Parse "client_or_server"
    pcommand_ = t_context->connection()->determine_command(is_orig(), tag(), command());
    int t_client_or_server__size;
    client_or_server_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( client_or_server_case_index() ) {
        case true:
            // Parse "client"
            {
                client_ = new UnknownCommand(this);
                int t_client__size;
                t_client__size = client_->Parse(t_dataptr_after_anonymous_field_008, t_end_of_data, t_context);
                t_client_or_server__size = t_client__size;
            }
            break;
        case false:
            // Parse "server"
            {
                server_ = new ServerContentText(this);
                int t_server__size;
                t_server__size = server_->Parse(t_dataptr_after_anonymous_field_008, t_end_of_data, t_context);
                t_client_or_server__size = t_server__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ImapToken", (int64)client_or_server_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ImapToken__size;
    const_byteptr const t_dataptr_after_client_or_server = t_dataptr_after_anonymous_field_008 + (t_client_or_server__size);
    BINPAC_ASSERT(t_dataptr_after_client_or_server <= t_end_of_data);
    t_ImapToken__size = t_dataptr_after_client_or_server - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_imap_token(is_orig(), tag(), command());
    BINPAC_ASSERT(t_begin_of_data + (t_ImapToken__size) <= t_end_of_data);
    return t_ImapToken__size;
}

ServerContentText::ServerContentText(ImapToken* rec) {
    val_case_index_ = -1;
    capability_ = nullptr;
    unknown_ = nullptr;
    rec_ = rec;
}

ServerContentText::~ServerContentText() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Clean up "capability"
            {
                delete capability_;
                capability_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                delete unknown_;
                unknown_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ServerContentText::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextIMAP* t_context) {
    int t_val__size;
    val_case_index_ = rec()->pcommand();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Parse "capability"
            {
                capability_ = new ServerCapability(rec());
                int t_capability__size;
                t_capability__size = capability_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_capability__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                unknown_ = new UnknownCommand(rec());
                int t_unknown__size;
                t_unknown__size = unknown_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Capability::Capability() {
}

Capability::~Capability() {
    cap_.free();
    nl_.free();
}

int Capability::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "cap"
    int t_cap_string_length;
    t_cap_string_length = 
        TAG_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_cap_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:36", "[[:alnum:][:punct:]]+", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_cap__size;
    t_cap__size = t_cap_string_length;
    // check for negative sizes
    if ( t_cap_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:36", t_cap_string_length);
    cap_.init(t_begin_of_data, t_cap_string_length);

    const_byteptr const t_dataptr_after_cap = t_begin_of_data + (t_cap__size);
    BINPAC_ASSERT(t_dataptr_after_cap <= t_end_of_data);
    // Parse "anonymous_field_009"
    bytestring anonymous_field_009_;
    int t_anonymous_field_009_string_length;
    t_anonymous_field_009_string_length = 
        OPTIONALSPACING_re_004.MatchPrefix(
            t_dataptr_after_cap,
            t_end_of_data - t_dataptr_after_cap);
    if ( t_anonymous_field_009_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:37", "[ ]*", string(reinterpret_cast<const char*>(t_dataptr_after_cap), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_009__size;
    t_anonymous_field_009__size = t_anonymous_field_009_string_length;
    anonymous_field_009_.free();

    const_byteptr const t_dataptr_after_anonymous_field_009 = t_dataptr_after_cap + (t_anonymous_field_009__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_009 <= t_end_of_data);
    // Parse "nl"
    int t_nl_string_length;
    t_nl_string_length = 
        OPTIONALNEWLINE_re_006.MatchPrefix(
            t_dataptr_after_anonymous_field_009,
            t_end_of_data - t_dataptr_after_anonymous_field_009);
    if ( t_nl_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:38", "[\\r\\n]*", string(reinterpret_cast<const char*>(t_dataptr_after_anonymous_field_009), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_nl__size;
    t_nl__size = t_nl_string_length;
    // check for negative sizes
    if ( t_nl_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:38", t_nl_string_length);
    nl_.init(t_dataptr_after_anonymous_field_009, t_nl_string_length);

    int t_Capability__size;
    const_byteptr const t_dataptr_after_nl = t_dataptr_after_anonymous_field_009 + (t_nl__size);
    BINPAC_ASSERT(t_dataptr_after_nl <= t_end_of_data);
    t_Capability__size = t_dataptr_after_nl - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Capability__size) <= t_end_of_data);
    return t_Capability__size;
}

ServerCapability::ServerCapability(ImapToken* rec) {
    capabilities_ = nullptr;
    capabilities__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

ServerCapability::~ServerCapability() {
    delete capabilities__elem_;
    capabilities__elem_ = nullptr;
    if ( capabilities() ) {
        for ( auto* capabilities__elem_ : *capabilities() ) {
            delete capabilities__elem_;
            capabilities__elem_ = nullptr;
        }
    }
    delete capabilities_;
}

int ServerCapability::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextIMAP* t_context) {
    // Parse "capabilities"
    int t_capabilities__arraylength;
    t_capabilities__arraylength = 0;
    capabilities__elem_ = nullptr;
    int t_capabilities__elem__it;
    t_capabilities__elem__it = 0;
    int t_capabilities__size;
    capabilities_ = new vector<Capability*>;
    const_byteptr t_capabilities__elem__dataptr = t_begin_of_data;
    for (; /* forever */; ++t_capabilities__elem__it) {
        // Check &until(capabilities__elem__dataptr >= end_of_data)
        if ( t_capabilities__elem__dataptr >= t_end_of_data ) {
            capabilities__elem_ = nullptr;
            goto end_of_capabilities;
        }
        capabilities__elem_ = new Capability();
        int t_capabilities__elem__size;
        t_capabilities__elem__size = capabilities__elem_->Parse(t_capabilities__elem__dataptr, t_end_of_data);
        capabilities_->push_back(capabilities__elem_);
        t_capabilities__elem__dataptr += t_capabilities__elem__size;
        BINPAC_ASSERT(t_capabilities__elem__dataptr <= t_end_of_data);
        // Check &until( ( @@$context->connection@->strlen@(@$element->nl@) > ((int) 0) ) )
        if (  ( t_context->connection()->strlen(capabilities__elem_->nl()) > 0 )  ) {
            capabilities__elem_ = nullptr;
            goto end_of_capabilities;
        }
        capabilities__elem_ = nullptr;
    }
end_of_capabilities: ;
    t_capabilities__size = t_capabilities__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    int t_ServerCapability__size;
    const_byteptr const t_dataptr_after_capabilities = t_begin_of_data + (t_capabilities__size);
    BINPAC_ASSERT(t_dataptr_after_capabilities <= t_end_of_data);
    t_ServerCapability__size = t_dataptr_after_capabilities - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_server_capability(capabilities());
    BINPAC_ASSERT(t_begin_of_data + (t_ServerCapability__size) <= t_end_of_data);
    return t_ServerCapability__size;
}

UnknownCommand::UnknownCommand(ImapToken* rec) {
    rec_ = rec;
}

UnknownCommand::~UnknownCommand() {
    tagcontent_.free();
}

int UnknownCommand::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextIMAP* t_context) {
    // Parse "tagcontent"
    int t_tagcontent_string_length;
    t_tagcontent_string_length = 
        CONTENT_re_002.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_tagcontent_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:46", "[^\\r\\n]*", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_tagcontent__size;
    t_tagcontent__size = t_tagcontent_string_length;
    // check for negative sizes
    if ( t_tagcontent_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:46", t_tagcontent_string_length);
    tagcontent_.init(t_begin_of_data, t_tagcontent_string_length);

    const_byteptr const t_dataptr_after_tagcontent = t_begin_of_data + (t_tagcontent__size);
    BINPAC_ASSERT(t_dataptr_after_tagcontent <= t_end_of_data);
    // Parse "anonymous_field_010"
    bytestring anonymous_field_010_;
    int t_anonymous_field_010_string_length;
    t_anonymous_field_010_string_length = 
        NEWLINE_re_005.MatchPrefix(
            t_dataptr_after_tagcontent,
            t_end_of_data - t_dataptr_after_tagcontent);
    if ( t_anonymous_field_010_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/imap/imap-protocol.pac:47", "[\\r\\n]+", string(reinterpret_cast<const char*>(t_dataptr_after_tagcontent), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_010__size;
    t_anonymous_field_010__size = t_anonymous_field_010_string_length;
    anonymous_field_010_.free();

    int t_UnknownCommand__size;
    const_byteptr const t_dataptr_after_anonymous_field_010 = t_dataptr_after_tagcontent + (t_anonymous_field_010__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_010 <= t_end_of_data);
    t_UnknownCommand__size = t_dataptr_after_anonymous_field_010 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UnknownCommand__size) <= t_end_of_data);
    return t_UnknownCommand__size;
}

IMAP_Flow::IMAP_Flow(IMAP_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

IMAP_Flow::~IMAP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void IMAP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new IMAP_PDU(is_orig());
        context_ = new ContextIMAP(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e;
    }
}

void IMAP_Flow::NewGap(int gap_length) {
}
void IMAP_Flow::FlowEOF() {
}
} // namespace IMAP
}  // namespace binpac
