// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/krb/krb_TCP.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_krb_krb_TCP_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_krb_krb_TCP_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


namespace zeek::analyzer::krb_tcp { class KRB_Analyzer; }
namespace binpac { namespace KRB_TCP { class KRB_Conn; } }
using KRBTCPAnalyzer = zeek::analyzer::krb_tcp::KRB_Analyzer*;

#include "zeek/zeek-config.h"
#include "zeek/analyzer/protocol/krb/KRB_TCP.h"

#include "zeek/analyzer/protocol/krb/types.bif.h"
#include "zeek/analyzer/protocol/krb/events.bif.h"


#include <cstdlib>


#include "zeek/file_analysis/Manager.h"
#include "zeek/Desc.h"

namespace binpac {

namespace KRB_TCP {
class ContextKRB_TCP;
class KRB_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum ASN1TypeTag {
    ASN1_INTEGER_TAG = 2,
    ASN1_OCTET_STRING_TAG = 4,
    ASN1_NULL_TAG = 5,
    ASN1_OBJECT_IDENTIFIER_TAG = 6,
    ASN1_SEQUENCE_TAG = 48,
    ASN1_APP_TAG_OFFSET = 96,
    ASN1_INDEX_TAG_OFFSET = 160,
};
class ASN1Encoding;
class ASN1EncodingMeta;
class ASN1OptionalEncodingMeta;
class ASN1SequenceMeta;
class ASN1Integer;
class ASN1OctetString;
class ASN1ObjectIdentifier;
class ASN1Boolean;
class ASN1Enumerated;
class SequenceElement;
class Array;
// NOLINTNEXTLINE(performance-enum-size)
enum KRBMessageTypes {
    AS_REQ = 10,
    AS_REP = 11,
    TGS_REQ = 12,
    TGS_REP = 13,
    AP_REQ = 14,
    AP_REP = 15,
    KRB_SAFE = 20,
    KRB_PRIV = 21,
    KRB_CRED = 22,
    KRB_ERROR = 30,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KRBPADataTypes {
    PA_TGS_REQ = 1,
    PA_ENC_TIMESTAMP = 2,
    PA_PW_SALT = 3,
    PA_ENCTYPE_INFO = 11,
    PA_PW_AS_REQ = 16,
    PA_PW_AS_REP = 17,
    PA_ENCTYPE_INFO2 = 19,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KRBErrorCodes {
    KDC_ERR_PREAUTH_REQUIRED = 25,
};
class KRB_Principal_Name;
class KRB_Time;
class KRB_Host_Addresses;
class KRB_Host_Address;
class KRB_Ticket;
class KRB_Ticket_Sequence;
class KRB_Encrypted_Data_in_Seq;
class KRB_Encrypted_Data;
class KRB_Checksum;
class KRB_PA_Data_Optional;
class KRB_PA_Data_Optional_Contents;
class KRB_PA_Data_Sequence;
class KRB_PA_Data_Container;
class KRB_PA_Data;
class KRB_PA_Data_Element;
class KRB_PA_AP_REQ_wrapper;
class KRB_PA_PK_AS_Req;
class KRB_PA_PK_AS_Rep;
class KRB_PA_ENCTYPE_INFO;
class KRB_PDU_TCP;
class KRB_PDU;
class KRB_AS_REQ;
class KRB_TGS_REQ;
class KRB_AS_REP;
class KRB_TGS_REP;
class KRB_KDC_REQ;
class KRB_REQ_Arg;
class KRB_REQ_Arg_Data;
class KRB_KDC_Options;
class KRB_KDC_REP;
class KRB_AP_REQ;
class KRB_AP_Options;
class KRB_AP_REP;
class KRB_ERROR_MSG;
class KRB_ERROR_Arg;
class KRB_ERROR_Arg_Data;
class KRB_ERROR_E_Data;
class KRB_SAFE_MSG;
class KRB_SAFE_Body;
class KRB_SAFE_Arg;
class KRB_SAFE_Arg_Data;
class KRB_PRIV_MSG;
class KRB_CRED_MSG;
class KRB_Flow;
} // namespace KRB_TCP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace KRB_TCP {

class ContextKRB_TCP final {
public:
    ContextKRB_TCP(KRB_Conn* connection, KRB_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextKRB_TCP();

    // Member access functions
    KRB_Conn* connection() const { return connection_; }
    KRB_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    KRB_Conn* connection_;
    KRB_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class KRB_Conn final : public binpac::ConnectionAnalyzer {
public:
    KRB_Conn(KRBTCPAnalyzer const& zeek_analyzer);
    ~KRB_Conn() override;

    // Member access functions
    KRB_Flow* upflow() const { return upflow_; }
    KRB_Flow* downflow() const { return downflow_; }
    KRBTCPAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool proc_krb_kdc_req_msg(KRB_KDC_REQ* msg);
    bool proc_krb_kdc_rep_msg(KRB_KDC_REP* msg);
    bool proc_krb_error_msg(KRB_ERROR_MSG* msg);
    bool proc_krb_ap_req_msg(KRB_AP_REQ* msg);
    bool proc_krb_ap_rep_msg(KRB_AP_REP* msg);
    bool proc_krb_safe_msg(KRB_SAFE_MSG* msg);
    bool proc_krb_priv_msg(KRB_PRIV_MSG* msg);
    bool proc_krb_cred_msg(KRB_CRED_MSG* msg);

protected:
    KRB_Flow* upflow_;
    KRB_Flow* downflow_;
    KRBTCPAnalyzer zeek_analyzer_;
};


	zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t);
	zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t);
	zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid);
	zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s);


class ASN1Encoding final {
public:
    ASN1Encoding();
    ~ASN1Encoding();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    bytestring const& content() const { return content_; }

protected:
    ASN1EncodingMeta* meta_;
    bytestring content_;
};


class ASN1EncodingMeta final {
public:
    ASN1EncodingMeta();
    ~ASN1EncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 tag() const { return tag_; }
    uint8 len() const { return len_; }
    bytestring const& more_len() const { return more_len_; }
    bool long_len() const { return long_len_; }
    uint64 length() const { return length_; }
    uint8 index() const { return index_; }

protected:
    uint8 tag_;
    uint8 len_;
    bytestring more_len_;
    bool long_len_;
    uint64 length_;
    uint8 index_;
};


class ASN1OptionalEncodingMeta final {
public:
    ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata);
    ~ASN1OptionalEncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ASN1EncodingMeta* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/../asn1/asn1.pac:42:data", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    bool is_present() const { return is_present_; }
    ASN1EncodingMeta* previous_metadata() const { return previous_metadata_; }
    uint64 length() const { return length_; }

protected:
    int val_case_index_;
    ASN1EncodingMeta* data_;
    bool is_present_;
    ASN1EncodingMeta* previous_metadata_;
    uint64 length_;
};


class ASN1SequenceMeta final {
public:
    ASN1SequenceMeta();
    ~ASN1SequenceMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* encoding() const { return encoding_; }

protected:
    ASN1EncodingMeta* encoding_;
};


class ASN1Integer final {
public:
    ASN1Integer();
    ~ASN1Integer();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1OctetString final {
public:
    ASN1OctetString();
    ~ASN1OctetString();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1ObjectIdentifier final {
public:
    ASN1ObjectIdentifier();
    ~ASN1ObjectIdentifier();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Boolean final {
public:
    ASN1Boolean();
    ~ASN1Boolean();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Enumerated final {
public:
    ASN1Enumerated();
    ~ASN1Enumerated();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class SequenceElement final {
public:
    SequenceElement(bool grab_content);
    ~SequenceElement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* index_meta() const { return index_meta_; }
    int have_content_case_index() const	{ return have_content_case_index_; }
    ASN1Encoding* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/../asn1/asn1.pac:75:data", (int64)have_content_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    ASN1EncodingMeta* meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/../asn1/asn1.pac:76:meta", (int64)have_content_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return meta_;
    }
    bool grab_content() const { return grab_content_; }
    uint8 index() const { return index_; }
    uint64 length() const { return length_; }

protected:
    ASN1EncodingMeta* index_meta_;
    int have_content_case_index_;
    ASN1Encoding* data_;
    ASN1EncodingMeta* meta_;
    bool grab_content_;
    uint8 index_;
    uint64 length_;
};


class Array final {
public:
    Array();
    ~Array();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* array_meta() const { return array_meta_; }
    vector<ASN1Encoding*>* data() const { return data_; }

protected:
    ASN1EncodingMeta* array_meta_;
    vector<ASN1Encoding*>* data_;
    ASN1Encoding* data__elem_;
};

int64 binary_to_int64(bytestring const& bs);

    zeek::ValPtr GetTimeFromAsn1(const KRB_Time* atime, int64 usecs);
    zeek::ValPtr GetTimeFromAsn1(zeek::StringVal* atime, int64 usecs);


zeek::ValPtr GetStringFromPrincipalName(const KRB_Principal_Name* pname);

zeek::VectorValPtr proc_cipher_list(const Array* list);

zeek::VectorValPtr proc_host_address_list(const ZeekAnalyzer a, const KRB_Host_Addresses* list);
zeek::RecordValPtr proc_host_address(const ZeekAnalyzer a, const KRB_Host_Address* addr);

zeek::VectorValPtr proc_tickets(const KRB_Ticket_Sequence* list);
zeek::RecordValPtr proc_ticket(const KRB_Ticket* ticket);

zeek::RecordValPtr proc_encrypted_data(const KRB_Encrypted_Data* encrypted_data);


class KRB_Principal_Name final {
public:
    KRB_Principal_Name();
    ~KRB_Principal_Name();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    ASN1EncodingMeta* name_meta() const { return name_meta_; }
    ASN1Integer* name_type() const { return name_type_; }
    ASN1EncodingMeta* seq_meta_1() const { return seq_meta_1_; }
    ASN1EncodingMeta* seq_meta_2() const { return seq_meta_2_; }
    vector<ASN1OctetString*>* data() const { return data_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    ASN1EncodingMeta* name_meta_;
    ASN1Integer* name_type_;
    ASN1EncodingMeta* seq_meta_1_;
    ASN1EncodingMeta* seq_meta_2_;
    vector<ASN1OctetString*>* data_;
    ASN1OctetString* data__elem_;
};


class KRB_Time final {
public:
    KRB_Time();
    ~KRB_Time();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    bytestring const& time() const { return time_; }

protected:
    ASN1EncodingMeta* meta_;
    bytestring time_;
};


class KRB_Host_Addresses final {
public:
    KRB_Host_Addresses();
    ~KRB_Host_Addresses();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    vector<KRB_Host_Address*>* addresses() const { return addresses_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    vector<KRB_Host_Address*>* addresses_;
    KRB_Host_Address* addresses__elem_;
};


class KRB_Host_Address final {
public:
    KRB_Host_Address();
    ~KRB_Host_Address();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    SequenceElement* addr_type_meta() const { return addr_type_meta_; }
    ASN1Integer* addr_type() const { return addr_type_; }
    SequenceElement* address() const { return address_; }

protected:
    SequenceElement* addr_type_meta_;
    ASN1Integer* addr_type_;
    SequenceElement* address_;
};


class KRB_Ticket final {
public:
    KRB_Ticket(bool in_sequence);
    ~KRB_Ticket();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    int have_seq_case_index() const	{ return have_seq_case_index_; }
    ASN1EncodingMeta* meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_seq_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-types.pac:159:meta", (int64)have_seq_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return meta_;
    }
    ASN1EncodingMeta* app_meta() const { return app_meta_; }
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    SequenceElement* tkt_vno() const { return tkt_vno_; }
    SequenceElement* realm() const { return realm_; }
    ASN1EncodingMeta* sname_meta() const { return sname_meta_; }
    KRB_Principal_Name* sname() const { return sname_; }
    KRB_Encrypted_Data_in_Seq* enc_part() const { return enc_part_; }
    bool in_sequence() const { return in_sequence_; }

protected:
    int have_seq_case_index_;
    ASN1EncodingMeta* meta_;
    ASN1EncodingMeta* app_meta_;
    ASN1EncodingMeta* seq_meta_;
    SequenceElement* tkt_vno_;
    SequenceElement* realm_;
    ASN1EncodingMeta* sname_meta_;
    KRB_Principal_Name* sname_;
    KRB_Encrypted_Data_in_Seq* enc_part_;
    bool in_sequence_;
};


class KRB_Ticket_Sequence final {
public:
    KRB_Ticket_Sequence();
    ~KRB_Ticket_Sequence();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    vector<KRB_Ticket*>* tickets() const { return tickets_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    vector<KRB_Ticket*>* tickets_;
    KRB_Ticket* tickets__elem_;
};


class KRB_Encrypted_Data_in_Seq final {
public:
    KRB_Encrypted_Data_in_Seq();
    ~KRB_Encrypted_Data_in_Seq();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* index_meta() const { return index_meta_; }
    KRB_Encrypted_Data* data() const { return data_; }

protected:
    ASN1EncodingMeta* index_meta_;
    KRB_Encrypted_Data* data_;
};


class KRB_Encrypted_Data final {
public:
    KRB_Encrypted_Data();
    ~KRB_Encrypted_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    SequenceElement* etype() const { return etype_; }
    ASN1EncodingMeta* kvno_meta() const { return kvno_meta_; }
    int case_kvno_case_index() const	{ return case_kvno_case_index_; }
    ASN1Integer* kvno() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( case_kvno_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-types.pac:186:kvno", (int64)case_kvno_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kvno_;
    }
    int grab_next_meta_case_index() const	{ return grab_next_meta_case_index_; }
    ASN1EncodingMeta* next_meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( grab_next_meta_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-types.pac:190:next_meta", (int64)grab_next_meta_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return next_meta_;
    }
    ASN1OctetString* ciphertext() const { return ciphertext_; }
    bool have_kvno() const { return have_kvno_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    SequenceElement* etype_;
    ASN1EncodingMeta* kvno_meta_;
    int case_kvno_case_index_;
    ASN1Integer* kvno_;
    int grab_next_meta_case_index_;
    ASN1EncodingMeta* next_meta_;
    ASN1OctetString* ciphertext_;
    bool have_kvno_;
};


class KRB_Checksum final {
public:
    KRB_Checksum();
    ~KRB_Checksum();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    SequenceElement* checksum_type() const { return checksum_type_; }
    SequenceElement* checksum() const { return checksum_; }

protected:
    SequenceElement* checksum_type_;
    SequenceElement* checksum_;
};


zeek::VectorValPtr proc_padata(const KRB_PA_Data_Sequence* data, const ZeekAnalyzer zeek_analyzer, bool is_error);


class KRB_PA_Data_Optional final {
public:
    KRB_PA_Data_Optional(bool is_orig, uint8 pkt_type, uint8 desired_index);
    ~KRB_PA_Data_Optional();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* first_meta() const { return first_meta_; }
    KRB_PA_Data_Optional_Contents* padata() const { return padata_; }
    ASN1OptionalEncodingMeta* next_meta() const { return next_meta_; }
    bool is_orig() const { return is_orig_; }
    uint8 pkt_type() const { return pkt_type_; }
    uint8 desired_index() const { return desired_index_; }
    bool has_padata() const { return has_padata_; }

protected:
    ASN1EncodingMeta* first_meta_;
    KRB_PA_Data_Optional_Contents* padata_;
    ASN1OptionalEncodingMeta* next_meta_;
    bool is_orig_;
    uint8 pkt_type_;
    uint8 desired_index_;
    bool has_padata_;
};


class KRB_PA_Data_Optional_Contents final {
public:
    KRB_PA_Data_Optional_Contents(bool is_orig, bool is_present, uint8 pkt_type, uint64 length);
    ~KRB_PA_Data_Optional_Contents();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    KRB_PA_Data_Sequence* padata() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:153:padata", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return padata_;
    }
    bool is_orig() const { return is_orig_; }
    bool is_present() const { return is_present_; }
    uint8 pkt_type() const { return pkt_type_; }
    uint64 length() const { return length_; }

protected:
    int val_case_index_;
    KRB_PA_Data_Sequence* padata_;
    bool is_orig_;
    bool is_present_;
    uint8 pkt_type_;
    uint64 length_;
};


class KRB_PA_Data_Sequence final {
public:
    KRB_PA_Data_Sequence(bool is_orig, uint8 pkt_type);
    ~KRB_PA_Data_Sequence();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    KRB_PA_Data_Container* data() const { return data_; }
    bool is_orig() const { return is_orig_; }
    uint8 pkt_type() const { return pkt_type_; }

protected:
    ASN1EncodingMeta* meta_;
    KRB_PA_Data_Container* data_;
    bool is_orig_;
    uint8 pkt_type_;
};


class KRB_PA_Data_Container final {
public:
    KRB_PA_Data_Container(bool is_orig, uint8 pkt_type, uint8 tag, uint64 length);
    ~KRB_PA_Data_Container();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    vector<KRB_PA_Data*>* padata_elems() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)48):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:168:padata_elems", (int64)val_case_index(), "ASN1_SEQUENCE_TAG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return padata_elems_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 pkt_type() const { return pkt_type_; }
    uint8 tag() const { return tag_; }
    uint64 length() const { return length_; }
    bool has_padata() const { return has_padata_; }

protected:
    uint8 val_case_index_;
    vector<KRB_PA_Data*>* padata_elems_;
    KRB_PA_Data* padata_elems__elem_;
    bytestring unknown_;
    bool is_orig_;
    uint8 pkt_type_;
    uint8 tag_;
    uint64 length_;
    bool has_padata_;
};


class KRB_PA_Data final {
public:
    KRB_PA_Data(bool is_orig, uint8 pkt_type);
    ~KRB_PA_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    SequenceElement* pa_data_type() const { return pa_data_type_; }
    ASN1EncodingMeta* pa_data_elem_meta() const { return pa_data_elem_meta_; }
    uint8 have_data_case_index() const	{ return have_data_case_index_; }
    bytestring const& pa_data_placeholder() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_data_case_index() ) {
            case ((uint8)30):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:182:pa_data_placeholder", (int64)have_data_case_index(), "KRB_ERROR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pa_data_placeholder_;
    }
    KRB_PA_Data_Element* pa_data_element() const {
        return pa_data_element_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 pkt_type() const { return pkt_type_; }
    int64 data_type() const { return data_type_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    SequenceElement* pa_data_type_;
    ASN1EncodingMeta* pa_data_elem_meta_;
    uint8 have_data_case_index_;
    bytestring pa_data_placeholder_;
    KRB_PA_Data_Element* pa_data_element_;
    bool is_orig_;
    uint8 pkt_type_;
    int64 data_type_;
};


class KRB_PA_Data_Element final {
public:
    KRB_PA_Data_Element(bool is_orig, int64 type, uint64 length);
    ~KRB_PA_Data_Element();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    int64 val_case_index() const	{ return val_case_index_; }
    KRB_PA_AP_REQ_wrapper* pa_tgs_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:191:pa_tgs_req", (int64)val_case_index(), "PA_TGS_REQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pa_tgs_req_;
    }
    KRB_Encrypted_Data* pa_enc_ts() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:192:pa_enc_ts", (int64)val_case_index(), "PA_ENC_TIMESTAMP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pa_enc_ts_;
    }
    ASN1OctetString* pa_pw_salt() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:193:pa_pw_salt", (int64)val_case_index(), "PA_PW_SALT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pa_pw_salt_;
    }
    KRB_PA_PK_AS_Req* pa_pk_as_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:194:pa_pk_as_req", (int64)val_case_index(), "PA_PW_AS_REQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pa_pk_as_req_;
    }
    KRB_PA_PK_AS_Rep* pa_pk_as_rep() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)17):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:195:pa_pk_as_rep", (int64)val_case_index(), "PA_PW_AS_REP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pa_pk_as_rep_;
    }
    KRB_PA_ENCTYPE_INFO* pf_enctype_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:196:pf_enctype_info", (int64)val_case_index(), "PA_ENCTYPE_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pf_enctype_info_;
    }
    KRB_PA_ENCTYPE_INFO* pf_enctype_info2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)19):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:197:pf_enctype_info2", (int64)val_case_index(), "PA_ENCTYPE_INFO2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pf_enctype_info2_;
    }
    ASN1Encoding* unknown() const {
        return unknown_;
    }
    bool is_orig() const { return is_orig_; }
    int64 type() const { return type_; }
    uint64 length() const { return length_; }

protected:
    int64 val_case_index_;
    KRB_PA_AP_REQ_wrapper* pa_tgs_req_;
    KRB_Encrypted_Data* pa_enc_ts_;
    ASN1OctetString* pa_pw_salt_;
    KRB_PA_PK_AS_Req* pa_pk_as_req_;
    KRB_PA_PK_AS_Rep* pa_pk_as_rep_;
    KRB_PA_ENCTYPE_INFO* pf_enctype_info_;
    KRB_PA_ENCTYPE_INFO* pf_enctype_info2_;
    ASN1Encoding* unknown_;
    bool is_orig_;
    int64 type_;
    uint64 length_;
};


class KRB_PA_AP_REQ_wrapper final {
public:
    KRB_PA_AP_REQ_wrapper(bool is_orig);
    ~KRB_PA_AP_REQ_wrapper();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* some_meta1() const { return some_meta1_; }
    ASN1EncodingMeta* some_meta2() const { return some_meta2_; }
    KRB_AP_REQ* req() const { return req_; }
    bool is_orig() const { return is_orig_; }

protected:
    ASN1EncodingMeta* some_meta1_;
    ASN1EncodingMeta* some_meta2_;
    KRB_AP_REQ* req_;
    bool is_orig_;
};


class KRB_PA_PK_AS_Req final {
public:
    KRB_PA_PK_AS_Req();
    ~KRB_PA_PK_AS_Req();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* string_meta() const { return string_meta_; }
    ASN1EncodingMeta* seq_meta1() const { return seq_meta1_; }
    ASN1EncodingMeta* elem_0_meta1() const { return elem_0_meta1_; }
    ASN1EncodingMeta* seq_meta2() const { return seq_meta2_; }
    ASN1Encoding* oid() const { return oid_; }
    ASN1EncodingMeta* elem_0_meta2() const { return elem_0_meta2_; }
    ASN1EncodingMeta* seq_meta3() const { return seq_meta3_; }
    ASN1Encoding* version() const { return version_; }
    ASN1Encoding* digest_algs() const { return digest_algs_; }
    ASN1Encoding* signed_data() const { return signed_data_; }
    ASN1EncodingMeta* cert_meta() const { return cert_meta_; }
    bytestring const& cert() const { return cert_; }

protected:
    ASN1EncodingMeta* string_meta_;
    ASN1EncodingMeta* seq_meta1_;
    ASN1EncodingMeta* elem_0_meta1_;
    ASN1EncodingMeta* seq_meta2_;
    ASN1Encoding* oid_;
    ASN1EncodingMeta* elem_0_meta2_;
    ASN1EncodingMeta* seq_meta3_;
    ASN1Encoding* version_;
    ASN1Encoding* digest_algs_;
    ASN1Encoding* signed_data_;
    ASN1EncodingMeta* cert_meta_;
    bytestring cert_;
    const_bytestring anonymous_field_001_;
};


class KRB_PA_PK_AS_Rep final {
public:
    KRB_PA_PK_AS_Rep();
    ~KRB_PA_PK_AS_Rep();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* string_meta() const { return string_meta_; }
    ASN1EncodingMeta* elem_0_meta1() const { return elem_0_meta1_; }
    ASN1EncodingMeta* seq_meta1() const { return seq_meta1_; }
    ASN1EncodingMeta* elem_0_meta2() const { return elem_0_meta2_; }
    ASN1EncodingMeta* seq_meta2() const { return seq_meta2_; }
    ASN1Encoding* oid() const { return oid_; }
    ASN1EncodingMeta* elem_0_meta3() const { return elem_0_meta3_; }
    ASN1EncodingMeta* seq_meta3() const { return seq_meta3_; }
    ASN1Encoding* version() const { return version_; }
    ASN1Encoding* digest_algs() const { return digest_algs_; }
    ASN1Encoding* signed_data() const { return signed_data_; }
    ASN1EncodingMeta* cert_meta() const { return cert_meta_; }
    bytestring const& cert() const { return cert_; }

protected:
    ASN1EncodingMeta* string_meta_;
    ASN1EncodingMeta* elem_0_meta1_;
    ASN1EncodingMeta* seq_meta1_;
    ASN1EncodingMeta* elem_0_meta2_;
    ASN1EncodingMeta* seq_meta2_;
    ASN1Encoding* oid_;
    ASN1EncodingMeta* elem_0_meta3_;
    ASN1EncodingMeta* seq_meta3_;
    ASN1Encoding* version_;
    ASN1Encoding* digest_algs_;
    ASN1Encoding* signed_data_;
    ASN1EncodingMeta* cert_meta_;
    bytestring cert_;
    const_bytestring anonymous_field_002_;
};


class KRB_PA_ENCTYPE_INFO final {
public:
    KRB_PA_ENCTYPE_INFO();
    ~KRB_PA_ENCTYPE_INFO();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* some_meta1() const { return some_meta1_; }
    ASN1EncodingMeta* some_meta2() const { return some_meta2_; }
    ASN1EncodingMeta* seq_meta1() const { return seq_meta1_; }
    ASN1Encoding* etype() const { return etype_; }
    int optional_seq_meta2_case_index() const	{ return optional_seq_meta2_case_index_; }
    ASN1EncodingMeta* seq_meta2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( optional_seq_meta2_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:252:seq_meta2", (int64)optional_seq_meta2_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return seq_meta2_;
    }
    int optional_string_meta_case_index() const	{ return optional_string_meta_case_index_; }
    ASN1EncodingMeta* string_meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( optional_string_meta_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:256:string_meta", (int64)optional_string_meta_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return string_meta_;
    }
    bytestring const& salt() const { return salt_; }
    bool has_string() const { return has_string_; }
    uint32 salt_length() const { return salt_length_; }

protected:
    ASN1EncodingMeta* some_meta1_;
    ASN1EncodingMeta* some_meta2_;
    ASN1EncodingMeta* seq_meta1_;
    ASN1Encoding* etype_;
    int optional_seq_meta2_case_index_;
    ASN1EncodingMeta* seq_meta2_;
    int optional_string_meta_case_index_;
    ASN1EncodingMeta* string_meta_;
    bytestring salt_;
    bool has_string_;
    uint32 salt_length_;
};


class KRB_PDU_TCP final {
public:
    KRB_PDU_TCP(bool is_orig);
    ~KRB_PDU_TCP();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextKRB_TCP* t_context);

    // Member access functions
    uint32 size() const { return size_; }
    KRB_PDU* pdu() const { return pdu_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    uint32 size_;
    KRB_PDU* pdu_;
    bool is_orig_;
    int byteorder_;
    int buffering_state_;
};


class KRB_PDU final {
public:
    KRB_PDU(bool is_orig);
    ~KRB_PDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context);

    // Member access functions
    ASN1EncodingMeta* app_meta() const { return app_meta_; }
    int msg_type_case_index() const	{ return msg_type_case_index_; }
    KRB_AS_REQ* as_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:22:as_req", (int64)msg_type_case_index(), "AS_REQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return as_req_;
    }
    KRB_AS_REP* as_rep() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:23:as_rep", (int64)msg_type_case_index(), "AS_REP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return as_rep_;
    }
    KRB_TGS_REQ* tgs_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:24:tgs_req", (int64)msg_type_case_index(), "TGS_REQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tgs_req_;
    }
    KRB_TGS_REP* tgs_rep() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:25:tgs_rep", (int64)msg_type_case_index(), "TGS_REP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tgs_rep_;
    }
    KRB_AP_REQ* ap_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:26:ap_req", (int64)msg_type_case_index(), "AP_REQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ap_req_;
    }
    KRB_AP_REP* ap_rep() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:27:ap_rep", (int64)msg_type_case_index(), "AP_REP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ap_rep_;
    }
    KRB_SAFE_MSG* krb_safe() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:28:krb_safe", (int64)msg_type_case_index(), "KRB_SAFE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return krb_safe_;
    }
    KRB_PRIV_MSG* krb_priv() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)21):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:29:krb_priv", (int64)msg_type_case_index(), "KRB_PRIV");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return krb_priv_;
    }
    KRB_CRED_MSG* krb_cred() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)22):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:30:krb_cred", (int64)msg_type_case_index(), "KRB_CRED");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return krb_cred_;
    }
    KRB_ERROR_MSG* krb_error() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case ((int)30):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:31:krb_error", (int64)msg_type_case_index(), "KRB_ERROR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return krb_error_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    ASN1EncodingMeta* app_meta_;
    int msg_type_case_index_;
    KRB_AS_REQ* as_req_;
    KRB_AS_REP* as_rep_;
    KRB_TGS_REQ* tgs_req_;
    KRB_TGS_REP* tgs_rep_;
    KRB_AP_REQ* ap_req_;
    KRB_AP_REP* ap_rep_;
    KRB_SAFE_MSG* krb_safe_;
    KRB_PRIV_MSG* krb_priv_;
    KRB_CRED_MSG* krb_cred_;
    KRB_ERROR_MSG* krb_error_;
    bool is_orig_;
    int byteorder_;
};


class KRB_AS_REQ final {
public:
    KRB_AS_REQ(bool is_orig);
    ~KRB_AS_REQ();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    KRB_KDC_REQ* data() const { return data_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    KRB_KDC_REQ* data_;
    bool is_orig_;
    bool proc_;
};


class KRB_TGS_REQ final {
public:
    KRB_TGS_REQ(bool is_orig);
    ~KRB_TGS_REQ();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    KRB_KDC_REQ* data() const { return data_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    KRB_KDC_REQ* data_;
    bool is_orig_;
    bool proc_;
};


class KRB_AS_REP final {
public:
    KRB_AS_REP(bool is_orig);
    ~KRB_AS_REP();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    KRB_KDC_REP* data() const { return data_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    KRB_KDC_REP* data_;
    bool is_orig_;
    bool proc_;
};


class KRB_TGS_REP final {
public:
    KRB_TGS_REP(bool is_orig);
    ~KRB_TGS_REP();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    KRB_KDC_REP* data() const { return data_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    KRB_KDC_REP* data_;
    bool is_orig_;
    bool proc_;
};


class KRB_KDC_REQ final {
public:
    KRB_KDC_REQ(bool is_orig, uint8 pkt_type);
    ~KRB_KDC_REQ();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    SequenceElement* pvno() const { return pvno_; }
    SequenceElement* msg_type() const { return msg_type_; }
    KRB_PA_Data_Optional* padata() const { return padata_; }
    ASN1EncodingMeta* body_meta() const { return body_meta_; }
    vector<KRB_REQ_Arg*>* body_args() const { return body_args_; }
    bool is_orig() const { return is_orig_; }
    uint8 pkt_type() const { return pkt_type_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    SequenceElement* pvno_;
    SequenceElement* msg_type_;
    KRB_PA_Data_Optional* padata_;
    ASN1EncodingMeta* body_meta_;
    vector<KRB_REQ_Arg*>* body_args_;
    KRB_REQ_Arg* body_args__elem_;
    bool is_orig_;
    uint8 pkt_type_;
};


class KRB_REQ_Arg final {
public:
    KRB_REQ_Arg();
    ~KRB_REQ_Arg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    KRB_REQ_Arg_Data* data() const { return data_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    KRB_REQ_Arg_Data* data_;
};


class KRB_REQ_Arg_Data final {
public:
    KRB_REQ_Arg_Data(uint8 index);
    ~KRB_REQ_Arg_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    KRB_KDC_Options* options() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:68:options", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return options_;
    }
    KRB_Principal_Name* principal() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:69:principal", (int64)val_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return principal_;
    }
    ASN1OctetString* realm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:70:realm", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return realm_;
    }
    KRB_Principal_Name* sname() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:71:sname", (int64)val_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return sname_;
    }
    KRB_Time* from() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:72:from", (int64)val_case_index(), "((int) 4)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return from_;
    }
    KRB_Time* till() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:73:till", (int64)val_case_index(), "((int) 5)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return till_;
    }
    KRB_Time* rtime() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:74:rtime", (int64)val_case_index(), "((int) 6)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rtime_;
    }
    ASN1Integer* nonce() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:75:nonce", (int64)val_case_index(), "((int) 7)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nonce_;
    }
    Array* etype() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:76:etype", (int64)val_case_index(), "((int) 8)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return etype_;
    }
    KRB_Host_Addresses* addrs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:77:addrs", (int64)val_case_index(), "((int) 9)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return addrs_;
    }
    ASN1OctetString* auth_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:78:auth_data", (int64)val_case_index(), "((int) 10)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_data_;
    }
    KRB_Ticket_Sequence* addl_tkts() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:79:addl_tkts", (int64)val_case_index(), "((int) 11)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return addl_tkts_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    uint8 index() const { return index_; }

protected:
    uint8 val_case_index_;
    KRB_KDC_Options* options_;
    KRB_Principal_Name* principal_;
    ASN1OctetString* realm_;
    KRB_Principal_Name* sname_;
    KRB_Time* from_;
    KRB_Time* till_;
    KRB_Time* rtime_;
    ASN1Integer* nonce_;
    Array* etype_;
    KRB_Host_Addresses* addrs_;
    ASN1OctetString* auth_data_;
    KRB_Ticket_Sequence* addl_tkts_;
    bytestring unknown_;
    uint8 index_;
};


class KRB_KDC_Options final {
public:
    KRB_KDC_Options();
    ~KRB_KDC_Options();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    uint8 pad() const { return pad_; }
    uint32 flags() const { return flags_; }
    bool reserved() const { return reserved_; }
    bool forwardable() const { return forwardable_; }
    bool forwarded() const { return forwarded_; }
    bool proxiable() const { return proxiable_; }
    bool proxy() const { return proxy_; }
    bool allow_postdate() const { return allow_postdate_; }
    bool postdated() const { return postdated_; }
    bool unused7() const { return unused7_; }
    bool renewable() const { return renewable_; }
    bool unused9() const { return unused9_; }
    bool unused10() const { return unused10_; }
    bool opt_hardware_auth() const { return opt_hardware_auth_; }
    bool unused12() const { return unused12_; }
    bool unused13() const { return unused13_; }
    bool unused15() const { return unused15_; }
    bool disable_transited_check() const { return disable_transited_check_; }
    bool renewable_ok() const { return renewable_ok_; }
    bool enc_tkt_in_skey() const { return enc_tkt_in_skey_; }
    bool renew() const { return renew_; }
    bool validate() const { return validate_; }

protected:
    ASN1EncodingMeta* meta_;
    uint8 pad_;
    uint32 flags_;
    bool reserved_;
    bool forwardable_;
    bool forwarded_;
    bool proxiable_;
    bool proxy_;
    bool allow_postdate_;
    bool postdated_;
    bool unused7_;
    bool renewable_;
    bool unused9_;
    bool unused10_;
    bool opt_hardware_auth_;
    bool unused12_;
    bool unused13_;
    bool unused15_;
    bool disable_transited_check_;
    bool renewable_ok_;
    bool enc_tkt_in_skey_;
    bool renew_;
    bool validate_;
};


class KRB_KDC_REP final {
public:
    KRB_KDC_REP(bool is_orig, uint8 pkt_type);
    ~KRB_KDC_REP();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    SequenceElement* pvno() const { return pvno_; }
    SequenceElement* msg_type() const { return msg_type_; }
    KRB_PA_Data_Optional* padata() const { return padata_; }
    ASN1OctetString* client_realm() const { return client_realm_; }
    ASN1EncodingMeta* cname_meta() const { return cname_meta_; }
    KRB_Principal_Name* client_name() const { return client_name_; }
    KRB_Ticket* ticket() const { return ticket_; }
    KRB_Encrypted_Data_in_Seq* enc_part() const { return enc_part_; }
    bool is_orig() const { return is_orig_; }
    uint8 pkt_type() const { return pkt_type_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    SequenceElement* pvno_;
    SequenceElement* msg_type_;
    KRB_PA_Data_Optional* padata_;
    ASN1OctetString* client_realm_;
    ASN1EncodingMeta* cname_meta_;
    KRB_Principal_Name* client_name_;
    KRB_Ticket* ticket_;
    KRB_Encrypted_Data_in_Seq* enc_part_;
    bool is_orig_;
    uint8 pkt_type_;
};


class KRB_AP_REQ final {
public:
    KRB_AP_REQ(bool is_orig);
    ~KRB_AP_REQ();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    SequenceElement* pvno() const { return pvno_; }
    SequenceElement* msg_type() const { return msg_type_; }
    KRB_AP_Options* ap_options() const { return ap_options_; }
    KRB_Ticket* ticket() const { return ticket_; }
    KRB_Encrypted_Data_in_Seq* enc_part() const { return enc_part_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    SequenceElement* pvno_;
    SequenceElement* msg_type_;
    KRB_AP_Options* ap_options_;
    KRB_Ticket* ticket_;
    KRB_Encrypted_Data_in_Seq* enc_part_;
    bool is_orig_;
    bool proc_;
};


class KRB_AP_Options final {
public:
    KRB_AP_Options();
    ~KRB_AP_Options();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    SequenceElement* meta() const { return meta_; }
    uint32 flags() const { return flags_; }
    bool reserved() const { return reserved_; }
    bool use_session_key() const { return use_session_key_; }
    bool mutual_required() const { return mutual_required_; }

protected:
    SequenceElement* meta_;
    uint32 flags_;
    bool reserved_;
    bool use_session_key_;
    bool mutual_required_;
};


class KRB_AP_REP final {
public:
    KRB_AP_REP(bool is_orig);
    ~KRB_AP_REP();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context);

    // Member access functions
    SequenceElement* pvno() const { return pvno_; }
    SequenceElement* msg_type() const { return msg_type_; }
    KRB_Encrypted_Data_in_Seq* enc_part() const { return enc_part_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    SequenceElement* pvno_;
    SequenceElement* msg_type_;
    KRB_Encrypted_Data_in_Seq* enc_part_;
    bool is_orig_;
    bool proc_;
};


class KRB_ERROR_MSG final {
public:
    KRB_ERROR_MSG(bool is_orig);
    ~KRB_ERROR_MSG();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    vector<KRB_ERROR_Arg*>* args1() const { return args1_; }
    ASN1Integer* error_code() const { return error_code_; }
    vector<KRB_ERROR_Arg*>* args2() const { return args2_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    vector<KRB_ERROR_Arg*>* args1_;
    KRB_ERROR_Arg* args1__elem_;
    ASN1Integer* error_code_;
    vector<KRB_ERROR_Arg*>* args2_;
    KRB_ERROR_Arg* args2__elem_;
    bool is_orig_;
    bool proc_;
};


class KRB_ERROR_Arg final {
public:
    KRB_ERROR_Arg(bool is_orig, int64 error_code);
    ~KRB_ERROR_Arg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    KRB_ERROR_Arg_Data* args() const { return args_; }
    bool is_orig() const { return is_orig_; }
    int64 error_code() const { return error_code_; }
    bool process_in_parent() const { return process_in_parent_; }
    uint64 arg_length() const { return arg_length_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    KRB_ERROR_Arg_Data* args_;
    bool is_orig_;
    int64 error_code_;
    bool process_in_parent_;
    uint64 arg_length_;
};


class KRB_ERROR_Arg_Data final {
public:
    KRB_ERROR_Arg_Data(bool is_orig, uint8 index, int64 error_code);
    ~KRB_ERROR_Arg_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ASN1Integer* pvno() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:174:pvno", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pvno_;
    }
    ASN1Integer* msg_type() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:175:msg_type", (int64)val_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msg_type_;
    }
    KRB_Time* ctime() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:176:ctime", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ctime_;
    }
    ASN1Integer* cusec() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:177:cusec", (int64)val_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cusec_;
    }
    KRB_Time* stime() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:178:stime", (int64)val_case_index(), "((int) 4)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return stime_;
    }
    ASN1Integer* susec() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:179:susec", (int64)val_case_index(), "((int) 5)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return susec_;
    }
    ASN1OctetString* crealm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:181:crealm", (int64)val_case_index(), "((int) 7)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return crealm_;
    }
    KRB_Principal_Name* cname() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:182:cname", (int64)val_case_index(), "((int) 8)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cname_;
    }
    ASN1OctetString* realm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:183:realm", (int64)val_case_index(), "((int) 9)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return realm_;
    }
    KRB_Principal_Name* sname() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:184:sname", (int64)val_case_index(), "((int) 10)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return sname_;
    }
    ASN1OctetString* e_text() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:185:e_text", (int64)val_case_index(), "((int) 11)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return e_text_;
    }
    KRB_ERROR_E_Data* e_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:186:e_data", (int64)val_case_index(), "((int) 12)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return e_data_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 index() const { return index_; }
    int64 error_code() const { return error_code_; }

protected:
    uint8 val_case_index_;
    ASN1Integer* pvno_;
    ASN1Integer* msg_type_;
    KRB_Time* ctime_;
    ASN1Integer* cusec_;
    KRB_Time* stime_;
    ASN1Integer* susec_;
    ASN1OctetString* crealm_;
    KRB_Principal_Name* cname_;
    ASN1OctetString* realm_;
    KRB_Principal_Name* sname_;
    ASN1OctetString* e_text_;
    KRB_ERROR_E_Data* e_data_;
    bool is_orig_;
    uint8 index_;
    int64 error_code_;
};


class KRB_ERROR_E_Data final {
public:
    KRB_ERROR_E_Data(bool is_orig, uint64 error_code);
    ~KRB_ERROR_E_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    KRB_PA_Data_Sequence* padata() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:190:padata", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return padata_;
    }
    bytestring const& unknown() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:191:unknown", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return unknown_;
    }
    bool is_orig() const { return is_orig_; }
    uint64 error_code() const { return error_code_; }

protected:
    int val_case_index_;
    KRB_PA_Data_Sequence* padata_;
    bytestring unknown_;
    bool is_orig_;
    uint64 error_code_;
};


class KRB_SAFE_MSG final {
public:
    KRB_SAFE_MSG(bool is_orig);
    ~KRB_SAFE_MSG();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context);

    // Member access functions
    SequenceElement* pvno() const { return pvno_; }
    SequenceElement* msg_type() const { return msg_type_; }
    KRB_SAFE_Body* safe_body() const { return safe_body_; }
    KRB_Checksum* checksum() const { return checksum_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    SequenceElement* pvno_;
    SequenceElement* msg_type_;
    KRB_SAFE_Body* safe_body_;
    KRB_Checksum* checksum_;
    bool is_orig_;
    bool proc_;
};


class KRB_SAFE_Body final {
public:
    KRB_SAFE_Body();
    ~KRB_SAFE_Body();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    vector<KRB_SAFE_Arg*>* args() const { return args_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    vector<KRB_SAFE_Arg*>* args_;
    KRB_SAFE_Arg* args__elem_;
};


class KRB_SAFE_Arg final {
public:
    KRB_SAFE_Arg();
    ~KRB_SAFE_Arg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    KRB_SAFE_Arg_Data* args() const { return args_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    KRB_SAFE_Arg_Data* args_;
};


class KRB_SAFE_Arg_Data final {
public:
    KRB_SAFE_Arg_Data(uint8 index);
    ~KRB_SAFE_Arg_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ASN1OctetString* user_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:214:user_data", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return user_data_;
    }
    KRB_Time* timestamp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:215:timestamp", (int64)val_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return timestamp_;
    }
    ASN1Integer* usec() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:216:usec", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return usec_;
    }
    ASN1Integer* seq_number() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:217:seq_number", (int64)val_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return seq_number_;
    }
    KRB_Host_Address* sender_addr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:218:sender_addr", (int64)val_case_index(), "((int) 4)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return sender_addr_;
    }
    KRB_Host_Address* recp_addr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:219:recp_addr", (int64)val_case_index(), "((int) 5)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return recp_addr_;
    }
    uint8 index() const { return index_; }

protected:
    uint8 val_case_index_;
    ASN1OctetString* user_data_;
    KRB_Time* timestamp_;
    ASN1Integer* usec_;
    ASN1Integer* seq_number_;
    KRB_Host_Address* sender_addr_;
    KRB_Host_Address* recp_addr_;
    uint8 index_;
};


class KRB_PRIV_MSG final {
public:
    KRB_PRIV_MSG(bool is_orig);
    ~KRB_PRIV_MSG();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context);

    // Member access functions
    SequenceElement* pvno() const { return pvno_; }
    SequenceElement* msg_type() const { return msg_type_; }
    KRB_Encrypted_Data_in_Seq* enc_part() const { return enc_part_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    SequenceElement* pvno_;
    SequenceElement* msg_type_;
    KRB_Encrypted_Data_in_Seq* enc_part_;
    bool is_orig_;
    bool proc_;
};


class KRB_CRED_MSG final {
public:
    KRB_CRED_MSG(bool is_orig);
    ~KRB_CRED_MSG();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB_TCP* t_context);

    // Member access functions
    SequenceElement* pvno() const { return pvno_; }
    SequenceElement* msg_type() const { return msg_type_; }
    SequenceElement* tkts_meta() const { return tkts_meta_; }
    KRB_Ticket_Sequence* tickets() const { return tickets_; }
    KRB_Encrypted_Data_in_Seq* enc_part() const { return enc_part_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    SequenceElement* pvno_;
    SequenceElement* msg_type_;
    SequenceElement* tkts_meta_;
    KRB_Ticket_Sequence* tickets_;
    KRB_Encrypted_Data_in_Seq* enc_part_;
    bool is_orig_;
    bool proc_;
};


class KRB_Flow final : public binpac::FlowAnalyzer {
public:
    KRB_Flow(KRB_Conn* connection, bool is_orig);
    ~KRB_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    KRB_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    KRB_PDU_TCP* dataunit_;
    ContextKRB_TCP* context_;
    FlowBuffer* flow_buffer_;
    KRB_Conn* connection_;
    bool is_orig_;
};


zeek::RecordValPtr proc_krb_kdc_options(const KRB_KDC_Options* opts);
zeek::RecordValPtr proc_krb_kdc_req_arguments(KRB_KDC_REQ* msg, const ZeekAnalyzer zeek_analyzer);

bool proc_error_arguments(zeek::RecordVal* rv, const std::vector<KRB_ERROR_Arg*>* args, int64 error_code);

} // namespace KRB_TCP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_krb_krb_TCP_pac_h */
