// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/krb/krb.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/krb/krb_pac.h"

namespace binpac {






namespace KRB {
ContextKRB::ContextKRB(KRB_Conn* connection, KRB_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

ContextKRB::~ContextKRB() {
}

KRB_Conn::KRB_Conn(KRBAnalyzer const& zeek_analyzer) {
    upflow_ = new KRB_Flow(this, true);
    downflow_ = new KRB_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

KRB_Conn::~KRB_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void KRB_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void KRB_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void KRB_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool KRB_Conn::proc_krb_kdc_req_msg(KRB_KDC_REQ* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		auto msg_type = binary_to_int64(msg->msg_type()->data()->content());

		if ( msg_type == 10 )
			{
			if ( ! krb_as_request )
				return false;

			auto rv = proc_krb_kdc_req_arguments(msg, zeek_analyzer());
			zeek::BifEvent::enqueue_krb_as_request(zeek_analyzer(), zeek_analyzer()->Conn(), std::move(rv));
			return true;
			}

		if ( msg_type == 12 )
			{
			if ( ! krb_tgs_request )
				return false;

			auto rv = proc_krb_kdc_req_arguments(msg, zeek_analyzer());
			zeek::BifEvent::enqueue_krb_tgs_request(zeek_analyzer(), zeek_analyzer()->Conn(), std::move(rv));
			return true;
			}

		return true;
		
}

bool KRB_Conn::proc_krb_kdc_rep_msg(KRB_KDC_REP* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		auto msg_type = binary_to_int64(msg->msg_type()->data()->content());
		auto make_arg = [this, msg]() -> zeek::RecordValPtr
			{
			auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::KDC_Response);

			rv->Assign(0, asn1_integer_to_val(msg->pvno()->data(), zeek::TYPE_COUNT));
			rv->Assign(1, asn1_integer_to_val(msg->msg_type()->data(), zeek::TYPE_COUNT));

			if ( msg->padata()->has_padata() )
				rv->Assign(2, proc_padata(msg->padata()->padata()->padata(), zeek_analyzer(), false));

			rv->Assign(3, to_stringval(msg->client_realm()->encoding()->content()));
			rv->Assign(4, GetStringFromPrincipalName(msg->client_name()));

			rv->Assign(5, proc_ticket(msg->ticket()));
			rv->Assign(6, proc_encrypted_data(msg->enc_part()->data()));
			return rv;
			};

		if ( msg_type == 11 )
			{
			if ( ! krb_as_response )
				return false;

			zeek::BifEvent::enqueue_krb_as_response(zeek_analyzer(), zeek_analyzer()->Conn(), make_arg());
			return true;
			}

		if ( msg_type == 13 )
			{
			if ( ! krb_tgs_response )
				return false;

			zeek::BifEvent::enqueue_krb_tgs_response(zeek_analyzer(), zeek_analyzer()->Conn(), make_arg());
			return true;
			}

		return true;
		
}

bool KRB_Conn::proc_krb_error_msg(KRB_ERROR_MSG* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		if ( krb_error )
			{
			auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Error_Msg);
			proc_error_arguments(rv.get(), msg->args1(), 0);
			rv->Assign(4, asn1_integer_to_val(msg->error_code(), zeek::TYPE_COUNT));
			proc_error_arguments(rv.get(), msg->args2(), binary_to_int64(msg->error_code()->encoding()->content()));
			zeek::BifEvent::enqueue_krb_error(zeek_analyzer(), zeek_analyzer()->Conn(), std::move(rv));
			}
		return true;
		
}

bool KRB_Conn::proc_krb_ap_req_msg(KRB_AP_REQ* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		if ( krb_ap_request )
			{
			auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::AP_Options);
			rv->Assign(0, msg->ap_options()->use_session_key());
			rv->Assign(1, msg->ap_options()->mutual_required());

			auto rvticket = proc_ticket(msg->ticket());
			auto authenticationinfo = zeek_analyzer()->GetAuthenticationInfo(
				rvticket->GetFieldAs<zeek::StringVal>(1),
				rvticket->GetFieldAs<zeek::StringVal>(2),
				rvticket->GetFieldAs<zeek::StringVal>(4),
				rvticket->GetFieldAs<zeek::CountVal>(3));

			if ( authenticationinfo )
				rvticket->Assign(5, authenticationinfo);

			zeek::BifEvent::enqueue_krb_ap_request(zeek_analyzer(), zeek_analyzer()->Conn(),
						      std::move(rvticket), std::move(rv));
			}
		return true;
		
}

bool KRB_Conn::proc_krb_ap_rep_msg(KRB_AP_REP* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		if ( krb_ap_response )
			{
			zeek::BifEvent::enqueue_krb_ap_response(zeek_analyzer(), zeek_analyzer()->Conn());
			}
		return true;
		
}

bool KRB_Conn::proc_krb_safe_msg(KRB_SAFE_MSG* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		if ( krb_safe )
			{
			auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::SAFE_Msg);

			rv->Assign(0, asn1_integer_to_val(msg->pvno()->data(), zeek::TYPE_COUNT));
			rv->Assign(1, asn1_integer_to_val(msg->msg_type()->data(), zeek::TYPE_COUNT));

			uint timestamp_i = 0;
			int64 timestamp_usecs = 0;

			// We need to do a pass first, to see if we have microseconds for the timestamp values, which are optional

			for ( uint i = 0; i < msg->safe_body()->args()->size(); ++i )
				{
				switch ( (*(msg->safe_body()->args()))[i]->seq_meta()->index() )
					{
					case 0:
						rv->Assign(3, to_stringval((*(msg->safe_body()->args()))[i]->args()->user_data()->encoding()->content()));
						break;
					case 1:
						timestamp_i = i;
						break;
					case 2:
						timestamp_usecs = binary_to_int64((*(msg->safe_body()->args()))[i]->args()->usec()->encoding()->content());
						break;
					case 3:
						rv->Assign(5, asn1_integer_to_val((*(msg->safe_body()->args()))[i]->args()->seq_number(), zeek::TYPE_COUNT));
						break;
					case 4:
						rv->Assign(6, proc_host_address(zeek_analyzer(), (*(msg->safe_body()->args()))[i]->args()->sender_addr()));
						break;
					case 5:
						rv->Assign(7, proc_host_address(zeek_analyzer(), (*(msg->safe_body()->args()))[i]->args()->recp_addr()));
						break;
					default:
						break;
					}
				}

			if ( timestamp_i )
				rv->Assign(4, GetTimeFromAsn1((*(msg->safe_body()->args()))[timestamp_i]->args()->timestamp(), timestamp_usecs));

			zeek::BifEvent::enqueue_krb_safe(zeek_analyzer(), zeek_analyzer()->Conn(), msg->is_orig(), std::move(rv));
			}
		return true;
		
}

bool KRB_Conn::proc_krb_priv_msg(KRB_PRIV_MSG* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		if ( krb_priv )
			{
			zeek::BifEvent::enqueue_krb_priv(zeek_analyzer(), zeek_analyzer()->Conn(), msg->is_orig());
			}
		return true;
		
}

bool KRB_Conn::proc_krb_cred_msg(KRB_CRED_MSG* msg) {

		zeek_analyzer()->AnalyzerConfirmation();
		if ( krb_cred )
			{
			zeek::BifEvent::enqueue_krb_cred(zeek_analyzer(), zeek_analyzer()->Conn(), msg->is_orig(),
						    		   proc_tickets(msg->tickets()));
			}
		return true;

		
}

ASN1Encoding::ASN1Encoding() {
    meta_ = nullptr;
}

ASN1Encoding::~ASN1Encoding() {
    delete meta_;
    meta_ = nullptr;
    content_.free();
}

int ASN1Encoding::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "content"
    int t_content__size;
    t_content__size = meta()->length();
    // Checking out-of-bound for "ASN1Encoding:content"
    if ( t_dataptr_after_meta + (t_content__size) > t_end_of_data || t_dataptr_after_meta + (t_content__size) < t_dataptr_after_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1Encoding:content",
        	((t_dataptr_after_meta - t_begin_of_data)) + (t_content__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_meta + t_content__size;
        int t_content_string_length;
        t_content_string_length = meta()->length();
        // check for negative sizes
        if ( t_content_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/../asn1/asn1.pac:28", t_content_string_length);
        content_.init(t_dataptr_after_meta, t_content_string_length);
    }

    int t_ASN1Encoding__size;
    const_byteptr const t_dataptr_after_content = t_dataptr_after_meta + (t_content__size);
    BINPAC_ASSERT(t_dataptr_after_content <= t_end_of_data);
    t_ASN1Encoding__size = t_dataptr_after_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Encoding__size) <= t_end_of_data);
    return t_ASN1Encoding__size;
}

ASN1EncodingMeta::ASN1EncodingMeta() {
    tag_ = 0;
    len_ = 0;
    long_len_ = false;
    length_ = 0;
    index_ = 0;
}

ASN1EncodingMeta::~ASN1EncodingMeta() {
    more_len_.free();
}

int ASN1EncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ASN1EncodingMeta:len"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:len",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tag"
    tag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "more_len"
    int t_more_len__size;
    long_len_ =  ( len() & 0x80 )  > 0;
    t_more_len__size = long_len() ? len() & 0x7f : 0;
    // Checking out-of-bound for "ASN1EncodingMeta:more_len"
    if ( (t_begin_of_data + 2) + (t_more_len__size) > t_end_of_data || (t_begin_of_data + 2) + (t_more_len__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:more_len",
        	(2) + (t_more_len__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_more_len__size;
        int t_more_len_string_length;
        t_more_len_string_length = long_len() ? len() & 0x7f : 0;
        // check for negative sizes
        if ( t_more_len_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/../asn1/asn1.pac:34", t_more_len_string_length);
        more_len_.init((t_begin_of_data + 2), t_more_len_string_length);
    }

    int t_ASN1EncodingMeta__size;
    const_byteptr const t_dataptr_after_more_len = (t_begin_of_data + 2) + (t_more_len__size);
    BINPAC_ASSERT(t_dataptr_after_more_len <= t_end_of_data);
    t_ASN1EncodingMeta__size = t_dataptr_after_more_len - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    length_ = long_len() ? binary_to_int64(more_len()) : len();
    index_ = tag() - ASN1_INDEX_TAG_OFFSET;
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1EncodingMeta__size) <= t_end_of_data);
    return t_ASN1EncodingMeta__size;
}

ASN1OptionalEncodingMeta::ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata) {
    val_case_index_ = -1;
    data_ = nullptr;
    is_present_ = is_present;
    previous_metadata_ = previous_metadata;
    length_ = 0;
}

ASN1OptionalEncodingMeta::~ASN1OptionalEncodingMeta() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ASN1OptionalEncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = is_present();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1EncodingMeta();
                int t_data__size;
                t_data__size = data_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_data__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_val__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ASN1OptionalEncodingMeta", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    length_ = is_present() ? data()->length() : previous_metadata()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ASN1SequenceMeta::ASN1SequenceMeta() {
    encoding_ = nullptr;
}

ASN1SequenceMeta::~ASN1SequenceMeta() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1SequenceMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1EncodingMeta();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1SequenceMeta__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1SequenceMeta__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1SequenceMeta__size) <= t_end_of_data);
    return t_ASN1SequenceMeta__size;
}

ASN1Integer::ASN1Integer() {
    encoding_ = nullptr;
}

ASN1Integer::~ASN1Integer() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Integer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Integer__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Integer__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Integer__size) <= t_end_of_data);
    return t_ASN1Integer__size;
}

ASN1OctetString::ASN1OctetString() {
    encoding_ = nullptr;
}

ASN1OctetString::~ASN1OctetString() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1OctetString::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1OctetString__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1OctetString__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1OctetString__size) <= t_end_of_data);
    return t_ASN1OctetString__size;
}

ASN1ObjectIdentifier::ASN1ObjectIdentifier() {
    encoding_ = nullptr;
}

ASN1ObjectIdentifier::~ASN1ObjectIdentifier() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1ObjectIdentifier::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1ObjectIdentifier__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1ObjectIdentifier__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1ObjectIdentifier__size) <= t_end_of_data);
    return t_ASN1ObjectIdentifier__size;
}

ASN1Boolean::ASN1Boolean() {
    encoding_ = nullptr;
}

ASN1Boolean::~ASN1Boolean() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Boolean::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Boolean__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Boolean__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Boolean__size) <= t_end_of_data);
    return t_ASN1Boolean__size;
}

ASN1Enumerated::ASN1Enumerated() {
    encoding_ = nullptr;
}

ASN1Enumerated::~ASN1Enumerated() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Enumerated::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Enumerated__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Enumerated__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Enumerated__size) <= t_end_of_data);
    return t_ASN1Enumerated__size;
}

SequenceElement::SequenceElement(bool grab_content) {
    index_meta_ = nullptr;
    have_content_case_index_ = -1;
    data_ = nullptr;
    meta_ = nullptr;
    grab_content_ = grab_content;
    index_ = 0;
    length_ = 0;
}

SequenceElement::~SequenceElement() {
    delete index_meta_;
    index_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "meta"
            {
                delete meta_;
                meta_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SequenceElement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "index_meta"
    index_meta_ = new ASN1EncodingMeta();
    int t_index_meta__size;
    t_index_meta__size = index_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_index_meta = t_begin_of_data + (t_index_meta__size);
    BINPAC_ASSERT(t_dataptr_after_index_meta <= t_end_of_data);
    // Parse "have_content"
    int t_have_content__size;
    have_content_case_index_ = grab_content();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1Encoding();
                int t_data__size;
                t_data__size = data_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_data__size;
            }
            break;
        case false:
            // Parse "meta"
            {
                meta_ = new ASN1EncodingMeta();
                int t_meta__size;
                t_meta__size = meta_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_meta__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SequenceElement", (int64)have_content_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SequenceElement__size;
    const_byteptr const t_dataptr_after_have_content = t_dataptr_after_index_meta + (t_have_content__size);
    BINPAC_ASSERT(t_dataptr_after_have_content <= t_end_of_data);
    t_SequenceElement__size = t_dataptr_after_have_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    index_ = index_meta()->index();
    length_ = index_meta()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_SequenceElement__size) <= t_end_of_data);
    return t_SequenceElement__size;
}

Array::Array() {
    array_meta_ = nullptr;
    data_ = nullptr;
    data__elem_ = nullptr;
}

Array::~Array() {
    delete array_meta_;
    array_meta_ = nullptr;
    delete data__elem_;
    data__elem_ = nullptr;
    if ( data() ) {
        for ( auto* data__elem_ : *data() ) {
            delete data__elem_;
            data__elem_ = nullptr;
        }
    }
    delete data_;
}

int Array::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "array_meta"
    array_meta_ = new ASN1EncodingMeta();
    int t_array_meta__size;
    t_array_meta__size = array_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_array_meta = t_begin_of_data + (t_array_meta__size);
    BINPAC_ASSERT(t_dataptr_after_array_meta <= t_end_of_data);
    // Parse "data"
    int t_data__arraylength;
    t_data__arraylength = 0;
    data__elem_ = nullptr;
    int t_data__elem__it;
    t_data__elem__it = 0;
    int t_data__size;
    data_ = new vector<ASN1Encoding*>;
    const_byteptr t_data__elem__dataptr = t_dataptr_after_array_meta;
    for (; /* forever */; ++t_data__elem__it) {
        // Check &until(data__elem__dataptr >= end_of_data)
        if ( t_data__elem__dataptr >= t_end_of_data ) {
            data__elem_ = nullptr;
            goto end_of_data;
        }
        data__elem_ = new ASN1Encoding();
        int t_data__elem__size;
        t_data__elem__size = data__elem_->Parse(t_data__elem__dataptr, t_end_of_data);
        data_->push_back(data__elem_);
        t_data__elem__dataptr += t_data__elem__size;
        BINPAC_ASSERT(t_data__elem__dataptr <= t_end_of_data);
        data__elem_ = nullptr;
    }
end_of_data: ;
    t_data__size = t_data__elem__dataptr - (t_dataptr_after_array_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_Array__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_array_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Array__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Array__size) <= t_end_of_data);
    return t_Array__size;
}

int64 binary_to_int64(bytestring const& bs) {

	int64 rval = 0;

	if ( bs.length() > 8 )
		{
		zeek::reporter->Weird("asn_binary_to_int64_shift_too_large", zeek::util::fmt("%d", bs.length()));
		return 0;
		}

	for ( int i = 0; i < bs.length(); ++i )
		{
		uint64 byte = bs[i];
		rval |= byte << (8 * (bs.length() - (i + 1)));
		}

	return rval;
	
}



zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t)
	{
	return asn1_integer_to_val(i->encoding(), t);
	}

zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t)
	{
	auto v = binary_to_int64(i->content());

	switch ( t ) {
	case zeek::TYPE_BOOL:
		return zeek::val_mgr->Bool(v);
	case zeek::TYPE_INT:
		return zeek::val_mgr->Int(v);
	case zeek::TYPE_COUNT:
		return zeek::val_mgr->Count(v);
	default:
		zeek::reporter->Error("bad asn1_integer_to_val tag: %s", zeek::type_name(t));
		return zeek::val_mgr->Count(v);
	}
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid)
	{
	return asn1_oid_to_val(oid->encoding());
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid)
	{
	vector<uint64> oid_components;
	vector<vector<uint8> > subidentifiers;
	vector<uint64> subidentifier_values;
	vector<uint8> subidentifier;
	bytestring const& bs = oid->content();

	for ( int i = 0; i < bs.length(); ++i )
		{
		if ( bs[i] & 0x80 )
			subidentifier.push_back(bs[i] & 0x7f);
		else
			{
			subidentifier.push_back(bs[i]);
			subidentifiers.push_back(subidentifier);
			subidentifier.clear();
			}
		}

	if ( ! subidentifier.empty() || subidentifiers.size() < 1 )
		// Underflow.
		return zeek::val_mgr->EmptyString();

	for ( const auto& subidentifier : subidentifiers )
		{
		uint64 value = 0;

		for ( size_t j = 0; j < subidentifier.size(); ++j )
			{
			uint64 byte = subidentifier[j];
			value |= byte << (7 * (subidentifier.size() - (j + 1)));
			}

		subidentifier_values.push_back(value);
		}

	string rval;

	for ( size_t i = 0; i < subidentifier_values.size(); ++i )
		{
		char tmp[32];

		if ( i > 0 )
			{
			snprintf(tmp, sizeof(tmp), ".%" PRIu64, subidentifier_values[i]);
			rval += tmp;
			}
		else
			{
			std::div_t result = std::div(subidentifier_values[i], 40);
			snprintf(tmp, sizeof(tmp), "%d.%d", result.quot, result.rem);
			rval += tmp;
			}
		}

	return zeek::make_intrusive<zeek::StringVal>(rval);
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s)
	{
	return asn1_octet_string_to_val(s->encoding());
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s)
	{
	bytestring const& bs = s->content();
	return zeek::make_intrusive<zeek::StringVal>(bs.length(), reinterpret_cast<const char*>(bs.data()));
	}



zeek::ValPtr GetTimeFromAsn1(const KRB_Time* atime, int64 usecs)
	{
	auto atime_bytestring = to_stringval(atime->time());
	auto result = GetTimeFromAsn1(atime_bytestring.get(), usecs);
	return result;
	}

zeek::ValPtr GetTimeFromAsn1(zeek::StringVal* atime, int64 usecs)
	{
	time_t lResult = 0;

	char lBuffer[17];
	char* pBuffer = lBuffer;

	size_t lTimeLength = atime->Len();
	const char* pString = reinterpret_cast<const char*>(atime->Bytes());

	if ( lTimeLength != 15 && lTimeLength != 17 )
		return nullptr;

	if (lTimeLength == 17 )
		pString = pString + 2;

	memcpy(pBuffer, pString, 15);
	*(pBuffer+15) = '\0';

	tm lTime;
	lTime.tm_sec  = ((lBuffer[12] - '0') * 10) + (lBuffer[13] - '0');
	lTime.tm_min  = ((lBuffer[10] - '0') * 10) + (lBuffer[11] - '0');
	lTime.tm_hour = ((lBuffer[8] - '0') * 10) + (lBuffer[9] - '0');
	lTime.tm_mday = ((lBuffer[6] - '0') * 10) + (lBuffer[7] - '0');
	lTime.tm_mon  = (((lBuffer[4] - '0') * 10) + (lBuffer[5] - '0')) - 1;
	lTime.tm_year = ((lBuffer[0] - '0') * 1000) + ((lBuffer[1] - '0') * 100) + ((lBuffer[2] - '0') * 10) + (lBuffer[3] - '0') - 1900;

	lTime.tm_wday = 0;
	lTime.tm_yday = 0;
	lTime.tm_isdst = 0;

	lResult = timegm(&lTime);

	if ( !lResult )
		lResult = 0;

	return zeek::make_intrusive<zeek::TimeVal>(double(lResult + double(usecs/100000.0)));
	}



zeek::ValPtr GetStringFromPrincipalName(const KRB_Principal_Name* pname)
{
	if ( pname->data()->size() == 1 )
		return to_stringval(pname->data()[0][0]->encoding()->content());
	if ( pname->data()->size() == 2 )
		return zeek::make_intrusive<zeek::StringVal>(zeek::util::fmt("%s/%s", reinterpret_cast<const char *> (pname->data()[0][0]->encoding()->content().begin()), reinterpret_cast<const char *>(pname->data()[0][1]->encoding()->content().begin())));
	if ( pname->data()->size() == 3 ) // if the name-string has a third value, this will just append it, else this will return unknown as the principal name
		return zeek::make_intrusive<zeek::StringVal>(zeek::util::fmt("%s/%s/%s", reinterpret_cast<const char *>(pname->data()[0][0]->encoding()->content().begin()), reinterpret_cast<const char *>(pname->data()[0][1]->encoding()->content().begin()), reinterpret_cast<const char *>(pname->data()[0][2]->encoding()->content().begin())));

	return zeek::make_intrusive<zeek::StringVal>("unknown");
}

zeek::VectorValPtr proc_cipher_list(const Array* list)
{
	auto ciphers = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);
	for ( const auto& data : *(list->data()) )
		ciphers->Assign(ciphers->Size(), asn1_integer_to_val(data, zeek::TYPE_COUNT));
	return ciphers;
}

zeek::VectorValPtr proc_host_address_list(const ZeekAnalyzer a, const KRB_Host_Addresses* list)
{
	auto addrs = zeek::make_intrusive<zeek::VectorVal>(zeek::id::find_type<zeek::VectorType>("KRB::Host_Address_Vector"));

	for ( const auto& addr : *(list->addresses()) )
		addrs->Assign(addrs->Size(), proc_host_address(a, addr));

	return addrs;
}

zeek::RecordValPtr proc_host_address(const ZeekAnalyzer a, const KRB_Host_Address* addr)
{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Host_Address);
	const auto& addr_bytes = addr->address()->data()->content();

	switch ( binary_to_int64(addr->addr_type()->encoding()->content()) )
		{
		case 2:
			{
			if ( addr_bytes.length() != 4 )
				{
				a->Weird("invalid_kerberos_addr_len");
				break;
				}

			auto bytes = reinterpret_cast<const uint32_t*>(addr_bytes.data());
			rv->Assign(0, zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr(IPv4, bytes, zeek::IPAddr::Network)));
			return rv;
			}
		case 24:
			{
			if ( addr_bytes.length() != 16 )
				{
				a->Weird("invalid_kerberos_addr_len");
				break;
				}

			auto bytes = reinterpret_cast<const uint32_t*>(addr_bytes.data());
			rv->Assign(0, zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr(IPv6, bytes, zeek::IPAddr::Network)));
			return rv;
			}
		case 20:
			{
			rv->Assign(1, to_stringval(addr_bytes));
			return rv;
			}
		default:
			break;
		}

	auto unk = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Type_Value);
	unk->Assign(0, asn1_integer_to_val(addr->addr_type(), zeek::TYPE_COUNT));
	unk->Assign(1, to_stringval(addr_bytes));
	rv->Assign(2, std::move(unk));
	return rv;
}

zeek::VectorValPtr proc_tickets(const KRB_Ticket_Sequence* list)
	{
	auto tickets = zeek::make_intrusive<zeek::VectorVal>(zeek::id::find_type<zeek::VectorType>("KRB::Ticket_Vector"));

	for ( KRB_Ticket* element : *(list->tickets()) )
		tickets->Assign(tickets->Size(), proc_ticket(element));

	return tickets;
	}

zeek::RecordValPtr proc_ticket(const KRB_Ticket* ticket)
	{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Ticket);

	rv->Assign(0, asn1_integer_to_val(ticket->tkt_vno()->data(), zeek::TYPE_COUNT));
	rv->Assign(1, to_stringval(ticket->realm()->data()->content()));
	rv->Assign(2, GetStringFromPrincipalName(ticket->sname()));
	rv->Assign(3, asn1_integer_to_val(ticket->enc_part()->data()->etype()->data(), zeek::TYPE_COUNT));
	rv->Assign(4, to_stringval(ticket->enc_part()->data()->ciphertext()->encoding()->content()));

	return rv;
	}

zeek::RecordValPtr proc_encrypted_data(const KRB_Encrypted_Data* encrypted_data)
	{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Encrypted_Data);
	if ( encrypted_data->have_kvno() )
		{
		rv->Assign(0, asn1_integer_to_val(encrypted_data->kvno(), zeek::TYPE_COUNT));
		}
	rv->Assign(1, asn1_integer_to_val(encrypted_data->etype()->data(), zeek::TYPE_COUNT));
	rv->Assign(2, to_stringval(encrypted_data->ciphertext()->encoding()->content()));

	return rv;
	}

KRB_Principal_Name::KRB_Principal_Name() {
    seq_meta_ = nullptr;
    name_meta_ = nullptr;
    name_type_ = nullptr;
    seq_meta_1_ = nullptr;
    seq_meta_2_ = nullptr;
    data_ = nullptr;
    data__elem_ = nullptr;
}

KRB_Principal_Name::~KRB_Principal_Name() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete name_meta_;
    name_meta_ = nullptr;
    delete name_type_;
    name_type_ = nullptr;
    delete seq_meta_1_;
    seq_meta_1_ = nullptr;
    delete seq_meta_2_;
    seq_meta_2_ = nullptr;
    delete data__elem_;
    data__elem_ = nullptr;
    if ( data() ) {
        for ( auto* data__elem_ : *data() ) {
            delete data__elem_;
            data__elem_ = nullptr;
        }
    }
    delete data_;
}

int KRB_Principal_Name::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "name_meta"
    name_meta_ = new ASN1EncodingMeta();
    int t_name_meta__size;
    t_name_meta__size = name_meta_->Parse(t_dataptr_after_seq_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_name_meta = t_dataptr_after_seq_meta + (t_name_meta__size);
    BINPAC_ASSERT(t_dataptr_after_name_meta <= t_end_of_data);
    // Parse "name_type"
    name_type_ = new ASN1Integer();
    int t_name_type__size;
    t_name_type__size = name_type_->Parse(t_dataptr_after_name_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_name_type = t_dataptr_after_name_meta + (t_name_type__size);
    BINPAC_ASSERT(t_dataptr_after_name_type <= t_end_of_data);
    // Parse "seq_meta_1"
    seq_meta_1_ = new ASN1EncodingMeta();
    int t_seq_meta_1__size;
    t_seq_meta_1__size = seq_meta_1_->Parse(t_dataptr_after_name_type, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta_1 = t_dataptr_after_name_type + (t_seq_meta_1__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta_1 <= t_end_of_data);
    // Parse "seq_meta_2"
    seq_meta_2_ = new ASN1EncodingMeta();
    int t_seq_meta_2__size;
    t_seq_meta_2__size = seq_meta_2_->Parse(t_dataptr_after_seq_meta_1, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta_2 = t_dataptr_after_seq_meta_1 + (t_seq_meta_2__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta_2 <= t_end_of_data);
    // Parse "data"
    int t_data__arraylength;
    t_data__arraylength = 0;
    data__elem_ = nullptr;
    int t_data__elem__it;
    t_data__elem__it = 0;
    int t_data__size;
    data_ = new vector<ASN1OctetString*>;
    const_byteptr t_data__elem__dataptr = t_dataptr_after_seq_meta_2;
    for (; /* forever */; ++t_data__elem__it) {
        // Check &until(data__elem__dataptr >= end_of_data)
        if ( t_data__elem__dataptr >= t_end_of_data ) {
            data__elem_ = nullptr;
            goto end_of_data;
        }
        data__elem_ = new ASN1OctetString();
        int t_data__elem__size;
        t_data__elem__size = data__elem_->Parse(t_data__elem__dataptr, t_end_of_data);
        data_->push_back(data__elem_);
        t_data__elem__dataptr += t_data__elem__size;
        BINPAC_ASSERT(t_data__elem__dataptr <= t_end_of_data);
        data__elem_ = nullptr;
    }
end_of_data: ;
    t_data__size = t_data__elem__dataptr - (t_dataptr_after_seq_meta_2);
    // Evaluate 'let' and 'withinput' fields

    int t_KRB_Principal_Name__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_seq_meta_2 + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_Principal_Name__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Principal_Name__size) <= t_end_of_data);
    return t_KRB_Principal_Name__size;
}

KRB_Time::KRB_Time() {
    meta_ = nullptr;
}

KRB_Time::~KRB_Time() {
    delete meta_;
    meta_ = nullptr;
    time_.free();
}

int KRB_Time::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "time"
    int t_time_string_length;
    t_time_string_length = (t_end_of_data) - (t_dataptr_after_meta);
    int t_time__size;
    t_time__size = t_time_string_length;
    // check for negative sizes
    if ( t_time_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-types.pac:143", t_time_string_length);
    time_.init(t_dataptr_after_meta, t_time_string_length);

    int t_KRB_Time__size;
    const_byteptr const t_dataptr_after_time = t_dataptr_after_meta + (t_time__size);
    BINPAC_ASSERT(t_dataptr_after_time <= t_end_of_data);
    t_KRB_Time__size = t_dataptr_after_time - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Time__size) <= t_end_of_data);
    return t_KRB_Time__size;
}

KRB_Host_Addresses::KRB_Host_Addresses() {
    seq_meta_ = nullptr;
    addresses_ = nullptr;
    addresses__elem_ = nullptr;
}

KRB_Host_Addresses::~KRB_Host_Addresses() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete addresses__elem_;
    addresses__elem_ = nullptr;
    if ( addresses() ) {
        for ( auto* addresses__elem_ : *addresses() ) {
            delete addresses__elem_;
            addresses__elem_ = nullptr;
        }
    }
    delete addresses_;
}

int KRB_Host_Addresses::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "addresses"
    int t_addresses__arraylength;
    t_addresses__arraylength = 0;
    addresses__elem_ = nullptr;
    int t_addresses__elem__it;
    t_addresses__elem__it = 0;
    int t_addresses__size;
    addresses_ = new vector<KRB_Host_Address*>;
    const_byteptr t_addresses__elem__dataptr = t_dataptr_after_seq_meta;
    for (; /* forever */; ++t_addresses__elem__it) {
        // Check &until(addresses__elem__dataptr >= end_of_data)
        if ( t_addresses__elem__dataptr >= t_end_of_data ) {
            addresses__elem_ = nullptr;
            goto end_of_addresses;
        }
        addresses__elem_ = new KRB_Host_Address();
        int t_addresses__elem__size;
        t_addresses__elem__size = addresses__elem_->Parse(t_addresses__elem__dataptr, t_end_of_data);
        addresses_->push_back(addresses__elem_);
        t_addresses__elem__dataptr += t_addresses__elem__size;
        BINPAC_ASSERT(t_addresses__elem__dataptr <= t_end_of_data);
        addresses__elem_ = nullptr;
    }
end_of_addresses: ;
    t_addresses__size = t_addresses__elem__dataptr - (t_dataptr_after_seq_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_KRB_Host_Addresses__size;
    const_byteptr const t_dataptr_after_addresses = t_dataptr_after_seq_meta + (t_addresses__size);
    BINPAC_ASSERT(t_dataptr_after_addresses <= t_end_of_data);
    t_KRB_Host_Addresses__size = t_dataptr_after_addresses - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Host_Addresses__size) <= t_end_of_data);
    return t_KRB_Host_Addresses__size;
}

KRB_Host_Address::KRB_Host_Address() {
    addr_type_meta_ = nullptr;
    addr_type_ = nullptr;
    address_ = nullptr;
}

KRB_Host_Address::~KRB_Host_Address() {
    delete addr_type_meta_;
    addr_type_meta_ = nullptr;
    delete addr_type_;
    addr_type_ = nullptr;
    delete address_;
    address_ = nullptr;
}

int KRB_Host_Address::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "addr_type_meta"
    addr_type_meta_ = new SequenceElement(false);
    int t_addr_type_meta__size;
    t_addr_type_meta__size = addr_type_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_addr_type_meta = t_begin_of_data + (t_addr_type_meta__size);
    BINPAC_ASSERT(t_dataptr_after_addr_type_meta <= t_end_of_data);
    // Parse "addr_type"
    addr_type_ = new ASN1Integer();
    int t_addr_type__size;
    t_addr_type__size = addr_type_->Parse(t_dataptr_after_addr_type_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_addr_type = t_dataptr_after_addr_type_meta + (t_addr_type__size);
    BINPAC_ASSERT(t_dataptr_after_addr_type <= t_end_of_data);
    // Parse "address"
    address_ = new SequenceElement(true);
    int t_address__size;
    t_address__size = address_->Parse(t_dataptr_after_addr_type, t_end_of_data);

    int t_KRB_Host_Address__size;
    const_byteptr const t_dataptr_after_address = t_dataptr_after_addr_type + (t_address__size);
    BINPAC_ASSERT(t_dataptr_after_address <= t_end_of_data);
    t_KRB_Host_Address__size = t_dataptr_after_address - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Host_Address__size) <= t_end_of_data);
    return t_KRB_Host_Address__size;
}

KRB_Ticket::KRB_Ticket(bool in_sequence) {
    have_seq_case_index_ = -1;
    meta_ = nullptr;
    app_meta_ = nullptr;
    seq_meta_ = nullptr;
    tkt_vno_ = nullptr;
    realm_ = nullptr;
    sname_meta_ = nullptr;
    sname_ = nullptr;
    enc_part_ = nullptr;
    in_sequence_ = in_sequence;
}

KRB_Ticket::~KRB_Ticket() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_seq_case_index() ) {
        case true:
            // Clean up "meta"
            {
                delete meta_;
                meta_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete app_meta_;
    app_meta_ = nullptr;
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete tkt_vno_;
    tkt_vno_ = nullptr;
    delete realm_;
    realm_ = nullptr;
    delete sname_meta_;
    sname_meta_ = nullptr;
    delete sname_;
    sname_ = nullptr;
    delete enc_part_;
    enc_part_ = nullptr;
}

int KRB_Ticket::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "have_seq"
    int t_have_seq__size;
    have_seq_case_index_ = in_sequence();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_seq_case_index() ) {
        case true:
            // Parse "meta"
            {
                meta_ = new ASN1EncodingMeta();
                int t_meta__size;
                t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);
                t_have_seq__size = t_meta__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_have_seq__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_Ticket", (int64)have_seq_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_seq = t_begin_of_data + (t_have_seq__size);
    BINPAC_ASSERT(t_dataptr_after_have_seq <= t_end_of_data);
    // Parse "app_meta"
    app_meta_ = new ASN1EncodingMeta();
    int t_app_meta__size;
    t_app_meta__size = app_meta_->Parse(t_dataptr_after_have_seq, t_end_of_data);

    const_byteptr const t_dataptr_after_app_meta = t_dataptr_after_have_seq + (t_app_meta__size);
    BINPAC_ASSERT(t_dataptr_after_app_meta <= t_end_of_data);
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_dataptr_after_app_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_dataptr_after_app_meta + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "tkt_vno"
    tkt_vno_ = new SequenceElement(true);
    int t_tkt_vno__size;
    t_tkt_vno__size = tkt_vno_->Parse(t_dataptr_after_seq_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_tkt_vno = t_dataptr_after_seq_meta + (t_tkt_vno__size);
    BINPAC_ASSERT(t_dataptr_after_tkt_vno <= t_end_of_data);
    // Parse "realm"
    realm_ = new SequenceElement(true);
    int t_realm__size;
    t_realm__size = realm_->Parse(t_dataptr_after_tkt_vno, t_end_of_data);

    const_byteptr const t_dataptr_after_realm = t_dataptr_after_tkt_vno + (t_realm__size);
    BINPAC_ASSERT(t_dataptr_after_realm <= t_end_of_data);
    // Parse "sname_meta"
    sname_meta_ = new ASN1EncodingMeta();
    int t_sname_meta__size;
    t_sname_meta__size = sname_meta_->Parse(t_dataptr_after_realm, t_end_of_data);

    const_byteptr const t_dataptr_after_sname_meta = t_dataptr_after_realm + (t_sname_meta__size);
    BINPAC_ASSERT(t_dataptr_after_sname_meta <= t_end_of_data);
    // Parse "sname"
    sname_ = new KRB_Principal_Name();
    int t_sname__size;
    t_sname__size = sname_meta()->length();
    // Checking out-of-bound for "KRB_Ticket:sname"
    if ( t_dataptr_after_sname_meta + (t_sname__size) > t_end_of_data || t_dataptr_after_sname_meta + (t_sname__size) < t_dataptr_after_sname_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_Ticket:sname",
        	((t_dataptr_after_sname_meta - t_begin_of_data)) + (t_sname__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_sname_meta + t_sname__size;
        sname_->Parse(t_dataptr_after_sname_meta, t_end_of_data);
    }

    const_byteptr const t_dataptr_after_sname = t_dataptr_after_sname_meta + (t_sname__size);
    BINPAC_ASSERT(t_dataptr_after_sname <= t_end_of_data);
    // Parse "enc_part"
    enc_part_ = new KRB_Encrypted_Data_in_Seq();
    int t_enc_part__size;
    t_enc_part__size = enc_part_->Parse(t_dataptr_after_sname, t_end_of_data);

    int t_KRB_Ticket__size;
    const_byteptr const t_dataptr_after_enc_part = t_dataptr_after_sname + (t_enc_part__size);
    BINPAC_ASSERT(t_dataptr_after_enc_part <= t_end_of_data);
    t_KRB_Ticket__size = t_dataptr_after_enc_part - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Ticket__size) <= t_end_of_data);
    return t_KRB_Ticket__size;
}

KRB_Ticket_Sequence::KRB_Ticket_Sequence() {
    seq_meta_ = nullptr;
    tickets_ = nullptr;
    tickets__elem_ = nullptr;
}

KRB_Ticket_Sequence::~KRB_Ticket_Sequence() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete tickets__elem_;
    tickets__elem_ = nullptr;
    if ( tickets() ) {
        for ( auto* tickets__elem_ : *tickets() ) {
            delete tickets__elem_;
            tickets__elem_ = nullptr;
        }
    }
    delete tickets_;
}

int KRB_Ticket_Sequence::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "tickets"
    int t_tickets__size;
    t_tickets__size = seq_meta()->length();
    // Checking out-of-bound for "KRB_Ticket_Sequence:tickets"
    if ( t_dataptr_after_seq_meta + (t_tickets__size) > t_end_of_data || t_dataptr_after_seq_meta + (t_tickets__size) < t_dataptr_after_seq_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_Ticket_Sequence:tickets",
        	((t_dataptr_after_seq_meta - t_begin_of_data)) + (t_tickets__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_seq_meta + t_tickets__size;
        int t_tickets__arraylength;
        t_tickets__arraylength = 0;
        tickets__elem_ = nullptr;
        int t_tickets__elem__it;
        t_tickets__elem__it = 0;
        tickets_ = new vector<KRB_Ticket*>;
        const_byteptr t_tickets__elem__dataptr = t_dataptr_after_seq_meta;
        for (; /* forever */; ++t_tickets__elem__it) {
            // Check &until(tickets__elem__dataptr >= end_of_data)
            if ( t_tickets__elem__dataptr >= t_end_of_data ) {
                tickets__elem_ = nullptr;
                goto end_of_tickets;
            }
            tickets__elem_ = new KRB_Ticket(false);
            int t_tickets__elem__size;
            t_tickets__elem__size = tickets__elem_->Parse(t_tickets__elem__dataptr, t_end_of_data);
            tickets_->push_back(tickets__elem_);
            t_tickets__elem__dataptr += t_tickets__elem__size;
            BINPAC_ASSERT(t_tickets__elem__dataptr <= t_end_of_data);
            tickets__elem_ = nullptr;
        }
    end_of_tickets: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_KRB_Ticket_Sequence__size;
    const_byteptr const t_dataptr_after_tickets = t_dataptr_after_seq_meta + (t_tickets__size);
    BINPAC_ASSERT(t_dataptr_after_tickets <= t_end_of_data);
    t_KRB_Ticket_Sequence__size = t_dataptr_after_tickets - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Ticket_Sequence__size) <= t_end_of_data);
    return t_KRB_Ticket_Sequence__size;
}

KRB_Encrypted_Data_in_Seq::KRB_Encrypted_Data_in_Seq() {
    index_meta_ = nullptr;
    data_ = nullptr;
}

KRB_Encrypted_Data_in_Seq::~KRB_Encrypted_Data_in_Seq() {
    delete index_meta_;
    index_meta_ = nullptr;
    delete data_;
    data_ = nullptr;
}

int KRB_Encrypted_Data_in_Seq::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "index_meta"
    index_meta_ = new ASN1EncodingMeta();
    int t_index_meta__size;
    t_index_meta__size = index_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_index_meta = t_begin_of_data + (t_index_meta__size);
    BINPAC_ASSERT(t_dataptr_after_index_meta <= t_end_of_data);
    // Parse "data"
    data_ = new KRB_Encrypted_Data();
    int t_data__size;
    t_data__size = index_meta()->length();
    // Checking out-of-bound for "KRB_Encrypted_Data_in_Seq:data"
    if ( t_dataptr_after_index_meta + (t_data__size) > t_end_of_data || t_dataptr_after_index_meta + (t_data__size) < t_dataptr_after_index_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_Encrypted_Data_in_Seq:data",
        	((t_dataptr_after_index_meta - t_begin_of_data)) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_index_meta + t_data__size;
        data_->Parse(t_dataptr_after_index_meta, t_end_of_data);
    }

    int t_KRB_Encrypted_Data_in_Seq__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_index_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_Encrypted_Data_in_Seq__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Encrypted_Data_in_Seq__size) <= t_end_of_data);
    return t_KRB_Encrypted_Data_in_Seq__size;
}

KRB_Encrypted_Data::KRB_Encrypted_Data() {
    seq_meta_ = nullptr;
    etype_ = nullptr;
    kvno_meta_ = nullptr;
    case_kvno_case_index_ = -1;
    kvno_ = nullptr;
    grab_next_meta_case_index_ = -1;
    next_meta_ = nullptr;
    ciphertext_ = nullptr;
    have_kvno_ = false;
}

KRB_Encrypted_Data::~KRB_Encrypted_Data() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete etype_;
    etype_ = nullptr;
    delete kvno_meta_;
    kvno_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( case_kvno_case_index() ) {
        case true:
            // Clean up "kvno"
            {
                delete kvno_;
                kvno_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( grab_next_meta_case_index() ) {
        case true:
            // Clean up "next_meta"
            {
                delete next_meta_;
                next_meta_ = nullptr;
            }
            break;
        case false:
            // Clean up "none_meta"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete ciphertext_;
    ciphertext_ = nullptr;
}

int KRB_Encrypted_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "etype"
    etype_ = new SequenceElement(true);
    int t_etype__size;
    t_etype__size = etype_->Parse(t_dataptr_after_seq_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_etype = t_dataptr_after_seq_meta + (t_etype__size);
    BINPAC_ASSERT(t_dataptr_after_etype <= t_end_of_data);
    // Parse "kvno_meta"
    kvno_meta_ = new ASN1EncodingMeta();
    int t_kvno_meta__size;
    t_kvno_meta__size = kvno_meta_->Parse(t_dataptr_after_etype, t_end_of_data);

    const_byteptr const t_dataptr_after_kvno_meta = t_dataptr_after_etype + (t_kvno_meta__size);
    BINPAC_ASSERT(t_dataptr_after_kvno_meta <= t_end_of_data);
    // Parse "case_kvno"
    int t_case_kvno__size;
    have_kvno_ = kvno_meta()->index() == 1;
    case_kvno_case_index_ = have_kvno();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( case_kvno_case_index() ) {
        case true:
            // Parse "kvno"
            {
                kvno_ = new ASN1Integer();
                int t_kvno__size;
                t_kvno__size = kvno_->Parse(t_dataptr_after_kvno_meta, t_end_of_data);
                t_case_kvno__size = t_kvno__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_case_kvno__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_Encrypted_Data", (int64)case_kvno_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_case_kvno = t_dataptr_after_kvno_meta + (t_case_kvno__size);
    BINPAC_ASSERT(t_dataptr_after_case_kvno <= t_end_of_data);
    // Parse "grab_next_meta"
    int t_grab_next_meta__size;
    grab_next_meta_case_index_ = have_kvno();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( grab_next_meta_case_index() ) {
        case true:
            // Parse "next_meta"
            {
                next_meta_ = new ASN1EncodingMeta();
                int t_next_meta__size;
                t_next_meta__size = next_meta_->Parse(t_dataptr_after_case_kvno, t_end_of_data);
                t_grab_next_meta__size = t_next_meta__size;
            }
            break;
        case false:
            // Parse "none_meta"
            {
                t_grab_next_meta__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_Encrypted_Data", (int64)grab_next_meta_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_grab_next_meta = t_dataptr_after_case_kvno + (t_grab_next_meta__size);
    BINPAC_ASSERT(t_dataptr_after_grab_next_meta <= t_end_of_data);
    // Parse "ciphertext"
    ciphertext_ = new ASN1OctetString();
    int t_ciphertext__size;
    t_ciphertext__size = have_kvno() ? next_meta()->length() : kvno_meta()->length();
    // Checking out-of-bound for "KRB_Encrypted_Data:ciphertext"
    if ( t_dataptr_after_grab_next_meta + (t_ciphertext__size) > t_end_of_data || t_dataptr_after_grab_next_meta + (t_ciphertext__size) < t_dataptr_after_grab_next_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_Encrypted_Data:ciphertext",
        	((t_dataptr_after_grab_next_meta - t_begin_of_data)) + (t_ciphertext__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_grab_next_meta + t_ciphertext__size;
        ciphertext_->Parse(t_dataptr_after_grab_next_meta, t_end_of_data);
    }

    int t_KRB_Encrypted_Data__size;
    const_byteptr const t_dataptr_after_ciphertext = t_dataptr_after_grab_next_meta + (t_ciphertext__size);
    BINPAC_ASSERT(t_dataptr_after_ciphertext <= t_end_of_data);
    t_KRB_Encrypted_Data__size = t_dataptr_after_ciphertext - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Encrypted_Data__size) <= t_end_of_data);
    return t_KRB_Encrypted_Data__size;
}

KRB_Checksum::KRB_Checksum() {
    checksum_type_ = nullptr;
    checksum_ = nullptr;
}

KRB_Checksum::~KRB_Checksum() {
    delete checksum_type_;
    checksum_type_ = nullptr;
    delete checksum_;
    checksum_ = nullptr;
}

int KRB_Checksum::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "checksum_type"
    checksum_type_ = new SequenceElement(true);
    int t_checksum_type__size;
    t_checksum_type__size = checksum_type_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_checksum_type = t_begin_of_data + (t_checksum_type__size);
    BINPAC_ASSERT(t_dataptr_after_checksum_type <= t_end_of_data);
    // Parse "checksum"
    checksum_ = new SequenceElement(true);
    int t_checksum__size;
    t_checksum__size = checksum_->Parse(t_dataptr_after_checksum_type, t_end_of_data);

    int t_KRB_Checksum__size;
    const_byteptr const t_dataptr_after_checksum = t_dataptr_after_checksum_type + (t_checksum__size);
    BINPAC_ASSERT(t_dataptr_after_checksum <= t_end_of_data);
    t_KRB_Checksum__size = t_dataptr_after_checksum - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_Checksum__size) <= t_end_of_data);
    return t_KRB_Checksum__size;
}


zeek::VectorValPtr proc_padata(const KRB_PA_Data_Sequence* data, const ZeekAnalyzer zeek_analyzer, bool is_error)
{
	auto vv = zeek::make_intrusive<zeek::VectorVal>(zeek::id::find_type<zeek::VectorType>("KRB::Type_Value_Vector"));

	if ( ! data->data()->has_padata() )
		return vv;

	for ( KRB_PA_Data* element : *(data->data()->padata_elems()) )
		{
		uint64_t data_type = element->data_type();

		if ( is_error && ( data_type == PA_PW_AS_REQ || data_type == PA_PW_AS_REP ) )
			data_type = 0;

		switch( data_type )
			{
			case PA_TGS_REQ:
				// will be generated as separate event
				break;
			case PA_ENC_TIMESTAMP:
				{
				auto type_val = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Type_Value);
				type_val->Assign(0, data_type);
				type_val->Assign(1, to_stringval(element->pa_data_element()->pa_enc_ts()->ciphertext()->encoding()->content()));
				vv->Assign(vv->Size(), std::move(type_val));
				break;
				}
			case PA_PW_SALT:
				{
				auto type_val = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Type_Value);
				type_val->Assign(0, data_type);
				type_val->Assign(1, to_stringval(element->pa_data_element()->pa_pw_salt()->encoding()->content()));
				vv->Assign(vv->Size(), std::move(type_val));
				break;
				}
			case PA_ENCTYPE_INFO:
				{
				auto type_val = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Type_Value);
				type_val->Assign(0, data_type);
				type_val->Assign(1, to_stringval(element->pa_data_element()->pf_enctype_info()->salt()));
				vv->Assign(vv->Size(), std::move(type_val));
				break;
				}
			case PA_ENCTYPE_INFO2:
				{
				auto type_val = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Type_Value);
				type_val->Assign(0, data_type);
				type_val->Assign(1, to_stringval(element->pa_data_element()->pf_enctype_info2()->salt()));
				vv->Assign(vv->Size(), std::move(type_val));
				break;
				}
			case PA_PW_AS_REQ:
				{
				const bytestring& cert = element->pa_data_element()->pa_pk_as_req()->cert();

				zeek::ODesc common;
				common.AddRaw("Analyzer::ANALYZER_KRB");
				common.Add(zeek_analyzer->Conn()->StartTime());
				// Request means is_orig=T
				common.AddRaw("T", 1);
				zeek_analyzer->Conn()->IDString(&common);

				zeek::ODesc file_handle;
				file_handle.Add(common.Description());
				file_handle.Add(0);

				string file_id = zeek::file_mgr->HashHandle(file_handle.Description());

				zeek::file_mgr->DataIn(reinterpret_cast<const u_char*>(cert.data()),
				                       cert.length(), zeek_analyzer->GetAnalyzerTag(),
				                       zeek_analyzer->Conn(), true, file_id,
				                       "application/x-x509-user-cert");
				zeek::file_mgr->EndOfFile(file_id);

				break;
				}
			case PA_PW_AS_REP:
				{
				const bytestring& cert = element->pa_data_element()->pa_pk_as_rep()->cert();

				zeek::ODesc common;
				common.AddRaw("Analyzer::ANALYZER_KRB");
				common.Add(zeek_analyzer->Conn()->StartTime());
				// Response means is_orig=F
				common.AddRaw("F", 1);
				zeek_analyzer->Conn()->IDString(&common);

				zeek::ODesc file_handle;
				file_handle.Add(common.Description());
				file_handle.Add(1);

				string file_id = zeek::file_mgr->HashHandle(file_handle.Description());

				zeek::file_mgr->DataIn(reinterpret_cast<const u_char*>(cert.data()),
				                       cert.length(), zeek_analyzer->GetAnalyzerTag(),
				                       zeek_analyzer->Conn(), false, file_id,
				                       "application/x-x509-user-cert");
				zeek::file_mgr->EndOfFile(file_id);

				break;
				}
			default:
				{
				if ( ! is_error && element->pa_data_element()->unknown()->meta()->length() > 0 )
					{
					auto type_val = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::Type_Value);
					type_val->Assign(0, data_type);
					type_val->Assign(1, to_stringval(element->pa_data_element()->unknown()->content()));
					vv->Assign(vv->Size(), std::move(type_val));
					}
				break;
				}
			}
		}
	return vv;
}

KRB_PA_Data_Optional::KRB_PA_Data_Optional(bool is_orig, uint8 pkt_type, uint8 desired_index) {
    first_meta_ = nullptr;
    padata_ = nullptr;
    next_meta_ = nullptr;
    is_orig_ = is_orig;
    pkt_type_ = pkt_type;
    desired_index_ = desired_index;
    has_padata_ = false;
}

KRB_PA_Data_Optional::~KRB_PA_Data_Optional() {
    delete first_meta_;
    first_meta_ = nullptr;
    delete padata_;
    padata_ = nullptr;
    delete next_meta_;
    next_meta_ = nullptr;
}

int KRB_PA_Data_Optional::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "first_meta"
    first_meta_ = new ASN1EncodingMeta();
    int t_first_meta__size;
    t_first_meta__size = first_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_first_meta = t_begin_of_data + (t_first_meta__size);
    BINPAC_ASSERT(t_dataptr_after_first_meta <= t_end_of_data);
    // Parse "padata"
    has_padata_ = first_meta()->index() == desired_index();
    padata_ = new KRB_PA_Data_Optional_Contents(is_orig(), has_padata(), pkt_type(), first_meta()->length());
    int t_padata__size;
    t_padata__size = padata_->Parse(t_dataptr_after_first_meta, t_end_of_data, t_context, t_byteorder);

    const_byteptr const t_dataptr_after_padata = t_dataptr_after_first_meta + (t_padata__size);
    BINPAC_ASSERT(t_dataptr_after_padata <= t_end_of_data);
    // Parse "next_meta"
    next_meta_ = new ASN1OptionalEncodingMeta(has_padata(), first_meta());
    int t_next_meta__size;
    t_next_meta__size = next_meta_->Parse(t_dataptr_after_padata, t_end_of_data);

    int t_KRB_PA_Data_Optional__size;
    const_byteptr const t_dataptr_after_next_meta = t_dataptr_after_padata + (t_next_meta__size);
    BINPAC_ASSERT(t_dataptr_after_next_meta <= t_end_of_data);
    t_KRB_PA_Data_Optional__size = t_dataptr_after_next_meta - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PA_Data_Optional__size) <= t_end_of_data);
    return t_KRB_PA_Data_Optional__size;
}

KRB_PA_Data_Optional_Contents::KRB_PA_Data_Optional_Contents(bool is_orig, bool is_present, uint8 pkt_type, uint64 length) {
    val_case_index_ = -1;
    padata_ = nullptr;
    is_orig_ = is_orig;
    is_present_ = is_present;
    pkt_type_ = pkt_type;
    length_ = length;
}

KRB_PA_Data_Optional_Contents::~KRB_PA_Data_Optional_Contents() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "padata"
            {
                delete padata_;
                padata_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_PA_Data_Optional_Contents::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = is_present();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "padata"
            {
                padata_ = new KRB_PA_Data_Sequence(is_orig(), pkt_type());
                int t_padata__size;
                t_padata__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Optional_Contents:padata"
                if ( t_begin_of_data + (t_padata__size) > t_end_of_data || t_begin_of_data + (t_padata__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Optional_Contents:padata",
                    	(0) + (t_padata__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_padata__size;
                    padata_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                }
                t_val__size = t_padata__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_val__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_PA_Data_Optional_Contents", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

KRB_PA_Data_Sequence::KRB_PA_Data_Sequence(bool is_orig, uint8 pkt_type) {
    meta_ = nullptr;
    data_ = nullptr;
    is_orig_ = is_orig;
    pkt_type_ = pkt_type;
}

KRB_PA_Data_Sequence::~KRB_PA_Data_Sequence() {
    delete meta_;
    meta_ = nullptr;
    delete data_;
    data_ = nullptr;
}

int KRB_PA_Data_Sequence::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "data"
    data_ = new KRB_PA_Data_Container(is_orig(), pkt_type(), meta()->tag(), meta()->length());
    int t_data__size;
    t_data__size = data_->Parse(t_dataptr_after_meta, t_end_of_data, t_context, t_byteorder);

    int t_KRB_PA_Data_Sequence__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_PA_Data_Sequence__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PA_Data_Sequence__size) <= t_end_of_data);
    return t_KRB_PA_Data_Sequence__size;
}

KRB_PA_Data_Container::KRB_PA_Data_Container(bool is_orig, uint8 pkt_type, uint8 tag, uint64 length) {
    val_case_index_ = -1;
    padata_elems_ = nullptr;
    padata_elems__elem_ = nullptr;
    is_orig_ = is_orig;
    pkt_type_ = pkt_type;
    tag_ = tag;
    length_ = length;
    has_padata_ = false;
}

KRB_PA_Data_Container::~KRB_PA_Data_Container() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)48):
            // Clean up "padata_elems"
            {
                delete padata_elems__elem_;
                padata_elems__elem_ = nullptr;
                if ( padata_elems() ) {
                    for ( auto* padata_elems__elem_ : *padata_elems() ) {
                        delete padata_elems__elem_;
                        padata_elems__elem_ = nullptr;
                    }
                }
                delete padata_elems_;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_PA_Data_Container::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = tag();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)48):
            // Parse "padata_elems"
            {
                int t_padata_elems__arraylength;
                t_padata_elems__arraylength = 0;
                padata_elems__elem_ = nullptr;
                int t_padata_elems__elem__it;
                t_padata_elems__elem__it = 0;
                int t_padata_elems__size;
                padata_elems_ = new vector<KRB_PA_Data*>;
                const_byteptr t_padata_elems__elem__dataptr = t_begin_of_data;
                for (; /* forever */; ++t_padata_elems__elem__it) {
                    // Check &until(padata_elems__elem__dataptr >= end_of_data)
                    if ( t_padata_elems__elem__dataptr >= t_end_of_data ) {
                        padata_elems__elem_ = nullptr;
                        goto end_of_padata_elems;
                    }
                    padata_elems__elem_ = new KRB_PA_Data(is_orig(), pkt_type());
                    int t_padata_elems__elem__size;
                    t_padata_elems__elem__size = padata_elems__elem_->Parse(t_padata_elems__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    padata_elems_->push_back(padata_elems__elem_);
                    t_padata_elems__elem__dataptr += t_padata_elems__elem__size;
                    BINPAC_ASSERT(t_padata_elems__elem__dataptr <= t_end_of_data);
                    padata_elems__elem_ = nullptr;
                }
            end_of_padata_elems: ;
                t_padata_elems__size = t_padata_elems__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_padata_elems__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown__size;
                t_unknown__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Container:unknown"
                if ( t_begin_of_data + (t_unknown__size) > t_end_of_data || t_begin_of_data + (t_unknown__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Container:unknown",
                    	(0) + (t_unknown__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_unknown__size;
                    int t_unknown_string_length;
                    t_unknown_string_length = length();
                    // check for negative sizes
                    if ( t_unknown_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:169", t_unknown_string_length);
                    unknown_.init(t_begin_of_data, t_unknown_string_length);
                }
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    has_padata_ =  ( tag() == ASN1_SEQUENCE_TAG ) ;
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

KRB_PA_Data::KRB_PA_Data(bool is_orig, uint8 pkt_type) {
    seq_meta_ = nullptr;
    pa_data_type_ = nullptr;
    pa_data_elem_meta_ = nullptr;
    have_data_case_index_ = -1;
    pa_data_element_ = nullptr;
    is_orig_ = is_orig;
    pkt_type_ = pkt_type;
    data_type_ = 0;
}

KRB_PA_Data::~KRB_PA_Data() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete pa_data_type_;
    pa_data_type_ = nullptr;
    delete pa_data_elem_meta_;
    pa_data_elem_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_data_case_index() ) {
        case ((uint8)30):
            // Clean up "pa_data_placeholder"
            {
                pa_data_placeholder_.free();
            }
            break;
        default:
            // Clean up "pa_data_element"
            {
                delete pa_data_element_;
                pa_data_element_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_PA_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "pa_data_type"
    pa_data_type_ = new SequenceElement(true);
    int t_pa_data_type__size;
    t_pa_data_type__size = pa_data_type_->Parse(t_dataptr_after_seq_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_pa_data_type = t_dataptr_after_seq_meta + (t_pa_data_type__size);
    BINPAC_ASSERT(t_dataptr_after_pa_data_type <= t_end_of_data);
    // Parse "pa_data_elem_meta"
    pa_data_elem_meta_ = new ASN1EncodingMeta();
    int t_pa_data_elem_meta__size;
    t_pa_data_elem_meta__size = pa_data_elem_meta_->Parse(t_dataptr_after_pa_data_type, t_end_of_data);

    const_byteptr const t_dataptr_after_pa_data_elem_meta = t_dataptr_after_pa_data_type + (t_pa_data_elem_meta__size);
    BINPAC_ASSERT(t_dataptr_after_pa_data_elem_meta <= t_end_of_data);
    // Parse "have_data"
    data_type_ = binary_to_int64(pa_data_type()->data()->content());
    int t_have_data__size;
    have_data_case_index_ = pkt_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_data_case_index() ) {
        case ((uint8)30):
            // Parse "pa_data_placeholder"
            {
                int t_pa_data_placeholder__size;
                t_pa_data_placeholder__size = pa_data_elem_meta()->length();
                // Checking out-of-bound for "KRB_PA_Data:pa_data_placeholder"
                if ( t_dataptr_after_pa_data_elem_meta + (t_pa_data_placeholder__size) > t_end_of_data || t_dataptr_after_pa_data_elem_meta + (t_pa_data_placeholder__size) < t_dataptr_after_pa_data_elem_meta ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data:pa_data_placeholder",
                    	((t_dataptr_after_pa_data_elem_meta - t_begin_of_data)) + (t_pa_data_placeholder__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_pa_data_elem_meta + t_pa_data_placeholder__size;
                    int t_pa_data_placeholder_string_length;
                    t_pa_data_placeholder_string_length = pa_data_elem_meta()->length();
                    // check for negative sizes
                    if ( t_pa_data_placeholder_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:182", t_pa_data_placeholder_string_length);
                    pa_data_placeholder_.init(t_dataptr_after_pa_data_elem_meta, t_pa_data_placeholder_string_length);
                }
                t_have_data__size = t_pa_data_placeholder__size;
            }
            break;
        default:
            // Parse "pa_data_element"
            {
                pa_data_element_ = new KRB_PA_Data_Element(is_orig(), data_type(), pa_data_elem_meta()->length());
                int t_pa_data_element__size;
                t_pa_data_element__size = pa_data_element_->Parse(t_dataptr_after_pa_data_elem_meta, t_end_of_data, t_context, t_byteorder);
                t_have_data__size = t_pa_data_element__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_KRB_PA_Data__size;
    const_byteptr const t_dataptr_after_have_data = t_dataptr_after_pa_data_elem_meta + (t_have_data__size);
    BINPAC_ASSERT(t_dataptr_after_have_data <= t_end_of_data);
    t_KRB_PA_Data__size = t_dataptr_after_have_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PA_Data__size) <= t_end_of_data);
    return t_KRB_PA_Data__size;
}

KRB_PA_Data_Element::KRB_PA_Data_Element(bool is_orig, int64 type, uint64 length) {
    val_case_index_ = -1;
    pa_tgs_req_ = nullptr;
    pa_enc_ts_ = nullptr;
    pa_pw_salt_ = nullptr;
    pa_pk_as_req_ = nullptr;
    pa_pk_as_rep_ = nullptr;
    pf_enctype_info_ = nullptr;
    pf_enctype_info2_ = nullptr;
    unknown_ = nullptr;
    is_orig_ = is_orig;
    type_ = type;
    length_ = length;
}

KRB_PA_Data_Element::~KRB_PA_Data_Element() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int64)1):
            // Clean up "pa_tgs_req"
            {
                delete pa_tgs_req_;
                pa_tgs_req_ = nullptr;
            }
            break;
        case ((int64)2):
            // Clean up "pa_enc_ts"
            {
                delete pa_enc_ts_;
                pa_enc_ts_ = nullptr;
            }
            break;
        case ((int64)3):
            // Clean up "pa_pw_salt"
            {
                delete pa_pw_salt_;
                pa_pw_salt_ = nullptr;
            }
            break;
        case ((int64)16):
            // Clean up "pa_pk_as_req"
            {
                delete pa_pk_as_req_;
                pa_pk_as_req_ = nullptr;
            }
            break;
        case ((int64)17):
            // Clean up "pa_pk_as_rep"
            {
                delete pa_pk_as_rep_;
                pa_pk_as_rep_ = nullptr;
            }
            break;
        case ((int64)11):
            // Clean up "pf_enctype_info"
            {
                delete pf_enctype_info_;
                pf_enctype_info_ = nullptr;
            }
            break;
        case ((int64)19):
            // Clean up "pf_enctype_info2"
            {
                delete pf_enctype_info2_;
                pf_enctype_info2_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                delete unknown_;
                unknown_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_PA_Data_Element::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int64)1):
            // Parse "pa_tgs_req"
            {
                pa_tgs_req_ = new KRB_PA_AP_REQ_wrapper(is_orig());
                int t_pa_tgs_req__size;
                t_pa_tgs_req__size = pa_tgs_req_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_pa_tgs_req__size;
            }
            break;
        case ((int64)2):
            // Parse "pa_enc_ts"
            {
                pa_enc_ts_ = new KRB_Encrypted_Data();
                int t_pa_enc_ts__size;
                t_pa_enc_ts__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Element:pa_enc_ts"
                if ( t_begin_of_data + (t_pa_enc_ts__size) > t_end_of_data || t_begin_of_data + (t_pa_enc_ts__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Element:pa_enc_ts",
                    	(0) + (t_pa_enc_ts__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_pa_enc_ts__size;
                    pa_enc_ts_->Parse(t_begin_of_data, t_end_of_data);
                }
                t_val__size = t_pa_enc_ts__size;
            }
            break;
        case ((int64)3):
            // Parse "pa_pw_salt"
            {
                pa_pw_salt_ = new ASN1OctetString();
                int t_pa_pw_salt__size;
                t_pa_pw_salt__size = pa_pw_salt_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_pa_pw_salt__size;
            }
            break;
        case ((int64)16):
            // Parse "pa_pk_as_req"
            {
                pa_pk_as_req_ = new KRB_PA_PK_AS_Req();
                int t_pa_pk_as_req__size;
                t_pa_pk_as_req__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Element:pa_pk_as_req"
                if ( t_begin_of_data + (t_pa_pk_as_req__size) > t_end_of_data || t_begin_of_data + (t_pa_pk_as_req__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Element:pa_pk_as_req",
                    	(0) + (t_pa_pk_as_req__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_pa_pk_as_req__size;
                    pa_pk_as_req_->Parse(t_begin_of_data, t_end_of_data);
                }
                t_val__size = t_pa_pk_as_req__size;
            }
            break;
        case ((int64)17):
            // Parse "pa_pk_as_rep"
            {
                pa_pk_as_rep_ = new KRB_PA_PK_AS_Rep();
                int t_pa_pk_as_rep__size;
                t_pa_pk_as_rep__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Element:pa_pk_as_rep"
                if ( t_begin_of_data + (t_pa_pk_as_rep__size) > t_end_of_data || t_begin_of_data + (t_pa_pk_as_rep__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Element:pa_pk_as_rep",
                    	(0) + (t_pa_pk_as_rep__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_pa_pk_as_rep__size;
                    pa_pk_as_rep_->Parse(t_begin_of_data, t_end_of_data);
                }
                t_val__size = t_pa_pk_as_rep__size;
            }
            break;
        case ((int64)11):
            // Parse "pf_enctype_info"
            {
                pf_enctype_info_ = new KRB_PA_ENCTYPE_INFO();
                int t_pf_enctype_info__size;
                t_pf_enctype_info__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Element:pf_enctype_info"
                if ( t_begin_of_data + (t_pf_enctype_info__size) > t_end_of_data || t_begin_of_data + (t_pf_enctype_info__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Element:pf_enctype_info",
                    	(0) + (t_pf_enctype_info__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_pf_enctype_info__size;
                    pf_enctype_info_->Parse(t_begin_of_data, t_end_of_data);
                }
                t_val__size = t_pf_enctype_info__size;
            }
            break;
        case ((int64)19):
            // Parse "pf_enctype_info2"
            {
                pf_enctype_info2_ = new KRB_PA_ENCTYPE_INFO();
                int t_pf_enctype_info2__size;
                t_pf_enctype_info2__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Element:pf_enctype_info2"
                if ( t_begin_of_data + (t_pf_enctype_info2__size) > t_end_of_data || t_begin_of_data + (t_pf_enctype_info2__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Element:pf_enctype_info2",
                    	(0) + (t_pf_enctype_info2__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_pf_enctype_info2__size;
                    pf_enctype_info2_->Parse(t_begin_of_data, t_end_of_data);
                }
                t_val__size = t_pf_enctype_info2__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                unknown_ = new ASN1Encoding();
                int t_unknown__size;
                t_unknown__size = length();
                // Checking out-of-bound for "KRB_PA_Data_Element:unknown"
                if ( t_begin_of_data + (t_unknown__size) > t_end_of_data || t_begin_of_data + (t_unknown__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("KRB_PA_Data_Element:unknown",
                    	(0) + (t_unknown__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_unknown__size;
                    unknown_->Parse(t_begin_of_data, t_end_of_data);
                }
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

KRB_PA_AP_REQ_wrapper::KRB_PA_AP_REQ_wrapper(bool is_orig) {
    some_meta1_ = nullptr;
    some_meta2_ = nullptr;
    req_ = nullptr;
    is_orig_ = is_orig;
}

KRB_PA_AP_REQ_wrapper::~KRB_PA_AP_REQ_wrapper() {
    delete some_meta1_;
    some_meta1_ = nullptr;
    delete some_meta2_;
    some_meta2_ = nullptr;
    delete req_;
    req_ = nullptr;
}

int KRB_PA_AP_REQ_wrapper::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "some_meta1"
    some_meta1_ = new ASN1EncodingMeta();
    int t_some_meta1__size;
    t_some_meta1__size = some_meta1_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_some_meta1 = t_begin_of_data + (t_some_meta1__size);
    BINPAC_ASSERT(t_dataptr_after_some_meta1 <= t_end_of_data);
    // Parse "some_meta2"
    some_meta2_ = new ASN1EncodingMeta();
    int t_some_meta2__size;
    t_some_meta2__size = some_meta2_->Parse(t_dataptr_after_some_meta1, t_end_of_data);

    const_byteptr const t_dataptr_after_some_meta2 = t_dataptr_after_some_meta1 + (t_some_meta2__size);
    BINPAC_ASSERT(t_dataptr_after_some_meta2 <= t_end_of_data);
    // Parse "req"
    req_ = new KRB_AP_REQ(is_orig());
    int t_req__size;
    t_req__size = req_->Parse(t_dataptr_after_some_meta2, t_end_of_data, t_context, t_byteorder);

    int t_KRB_PA_AP_REQ_wrapper__size;
    const_byteptr const t_dataptr_after_req = t_dataptr_after_some_meta2 + (t_req__size);
    BINPAC_ASSERT(t_dataptr_after_req <= t_end_of_data);
    t_KRB_PA_AP_REQ_wrapper__size = t_dataptr_after_req - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PA_AP_REQ_wrapper__size) <= t_end_of_data);
    return t_KRB_PA_AP_REQ_wrapper__size;
}

KRB_PA_PK_AS_Req::KRB_PA_PK_AS_Req() {
    string_meta_ = nullptr;
    seq_meta1_ = nullptr;
    elem_0_meta1_ = nullptr;
    seq_meta2_ = nullptr;
    oid_ = nullptr;
    elem_0_meta2_ = nullptr;
    seq_meta3_ = nullptr;
    version_ = nullptr;
    digest_algs_ = nullptr;
    signed_data_ = nullptr;
    cert_meta_ = nullptr;
}

KRB_PA_PK_AS_Req::~KRB_PA_PK_AS_Req() {
    delete string_meta_;
    string_meta_ = nullptr;
    delete seq_meta1_;
    seq_meta1_ = nullptr;
    delete elem_0_meta1_;
    elem_0_meta1_ = nullptr;
    delete seq_meta2_;
    seq_meta2_ = nullptr;
    delete oid_;
    oid_ = nullptr;
    delete elem_0_meta2_;
    elem_0_meta2_ = nullptr;
    delete seq_meta3_;
    seq_meta3_ = nullptr;
    delete version_;
    version_ = nullptr;
    delete digest_algs_;
    digest_algs_ = nullptr;
    delete signed_data_;
    signed_data_ = nullptr;
    delete cert_meta_;
    cert_meta_ = nullptr;
    cert_.free();
}

int KRB_PA_PK_AS_Req::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "string_meta"
    string_meta_ = new ASN1EncodingMeta();
    int t_string_meta__size;
    t_string_meta__size = string_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_string_meta = t_begin_of_data + (t_string_meta__size);
    BINPAC_ASSERT(t_dataptr_after_string_meta <= t_end_of_data);
    // Parse "seq_meta1"
    seq_meta1_ = new ASN1EncodingMeta();
    int t_seq_meta1__size;
    t_seq_meta1__size = seq_meta1_->Parse(t_dataptr_after_string_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta1 = t_dataptr_after_string_meta + (t_seq_meta1__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta1 <= t_end_of_data);
    // Parse "elem_0_meta1"
    elem_0_meta1_ = new ASN1EncodingMeta();
    int t_elem_0_meta1__size;
    t_elem_0_meta1__size = elem_0_meta1_->Parse(t_dataptr_after_seq_meta1, t_end_of_data);

    const_byteptr const t_dataptr_after_elem_0_meta1 = t_dataptr_after_seq_meta1 + (t_elem_0_meta1__size);
    BINPAC_ASSERT(t_dataptr_after_elem_0_meta1 <= t_end_of_data);
    // Parse "seq_meta2"
    seq_meta2_ = new ASN1EncodingMeta();
    int t_seq_meta2__size;
    t_seq_meta2__size = seq_meta2_->Parse(t_dataptr_after_elem_0_meta1, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta2 = t_dataptr_after_elem_0_meta1 + (t_seq_meta2__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta2 <= t_end_of_data);
    // Parse "oid"
    oid_ = new ASN1Encoding();
    int t_oid__size;
    t_oid__size = oid_->Parse(t_dataptr_after_seq_meta2, t_end_of_data);

    const_byteptr const t_dataptr_after_oid = t_dataptr_after_seq_meta2 + (t_oid__size);
    BINPAC_ASSERT(t_dataptr_after_oid <= t_end_of_data);
    // Parse "elem_0_meta2"
    elem_0_meta2_ = new ASN1EncodingMeta();
    int t_elem_0_meta2__size;
    t_elem_0_meta2__size = elem_0_meta2_->Parse(t_dataptr_after_oid, t_end_of_data);

    const_byteptr const t_dataptr_after_elem_0_meta2 = t_dataptr_after_oid + (t_elem_0_meta2__size);
    BINPAC_ASSERT(t_dataptr_after_elem_0_meta2 <= t_end_of_data);
    // Parse "seq_meta3"
    seq_meta3_ = new ASN1EncodingMeta();
    int t_seq_meta3__size;
    t_seq_meta3__size = seq_meta3_->Parse(t_dataptr_after_elem_0_meta2, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta3 = t_dataptr_after_elem_0_meta2 + (t_seq_meta3__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta3 <= t_end_of_data);
    // Parse "version"
    version_ = new ASN1Encoding();
    int t_version__size;
    t_version__size = version_->Parse(t_dataptr_after_seq_meta3, t_end_of_data);

    const_byteptr const t_dataptr_after_version = t_dataptr_after_seq_meta3 + (t_version__size);
    BINPAC_ASSERT(t_dataptr_after_version <= t_end_of_data);
    // Parse "digest_algs"
    digest_algs_ = new ASN1Encoding();
    int t_digest_algs__size;
    t_digest_algs__size = digest_algs_->Parse(t_dataptr_after_version, t_end_of_data);

    const_byteptr const t_dataptr_after_digest_algs = t_dataptr_after_version + (t_digest_algs__size);
    BINPAC_ASSERT(t_dataptr_after_digest_algs <= t_end_of_data);
    // Parse "signed_data"
    signed_data_ = new ASN1Encoding();
    int t_signed_data__size;
    t_signed_data__size = signed_data_->Parse(t_dataptr_after_digest_algs, t_end_of_data);

    const_byteptr const t_dataptr_after_signed_data = t_dataptr_after_digest_algs + (t_signed_data__size);
    BINPAC_ASSERT(t_dataptr_after_signed_data <= t_end_of_data);
    // Parse "cert_meta"
    cert_meta_ = new ASN1EncodingMeta();
    int t_cert_meta__size;
    t_cert_meta__size = cert_meta_->Parse(t_dataptr_after_signed_data, t_end_of_data);

    const_byteptr const t_dataptr_after_cert_meta = t_dataptr_after_signed_data + (t_cert_meta__size);
    BINPAC_ASSERT(t_dataptr_after_cert_meta <= t_end_of_data);
    // Parse "cert"
    int t_cert__size;
    t_cert__size = cert_meta()->length();
    // Checking out-of-bound for "KRB_PA_PK_AS_Req:cert"
    if ( t_dataptr_after_cert_meta + (t_cert__size) > t_end_of_data || t_dataptr_after_cert_meta + (t_cert__size) < t_dataptr_after_cert_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_PA_PK_AS_Req:cert",
        	((t_dataptr_after_cert_meta - t_begin_of_data)) + (t_cert__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_cert_meta + t_cert__size;
        int t_cert_string_length;
        t_cert_string_length = cert_meta()->length();
        // check for negative sizes
        if ( t_cert_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:222", t_cert_string_length);
        cert_.init(t_dataptr_after_cert_meta, t_cert_string_length);
    }

    const_byteptr const t_dataptr_after_cert = t_dataptr_after_cert_meta + (t_cert__size);
    BINPAC_ASSERT(t_dataptr_after_cert <= t_end_of_data);
    // Parse "anonymous_field_001"
    const_bytestring anonymous_field_001_;
    int t_anonymous_field_001_string_length;
    t_anonymous_field_001_string_length = (t_end_of_data) - (t_dataptr_after_cert);
    int t_anonymous_field_001__size;
    t_anonymous_field_001__size = t_anonymous_field_001_string_length;

    int t_KRB_PA_PK_AS_Req__size;
    const_byteptr const t_dataptr_after_anonymous_field_001 = t_dataptr_after_cert + (t_anonymous_field_001__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_001 <= t_end_of_data);
    t_KRB_PA_PK_AS_Req__size = t_dataptr_after_anonymous_field_001 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PA_PK_AS_Req__size) <= t_end_of_data);
    return t_KRB_PA_PK_AS_Req__size;
}

KRB_PA_PK_AS_Rep::KRB_PA_PK_AS_Rep() {
    string_meta_ = nullptr;
    elem_0_meta1_ = nullptr;
    seq_meta1_ = nullptr;
    elem_0_meta2_ = nullptr;
    seq_meta2_ = nullptr;
    oid_ = nullptr;
    elem_0_meta3_ = nullptr;
    seq_meta3_ = nullptr;
    version_ = nullptr;
    digest_algs_ = nullptr;
    signed_data_ = nullptr;
    cert_meta_ = nullptr;
}

KRB_PA_PK_AS_Rep::~KRB_PA_PK_AS_Rep() {
    delete string_meta_;
    string_meta_ = nullptr;
    delete elem_0_meta1_;
    elem_0_meta1_ = nullptr;
    delete seq_meta1_;
    seq_meta1_ = nullptr;
    delete elem_0_meta2_;
    elem_0_meta2_ = nullptr;
    delete seq_meta2_;
    seq_meta2_ = nullptr;
    delete oid_;
    oid_ = nullptr;
    delete elem_0_meta3_;
    elem_0_meta3_ = nullptr;
    delete seq_meta3_;
    seq_meta3_ = nullptr;
    delete version_;
    version_ = nullptr;
    delete digest_algs_;
    digest_algs_ = nullptr;
    delete signed_data_;
    signed_data_ = nullptr;
    delete cert_meta_;
    cert_meta_ = nullptr;
    cert_.free();
}

int KRB_PA_PK_AS_Rep::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "string_meta"
    string_meta_ = new ASN1EncodingMeta();
    int t_string_meta__size;
    t_string_meta__size = string_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_string_meta = t_begin_of_data + (t_string_meta__size);
    BINPAC_ASSERT(t_dataptr_after_string_meta <= t_end_of_data);
    // Parse "elem_0_meta1"
    elem_0_meta1_ = new ASN1EncodingMeta();
    int t_elem_0_meta1__size;
    t_elem_0_meta1__size = elem_0_meta1_->Parse(t_dataptr_after_string_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_elem_0_meta1 = t_dataptr_after_string_meta + (t_elem_0_meta1__size);
    BINPAC_ASSERT(t_dataptr_after_elem_0_meta1 <= t_end_of_data);
    // Parse "seq_meta1"
    seq_meta1_ = new ASN1EncodingMeta();
    int t_seq_meta1__size;
    t_seq_meta1__size = seq_meta1_->Parse(t_dataptr_after_elem_0_meta1, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta1 = t_dataptr_after_elem_0_meta1 + (t_seq_meta1__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta1 <= t_end_of_data);
    // Parse "elem_0_meta2"
    elem_0_meta2_ = new ASN1EncodingMeta();
    int t_elem_0_meta2__size;
    t_elem_0_meta2__size = elem_0_meta2_->Parse(t_dataptr_after_seq_meta1, t_end_of_data);

    const_byteptr const t_dataptr_after_elem_0_meta2 = t_dataptr_after_seq_meta1 + (t_elem_0_meta2__size);
    BINPAC_ASSERT(t_dataptr_after_elem_0_meta2 <= t_end_of_data);
    // Parse "seq_meta2"
    seq_meta2_ = new ASN1EncodingMeta();
    int t_seq_meta2__size;
    t_seq_meta2__size = seq_meta2_->Parse(t_dataptr_after_elem_0_meta2, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta2 = t_dataptr_after_elem_0_meta2 + (t_seq_meta2__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta2 <= t_end_of_data);
    // Parse "oid"
    oid_ = new ASN1Encoding();
    int t_oid__size;
    t_oid__size = oid_->Parse(t_dataptr_after_seq_meta2, t_end_of_data);

    const_byteptr const t_dataptr_after_oid = t_dataptr_after_seq_meta2 + (t_oid__size);
    BINPAC_ASSERT(t_dataptr_after_oid <= t_end_of_data);
    // Parse "elem_0_meta3"
    elem_0_meta3_ = new ASN1EncodingMeta();
    int t_elem_0_meta3__size;
    t_elem_0_meta3__size = elem_0_meta3_->Parse(t_dataptr_after_oid, t_end_of_data);

    const_byteptr const t_dataptr_after_elem_0_meta3 = t_dataptr_after_oid + (t_elem_0_meta3__size);
    BINPAC_ASSERT(t_dataptr_after_elem_0_meta3 <= t_end_of_data);
    // Parse "seq_meta3"
    seq_meta3_ = new ASN1EncodingMeta();
    int t_seq_meta3__size;
    t_seq_meta3__size = seq_meta3_->Parse(t_dataptr_after_elem_0_meta3, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta3 = t_dataptr_after_elem_0_meta3 + (t_seq_meta3__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta3 <= t_end_of_data);
    // Parse "version"
    version_ = new ASN1Encoding();
    int t_version__size;
    t_version__size = version_->Parse(t_dataptr_after_seq_meta3, t_end_of_data);

    const_byteptr const t_dataptr_after_version = t_dataptr_after_seq_meta3 + (t_version__size);
    BINPAC_ASSERT(t_dataptr_after_version <= t_end_of_data);
    // Parse "digest_algs"
    digest_algs_ = new ASN1Encoding();
    int t_digest_algs__size;
    t_digest_algs__size = digest_algs_->Parse(t_dataptr_after_version, t_end_of_data);

    const_byteptr const t_dataptr_after_digest_algs = t_dataptr_after_version + (t_digest_algs__size);
    BINPAC_ASSERT(t_dataptr_after_digest_algs <= t_end_of_data);
    // Parse "signed_data"
    signed_data_ = new ASN1Encoding();
    int t_signed_data__size;
    t_signed_data__size = signed_data_->Parse(t_dataptr_after_digest_algs, t_end_of_data);

    const_byteptr const t_dataptr_after_signed_data = t_dataptr_after_digest_algs + (t_signed_data__size);
    BINPAC_ASSERT(t_dataptr_after_signed_data <= t_end_of_data);
    // Parse "cert_meta"
    cert_meta_ = new ASN1EncodingMeta();
    int t_cert_meta__size;
    t_cert_meta__size = cert_meta_->Parse(t_dataptr_after_signed_data, t_end_of_data);

    const_byteptr const t_dataptr_after_cert_meta = t_dataptr_after_signed_data + (t_cert_meta__size);
    BINPAC_ASSERT(t_dataptr_after_cert_meta <= t_end_of_data);
    // Parse "cert"
    int t_cert__size;
    t_cert__size = cert_meta()->length();
    // Checking out-of-bound for "KRB_PA_PK_AS_Rep:cert"
    if ( t_dataptr_after_cert_meta + (t_cert__size) > t_end_of_data || t_dataptr_after_cert_meta + (t_cert__size) < t_dataptr_after_cert_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_PA_PK_AS_Rep:cert",
        	((t_dataptr_after_cert_meta - t_begin_of_data)) + (t_cert__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_cert_meta + t_cert__size;
        int t_cert_string_length;
        t_cert_string_length = cert_meta()->length();
        // check for negative sizes
        if ( t_cert_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:241", t_cert_string_length);
        cert_.init(t_dataptr_after_cert_meta, t_cert_string_length);
    }

    const_byteptr const t_dataptr_after_cert = t_dataptr_after_cert_meta + (t_cert__size);
    BINPAC_ASSERT(t_dataptr_after_cert <= t_end_of_data);
    // Parse "anonymous_field_002"
    const_bytestring anonymous_field_002_;
    int t_anonymous_field_002_string_length;
    t_anonymous_field_002_string_length = (t_end_of_data) - (t_dataptr_after_cert);
    int t_anonymous_field_002__size;
    t_anonymous_field_002__size = t_anonymous_field_002_string_length;

    int t_KRB_PA_PK_AS_Rep__size;
    const_byteptr const t_dataptr_after_anonymous_field_002 = t_dataptr_after_cert + (t_anonymous_field_002__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_002 <= t_end_of_data);
    t_KRB_PA_PK_AS_Rep__size = t_dataptr_after_anonymous_field_002 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PA_PK_AS_Rep__size) <= t_end_of_data);
    return t_KRB_PA_PK_AS_Rep__size;
}

KRB_PA_ENCTYPE_INFO::KRB_PA_ENCTYPE_INFO() {
    some_meta1_ = nullptr;
    some_meta2_ = nullptr;
    seq_meta1_ = nullptr;
    etype_ = nullptr;
    optional_seq_meta2_case_index_ = -1;
    seq_meta2_ = nullptr;
    optional_string_meta_case_index_ = -1;
    string_meta_ = nullptr;
    has_string_ = false;
    salt_length_ = 0;
}

KRB_PA_ENCTYPE_INFO::~KRB_PA_ENCTYPE_INFO() {
    delete some_meta1_;
    some_meta1_ = nullptr;
    delete some_meta2_;
    some_meta2_ = nullptr;
    delete seq_meta1_;
    seq_meta1_ = nullptr;
    delete etype_;
    etype_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( optional_seq_meta2_case_index() ) {
        case true:
            // Clean up "seq_meta2"
            {
                delete seq_meta2_;
                seq_meta2_ = nullptr;
            }
            break;
        case false:
            // Clean up "nil1"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( optional_string_meta_case_index() ) {
        case true:
            // Clean up "string_meta"
            {
                delete string_meta_;
                string_meta_ = nullptr;
            }
            break;
        case false:
            // Clean up "nil2"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    salt_.free();
}

int KRB_PA_ENCTYPE_INFO::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "some_meta1"
    some_meta1_ = new ASN1EncodingMeta();
    int t_some_meta1__size;
    t_some_meta1__size = some_meta1_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_some_meta1 = t_begin_of_data + (t_some_meta1__size);
    BINPAC_ASSERT(t_dataptr_after_some_meta1 <= t_end_of_data);
    // Parse "some_meta2"
    some_meta2_ = new ASN1EncodingMeta();
    int t_some_meta2__size;
    t_some_meta2__size = some_meta2_->Parse(t_dataptr_after_some_meta1, t_end_of_data);

    const_byteptr const t_dataptr_after_some_meta2 = t_dataptr_after_some_meta1 + (t_some_meta2__size);
    BINPAC_ASSERT(t_dataptr_after_some_meta2 <= t_end_of_data);
    // Parse "seq_meta1"
    seq_meta1_ = new ASN1EncodingMeta();
    int t_seq_meta1__size;
    t_seq_meta1__size = seq_meta1_->Parse(t_dataptr_after_some_meta2, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta1 = t_dataptr_after_some_meta2 + (t_seq_meta1__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta1 <= t_end_of_data);
    // Parse "etype"
    etype_ = new ASN1Encoding();
    int t_etype__size;
    t_etype__size = etype_->Parse(t_dataptr_after_seq_meta1, t_end_of_data);

    const_byteptr const t_dataptr_after_etype = t_dataptr_after_seq_meta1 + (t_etype__size);
    BINPAC_ASSERT(t_dataptr_after_etype <= t_end_of_data);
    // Parse "optional_seq_meta2"
    int t_optional_seq_meta2__size;
    has_string_ =  ( some_meta2()->length() > 7 ) ;
    optional_seq_meta2_case_index_ = has_string();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( optional_seq_meta2_case_index() ) {
        case true:
            // Parse "seq_meta2"
            {
                seq_meta2_ = new ASN1EncodingMeta();
                int t_seq_meta2__size;
                t_seq_meta2__size = seq_meta2_->Parse(t_dataptr_after_etype, t_end_of_data);
                t_optional_seq_meta2__size = t_seq_meta2__size;
            }
            break;
        case false:
            // Parse "nil1"
            {
                t_optional_seq_meta2__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_PA_ENCTYPE_INFO", (int64)optional_seq_meta2_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_optional_seq_meta2 = t_dataptr_after_etype + (t_optional_seq_meta2__size);
    BINPAC_ASSERT(t_dataptr_after_optional_seq_meta2 <= t_end_of_data);
    // Parse "optional_string_meta"
    int t_optional_string_meta__size;
    optional_string_meta_case_index_ = has_string();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( optional_string_meta_case_index() ) {
        case true:
            // Parse "string_meta"
            {
                string_meta_ = new ASN1EncodingMeta();
                int t_string_meta__size;
                t_string_meta__size = string_meta_->Parse(t_dataptr_after_optional_seq_meta2, t_end_of_data);
                t_optional_string_meta__size = t_string_meta__size;
            }
            break;
        case false:
            // Parse "nil2"
            {
                t_optional_string_meta__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_PA_ENCTYPE_INFO", (int64)optional_string_meta_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_optional_string_meta = t_dataptr_after_optional_seq_meta2 + (t_optional_string_meta__size);
    BINPAC_ASSERT(t_dataptr_after_optional_string_meta <= t_end_of_data);
    // Parse "salt"
    int t_salt__size;
    salt_length_ = has_string() ? string_meta()->length() : 0;
    t_salt__size = salt_length();
    // Checking out-of-bound for "KRB_PA_ENCTYPE_INFO:salt"
    if ( t_dataptr_after_optional_string_meta + (t_salt__size) > t_end_of_data || t_dataptr_after_optional_string_meta + (t_salt__size) < t_dataptr_after_optional_string_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_PA_ENCTYPE_INFO:salt",
        	((t_dataptr_after_optional_string_meta - t_begin_of_data)) + (t_salt__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_optional_string_meta + t_salt__size;
        int t_salt_string_length;
        t_salt_string_length = salt_length();
        // check for negative sizes
        if ( t_salt_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-padata.pac:259", t_salt_string_length);
        salt_.init(t_dataptr_after_optional_string_meta, t_salt_string_length);
    }

    int t_KRB_PA_ENCTYPE_INFO__size;
    const_byteptr const t_dataptr_after_salt = t_dataptr_after_optional_string_meta + (t_salt__size);
    BINPAC_ASSERT(t_dataptr_after_salt <= t_end_of_data);
    t_KRB_PA_ENCTYPE_INFO__size = t_dataptr_after_salt - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PA_ENCTYPE_INFO__size) <= t_end_of_data);
    return t_KRB_PA_ENCTYPE_INFO__size;
}

KRB_PDU_TCP::KRB_PDU_TCP(bool is_orig) {
    size_ = 0;
    pdu_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
}

KRB_PDU_TCP::~KRB_PDU_TCP() {
    delete pdu_;
    pdu_ = nullptr;
}

int KRB_PDU_TCP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context) {
    int t_KRB_PDU_TCP__size;
    // Checking out-of-bound for "KRB_PDU_TCP:size"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_PDU_TCP:size",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "size"
    size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
    t_KRB_PDU_TCP__size = size() + 4;
    // Checking out-of-bound for "KRB_PDU_TCP"
    if ( t_begin_of_data + (t_KRB_PDU_TCP__size) > t_end_of_data || t_begin_of_data + (t_KRB_PDU_TCP__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_PDU_TCP",
        	(0) + (t_KRB_PDU_TCP__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_KRB_PDU_TCP__size;

        // Parse "pdu"
        pdu_ = new KRB_PDU(is_orig());
        int t_pdu__size;
        t_pdu__size = pdu_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PDU_TCP__size) <= t_end_of_data);
    return t_KRB_PDU_TCP__size;
}

KRB_PDU::KRB_PDU(bool is_orig) {
    app_meta_ = nullptr;
    msg_type_case_index_ = -1;
    as_req_ = nullptr;
    as_rep_ = nullptr;
    tgs_req_ = nullptr;
    tgs_rep_ = nullptr;
    ap_req_ = nullptr;
    ap_rep_ = nullptr;
    krb_safe_ = nullptr;
    krb_priv_ = nullptr;
    krb_cred_ = nullptr;
    krb_error_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
}

KRB_PDU::~KRB_PDU() {
    delete app_meta_;
    app_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_type_case_index() ) {
        case ((int)10):
            // Clean up "as_req"
            {
                delete as_req_;
                as_req_ = nullptr;
            }
            break;
        case ((int)11):
            // Clean up "as_rep"
            {
                delete as_rep_;
                as_rep_ = nullptr;
            }
            break;
        case ((int)12):
            // Clean up "tgs_req"
            {
                delete tgs_req_;
                tgs_req_ = nullptr;
            }
            break;
        case ((int)13):
            // Clean up "tgs_rep"
            {
                delete tgs_rep_;
                tgs_rep_ = nullptr;
            }
            break;
        case ((int)14):
            // Clean up "ap_req"
            {
                delete ap_req_;
                ap_req_ = nullptr;
            }
            break;
        case ((int)15):
            // Clean up "ap_rep"
            {
                delete ap_rep_;
                ap_rep_ = nullptr;
            }
            break;
        case ((int)20):
            // Clean up "krb_safe"
            {
                delete krb_safe_;
                krb_safe_ = nullptr;
            }
            break;
        case ((int)21):
            // Clean up "krb_priv"
            {
                delete krb_priv_;
                krb_priv_ = nullptr;
            }
            break;
        case ((int)22):
            // Clean up "krb_cred"
            {
                delete krb_cred_;
                krb_cred_ = nullptr;
            }
            break;
        case ((int)30):
            // Clean up "krb_error"
            {
                delete krb_error_;
                krb_error_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context) {
    // Parse "app_meta"
    app_meta_ = new ASN1EncodingMeta();
    int t_app_meta__size;
    t_app_meta__size = app_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_app_meta = t_begin_of_data + (t_app_meta__size);
    BINPAC_ASSERT(t_dataptr_after_app_meta <= t_end_of_data);
    // Parse "msg_type"
    int t_msg_type__size;
    msg_type_case_index_ =  ( app_meta()->tag() - ASN1_APP_TAG_OFFSET ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_type_case_index() ) {
        case ((int)10):
            // Parse "as_req"
            {
                as_req_ = new KRB_AS_REQ(is_orig());
                int t_as_req__size;
                t_as_req__size = as_req_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context, byteorder());
                t_msg_type__size = t_as_req__size;
            }
            break;
        case ((int)11):
            // Parse "as_rep"
            {
                as_rep_ = new KRB_AS_REP(is_orig());
                int t_as_rep__size;
                t_as_rep__size = as_rep_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context, byteorder());
                t_msg_type__size = t_as_rep__size;
            }
            break;
        case ((int)12):
            // Parse "tgs_req"
            {
                tgs_req_ = new KRB_TGS_REQ(is_orig());
                int t_tgs_req__size;
                t_tgs_req__size = tgs_req_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context, byteorder());
                t_msg_type__size = t_tgs_req__size;
            }
            break;
        case ((int)13):
            // Parse "tgs_rep"
            {
                tgs_rep_ = new KRB_TGS_REP(is_orig());
                int t_tgs_rep__size;
                t_tgs_rep__size = tgs_rep_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context, byteorder());
                t_msg_type__size = t_tgs_rep__size;
            }
            break;
        case ((int)14):
            // Parse "ap_req"
            {
                ap_req_ = new KRB_AP_REQ(is_orig());
                int t_ap_req__size;
                t_ap_req__size = ap_req_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context, byteorder());
                t_msg_type__size = t_ap_req__size;
            }
            break;
        case ((int)15):
            // Parse "ap_rep"
            {
                ap_rep_ = new KRB_AP_REP(is_orig());
                int t_ap_rep__size;
                t_ap_rep__size = ap_rep_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context);
                t_msg_type__size = t_ap_rep__size;
            }
            break;
        case ((int)20):
            // Parse "krb_safe"
            {
                krb_safe_ = new KRB_SAFE_MSG(is_orig());
                int t_krb_safe__size;
                t_krb_safe__size = krb_safe_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context);
                t_msg_type__size = t_krb_safe__size;
            }
            break;
        case ((int)21):
            // Parse "krb_priv"
            {
                krb_priv_ = new KRB_PRIV_MSG(is_orig());
                int t_krb_priv__size;
                t_krb_priv__size = krb_priv_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context);
                t_msg_type__size = t_krb_priv__size;
            }
            break;
        case ((int)22):
            // Parse "krb_cred"
            {
                krb_cred_ = new KRB_CRED_MSG(is_orig());
                int t_krb_cred__size;
                t_krb_cred__size = krb_cred_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context);
                t_msg_type__size = t_krb_cred__size;
            }
            break;
        case ((int)30):
            // Parse "krb_error"
            {
                krb_error_ = new KRB_ERROR_MSG(is_orig());
                int t_krb_error__size;
                t_krb_error__size = krb_error_->Parse(t_dataptr_after_app_meta, t_end_of_data, t_context, byteorder());
                t_msg_type__size = t_krb_error__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_PDU", (int64)msg_type_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_KRB_PDU__size;
    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_app_meta + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    t_KRB_PDU__size = t_dataptr_after_msg_type - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PDU__size) <= t_end_of_data);
    return t_KRB_PDU__size;
}

KRB_AS_REQ::KRB_AS_REQ(bool is_orig) {
    data_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_AS_REQ::~KRB_AS_REQ() {
    delete data_;
    data_ = nullptr;
}

int KRB_AS_REQ::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "data"
    data_ = new KRB_KDC_REQ(is_orig(), AS_REQ);
    int t_data__size;
    t_data__size = data_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);

    int t_KRB_AS_REQ__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_AS_REQ__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_kdc_req_msg(data());
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_AS_REQ__size) <= t_end_of_data);
    return t_KRB_AS_REQ__size;
}

KRB_TGS_REQ::KRB_TGS_REQ(bool is_orig) {
    data_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_TGS_REQ::~KRB_TGS_REQ() {
    delete data_;
    data_ = nullptr;
}

int KRB_TGS_REQ::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "data"
    data_ = new KRB_KDC_REQ(is_orig(), TGS_REQ);
    int t_data__size;
    t_data__size = data_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);

    int t_KRB_TGS_REQ__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_TGS_REQ__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_kdc_req_msg(data());
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_TGS_REQ__size) <= t_end_of_data);
    return t_KRB_TGS_REQ__size;
}

KRB_AS_REP::KRB_AS_REP(bool is_orig) {
    data_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_AS_REP::~KRB_AS_REP() {
    delete data_;
    data_ = nullptr;
}

int KRB_AS_REP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "data"
    data_ = new KRB_KDC_REP(is_orig(), AS_REP);
    int t_data__size;
    t_data__size = data_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);

    int t_KRB_AS_REP__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_AS_REP__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_kdc_rep_msg(data());
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_AS_REP__size) <= t_end_of_data);
    return t_KRB_AS_REP__size;
}

KRB_TGS_REP::KRB_TGS_REP(bool is_orig) {
    data_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_TGS_REP::~KRB_TGS_REP() {
    delete data_;
    data_ = nullptr;
}

int KRB_TGS_REP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "data"
    data_ = new KRB_KDC_REP(is_orig(), TGS_REP);
    int t_data__size;
    t_data__size = data_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);

    int t_KRB_TGS_REP__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_TGS_REP__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_kdc_rep_msg(data());
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_TGS_REP__size) <= t_end_of_data);
    return t_KRB_TGS_REP__size;
}

KRB_KDC_REQ::KRB_KDC_REQ(bool is_orig, uint8 pkt_type) {
    seq_meta_ = nullptr;
    pvno_ = nullptr;
    msg_type_ = nullptr;
    padata_ = nullptr;
    body_meta_ = nullptr;
    body_args_ = nullptr;
    body_args__elem_ = nullptr;
    is_orig_ = is_orig;
    pkt_type_ = pkt_type;
}

KRB_KDC_REQ::~KRB_KDC_REQ() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete pvno_;
    pvno_ = nullptr;
    delete msg_type_;
    msg_type_ = nullptr;
    delete padata_;
    padata_ = nullptr;
    delete body_meta_;
    body_meta_ = nullptr;
    delete body_args__elem_;
    body_args__elem_ = nullptr;
    if ( body_args() ) {
        for ( auto* body_args__elem_ : *body_args() ) {
            delete body_args__elem_;
            body_args__elem_ = nullptr;
        }
    }
    delete body_args_;
}

int KRB_KDC_REQ::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "pvno"
    pvno_ = new SequenceElement(true);
    int t_pvno__size;
    t_pvno__size = pvno_->Parse(t_dataptr_after_seq_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_pvno = t_dataptr_after_seq_meta + (t_pvno__size);
    BINPAC_ASSERT(t_dataptr_after_pvno <= t_end_of_data);
    // Parse "msg_type"
    msg_type_ = new SequenceElement(true);
    int t_msg_type__size;
    t_msg_type__size = msg_type_->Parse(t_dataptr_after_pvno, t_end_of_data);

    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_pvno + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    // Parse "padata"
    padata_ = new KRB_PA_Data_Optional(is_orig(), pkt_type(), 3);
    int t_padata__size;
    t_padata__size = padata_->Parse(t_dataptr_after_msg_type, t_end_of_data, t_context, t_byteorder);

    const_byteptr const t_dataptr_after_padata = t_dataptr_after_msg_type + (t_padata__size);
    BINPAC_ASSERT(t_dataptr_after_padata <= t_end_of_data);
    // Parse "body_meta"
    body_meta_ = new ASN1EncodingMeta();
    int t_body_meta__size;
    t_body_meta__size = body_meta_->Parse(t_dataptr_after_padata, t_end_of_data);

    const_byteptr const t_dataptr_after_body_meta = t_dataptr_after_padata + (t_body_meta__size);
    BINPAC_ASSERT(t_dataptr_after_body_meta <= t_end_of_data);
    // Parse "body_args"
    int t_body_args__arraylength;
    t_body_args__arraylength = 0;
    body_args__elem_ = nullptr;
    int t_body_args__elem__it;
    t_body_args__elem__it = 0;
    int t_body_args__size;
    body_args_ = new vector<KRB_REQ_Arg*>;
    const_byteptr t_body_args__elem__dataptr = t_dataptr_after_body_meta;
    for (; /* forever */; ++t_body_args__elem__it) {
        // Check &until(body_args__elem__dataptr >= end_of_data)
        if ( t_body_args__elem__dataptr >= t_end_of_data ) {
            body_args__elem_ = nullptr;
            goto end_of_body_args;
        }
        body_args__elem_ = new KRB_REQ_Arg();
        int t_body_args__elem__size;
        t_body_args__elem__size = body_args__elem_->Parse(t_body_args__elem__dataptr, t_end_of_data, t_byteorder);
        body_args_->push_back(body_args__elem_);
        t_body_args__elem__dataptr += t_body_args__elem__size;
        BINPAC_ASSERT(t_body_args__elem__dataptr <= t_end_of_data);
        body_args__elem_ = nullptr;
    }
end_of_body_args: ;
    t_body_args__size = t_body_args__elem__dataptr - (t_dataptr_after_body_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_KRB_KDC_REQ__size;
    const_byteptr const t_dataptr_after_body_args = t_dataptr_after_body_meta + (t_body_args__size);
    BINPAC_ASSERT(t_dataptr_after_body_args <= t_end_of_data);
    t_KRB_KDC_REQ__size = t_dataptr_after_body_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_KDC_REQ__size) <= t_end_of_data);
    return t_KRB_KDC_REQ__size;
}

KRB_REQ_Arg::KRB_REQ_Arg() {
    seq_meta_ = nullptr;
    data_ = nullptr;
}

KRB_REQ_Arg::~KRB_REQ_Arg() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete data_;
    data_ = nullptr;
}

int KRB_REQ_Arg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "data"
    data_ = new KRB_REQ_Arg_Data(seq_meta()->index());
    int t_data__size;
    t_data__size = seq_meta()->length();
    // Checking out-of-bound for "KRB_REQ_Arg:data"
    if ( t_dataptr_after_seq_meta + (t_data__size) > t_end_of_data || t_dataptr_after_seq_meta + (t_data__size) < t_dataptr_after_seq_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_REQ_Arg:data",
        	((t_dataptr_after_seq_meta - t_begin_of_data)) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_seq_meta + t_data__size;
        data_->Parse(t_dataptr_after_seq_meta, t_end_of_data, t_byteorder);
    }

    int t_KRB_REQ_Arg__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_seq_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_KRB_REQ_Arg__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_REQ_Arg__size) <= t_end_of_data);
    return t_KRB_REQ_Arg__size;
}

KRB_REQ_Arg_Data::KRB_REQ_Arg_Data(uint8 index) {
    val_case_index_ = -1;
    options_ = nullptr;
    principal_ = nullptr;
    realm_ = nullptr;
    sname_ = nullptr;
    from_ = nullptr;
    till_ = nullptr;
    rtime_ = nullptr;
    nonce_ = nullptr;
    etype_ = nullptr;
    addrs_ = nullptr;
    auth_data_ = nullptr;
    addl_tkts_ = nullptr;
    index_ = index;
}

KRB_REQ_Arg_Data::~KRB_REQ_Arg_Data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Clean up "options"
            {
                delete options_;
                options_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "principal"
            {
                delete principal_;
                principal_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "realm"
            {
                delete realm_;
                realm_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "sname"
            {
                delete sname_;
                sname_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "from"
            {
                delete from_;
                from_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "till"
            {
                delete till_;
                till_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "rtime"
            {
                delete rtime_;
                rtime_ = nullptr;
            }
            break;
        case ((uint8)7):
            // Clean up "nonce"
            {
                delete nonce_;
                nonce_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "etype"
            {
                delete etype_;
                etype_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "addrs"
            {
                delete addrs_;
                addrs_ = nullptr;
            }
            break;
        case ((uint8)10):
            // Clean up "auth_data"
            {
                delete auth_data_;
                auth_data_ = nullptr;
            }
            break;
        case ((uint8)11):
            // Clean up "addl_tkts"
            {
                delete addl_tkts_;
                addl_tkts_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_REQ_Arg_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_val__size;
    val_case_index_ = index();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Parse "options"
            {
                options_ = new KRB_KDC_Options();
                int t_options__size;
                t_options__size = options_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_options__size;
            }
            break;
        case ((uint8)1):
            // Parse "principal"
            {
                principal_ = new KRB_Principal_Name();
                int t_principal__size;
                t_principal__size = principal_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_principal__size;
            }
            break;
        case ((uint8)2):
            // Parse "realm"
            {
                realm_ = new ASN1OctetString();
                int t_realm__size;
                t_realm__size = realm_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_realm__size;
            }
            break;
        case ((uint8)3):
            // Parse "sname"
            {
                sname_ = new KRB_Principal_Name();
                int t_sname__size;
                t_sname__size = sname_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_sname__size;
            }
            break;
        case ((uint8)4):
            // Parse "from"
            {
                from_ = new KRB_Time();
                int t_from__size;
                t_from__size = from_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_from__size;
            }
            break;
        case ((uint8)5):
            // Parse "till"
            {
                till_ = new KRB_Time();
                int t_till__size;
                t_till__size = till_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_till__size;
            }
            break;
        case ((uint8)6):
            // Parse "rtime"
            {
                rtime_ = new KRB_Time();
                int t_rtime__size;
                t_rtime__size = rtime_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_rtime__size;
            }
            break;
        case ((uint8)7):
            // Parse "nonce"
            {
                nonce_ = new ASN1Integer();
                int t_nonce__size;
                t_nonce__size = nonce_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_nonce__size;
            }
            break;
        case ((uint8)8):
            // Parse "etype"
            {
                etype_ = new Array();
                int t_etype__size;
                t_etype__size = etype_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_etype__size;
            }
            break;
        case ((uint8)9):
            // Parse "addrs"
            {
                addrs_ = new KRB_Host_Addresses();
                int t_addrs__size;
                t_addrs__size = addrs_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_addrs__size;
            }
            break;
        case ((uint8)10):
            // Parse "auth_data"
            {
                auth_data_ = new ASN1OctetString();
                int t_auth_data__size;
                t_auth_data__size = auth_data_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_auth_data__size;
            }
            break;
        case ((uint8)11):
            // Parse "addl_tkts"
            {
                addl_tkts_ = new KRB_Ticket_Sequence();
                int t_addl_tkts__size;
                t_addl_tkts__size = addl_tkts_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_addl_tkts__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:80", t_unknown_string_length);
                unknown_.init(t_begin_of_data, t_unknown_string_length);
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

KRB_KDC_Options::KRB_KDC_Options() {
    meta_ = nullptr;
    pad_ = 0;
    flags_ = 0;
    reserved_ = false;
    forwardable_ = false;
    forwarded_ = false;
    proxiable_ = false;
    proxy_ = false;
    allow_postdate_ = false;
    postdated_ = false;
    unused7_ = false;
    renewable_ = false;
    unused9_ = false;
    unused10_ = false;
    opt_hardware_auth_ = false;
    unused12_ = false;
    unused13_ = false;
    unused15_ = false;
    disable_transited_check_ = false;
    renewable_ok_ = false;
    enc_tkt_in_skey_ = false;
    renew_ = false;
    validate_ = false;
}

KRB_KDC_Options::~KRB_KDC_Options() {
    delete meta_;
    meta_ = nullptr;
}

int KRB_KDC_Options::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Checking out-of-bound for "KRB_KDC_Options:flags"
    if ( (t_dataptr_after_meta + 1) + (4) > t_end_of_data || (t_dataptr_after_meta + 1) + (4) < (t_dataptr_after_meta + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_KDC_Options:flags",
        	(((t_dataptr_after_meta + 1) - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "pad"
    pad_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_meta));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_meta + 1))));

    int t_KRB_KDC_Options__size;
    t_KRB_KDC_Options__size = (t_dataptr_after_meta + 5) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    reserved_ =  ( flags() & 0x80000000 )  > 0;
    forwardable_ =  ( flags() & 0x40000000 )  > 0;
    forwarded_ =  ( flags() & 0x20000000 )  > 0;
    proxiable_ =  ( flags() & 0x10000000 )  > 0;
    proxy_ =  ( flags() & 0x8000000 )  > 0;
    allow_postdate_ =  ( flags() & 0x4000000 )  > 0;
    postdated_ =  ( flags() & 0x2000000 )  > 0;
    unused7_ =  ( flags() & 0x1000000 )  > 0;
    renewable_ =  ( flags() & 0x800000 )  > 0;
    unused9_ =  ( flags() & 0x400000 )  > 0;
    unused10_ =  ( flags() & 0x200000 )  > 0;
    opt_hardware_auth_ =  ( flags() & 0x100000 )  > 0;
    unused12_ =  ( flags() & 0x80000 )  > 0;
    unused13_ =  ( flags() & 0x40000 )  > 0;
    unused15_ =  ( flags() & 0x10000 )  > 0;
    disable_transited_check_ =  ( flags() & 0x10 )  > 0;
    renewable_ok_ =  ( flags() & 0x8 )  > 0;
    enc_tkt_in_skey_ =  ( flags() & 0x4 )  > 0;
    renew_ =  ( flags() & 0x2 )  > 0;
    validate_ =  ( flags() & 0x1 )  > 0;
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_KDC_Options__size) <= t_end_of_data);
    return t_KRB_KDC_Options__size;
}

KRB_KDC_REP::KRB_KDC_REP(bool is_orig, uint8 pkt_type) {
    seq_meta_ = nullptr;
    pvno_ = nullptr;
    msg_type_ = nullptr;
    padata_ = nullptr;
    client_realm_ = nullptr;
    cname_meta_ = nullptr;
    client_name_ = nullptr;
    ticket_ = nullptr;
    enc_part_ = nullptr;
    is_orig_ = is_orig;
    pkt_type_ = pkt_type;
}

KRB_KDC_REP::~KRB_KDC_REP() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete pvno_;
    pvno_ = nullptr;
    delete msg_type_;
    msg_type_ = nullptr;
    delete padata_;
    padata_ = nullptr;
    delete client_realm_;
    client_realm_ = nullptr;
    delete cname_meta_;
    cname_meta_ = nullptr;
    delete client_name_;
    client_name_ = nullptr;
    delete ticket_;
    ticket_ = nullptr;
    delete enc_part_;
    enc_part_ = nullptr;
}

int KRB_KDC_REP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "pvno"
    pvno_ = new SequenceElement(true);
    int t_pvno__size;
    t_pvno__size = pvno_->Parse(t_dataptr_after_seq_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_pvno = t_dataptr_after_seq_meta + (t_pvno__size);
    BINPAC_ASSERT(t_dataptr_after_pvno <= t_end_of_data);
    // Parse "msg_type"
    msg_type_ = new SequenceElement(true);
    int t_msg_type__size;
    t_msg_type__size = msg_type_->Parse(t_dataptr_after_pvno, t_end_of_data);

    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_pvno + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    // Parse "padata"
    padata_ = new KRB_PA_Data_Optional(is_orig(), pkt_type(), 2);
    int t_padata__size;
    t_padata__size = padata_->Parse(t_dataptr_after_msg_type, t_end_of_data, t_context, t_byteorder);

    const_byteptr const t_dataptr_after_padata = t_dataptr_after_msg_type + (t_padata__size);
    BINPAC_ASSERT(t_dataptr_after_padata <= t_end_of_data);
    // Parse "client_realm"
    client_realm_ = new ASN1OctetString();
    int t_client_realm__size;
    t_client_realm__size = padata()->next_meta()->length();
    // Checking out-of-bound for "KRB_KDC_REP:client_realm"
    if ( t_dataptr_after_padata + (t_client_realm__size) > t_end_of_data || t_dataptr_after_padata + (t_client_realm__size) < t_dataptr_after_padata ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_KDC_REP:client_realm",
        	((t_dataptr_after_padata - t_begin_of_data)) + (t_client_realm__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_padata + t_client_realm__size;
        client_realm_->Parse(t_dataptr_after_padata, t_end_of_data);
    }

    const_byteptr const t_dataptr_after_client_realm = t_dataptr_after_padata + (t_client_realm__size);
    BINPAC_ASSERT(t_dataptr_after_client_realm <= t_end_of_data);
    // Parse "cname_meta"
    cname_meta_ = new ASN1EncodingMeta();
    int t_cname_meta__size;
    t_cname_meta__size = cname_meta_->Parse(t_dataptr_after_client_realm, t_end_of_data);

    const_byteptr const t_dataptr_after_cname_meta = t_dataptr_after_client_realm + (t_cname_meta__size);
    BINPAC_ASSERT(t_dataptr_after_cname_meta <= t_end_of_data);
    // Parse "client_name"
    client_name_ = new KRB_Principal_Name();
    int t_client_name__size;
    t_client_name__size = cname_meta()->length();
    // Checking out-of-bound for "KRB_KDC_REP:client_name"
    if ( t_dataptr_after_cname_meta + (t_client_name__size) > t_end_of_data || t_dataptr_after_cname_meta + (t_client_name__size) < t_dataptr_after_cname_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_KDC_REP:client_name",
        	((t_dataptr_after_cname_meta - t_begin_of_data)) + (t_client_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_cname_meta + t_client_name__size;
        client_name_->Parse(t_dataptr_after_cname_meta, t_end_of_data);
    }

    const_byteptr const t_dataptr_after_client_name = t_dataptr_after_cname_meta + (t_client_name__size);
    BINPAC_ASSERT(t_dataptr_after_client_name <= t_end_of_data);
    // Parse "ticket"
    ticket_ = new KRB_Ticket(true);
    int t_ticket__size;
    t_ticket__size = ticket_->Parse(t_dataptr_after_client_name, t_end_of_data);

    const_byteptr const t_dataptr_after_ticket = t_dataptr_after_client_name + (t_ticket__size);
    BINPAC_ASSERT(t_dataptr_after_ticket <= t_end_of_data);
    // Parse "enc_part"
    enc_part_ = new KRB_Encrypted_Data_in_Seq();
    int t_enc_part__size;
    t_enc_part__size = enc_part_->Parse(t_dataptr_after_ticket, t_end_of_data);

    int t_KRB_KDC_REP__size;
    const_byteptr const t_dataptr_after_enc_part = t_dataptr_after_ticket + (t_enc_part__size);
    BINPAC_ASSERT(t_dataptr_after_enc_part <= t_end_of_data);
    t_KRB_KDC_REP__size = t_dataptr_after_enc_part - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_KDC_REP__size) <= t_end_of_data);
    return t_KRB_KDC_REP__size;
}

KRB_AP_REQ::KRB_AP_REQ(bool is_orig) {
    seq_meta_ = nullptr;
    pvno_ = nullptr;
    msg_type_ = nullptr;
    ap_options_ = nullptr;
    ticket_ = nullptr;
    enc_part_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_AP_REQ::~KRB_AP_REQ() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete pvno_;
    pvno_ = nullptr;
    delete msg_type_;
    msg_type_ = nullptr;
    delete ap_options_;
    ap_options_ = nullptr;
    delete ticket_;
    ticket_ = nullptr;
    delete enc_part_;
    enc_part_ = nullptr;
}

int KRB_AP_REQ::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "pvno"
    pvno_ = new SequenceElement(true);
    int t_pvno__size;
    t_pvno__size = pvno_->Parse(t_dataptr_after_seq_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_pvno = t_dataptr_after_seq_meta + (t_pvno__size);
    BINPAC_ASSERT(t_dataptr_after_pvno <= t_end_of_data);
    // Parse "msg_type"
    msg_type_ = new SequenceElement(true);
    int t_msg_type__size;
    t_msg_type__size = msg_type_->Parse(t_dataptr_after_pvno, t_end_of_data);

    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_pvno + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    // Parse "ap_options"
    ap_options_ = new KRB_AP_Options();
    int t_ap_options__size;
    t_ap_options__size = ap_options_->Parse(t_dataptr_after_msg_type, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_ap_options = t_dataptr_after_msg_type + (t_ap_options__size);
    BINPAC_ASSERT(t_dataptr_after_ap_options <= t_end_of_data);
    // Parse "ticket"
    ticket_ = new KRB_Ticket(true);
    int t_ticket__size;
    t_ticket__size = ticket_->Parse(t_dataptr_after_ap_options, t_end_of_data);

    const_byteptr const t_dataptr_after_ticket = t_dataptr_after_ap_options + (t_ticket__size);
    BINPAC_ASSERT(t_dataptr_after_ticket <= t_end_of_data);
    // Parse "enc_part"
    enc_part_ = new KRB_Encrypted_Data_in_Seq();
    int t_enc_part__size;
    t_enc_part__size = enc_part_->Parse(t_dataptr_after_ticket, t_end_of_data);

    int t_KRB_AP_REQ__size;
    const_byteptr const t_dataptr_after_enc_part = t_dataptr_after_ticket + (t_enc_part__size);
    BINPAC_ASSERT(t_dataptr_after_enc_part <= t_end_of_data);
    t_KRB_AP_REQ__size = t_dataptr_after_enc_part - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_ap_req_msg(this);
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_AP_REQ__size) <= t_end_of_data);
    return t_KRB_AP_REQ__size;
}

KRB_AP_Options::KRB_AP_Options() {
    meta_ = nullptr;
    flags_ = 0;
    reserved_ = false;
    use_session_key_ = false;
    mutual_required_ = false;
}

KRB_AP_Options::~KRB_AP_Options() {
    delete meta_;
    meta_ = nullptr;
}

int KRB_AP_Options::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "meta"
    meta_ = new SequenceElement(false);
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);


    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Checking out-of-bound for "KRB_AP_Options:flags"
    if ( (t_dataptr_after_meta + 1) + (4) > t_end_of_data || (t_dataptr_after_meta + 1) + (4) < (t_dataptr_after_meta + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_AP_Options:flags",
        	(((t_dataptr_after_meta + 1) - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_meta + 1))));

    int t_KRB_AP_Options__size;
    t_KRB_AP_Options__size = (t_dataptr_after_meta + 5) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    reserved_ =  ( flags() & 0x80000000 )  > 0;
    use_session_key_ =  ( flags() & 0x40000000 )  > 0;
    mutual_required_ =  ( flags() & 0x20000000 )  > 0;
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_AP_Options__size) <= t_end_of_data);
    return t_KRB_AP_Options__size;
}

KRB_AP_REP::KRB_AP_REP(bool is_orig) {
    pvno_ = nullptr;
    msg_type_ = nullptr;
    enc_part_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_AP_REP::~KRB_AP_REP() {
    delete pvno_;
    pvno_ = nullptr;
    delete msg_type_;
    msg_type_ = nullptr;
    delete enc_part_;
    enc_part_ = nullptr;
}

int KRB_AP_REP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context) {
    // Parse "pvno"
    pvno_ = new SequenceElement(true);
    int t_pvno__size;
    t_pvno__size = pvno_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_pvno = t_begin_of_data + (t_pvno__size);
    BINPAC_ASSERT(t_dataptr_after_pvno <= t_end_of_data);
    // Parse "msg_type"
    msg_type_ = new SequenceElement(true);
    int t_msg_type__size;
    t_msg_type__size = msg_type_->Parse(t_dataptr_after_pvno, t_end_of_data);

    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_pvno + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    // Parse "enc_part"
    enc_part_ = new KRB_Encrypted_Data_in_Seq();
    int t_enc_part__size;
    t_enc_part__size = enc_part_->Parse(t_dataptr_after_msg_type, t_end_of_data);

    int t_KRB_AP_REP__size;
    const_byteptr const t_dataptr_after_enc_part = t_dataptr_after_msg_type + (t_enc_part__size);
    BINPAC_ASSERT(t_dataptr_after_enc_part <= t_end_of_data);
    t_KRB_AP_REP__size = t_dataptr_after_enc_part - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_ap_rep_msg(this);
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_AP_REP__size) <= t_end_of_data);
    return t_KRB_AP_REP__size;
}

KRB_ERROR_MSG::KRB_ERROR_MSG(bool is_orig) {
    seq_meta_ = nullptr;
    args1_ = nullptr;
    args1__elem_ = nullptr;
    error_code_ = nullptr;
    args2_ = nullptr;
    args2__elem_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_ERROR_MSG::~KRB_ERROR_MSG() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete args1__elem_;
    args1__elem_ = nullptr;
    if ( args1() ) {
        for ( auto* args1__elem_ : *args1() ) {
            delete args1__elem_;
            args1__elem_ = nullptr;
        }
    }
    delete args1_;
    delete error_code_;
    error_code_ = nullptr;
    delete args2__elem_;
    args2__elem_ = nullptr;
    if ( args2() ) {
        for ( auto* args2__elem_ : *args2() ) {
            delete args2__elem_;
            args2__elem_ = nullptr;
        }
    }
    delete args2_;
}

int KRB_ERROR_MSG::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args1"
    int t_args1__arraylength;
    t_args1__arraylength = 0;
    args1__elem_ = nullptr;
    int t_args1__elem__it;
    t_args1__elem__it = 0;
    int t_args1__size;
    args1_ = new vector<KRB_ERROR_Arg*>;
    const_byteptr t_args1__elem__dataptr = t_dataptr_after_seq_meta;
    for (; /* forever */; ++t_args1__elem__it) {
        // Check &until(args1__elem__dataptr >= end_of_data)
        if ( t_args1__elem__dataptr >= t_end_of_data ) {
            args1__elem_ = nullptr;
            goto end_of_args1;
        }
        args1__elem_ = new KRB_ERROR_Arg(is_orig(), 0);
        int t_args1__elem__size;
        t_args1__elem__size = args1__elem_->Parse(t_args1__elem__dataptr, t_end_of_data, t_context, t_byteorder);
        args1_->push_back(args1__elem_);
        t_args1__elem__dataptr += t_args1__elem__size;
        BINPAC_ASSERT(t_args1__elem__dataptr <= t_end_of_data);
        // Check &until( ( @$element->process_in_parent@ ) )
        if (  ( args1__elem_->process_in_parent() )  ) {
            args1__elem_ = nullptr;
            goto end_of_args1;
        }
        args1__elem_ = nullptr;
    }
end_of_args1: ;
    t_args1__size = t_args1__elem__dataptr - (t_dataptr_after_seq_meta);
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_args1 = t_dataptr_after_seq_meta + (t_args1__size);
    BINPAC_ASSERT(t_dataptr_after_args1 <= t_end_of_data);
    // Parse "error_code"
    error_code_ = new ASN1Integer();
    int t_error_code__size;
    t_error_code__size = error_code_->Parse(t_dataptr_after_args1, t_end_of_data);

    const_byteptr const t_dataptr_after_error_code = t_dataptr_after_args1 + (t_error_code__size);
    BINPAC_ASSERT(t_dataptr_after_error_code <= t_end_of_data);
    // Parse "args2"
    int t_args2__arraylength;
    t_args2__arraylength = 0;
    args2__elem_ = nullptr;
    int t_args2__elem__it;
    t_args2__elem__it = 0;
    int t_args2__size;
    args2_ = new vector<KRB_ERROR_Arg*>;
    const_byteptr t_args2__elem__dataptr = t_dataptr_after_error_code;
    for (; /* forever */; ++t_args2__elem__it) {
        // Check &until(args2__elem__dataptr >= end_of_data)
        if ( t_args2__elem__dataptr >= t_end_of_data ) {
            args2__elem_ = nullptr;
            goto end_of_args2;
        }
        args2__elem_ = new KRB_ERROR_Arg(is_orig(), binary_to_int64(error_code()->encoding()->content()));
        int t_args2__elem__size;
        t_args2__elem__size = args2__elem_->Parse(t_args2__elem__dataptr, t_end_of_data, t_context, t_byteorder);
        args2_->push_back(args2__elem_);
        t_args2__elem__dataptr += t_args2__elem__size;
        BINPAC_ASSERT(t_args2__elem__dataptr <= t_end_of_data);
        args2__elem_ = nullptr;
    }
end_of_args2: ;
    t_args2__size = t_args2__elem__dataptr - (t_dataptr_after_error_code);
    // Evaluate 'let' and 'withinput' fields

    int t_KRB_ERROR_MSG__size;
    const_byteptr const t_dataptr_after_args2 = t_dataptr_after_error_code + (t_args2__size);
    BINPAC_ASSERT(t_dataptr_after_args2 <= t_end_of_data);
    t_KRB_ERROR_MSG__size = t_dataptr_after_args2 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_error_msg(this);
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_ERROR_MSG__size) <= t_end_of_data);
    return t_KRB_ERROR_MSG__size;
}

KRB_ERROR_Arg::KRB_ERROR_Arg(bool is_orig, int64 error_code) {
    seq_meta_ = nullptr;
    args_ = nullptr;
    is_orig_ = is_orig;
    error_code_ = error_code;
    process_in_parent_ = false;
    arg_length_ = 0;
}

KRB_ERROR_Arg::~KRB_ERROR_Arg() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete args_;
    args_ = nullptr;
}

int KRB_ERROR_Arg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args"
    args_ = new KRB_ERROR_Arg_Data(is_orig(), seq_meta()->index(), error_code());
    int t_args__size;
    process_in_parent_ = seq_meta()->index() == 6;
    arg_length_ =  ( process_in_parent() ? 0 : seq_meta()->length() ) ;
    t_args__size = arg_length();
    // Checking out-of-bound for "KRB_ERROR_Arg:args"
    if ( t_dataptr_after_seq_meta + (t_args__size) > t_end_of_data || t_dataptr_after_seq_meta + (t_args__size) < t_dataptr_after_seq_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_ERROR_Arg:args",
        	((t_dataptr_after_seq_meta - t_begin_of_data)) + (t_args__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_seq_meta + t_args__size;
        args_->Parse(t_dataptr_after_seq_meta, t_end_of_data, t_context, t_byteorder);
    }

    int t_KRB_ERROR_Arg__size;
    const_byteptr const t_dataptr_after_args = t_dataptr_after_seq_meta + (t_args__size);
    BINPAC_ASSERT(t_dataptr_after_args <= t_end_of_data);
    t_KRB_ERROR_Arg__size = t_dataptr_after_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_ERROR_Arg__size) <= t_end_of_data);
    return t_KRB_ERROR_Arg__size;
}

KRB_ERROR_Arg_Data::KRB_ERROR_Arg_Data(bool is_orig, uint8 index, int64 error_code) {
    val_case_index_ = -1;
    pvno_ = nullptr;
    msg_type_ = nullptr;
    ctime_ = nullptr;
    cusec_ = nullptr;
    stime_ = nullptr;
    susec_ = nullptr;
    crealm_ = nullptr;
    cname_ = nullptr;
    realm_ = nullptr;
    sname_ = nullptr;
    e_text_ = nullptr;
    e_data_ = nullptr;
    is_orig_ = is_orig;
    index_ = index;
    error_code_ = error_code;
}

KRB_ERROR_Arg_Data::~KRB_ERROR_Arg_Data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Clean up "pvno"
            {
                delete pvno_;
                pvno_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "msg_type"
            {
                delete msg_type_;
                msg_type_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "ctime"
            {
                delete ctime_;
                ctime_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "cusec"
            {
                delete cusec_;
                cusec_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "stime"
            {
                delete stime_;
                stime_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "susec"
            {
                delete susec_;
                susec_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "err_code"
            {
            }
            break;
        case ((uint8)7):
            // Clean up "crealm"
            {
                delete crealm_;
                crealm_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "cname"
            {
                delete cname_;
                cname_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "realm"
            {
                delete realm_;
                realm_ = nullptr;
            }
            break;
        case ((uint8)10):
            // Clean up "sname"
            {
                delete sname_;
                sname_ = nullptr;
            }
            break;
        case ((uint8)11):
            // Clean up "e_text"
            {
                delete e_text_;
                e_text_ = nullptr;
            }
            break;
        case ((uint8)12):
            // Clean up "e_data"
            {
                delete e_data_;
                e_data_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_ERROR_Arg_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = index();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Parse "pvno"
            {
                pvno_ = new ASN1Integer();
                int t_pvno__size;
                t_pvno__size = pvno_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_pvno__size;
            }
            break;
        case ((uint8)1):
            // Parse "msg_type"
            {
                msg_type_ = new ASN1Integer();
                int t_msg_type__size;
                t_msg_type__size = msg_type_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_msg_type__size;
            }
            break;
        case ((uint8)2):
            // Parse "ctime"
            {
                ctime_ = new KRB_Time();
                int t_ctime__size;
                t_ctime__size = ctime_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_ctime__size;
            }
            break;
        case ((uint8)3):
            // Parse "cusec"
            {
                cusec_ = new ASN1Integer();
                int t_cusec__size;
                t_cusec__size = cusec_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_cusec__size;
            }
            break;
        case ((uint8)4):
            // Parse "stime"
            {
                stime_ = new KRB_Time();
                int t_stime__size;
                t_stime__size = stime_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_stime__size;
            }
            break;
        case ((uint8)5):
            // Parse "susec"
            {
                susec_ = new ASN1Integer();
                int t_susec__size;
                t_susec__size = susec_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_susec__size;
            }
            break;
        case ((uint8)6):
            // Parse "err_code"
            {
                t_val__size = 0;
            }
            break;
        case ((uint8)7):
            // Parse "crealm"
            {
                crealm_ = new ASN1OctetString();
                int t_crealm__size;
                t_crealm__size = crealm_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_crealm__size;
            }
            break;
        case ((uint8)8):
            // Parse "cname"
            {
                cname_ = new KRB_Principal_Name();
                int t_cname__size;
                t_cname__size = cname_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_cname__size;
            }
            break;
        case ((uint8)9):
            // Parse "realm"
            {
                realm_ = new ASN1OctetString();
                int t_realm__size;
                t_realm__size = realm_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_realm__size;
            }
            break;
        case ((uint8)10):
            // Parse "sname"
            {
                sname_ = new KRB_Principal_Name();
                int t_sname__size;
                t_sname__size = sname_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_sname__size;
            }
            break;
        case ((uint8)11):
            // Parse "e_text"
            {
                e_text_ = new ASN1OctetString();
                int t_e_text__size;
                t_e_text__size = e_text_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_e_text__size;
            }
            break;
        case ((uint8)12):
            // Parse "e_data"
            {
                e_data_ = new KRB_ERROR_E_Data(is_orig(), error_code());
                int t_e_data__size;
                t_e_data__size = e_data_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_e_data__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_ERROR_Arg_Data", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

KRB_ERROR_E_Data::KRB_ERROR_E_Data(bool is_orig, uint64 error_code) {
    val_case_index_ = -1;
    padata_ = nullptr;
    is_orig_ = is_orig;
    error_code_ = error_code;
}

KRB_ERROR_E_Data::~KRB_ERROR_E_Data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Clean up "padata"
            {
                delete padata_;
                padata_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_ERROR_E_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ =  ( error_code() == KDC_ERR_PREAUTH_REQUIRED ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Parse "padata"
            {
                padata_ = new KRB_PA_Data_Sequence(is_orig(), KRB_ERROR);
                int t_padata__size;
                t_padata__size = padata_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_padata__size;
            }
            break;
        case ((int)0):
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/krb/krb-protocol.pac:191", t_unknown_string_length);
                unknown_.init(t_begin_of_data, t_unknown_string_length);
                t_val__size = t_unknown__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_ERROR_E_Data", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

KRB_SAFE_MSG::KRB_SAFE_MSG(bool is_orig) {
    pvno_ = nullptr;
    msg_type_ = nullptr;
    safe_body_ = nullptr;
    checksum_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_SAFE_MSG::~KRB_SAFE_MSG() {
    delete pvno_;
    pvno_ = nullptr;
    delete msg_type_;
    msg_type_ = nullptr;
    delete safe_body_;
    safe_body_ = nullptr;
    delete checksum_;
    checksum_ = nullptr;
}

int KRB_SAFE_MSG::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context) {
    // Parse "pvno"
    pvno_ = new SequenceElement(true);
    int t_pvno__size;
    t_pvno__size = pvno_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_pvno = t_begin_of_data + (t_pvno__size);
    BINPAC_ASSERT(t_dataptr_after_pvno <= t_end_of_data);
    // Parse "msg_type"
    msg_type_ = new SequenceElement(true);
    int t_msg_type__size;
    t_msg_type__size = msg_type_->Parse(t_dataptr_after_pvno, t_end_of_data);

    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_pvno + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    // Parse "safe_body"
    safe_body_ = new KRB_SAFE_Body();
    int t_safe_body__size;
    t_safe_body__size = safe_body_->Parse(t_dataptr_after_msg_type, t_end_of_data);

    const_byteptr const t_dataptr_after_safe_body = t_dataptr_after_msg_type + (t_safe_body__size);
    BINPAC_ASSERT(t_dataptr_after_safe_body <= t_end_of_data);
    // Parse "checksum"
    checksum_ = new KRB_Checksum();
    int t_checksum__size;
    t_checksum__size = checksum_->Parse(t_dataptr_after_safe_body, t_end_of_data);

    int t_KRB_SAFE_MSG__size;
    const_byteptr const t_dataptr_after_checksum = t_dataptr_after_safe_body + (t_checksum__size);
    BINPAC_ASSERT(t_dataptr_after_checksum <= t_end_of_data);
    t_KRB_SAFE_MSG__size = t_dataptr_after_checksum - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_safe_msg(this);
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_SAFE_MSG__size) <= t_end_of_data);
    return t_KRB_SAFE_MSG__size;
}

KRB_SAFE_Body::KRB_SAFE_Body() {
    seq_meta_ = nullptr;
    args_ = nullptr;
    args__elem_ = nullptr;
}

KRB_SAFE_Body::~KRB_SAFE_Body() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete args__elem_;
    args__elem_ = nullptr;
    if ( args() ) {
        for ( auto* args__elem_ : *args() ) {
            delete args__elem_;
            args__elem_ = nullptr;
        }
    }
    delete args_;
}

int KRB_SAFE_Body::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args"
    int t_args__arraylength;
    t_args__arraylength = 0;
    args__elem_ = nullptr;
    int t_args__elem__it;
    t_args__elem__it = 0;
    int t_args__size;
    args_ = new vector<KRB_SAFE_Arg*>;
    const_byteptr t_args__elem__dataptr = t_dataptr_after_seq_meta;
    for (; /* forever */; ++t_args__elem__it) {
        // Check &until(args__elem__dataptr >= end_of_data)
        if ( t_args__elem__dataptr >= t_end_of_data ) {
            args__elem_ = nullptr;
            goto end_of_args;
        }
        args__elem_ = new KRB_SAFE_Arg();
        int t_args__elem__size;
        t_args__elem__size = args__elem_->Parse(t_args__elem__dataptr, t_end_of_data);
        args_->push_back(args__elem_);
        t_args__elem__dataptr += t_args__elem__size;
        BINPAC_ASSERT(t_args__elem__dataptr <= t_end_of_data);
        args__elem_ = nullptr;
    }
end_of_args: ;
    t_args__size = t_args__elem__dataptr - (t_dataptr_after_seq_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_KRB_SAFE_Body__size;
    const_byteptr const t_dataptr_after_args = t_dataptr_after_seq_meta + (t_args__size);
    BINPAC_ASSERT(t_dataptr_after_args <= t_end_of_data);
    t_KRB_SAFE_Body__size = t_dataptr_after_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_SAFE_Body__size) <= t_end_of_data);
    return t_KRB_SAFE_Body__size;
}

KRB_SAFE_Arg::KRB_SAFE_Arg() {
    seq_meta_ = nullptr;
    args_ = nullptr;
}

KRB_SAFE_Arg::~KRB_SAFE_Arg() {
    delete seq_meta_;
    seq_meta_ = nullptr;
    delete args_;
    args_ = nullptr;
}

int KRB_SAFE_Arg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "seq_meta"
    seq_meta_ = new ASN1EncodingMeta();
    int t_seq_meta__size;
    t_seq_meta__size = seq_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_seq_meta = t_begin_of_data + (t_seq_meta__size);
    BINPAC_ASSERT(t_dataptr_after_seq_meta <= t_end_of_data);
    // Parse "args"
    args_ = new KRB_SAFE_Arg_Data(seq_meta()->index());
    int t_args__size;
    t_args__size = seq_meta()->length();
    // Checking out-of-bound for "KRB_SAFE_Arg:args"
    if ( t_dataptr_after_seq_meta + (t_args__size) > t_end_of_data || t_dataptr_after_seq_meta + (t_args__size) < t_dataptr_after_seq_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KRB_SAFE_Arg:args",
        	((t_dataptr_after_seq_meta - t_begin_of_data)) + (t_args__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_seq_meta + t_args__size;
        args_->Parse(t_dataptr_after_seq_meta, t_end_of_data);
    }

    int t_KRB_SAFE_Arg__size;
    const_byteptr const t_dataptr_after_args = t_dataptr_after_seq_meta + (t_args__size);
    BINPAC_ASSERT(t_dataptr_after_args <= t_end_of_data);
    t_KRB_SAFE_Arg__size = t_dataptr_after_args - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_SAFE_Arg__size) <= t_end_of_data);
    return t_KRB_SAFE_Arg__size;
}

KRB_SAFE_Arg_Data::KRB_SAFE_Arg_Data(uint8 index) {
    val_case_index_ = -1;
    user_data_ = nullptr;
    timestamp_ = nullptr;
    usec_ = nullptr;
    seq_number_ = nullptr;
    sender_addr_ = nullptr;
    recp_addr_ = nullptr;
    index_ = index;
}

KRB_SAFE_Arg_Data::~KRB_SAFE_Arg_Data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Clean up "user_data"
            {
                delete user_data_;
                user_data_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "timestamp"
            {
                delete timestamp_;
                timestamp_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "usec"
            {
                delete usec_;
                usec_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "seq_number"
            {
                delete seq_number_;
                seq_number_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "sender_addr"
            {
                delete sender_addr_;
                sender_addr_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "recp_addr"
            {
                delete recp_addr_;
                recp_addr_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KRB_SAFE_Arg_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = index();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Parse "user_data"
            {
                user_data_ = new ASN1OctetString();
                int t_user_data__size;
                t_user_data__size = user_data_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_user_data__size;
            }
            break;
        case ((uint8)1):
            // Parse "timestamp"
            {
                timestamp_ = new KRB_Time();
                int t_timestamp__size;
                t_timestamp__size = timestamp_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_timestamp__size;
            }
            break;
        case ((uint8)2):
            // Parse "usec"
            {
                usec_ = new ASN1Integer();
                int t_usec__size;
                t_usec__size = usec_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_usec__size;
            }
            break;
        case ((uint8)3):
            // Parse "seq_number"
            {
                seq_number_ = new ASN1Integer();
                int t_seq_number__size;
                t_seq_number__size = seq_number_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_seq_number__size;
            }
            break;
        case ((uint8)4):
            // Parse "sender_addr"
            {
                sender_addr_ = new KRB_Host_Address();
                int t_sender_addr__size;
                t_sender_addr__size = sender_addr_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_sender_addr__size;
            }
            break;
        case ((uint8)5):
            // Parse "recp_addr"
            {
                recp_addr_ = new KRB_Host_Address();
                int t_recp_addr__size;
                t_recp_addr__size = recp_addr_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_recp_addr__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("KRB_SAFE_Arg_Data", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

KRB_PRIV_MSG::KRB_PRIV_MSG(bool is_orig) {
    pvno_ = nullptr;
    msg_type_ = nullptr;
    enc_part_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_PRIV_MSG::~KRB_PRIV_MSG() {
    delete pvno_;
    pvno_ = nullptr;
    delete msg_type_;
    msg_type_ = nullptr;
    delete enc_part_;
    enc_part_ = nullptr;
}

int KRB_PRIV_MSG::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context) {
    // Parse "pvno"
    pvno_ = new SequenceElement(true);
    int t_pvno__size;
    t_pvno__size = pvno_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_pvno = t_begin_of_data + (t_pvno__size);
    BINPAC_ASSERT(t_dataptr_after_pvno <= t_end_of_data);
    // Parse "msg_type"
    msg_type_ = new SequenceElement(true);
    int t_msg_type__size;
    t_msg_type__size = msg_type_->Parse(t_dataptr_after_pvno, t_end_of_data);

    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_pvno + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    // Parse "enc_part"
    enc_part_ = new KRB_Encrypted_Data_in_Seq();
    int t_enc_part__size;
    t_enc_part__size = enc_part_->Parse(t_dataptr_after_msg_type, t_end_of_data);

    int t_KRB_PRIV_MSG__size;
    const_byteptr const t_dataptr_after_enc_part = t_dataptr_after_msg_type + (t_enc_part__size);
    BINPAC_ASSERT(t_dataptr_after_enc_part <= t_end_of_data);
    t_KRB_PRIV_MSG__size = t_dataptr_after_enc_part - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_priv_msg(this);
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_PRIV_MSG__size) <= t_end_of_data);
    return t_KRB_PRIV_MSG__size;
}

KRB_CRED_MSG::KRB_CRED_MSG(bool is_orig) {
    pvno_ = nullptr;
    msg_type_ = nullptr;
    tkts_meta_ = nullptr;
    tickets_ = nullptr;
    enc_part_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

KRB_CRED_MSG::~KRB_CRED_MSG() {
    delete pvno_;
    pvno_ = nullptr;
    delete msg_type_;
    msg_type_ = nullptr;
    delete tkts_meta_;
    tkts_meta_ = nullptr;
    delete tickets_;
    tickets_ = nullptr;
    delete enc_part_;
    enc_part_ = nullptr;
}

int KRB_CRED_MSG::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextKRB* t_context) {
    // Parse "pvno"
    pvno_ = new SequenceElement(true);
    int t_pvno__size;
    t_pvno__size = pvno_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_pvno = t_begin_of_data + (t_pvno__size);
    BINPAC_ASSERT(t_dataptr_after_pvno <= t_end_of_data);
    // Parse "msg_type"
    msg_type_ = new SequenceElement(true);
    int t_msg_type__size;
    t_msg_type__size = msg_type_->Parse(t_dataptr_after_pvno, t_end_of_data);

    const_byteptr const t_dataptr_after_msg_type = t_dataptr_after_pvno + (t_msg_type__size);
    BINPAC_ASSERT(t_dataptr_after_msg_type <= t_end_of_data);
    // Parse "tkts_meta"
    tkts_meta_ = new SequenceElement(false);
    int t_tkts_meta__size;
    t_tkts_meta__size = tkts_meta_->Parse(t_dataptr_after_msg_type, t_end_of_data);

    const_byteptr const t_dataptr_after_tkts_meta = t_dataptr_after_msg_type + (t_tkts_meta__size);
    BINPAC_ASSERT(t_dataptr_after_tkts_meta <= t_end_of_data);
    // Parse "tickets"
    tickets_ = new KRB_Ticket_Sequence();
    int t_tickets__size;
    t_tickets__size = tickets_->Parse(t_dataptr_after_tkts_meta, t_end_of_data);

    const_byteptr const t_dataptr_after_tickets = t_dataptr_after_tkts_meta + (t_tickets__size);
    BINPAC_ASSERT(t_dataptr_after_tickets <= t_end_of_data);
    // Parse "enc_part"
    enc_part_ = new KRB_Encrypted_Data_in_Seq();
    int t_enc_part__size;
    t_enc_part__size = enc_part_->Parse(t_dataptr_after_tickets, t_end_of_data);

    int t_KRB_CRED_MSG__size;
    const_byteptr const t_dataptr_after_enc_part = t_dataptr_after_tickets + (t_enc_part__size);
    BINPAC_ASSERT(t_dataptr_after_enc_part <= t_end_of_data);
    t_KRB_CRED_MSG__size = t_dataptr_after_enc_part - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_krb_cred_msg(this);
    BINPAC_ASSERT(t_begin_of_data + (t_KRB_CRED_MSG__size) <= t_end_of_data);
    return t_KRB_CRED_MSG__size;
}

KRB_Flow::KRB_Flow(KRB_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

KRB_Flow::~KRB_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void KRB_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new KRB_PDU(is_orig());
        context_ = new ContextKRB(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e;
    }
}

void KRB_Flow::NewGap(int gap_length) {
}
void KRB_Flow::FlowEOF() {
}

zeek::RecordValPtr proc_krb_kdc_options(const KRB_KDC_Options* opts)
{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::KDC_Options);

	rv->Assign(0, opts->forwardable());
	rv->Assign(1, opts->forwarded());
	rv->Assign(2, opts->proxiable());
	rv->Assign(3, opts->proxy());
	rv->Assign(4, opts->allow_postdate());
	rv->Assign(5, opts->postdated());
	rv->Assign(6, opts->renewable());
	rv->Assign(7, opts->opt_hardware_auth());
	rv->Assign(8, opts->disable_transited_check());
	rv->Assign(9, opts->renewable_ok());
	rv->Assign(10, opts->enc_tkt_in_skey());
	rv->Assign(11, opts->renew());
	rv->Assign(12, opts->validate());

	return rv;
}

zeek::RecordValPtr proc_krb_kdc_req_arguments(KRB_KDC_REQ* msg, const ZeekAnalyzer zeek_analyzer)
{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::KRB::KDC_Request);

	rv->Assign(0, asn1_integer_to_val(msg->pvno()->data(), zeek::TYPE_COUNT));
	rv->Assign(1, asn1_integer_to_val(msg->msg_type()->data(), zeek::TYPE_COUNT));

	if ( msg->padata()->has_padata() )
		rv->Assign(2, proc_padata(msg->padata()->padata()->padata(), zeek_analyzer, false));

	for ( KRB_REQ_Arg* element : *(msg->body_args()) )
		{
		switch ( element->seq_meta()->index() )
			{
			case 0:
				rv->Assign(3, proc_krb_kdc_options(element->data()->options()));
				break;
			case 1:
				rv->Assign(4, GetStringFromPrincipalName(element->data()->principal()));
				break;
			case 2:
				rv->Assign(5, to_stringval(element->data()->realm()->encoding()->content()));
				break;
			case 3:
				rv->Assign(6, GetStringFromPrincipalName(element->data()->sname()));
				break;
			case 4:
				rv->Assign(7, GetTimeFromAsn1(element->data()->from(), 0));
				break;
			case 5:
				rv->Assign(8, GetTimeFromAsn1(element->data()->till(), 0));
				break;
			case 6:
				rv->Assign(9, GetTimeFromAsn1(element->data()->rtime(), 0));
				break;
			case 7:
				rv->Assign(10, asn1_integer_to_val(element->data()->nonce(), zeek::TYPE_COUNT));
				break;
			case 8:
				if ( element->data()->etype()->data()->size() )
					rv->Assign(11, proc_cipher_list(element->data()->etype()));

				break;
			case 9:
				if ( element->data()->addrs()->addresses()->size() )
					rv->Assign(12, proc_host_address_list(zeek_analyzer, element->data()->addrs()));

				break;
			case 10:
				// TODO
				break;
			case 11:
				if ( element->data()->addl_tkts()->tickets()->size() )
					rv->Assign(13, proc_tickets(element->data()->addl_tkts()));

				break;
			default:
				break;
			}
		}

	return rv;
}


bool proc_error_arguments(zeek::RecordVal* rv, const std::vector<KRB_ERROR_Arg*>* args, int64 error_code )
{
	uint ctime_i = 0;
	uint stime_i = 0;
	int64 ctime_usecs = 0;
	int64 stime_usecs = 0;

	// We need to do a pass first, to see if we have microseconds for the timestamp values, which are optional

	for ( uint i = 0; i < args->size(); i++ )
		{
		switch ( (*args)[i]->seq_meta()->index() )
			{
			case 2:
				ctime_i = i;
				break;
			case 3:
				ctime_usecs = binary_to_int64((*args)[i]->args()->cusec()->encoding()->content());
				break;
			case 4:
				stime_i = i;
				break;
			case 5:
				stime_usecs = binary_to_int64((*args)[i]->args()->susec()->encoding()->content());
				break;
			default:
				break;
			}
		}

	if ( ctime_i )
		rv->Assign(2, GetTimeFromAsn1((*args)[ctime_i]->args()->ctime(), ctime_usecs));

	if ( stime_i )
		rv->Assign(3, GetTimeFromAsn1((*args)[stime_i]->args()->stime(), stime_usecs));

	for ( KRB_ERROR_Arg* arg : *args )
		{
		switch ( arg->seq_meta()->index() )
			{
			case 0:
				rv->Assign(0, asn1_integer_to_val(arg->args()->pvno(), zeek::TYPE_COUNT));
				break;
			case 1:
				rv->Assign(1, asn1_integer_to_val(arg->args()->msg_type(), zeek::TYPE_COUNT));
				break;
			// ctime/stime handled above
			case 7:
				rv->Assign(5, to_stringval(arg->args()->crealm()->encoding()->content()));
				break;
			case 8:
				rv->Assign(6, GetStringFromPrincipalName(arg->args()->cname()));
				break;
			case 9:
				rv->Assign(7, to_stringval(arg->args()->realm()->encoding()->content()));
				break;
			case 10:
				rv->Assign(8, GetStringFromPrincipalName(arg->args()->sname()));
				break;
			case 11:
				rv->Assign(9, to_stringval(arg->args()->e_text()->encoding()->content()));
				break;
			case 12:
				if ( error_code == KDC_ERR_PREAUTH_REQUIRED )
					rv->Assign(10, proc_padata(arg->args()->e_data()->padata(), nullptr, true));
				break;
			default:
				break;
			}
		}

	return true;
}


} // namespace KRB
}  // namespace binpac
