// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/modbus/modbus_pac.h"

namespace binpac {






namespace ModbusTCP {
ContextModbusTCP::ContextModbusTCP(ModbusTCP_Conn* connection, ModbusTCP_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextModbusTCP::~ContextModbusTCP() {
}

ModbusTCP_Conn::ModbusTCP_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new ModbusTCP_Flow(this, true);
    downflow_ = new ModbusTCP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		confirmed = false;
		orig_pdu = false;
		resp_pdu = false;
		
}

ModbusTCP_Conn::~ModbusTCP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void ModbusTCP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void ModbusTCP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void ModbusTCP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool ModbusTCP_Conn::SetPDU(bool is_orig) {

		if ( is_orig )
			orig_pdu = true;
		else
			resp_pdu = true;

		return true;
		
}

bool ModbusTCP_Conn::SetConfirmed() {

		confirmed = true;
		return true;
		
}

bool ModbusTCP_Conn::IsConfirmed() {

		return confirmed && orig_pdu && resp_pdu;
		
}

ModbusTCP_PDU::ModbusTCP_PDU(bool is_orig) {
    header_ = nullptr;
    body_case_index_ = -1;
    request_ = nullptr;
    response_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    deliver_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ModbusTCP_PDU::~ModbusTCP_PDU() {
    delete header_;
    header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( body_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool ModbusTCP_PDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextModbusTCP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(8, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "header"
            header_ = new ModbusTCP_TransportHeader();
            header_->Parse(t_begin_of_data, t_end_of_data, t_context);
            t_flow_buffer->GrowFrame(header()->len() + 6);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "body"
                int t_body__size;
                body_case_index_ = is_orig();
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( body_case_index() ) {
                    case true:
                        // Parse "request"
                        {
                            request_ = new ModbusTCP_Request(header());
                            int t_request__size;
                            t_request__size = request_->Parse((t_begin_of_data + 8), t_end_of_data, t_context);
                            t_body__size = t_request__size;
                        }
                        break;
                    case false:
                        // Parse "response"
                        {
                            response_ = new ModbusTCP_Response(header());
                            int t_response__size;
                            t_response__size = response_->Parse((t_begin_of_data + 8), t_end_of_data, t_context);
                            t_body__size = t_response__size;
                        }
                        break;
                    default:
                        throw binpac::ExceptionInvalidCaseIndex("ModbusTCP_PDU", (int64)body_case_index());
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    deliver_ = t_context->flow()->deliver_ModbusTCP_PDU(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ModbusTCP_TransportHeader::ModbusTCP_TransportHeader() {
    tid_ = 0;
    pid_ = 0;
    len_ = 0;
    uid_ = 0;
    fc_ = 0;
    byteorder_ = bigendian;
    deliver_ = false;
}

ModbusTCP_TransportHeader::~ModbusTCP_TransportHeader() {
}

int ModbusTCP_TransportHeader::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ModbusTCP_TransportHeader"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ModbusTCP_TransportHeader",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tid"
    tid_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "pid"
    pid_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));
    // Evaluate '&enforce' attribute
    if (! ( pid() == 0 ) ) {
        throw binpac::ExceptionEnforceViolation("ModbusTCP_TransportHeader:pid");
    }

    // Parse "len"
    len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));
    // Evaluate '&enforce' attribute
    if (! ( len() >= 2 ) ) {
        throw binpac::ExceptionEnforceViolation("ModbusTCP_TransportHeader:len");
    }

    // Parse "uid"
    uid_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 6)));

    // Parse "fc"
    fc_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_message(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

ModbusTCP_Request::ModbusTCP_Request(ModbusTCP_TransportHeader* header) {
    val_case_index_ = -1;
    readCoils_ = nullptr;
    readDiscreteInputs_ = nullptr;
    readHoldingRegisters_ = nullptr;
    readInputRegisters_ = nullptr;
    writeSingleCoil_ = nullptr;
    writeSingleRegister_ = nullptr;
    diagnostics_ = nullptr;
    writeMultipleCoils_ = nullptr;
    writeMultRegisters_ = nullptr;
    readFileRecord_ = nullptr;
    writeFileRecord_ = nullptr;
    maskWriteRegister_ = nullptr;
    readWriteMultipleRegisters_ = nullptr;
    readFIFOQueue_ = nullptr;
    encapInterfaceException_ = nullptr;
    header_ = header;
}

ModbusTCP_Request::~ModbusTCP_Request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Clean up "readCoils"
            {
                delete readCoils_;
                readCoils_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "readDiscreteInputs"
            {
                delete readDiscreteInputs_;
                readDiscreteInputs_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "readHoldingRegisters"
            {
                delete readHoldingRegisters_;
                readHoldingRegisters_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "readInputRegisters"
            {
                delete readInputRegisters_;
                readInputRegisters_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "writeSingleCoil"
            {
                delete writeSingleCoil_;
                writeSingleCoil_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "writeSingleRegister"
            {
                delete writeSingleRegister_;
                writeSingleRegister_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "diagnostics"
            {
                delete diagnostics_;
                diagnostics_ = nullptr;
            }
            break;
        case ((uint8)15):
            // Clean up "writeMultipleCoils"
            {
                delete writeMultipleCoils_;
                writeMultipleCoils_ = nullptr;
            }
            break;
        case ((uint8)16):
            // Clean up "writeMultRegisters"
            {
                delete writeMultRegisters_;
                writeMultRegisters_ = nullptr;
            }
            break;
        case ((uint8)20):
            // Clean up "readFileRecord"
            {
                delete readFileRecord_;
                readFileRecord_ = nullptr;
            }
            break;
        case ((uint8)21):
            // Clean up "writeFileRecord"
            {
                delete writeFileRecord_;
                writeFileRecord_ = nullptr;
            }
            break;
        case ((uint8)22):
            // Clean up "maskWriteRegister"
            {
                delete maskWriteRegister_;
                maskWriteRegister_ = nullptr;
            }
            break;
        case ((uint8)23):
            // Clean up "readWriteMultipleRegisters"
            {
                delete readWriteMultipleRegisters_;
                readWriteMultipleRegisters_ = nullptr;
            }
            break;
        case ((uint8)24):
            // Clean up "readFIFOQueue"
            {
                delete readFIFOQueue_;
                readFIFOQueue_ = nullptr;
            }
            break;
        case ((uint8)43):
            // Clean up "encapInterfaceException"
            {
                delete encapInterfaceException_;
                encapInterfaceException_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ModbusTCP_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    int t_val__size;
    val_case_index_ = header()->fc();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Parse "readCoils"
            {
                readCoils_ = new ReadCoilsRequest(header());
                readCoils_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)2):
            // Parse "readDiscreteInputs"
            {
                readDiscreteInputs_ = new ReadDiscreteInputsRequest(header());
                readDiscreteInputs_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)3):
            // Parse "readHoldingRegisters"
            {
                readHoldingRegisters_ = new ReadHoldingRegistersRequest(header());
                readHoldingRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)4):
            // Parse "readInputRegisters"
            {
                readInputRegisters_ = new ReadInputRegistersRequest(header());
                readInputRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)5):
            // Parse "writeSingleCoil"
            {
                writeSingleCoil_ = new WriteSingleCoilRequest(header());
                writeSingleCoil_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)6):
            // Parse "writeSingleRegister"
            {
                writeSingleRegister_ = new WriteSingleRegisterRequest(header());
                writeSingleRegister_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)8):
            // Parse "diagnostics"
            {
                diagnostics_ = new DiagnosticsRequest(header());
                int t_diagnostics__size;
                t_diagnostics__size = diagnostics_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_diagnostics__size;
            }
            break;
        case ((uint8)15):
            // Parse "writeMultipleCoils"
            {
                writeMultipleCoils_ = new WriteMultipleCoilsRequest(header());
                int t_writeMultipleCoils__size;
                t_writeMultipleCoils__size = writeMultipleCoils_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_writeMultipleCoils__size;
            }
            break;
        case ((uint8)16):
            // Parse "writeMultRegisters"
            {
                writeMultRegisters_ = new WriteMultipleRegistersRequest(header());
                int t_writeMultRegisters__size;
                t_writeMultRegisters__size = writeMultRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_writeMultRegisters__size;
            }
            break;
        case ((uint8)20):
            // Parse "readFileRecord"
            {
                readFileRecord_ = new ReadFileRecordRequest(header());
                int t_readFileRecord__size;
                t_readFileRecord__size = readFileRecord_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readFileRecord__size;
            }
            break;
        case ((uint8)21):
            // Parse "writeFileRecord"
            {
                writeFileRecord_ = new WriteFileRecordRequest(header());
                int t_writeFileRecord__size;
                t_writeFileRecord__size = writeFileRecord_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_writeFileRecord__size;
            }
            break;
        case ((uint8)22):
            // Parse "maskWriteRegister"
            {
                maskWriteRegister_ = new MaskWriteRegisterRequest(header());
                maskWriteRegister_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 6;
            }
            break;
        case ((uint8)23):
            // Parse "readWriteMultipleRegisters"
            {
                readWriteMultipleRegisters_ = new ReadWriteMultipleRegistersRequest(header());
                int t_readWriteMultipleRegisters__size;
                t_readWriteMultipleRegisters__size = readWriteMultipleRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readWriteMultipleRegisters__size;
            }
            break;
        case ((uint8)24):
            // Parse "readFIFOQueue"
            {
                readFIFOQueue_ = new ReadFIFOQueueRequest(header());
                readFIFOQueue_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 2;
            }
            break;
        case ((uint8)43):
            // Parse "encapInterfaceException"
            {
                encapInterfaceException_ = new EncapInterfaceTransportRequest(header());
                int t_encapInterfaceException__size;
                t_encapInterfaceException__size = encapInterfaceException_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_encapInterfaceException__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:108", t_unknown_string_length);
                unknown_.init(t_begin_of_data, t_unknown_string_length);
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ModbusTCP_Response::ModbusTCP_Response(ModbusTCP_TransportHeader* header) {
    val_case_index_ = -1;
    normal_response_ = nullptr;
    exception_response_ = nullptr;
    header_ = header;
}

ModbusTCP_Response::~ModbusTCP_Response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Clean up "normal_response"
            {
                delete normal_response_;
                normal_response_ = nullptr;
            }
            break;
        default:
            // Clean up "exception_response"
            {
                delete exception_response_;
                exception_response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ModbusTCP_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    int t_val__size;
    val_case_index_ = header()->fc() & 0x80;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Parse "normal_response"
            {
                normal_response_ = new ModbusTCP_NormalResponse(header());
                int t_normal_response__size;
                t_normal_response__size = normal_response_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_normal_response__size;
            }
            break;
        default:
            // Parse "exception_response"
            {
                exception_response_ = new ModbusTCP_ExceptResponse(header());
                exception_response_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 1;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ModbusTCP_NormalResponse::ModbusTCP_NormalResponse(ModbusTCP_TransportHeader* header) {
    val_case_index_ = -1;
    readCoils_ = nullptr;
    readDiscreteInputs_ = nullptr;
    readHoldingRegisters_ = nullptr;
    readInputRegisters_ = nullptr;
    writeSingleCoil_ = nullptr;
    writeSingleRegister_ = nullptr;
    diagnostics_ = nullptr;
    writeMultipleCoils_ = nullptr;
    writeMultRegisters_ = nullptr;
    readFileRecord_ = nullptr;
    writeFileRecord_ = nullptr;
    maskWriteRegister_ = nullptr;
    readWriteMultipleRegisters_ = nullptr;
    readFIFOQueue_ = nullptr;
    encapInterfaceTransport_ = nullptr;
    header_ = header;
}

ModbusTCP_NormalResponse::~ModbusTCP_NormalResponse() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Clean up "readCoils"
            {
                delete readCoils_;
                readCoils_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "readDiscreteInputs"
            {
                delete readDiscreteInputs_;
                readDiscreteInputs_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "readHoldingRegisters"
            {
                delete readHoldingRegisters_;
                readHoldingRegisters_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "readInputRegisters"
            {
                delete readInputRegisters_;
                readInputRegisters_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "writeSingleCoil"
            {
                delete writeSingleCoil_;
                writeSingleCoil_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "writeSingleRegister"
            {
                delete writeSingleRegister_;
                writeSingleRegister_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "diagnostics"
            {
                delete diagnostics_;
                diagnostics_ = nullptr;
            }
            break;
        case ((uint8)15):
            // Clean up "writeMultipleCoils"
            {
                delete writeMultipleCoils_;
                writeMultipleCoils_ = nullptr;
            }
            break;
        case ((uint8)16):
            // Clean up "writeMultRegisters"
            {
                delete writeMultRegisters_;
                writeMultRegisters_ = nullptr;
            }
            break;
        case ((uint8)20):
            // Clean up "readFileRecord"
            {
                delete readFileRecord_;
                readFileRecord_ = nullptr;
            }
            break;
        case ((uint8)21):
            // Clean up "writeFileRecord"
            {
                delete writeFileRecord_;
                writeFileRecord_ = nullptr;
            }
            break;
        case ((uint8)22):
            // Clean up "maskWriteRegister"
            {
                delete maskWriteRegister_;
                maskWriteRegister_ = nullptr;
            }
            break;
        case ((uint8)23):
            // Clean up "readWriteMultipleRegisters"
            {
                delete readWriteMultipleRegisters_;
                readWriteMultipleRegisters_ = nullptr;
            }
            break;
        case ((uint8)24):
            // Clean up "readFIFOQueue"
            {
                delete readFIFOQueue_;
                readFIFOQueue_ = nullptr;
            }
            break;
        case ((uint8)43):
            // Clean up "encapInterfaceTransport"
            {
                delete encapInterfaceTransport_;
                encapInterfaceTransport_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ModbusTCP_NormalResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    int t_val__size;
    val_case_index_ = header()->fc();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Parse "readCoils"
            {
                readCoils_ = new ReadCoilsResponse(header());
                int t_readCoils__size;
                t_readCoils__size = readCoils_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readCoils__size;
            }
            break;
        case ((uint8)2):
            // Parse "readDiscreteInputs"
            {
                readDiscreteInputs_ = new ReadDiscreteInputsResponse(header());
                int t_readDiscreteInputs__size;
                t_readDiscreteInputs__size = readDiscreteInputs_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readDiscreteInputs__size;
            }
            break;
        case ((uint8)3):
            // Parse "readHoldingRegisters"
            {
                readHoldingRegisters_ = new ReadHoldingRegistersResponse(header());
                int t_readHoldingRegisters__size;
                t_readHoldingRegisters__size = readHoldingRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readHoldingRegisters__size;
            }
            break;
        case ((uint8)4):
            // Parse "readInputRegisters"
            {
                readInputRegisters_ = new ReadInputRegistersResponse(header());
                int t_readInputRegisters__size;
                t_readInputRegisters__size = readInputRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readInputRegisters__size;
            }
            break;
        case ((uint8)5):
            // Parse "writeSingleCoil"
            {
                writeSingleCoil_ = new WriteSingleCoilResponse(header());
                writeSingleCoil_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)6):
            // Parse "writeSingleRegister"
            {
                writeSingleRegister_ = new WriteSingleRegisterResponse(header());
                writeSingleRegister_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)8):
            // Parse "diagnostics"
            {
                diagnostics_ = new DiagnosticsResponse(header());
                int t_diagnostics__size;
                t_diagnostics__size = diagnostics_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_diagnostics__size;
            }
            break;
        case ((uint8)15):
            // Parse "writeMultipleCoils"
            {
                writeMultipleCoils_ = new WriteMultipleCoilsResponse(header());
                writeMultipleCoils_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)16):
            // Parse "writeMultRegisters"
            {
                writeMultRegisters_ = new WriteMultipleRegistersResponse(header());
                writeMultRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 4;
            }
            break;
        case ((uint8)20):
            // Parse "readFileRecord"
            {
                readFileRecord_ = new ReadFileRecordResponse(header());
                int t_readFileRecord__size;
                t_readFileRecord__size = readFileRecord_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readFileRecord__size;
            }
            break;
        case ((uint8)21):
            // Parse "writeFileRecord"
            {
                writeFileRecord_ = new WriteFileRecordResponse(header());
                int t_writeFileRecord__size;
                t_writeFileRecord__size = writeFileRecord_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_writeFileRecord__size;
            }
            break;
        case ((uint8)22):
            // Parse "maskWriteRegister"
            {
                maskWriteRegister_ = new MaskWriteRegisterResponse(header());
                maskWriteRegister_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 6;
            }
            break;
        case ((uint8)23):
            // Parse "readWriteMultipleRegisters"
            {
                readWriteMultipleRegisters_ = new ReadWriteMultipleRegistersResponse(header());
                int t_readWriteMultipleRegisters__size;
                t_readWriteMultipleRegisters__size = readWriteMultipleRegisters_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readWriteMultipleRegisters__size;
            }
            break;
        case ((uint8)24):
            // Parse "readFIFOQueue"
            {
                readFIFOQueue_ = new ReadFIFOQueueResponse(header());
                int t_readFIFOQueue__size;
                t_readFIFOQueue__size = readFIFOQueue_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_readFIFOQueue__size;
            }
            break;
        case ((uint8)43):
            // Parse "encapInterfaceTransport"
            {
                encapInterfaceTransport_ = new EncapInterfaceTransportResponse(header());
                int t_encapInterfaceTransport__size;
                t_encapInterfaceTransport__size = encapInterfaceTransport_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_encapInterfaceTransport__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:140", t_unknown_string_length);
                unknown_.init(t_begin_of_data, t_unknown_string_length);
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ModbusTCP_ExceptResponse::ModbusTCP_ExceptResponse(ModbusTCP_TransportHeader* header) {
    code_ = 0;
    header_ = header;
    deliver_ = false;
}

ModbusTCP_ExceptResponse::~ModbusTCP_ExceptResponse() {
}

int ModbusTCP_ExceptResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ModbusTCP_ExceptResponse"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ModbusTCP_ExceptResponse",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "code"
    code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_Exception(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

ReadCoilsRequest::ReadCoilsRequest(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadCoilsRequest::~ReadCoilsRequest() {
}

int ReadCoilsRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadCoilsRequest"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadCoilsRequest",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadCoilsRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

ReadCoilsResponse::ReadCoilsResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadCoilsResponse::~ReadCoilsResponse() {
    bits_.free();
}

int ReadCoilsResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadCoilsResponse:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadCoilsResponse:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "bits"
    int t_bits__size;
    t_bits__size = byte_count();
    // Checking out-of-bound for "ReadCoilsResponse:bits"
    if ( (t_begin_of_data + 1) + (t_bits__size) > t_end_of_data || (t_begin_of_data + 1) + (t_bits__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadCoilsResponse:bits",
        	(1) + (t_bits__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_bits__size;
        int t_bits_string_length;
        t_bits_string_length = byte_count();
        // check for negative sizes
        if ( t_bits_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:160", t_bits_string_length);
        bits_.init((t_begin_of_data + 1), t_bits_string_length);
    }

    int t_ReadCoilsResponse__size;
    const_byteptr const t_dataptr_after_bits = (t_begin_of_data + 1) + (t_bits__size);
    BINPAC_ASSERT(t_dataptr_after_bits <= t_end_of_data);
    t_ReadCoilsResponse__size = t_dataptr_after_bits - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadCoilsResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadCoilsResponse__size) <= t_end_of_data);
    return t_ReadCoilsResponse__size;
}

ReadDiscreteInputsRequest::ReadDiscreteInputsRequest(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadDiscreteInputsRequest::~ReadDiscreteInputsRequest() {
}

int ReadDiscreteInputsRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadDiscreteInputsRequest"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadDiscreteInputsRequest",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadDiscreteInputsRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

ReadDiscreteInputsResponse::ReadDiscreteInputsResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadDiscreteInputsResponse::~ReadDiscreteInputsResponse() {
    bits_.free();
}

int ReadDiscreteInputsResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadDiscreteInputsResponse:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadDiscreteInputsResponse:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "bits"
    int t_bits__size;
    t_bits__size = byte_count();
    // Checking out-of-bound for "ReadDiscreteInputsResponse:bits"
    if ( (t_begin_of_data + 1) + (t_bits__size) > t_end_of_data || (t_begin_of_data + 1) + (t_bits__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadDiscreteInputsResponse:bits",
        	(1) + (t_bits__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_bits__size;
        int t_bits_string_length;
        t_bits_string_length = byte_count();
        // check for negative sizes
        if ( t_bits_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:176", t_bits_string_length);
        bits_.init((t_begin_of_data + 1), t_bits_string_length);
    }

    int t_ReadDiscreteInputsResponse__size;
    const_byteptr const t_dataptr_after_bits = (t_begin_of_data + 1) + (t_bits__size);
    BINPAC_ASSERT(t_dataptr_after_bits <= t_end_of_data);
    t_ReadDiscreteInputsResponse__size = t_dataptr_after_bits - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadDiscreteInputsResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadDiscreteInputsResponse__size) <= t_end_of_data);
    return t_ReadDiscreteInputsResponse__size;
}

ReadHoldingRegistersRequest::ReadHoldingRegistersRequest(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadHoldingRegistersRequest::~ReadHoldingRegistersRequest() {
}

int ReadHoldingRegistersRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadHoldingRegistersRequest"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadHoldingRegistersRequest",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadHoldingRegistersRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

ReadHoldingRegistersResponse::ReadHoldingRegistersResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    registers_ = nullptr;
    registers__elem_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadHoldingRegistersResponse::~ReadHoldingRegistersResponse() {
    delete registers_;
}

int ReadHoldingRegistersResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadHoldingRegistersResponse:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadHoldingRegistersResponse:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "registers"
    int t_registers__size;
    t_registers__size = byte_count();
    // Checking out-of-bound for "ReadHoldingRegistersResponse:registers"
    if ( (t_begin_of_data + 1) + (t_registers__size) > t_end_of_data || (t_begin_of_data + 1) + (t_registers__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadHoldingRegistersResponse:registers",
        	(1) + (t_registers__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_registers__size;
        int t_registers__arraylength;
        t_registers__arraylength = byte_count() / 2;
        if ( t_registers__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("ReadHoldingRegistersResponse:registers",
              t_registers__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: ReadHoldingRegistersResponse:registers
        if ( t_registers__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 2) )
            throw binpac::ExceptionOutOfBound("ReadHoldingRegistersResponse:registers",
              t_registers__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
        registers__elem_ = 0;
        int t_registers__elem__it;
        t_registers__elem__it = 0;
        registers_ = new vector<uint16>;
        registers_->reserve(t_registers__arraylength);
        const_byteptr t_registers__elem__dataptr = (t_begin_of_data + 1);
        for (; t_registers__elem__it < t_registers__arraylength; ++t_registers__elem__it) {
            registers__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_registers__elem__dataptr)));
            registers_->push_back(registers__elem_);
            t_registers__elem__dataptr += 2;
            BINPAC_ASSERT(t_registers__elem__dataptr <= t_end_of_data);
        }
    end_of_registers: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_ReadHoldingRegistersResponse__size;
    const_byteptr const t_dataptr_after_registers = (t_begin_of_data + 1) + (t_registers__size);
    BINPAC_ASSERT(t_dataptr_after_registers <= t_end_of_data);
    t_ReadHoldingRegistersResponse__size = t_dataptr_after_registers - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadHoldingRegistersResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadHoldingRegistersResponse__size) <= t_end_of_data);
    return t_ReadHoldingRegistersResponse__size;
}

ReadInputRegistersRequest::ReadInputRegistersRequest(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadInputRegistersRequest::~ReadInputRegistersRequest() {
}

int ReadInputRegistersRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadInputRegistersRequest"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadInputRegistersRequest",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadInputRegistersRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

ReadInputRegistersResponse::ReadInputRegistersResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    registers_ = nullptr;
    registers__elem_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadInputRegistersResponse::~ReadInputRegistersResponse() {
    delete registers_;
}

int ReadInputRegistersResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadInputRegistersResponse:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadInputRegistersResponse:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "registers"
    int t_registers__size;
    t_registers__size = byte_count();
    // Checking out-of-bound for "ReadInputRegistersResponse:registers"
    if ( (t_begin_of_data + 1) + (t_registers__size) > t_end_of_data || (t_begin_of_data + 1) + (t_registers__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadInputRegistersResponse:registers",
        	(1) + (t_registers__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_registers__size;
        int t_registers__arraylength;
        t_registers__arraylength = byte_count() / 2;
        if ( t_registers__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("ReadInputRegistersResponse:registers",
              t_registers__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: ReadInputRegistersResponse:registers
        if ( t_registers__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 2) )
            throw binpac::ExceptionOutOfBound("ReadInputRegistersResponse:registers",
              t_registers__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
        registers__elem_ = 0;
        int t_registers__elem__it;
        t_registers__elem__it = 0;
        registers_ = new vector<uint16>;
        registers_->reserve(t_registers__arraylength);
        const_byteptr t_registers__elem__dataptr = (t_begin_of_data + 1);
        for (; t_registers__elem__it < t_registers__arraylength; ++t_registers__elem__it) {
            registers__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_registers__elem__dataptr)));
            registers_->push_back(registers__elem_);
            t_registers__elem__dataptr += 2;
            BINPAC_ASSERT(t_registers__elem__dataptr <= t_end_of_data);
        }
    end_of_registers: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_ReadInputRegistersResponse__size;
    const_byteptr const t_dataptr_after_registers = (t_begin_of_data + 1) + (t_registers__size);
    BINPAC_ASSERT(t_dataptr_after_registers <= t_end_of_data);
    t_ReadInputRegistersResponse__size = t_dataptr_after_registers - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadInputRegistersResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadInputRegistersResponse__size) <= t_end_of_data);
    return t_ReadInputRegistersResponse__size;
}

WriteSingleCoilRequest::WriteSingleCoilRequest(ModbusTCP_TransportHeader* header) {
    address_ = 0;
    value_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteSingleCoilRequest::~WriteSingleCoilRequest() {
}

int WriteSingleCoilRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteSingleCoilRequest"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteSingleCoilRequest",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "address"
    address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteSingleCoilRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

WriteSingleCoilResponse::WriteSingleCoilResponse(ModbusTCP_TransportHeader* header) {
    address_ = 0;
    value_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteSingleCoilResponse::~WriteSingleCoilResponse() {
}

int WriteSingleCoilResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteSingleCoilResponse"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteSingleCoilResponse",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "address"
    address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteSingleCoilResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

WriteSingleRegisterRequest::WriteSingleRegisterRequest(ModbusTCP_TransportHeader* header) {
    address_ = 0;
    value_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteSingleRegisterRequest::~WriteSingleRegisterRequest() {
}

int WriteSingleRegisterRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteSingleRegisterRequest"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteSingleRegisterRequest",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "address"
    address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteSingleRegisterRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

WriteSingleRegisterResponse::WriteSingleRegisterResponse(ModbusTCP_TransportHeader* header) {
    address_ = 0;
    value_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteSingleRegisterResponse::~WriteSingleRegisterResponse() {
}

int WriteSingleRegisterResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteSingleRegisterResponse"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteSingleRegisterResponse",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "address"
    address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteSingleRegisterResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

DiagnosticsRequest::DiagnosticsRequest(ModbusTCP_TransportHeader* header) {
    subfunction_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

DiagnosticsRequest::~DiagnosticsRequest() {
    data_.free();
}

int DiagnosticsRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "DiagnosticsRequest:subfunction"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DiagnosticsRequest:subfunction",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "subfunction"
    subfunction_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 2));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:248", t_data_string_length);
    data_.init((t_begin_of_data + 2), t_data_string_length);

    int t_DiagnosticsRequest__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 2) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_DiagnosticsRequest__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_DiagnosticsRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_DiagnosticsRequest__size) <= t_end_of_data);
    return t_DiagnosticsRequest__size;
}

DiagnosticsResponse::DiagnosticsResponse(ModbusTCP_TransportHeader* header) {
    subfunction_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

DiagnosticsResponse::~DiagnosticsResponse() {
    data_.free();
}

int DiagnosticsResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "DiagnosticsResponse:subfunction"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DiagnosticsResponse:subfunction",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "subfunction"
    subfunction_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 2));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:256", t_data_string_length);
    data_.init((t_begin_of_data + 2), t_data_string_length);

    int t_DiagnosticsResponse__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 2) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_DiagnosticsResponse__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_DiagnosticsResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_DiagnosticsResponse__size) <= t_end_of_data);
    return t_DiagnosticsResponse__size;
}

WriteMultipleCoilsRequest::WriteMultipleCoilsRequest(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    byte_count_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteMultipleCoilsRequest::~WriteMultipleCoilsRequest() {
    coils_.free();
}

int WriteMultipleCoilsRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteMultipleCoilsRequest:byte_count"
    if ( (t_begin_of_data + 4) + (1) > t_end_of_data || (t_begin_of_data + 4) + (1) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteMultipleCoilsRequest:byte_count",
        	(4) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "coils"
    int t_coils__size;
    t_coils__size = byte_count();
    // Checking out-of-bound for "WriteMultipleCoilsRequest:coils"
    if ( (t_begin_of_data + 5) + (t_coils__size) > t_end_of_data || (t_begin_of_data + 5) + (t_coils__size) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteMultipleCoilsRequest:coils",
        	(5) + (t_coils__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + t_coils__size;
        int t_coils_string_length;
        t_coils_string_length = byte_count();
        // check for negative sizes
        if ( t_coils_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:266", t_coils_string_length);
        coils_.init((t_begin_of_data + 5), t_coils_string_length);
    }

    int t_WriteMultipleCoilsRequest__size;
    const_byteptr const t_dataptr_after_coils = (t_begin_of_data + 5) + (t_coils__size);
    BINPAC_ASSERT(t_dataptr_after_coils <= t_end_of_data);
    t_WriteMultipleCoilsRequest__size = t_dataptr_after_coils - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteMultipleCoilsRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_WriteMultipleCoilsRequest__size) <= t_end_of_data);
    return t_WriteMultipleCoilsRequest__size;
}

WriteMultipleCoilsResponse::WriteMultipleCoilsResponse(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteMultipleCoilsResponse::~WriteMultipleCoilsResponse() {
}

int WriteMultipleCoilsResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteMultipleCoilsResponse"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteMultipleCoilsResponse",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteMultipleCoilsResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

WriteMultipleRegistersRequest::WriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    byte_count_ = 0;
    registers_ = nullptr;
    registers__elem_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteMultipleRegistersRequest::~WriteMultipleRegistersRequest() {
    delete registers_;
}

int WriteMultipleRegistersRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteMultipleRegistersRequest:byte_count"
    if ( (t_begin_of_data + 4) + (1) > t_end_of_data || (t_begin_of_data + 4) + (1) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteMultipleRegistersRequest:byte_count",
        	(4) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "registers"
    int t_registers__size;
    t_registers__size = byte_count();
    // Checking out-of-bound for "WriteMultipleRegistersRequest:registers"
    if ( (t_begin_of_data + 5) + (t_registers__size) > t_end_of_data || (t_begin_of_data + 5) + (t_registers__size) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteMultipleRegistersRequest:registers",
        	(5) + (t_registers__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + t_registers__size;
        int t_registers__arraylength;
        t_registers__arraylength = quantity();
        if ( t_registers__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("WriteMultipleRegistersRequest:registers",
              t_registers__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: WriteMultipleRegistersRequest:registers
        if ( t_registers__arraylength > ((t_end_of_data - (t_begin_of_data + 5)) / 2) )
            throw binpac::ExceptionOutOfBound("WriteMultipleRegistersRequest:registers",
              t_registers__arraylength, (t_end_of_data) - ((t_begin_of_data + 5)));
        registers__elem_ = 0;
        int t_registers__elem__it;
        t_registers__elem__it = 0;
        registers_ = new vector<uint16>;
        registers_->reserve(t_registers__arraylength);
        const_byteptr t_registers__elem__dataptr = (t_begin_of_data + 5);
        for (; t_registers__elem__it < t_registers__arraylength; ++t_registers__elem__it) {
            registers__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_registers__elem__dataptr)));
            registers_->push_back(registers__elem_);
            t_registers__elem__dataptr += 2;
            BINPAC_ASSERT(t_registers__elem__dataptr <= t_end_of_data);
        }
    end_of_registers: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_WriteMultipleRegistersRequest__size;
    const_byteptr const t_dataptr_after_registers = (t_begin_of_data + 5) + (t_registers__size);
    BINPAC_ASSERT(t_dataptr_after_registers <= t_end_of_data);
    t_WriteMultipleRegistersRequest__size = t_dataptr_after_registers - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteMultipleRegistersRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_WriteMultipleRegistersRequest__size) <= t_end_of_data);
    return t_WriteMultipleRegistersRequest__size;
}

WriteMultipleRegistersResponse::WriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    quantity_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteMultipleRegistersResponse::~WriteMultipleRegistersResponse() {
}

int WriteMultipleRegistersResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteMultipleRegistersResponse"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteMultipleRegistersResponse",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "quantity"
    quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteMultipleRegistersResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

FileRecordRequest::FileRecordRequest() {
    ref_type_ = 0;
    file_num_ = 0;
    record_num_ = 0;
    record_len_ = 0;
    byteorder_ = bigendian;
}

FileRecordRequest::~FileRecordRequest() {
}

int FileRecordRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "FileRecordRequest"
    if ( t_begin_of_data + (7) > t_end_of_data || t_begin_of_data + (7) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FileRecordRequest",
        	(0) + (7), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ref_type"
    ref_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "file_num"
    file_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "record_num"
    record_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "record_len"
    record_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (7) <= t_end_of_data);
    return 7;
}

ReadFileRecordRequest::ReadFileRecordRequest(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    references_ = nullptr;
    references__elem_ = nullptr;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadFileRecordRequest::~ReadFileRecordRequest() {
    delete references__elem_;
    references__elem_ = nullptr;
    if ( references() ) {
        for ( auto* references__elem_ : *references() ) {
            delete references__elem_;
            references__elem_ = nullptr;
        }
    }
    delete references_;
}

int ReadFileRecordRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadFileRecordRequest:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadFileRecordRequest:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "references"
    int t_references__size;
    t_references__size = byte_count();
    // Checking out-of-bound for "ReadFileRecordRequest:references"
    if ( (t_begin_of_data + 1) + (t_references__size) > t_end_of_data || (t_begin_of_data + 1) + (t_references__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadFileRecordRequest:references",
        	(1) + (t_references__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_references__size;
        int t_references__arraylength;
        t_references__arraylength = 0;
        references__elem_ = nullptr;
        int t_references__elem__it;
        t_references__elem__it = 0;
        references_ = new vector<FileRecordRequest*>;
        const_byteptr t_references__elem__dataptr = (t_begin_of_data + 1);
        for (; /* forever */; ++t_references__elem__it) {
            // Check &until(references__elem__dataptr >= end_of_data)
            if ( t_references__elem__dataptr >= t_end_of_data ) {
                references__elem_ = nullptr;
                goto end_of_references;
            }
            references__elem_ = new FileRecordRequest();
            references__elem_->Parse(t_references__elem__dataptr, t_end_of_data);
            references_->push_back(references__elem_);
            t_references__elem__dataptr += 7;
            BINPAC_ASSERT(t_references__elem__dataptr <= t_end_of_data);
            references__elem_ = nullptr;
        }
    end_of_references: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_ReadFileRecordRequest__size;
    const_byteptr const t_dataptr_after_references = (t_begin_of_data + 1) + (t_references__size);
    BINPAC_ASSERT(t_dataptr_after_references <= t_end_of_data);
    t_ReadFileRecordRequest__size = t_dataptr_after_references - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadFileRecordRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadFileRecordRequest__size) <= t_end_of_data);
    return t_ReadFileRecordRequest__size;
}

FileRecordResponse::FileRecordResponse() {
    file_len_ = 0;
    ref_type_ = 0;
    byteorder_ = bigendian;
}

FileRecordResponse::~FileRecordResponse() {
    record_data_.free();
}

int FileRecordResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "FileRecordResponse:ref_type"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FileRecordResponse:ref_type",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "file_len"
    file_len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "ref_type"
    ref_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "record_data"
    int t_record_data__size;
    t_record_data__size = file_len();
    // Checking out-of-bound for "FileRecordResponse:record_data"
    if ( (t_begin_of_data + 2) + (t_record_data__size) > t_end_of_data || (t_begin_of_data + 2) + (t_record_data__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FileRecordResponse:record_data",
        	(2) + (t_record_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_record_data__size;
        int t_record_data_string_length;
        t_record_data_string_length = file_len();
        // check for negative sizes
        if ( t_record_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:319", t_record_data_string_length);
        record_data_.init((t_begin_of_data + 2), t_record_data_string_length);
    }

    int t_FileRecordResponse__size;
    const_byteptr const t_dataptr_after_record_data = (t_begin_of_data + 2) + (t_record_data__size);
    BINPAC_ASSERT(t_dataptr_after_record_data <= t_end_of_data);
    t_FileRecordResponse__size = t_dataptr_after_record_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_FileRecordResponse__size) <= t_end_of_data);
    return t_FileRecordResponse__size;
}

ReadFileRecordResponse::ReadFileRecordResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    references_ = nullptr;
    references__elem_ = nullptr;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadFileRecordResponse::~ReadFileRecordResponse() {
    delete references__elem_;
    references__elem_ = nullptr;
    if ( references() ) {
        for ( auto* references__elem_ : *references() ) {
            delete references__elem_;
            references__elem_ = nullptr;
        }
    }
    delete references_;
}

int ReadFileRecordResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadFileRecordResponse:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadFileRecordResponse:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "references"
    int t_references__size;
    t_references__size = byte_count();
    // Checking out-of-bound for "ReadFileRecordResponse:references"
    if ( (t_begin_of_data + 1) + (t_references__size) > t_end_of_data || (t_begin_of_data + 1) + (t_references__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadFileRecordResponse:references",
        	(1) + (t_references__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_references__size;
        int t_references__arraylength;
        t_references__arraylength = 0;
        references__elem_ = nullptr;
        int t_references__elem__it;
        t_references__elem__it = 0;
        references_ = new vector<FileRecordResponse*>;
        const_byteptr t_references__elem__dataptr = (t_begin_of_data + 1);
        for (; /* forever */; ++t_references__elem__it) {
            // Check &until(references__elem__dataptr >= end_of_data)
            if ( t_references__elem__dataptr >= t_end_of_data ) {
                references__elem_ = nullptr;
                goto end_of_references;
            }
            references__elem_ = new FileRecordResponse();
            int t_references__elem__size;
            t_references__elem__size = references__elem_->Parse(t_references__elem__dataptr, t_end_of_data);
            references_->push_back(references__elem_);
            t_references__elem__dataptr += t_references__elem__size;
            BINPAC_ASSERT(t_references__elem__dataptr <= t_end_of_data);
            references__elem_ = nullptr;
        }
    end_of_references: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_ReadFileRecordResponse__size;
    const_byteptr const t_dataptr_after_references = (t_begin_of_data + 1) + (t_references__size);
    BINPAC_ASSERT(t_dataptr_after_references <= t_end_of_data);
    t_ReadFileRecordResponse__size = t_dataptr_after_references - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadFileRecordResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadFileRecordResponse__size) <= t_end_of_data);
    return t_ReadFileRecordResponse__size;
}

ReferenceWithData::ReferenceWithData() {
    ref_type_ = 0;
    file_num_ = 0;
    record_num_ = 0;
    record_length_ = 0;
    byteorder_ = bigendian;
}

ReferenceWithData::~ReferenceWithData() {
    record_data_.free();
}

int ReferenceWithData::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ReferenceWithData:record_length"
    if ( (t_begin_of_data + 5) + (2) > t_end_of_data || (t_begin_of_data + 5) + (2) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReferenceWithData:record_length",
        	(5) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ref_type"
    ref_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "file_num"
    file_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "record_num"
    record_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "record_length"
    record_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "record_data"
    int t_record_data__size;
    t_record_data__size = record_length() * 2;
    // Checking out-of-bound for "ReferenceWithData:record_data"
    if ( (t_begin_of_data + 7) + (t_record_data__size) > t_end_of_data || (t_begin_of_data + 7) + (t_record_data__size) < (t_begin_of_data + 7) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReferenceWithData:record_data",
        	(7) + (t_record_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 7) + t_record_data__size;
        int t_record_data_string_length;
        t_record_data_string_length = record_length() * 2;
        // check for negative sizes
        if ( t_record_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:336", t_record_data_string_length);
        record_data_.init((t_begin_of_data + 7), t_record_data_string_length);
    }

    int t_ReferenceWithData__size;
    const_byteptr const t_dataptr_after_record_data = (t_begin_of_data + 7) + (t_record_data__size);
    BINPAC_ASSERT(t_dataptr_after_record_data <= t_end_of_data);
    t_ReferenceWithData__size = t_dataptr_after_record_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ReferenceWithData__size) <= t_end_of_data);
    return t_ReferenceWithData__size;
}

WriteFileRecordRequest::WriteFileRecordRequest(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    references_ = nullptr;
    references__elem_ = nullptr;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteFileRecordRequest::~WriteFileRecordRequest() {
    delete references__elem_;
    references__elem_ = nullptr;
    if ( references() ) {
        for ( auto* references__elem_ : *references() ) {
            delete references__elem_;
            references__elem_ = nullptr;
        }
    }
    delete references_;
}

int WriteFileRecordRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteFileRecordRequest:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteFileRecordRequest:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "references"
    int t_references__size;
    t_references__size = byte_count();
    // Checking out-of-bound for "WriteFileRecordRequest:references"
    if ( (t_begin_of_data + 1) + (t_references__size) > t_end_of_data || (t_begin_of_data + 1) + (t_references__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteFileRecordRequest:references",
        	(1) + (t_references__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_references__size;
        int t_references__arraylength;
        t_references__arraylength = 0;
        references__elem_ = nullptr;
        int t_references__elem__it;
        t_references__elem__it = 0;
        references_ = new vector<ReferenceWithData*>;
        const_byteptr t_references__elem__dataptr = (t_begin_of_data + 1);
        for (; /* forever */; ++t_references__elem__it) {
            // Check &until(references__elem__dataptr >= end_of_data)
            if ( t_references__elem__dataptr >= t_end_of_data ) {
                references__elem_ = nullptr;
                goto end_of_references;
            }
            references__elem_ = new ReferenceWithData();
            int t_references__elem__size;
            t_references__elem__size = references__elem_->Parse(t_references__elem__dataptr, t_end_of_data);
            references_->push_back(references__elem_);
            t_references__elem__dataptr += t_references__elem__size;
            BINPAC_ASSERT(t_references__elem__dataptr <= t_end_of_data);
            references__elem_ = nullptr;
        }
    end_of_references: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_WriteFileRecordRequest__size;
    const_byteptr const t_dataptr_after_references = (t_begin_of_data + 1) + (t_references__size);
    BINPAC_ASSERT(t_dataptr_after_references <= t_end_of_data);
    t_WriteFileRecordRequest__size = t_dataptr_after_references - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteFileRecordRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_WriteFileRecordRequest__size) <= t_end_of_data);
    return t_WriteFileRecordRequest__size;
}

WriteFileRecordResponse::WriteFileRecordResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    references_ = nullptr;
    references__elem_ = nullptr;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

WriteFileRecordResponse::~WriteFileRecordResponse() {
    delete references__elem_;
    references__elem_ = nullptr;
    if ( references() ) {
        for ( auto* references__elem_ : *references() ) {
            delete references__elem_;
            references__elem_ = nullptr;
        }
    }
    delete references_;
}

int WriteFileRecordResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "WriteFileRecordResponse:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteFileRecordResponse:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "references"
    int t_references__size;
    t_references__size = byte_count();
    // Checking out-of-bound for "WriteFileRecordResponse:references"
    if ( (t_begin_of_data + 1) + (t_references__size) > t_end_of_data || (t_begin_of_data + 1) + (t_references__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WriteFileRecordResponse:references",
        	(1) + (t_references__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_references__size;
        int t_references__arraylength;
        t_references__arraylength = 0;
        references__elem_ = nullptr;
        int t_references__elem__it;
        t_references__elem__it = 0;
        references_ = new vector<ReferenceWithData*>;
        const_byteptr t_references__elem__dataptr = (t_begin_of_data + 1);
        for (; /* forever */; ++t_references__elem__it) {
            // Check &until(references__elem__dataptr >= end_of_data)
            if ( t_references__elem__dataptr >= t_end_of_data ) {
                references__elem_ = nullptr;
                goto end_of_references;
            }
            references__elem_ = new ReferenceWithData();
            int t_references__elem__size;
            t_references__elem__size = references__elem_->Parse(t_references__elem__dataptr, t_end_of_data);
            references_->push_back(references__elem_);
            t_references__elem__dataptr += t_references__elem__size;
            BINPAC_ASSERT(t_references__elem__dataptr <= t_end_of_data);
            references__elem_ = nullptr;
        }
    end_of_references: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_WriteFileRecordResponse__size;
    const_byteptr const t_dataptr_after_references = (t_begin_of_data + 1) + (t_references__size);
    BINPAC_ASSERT(t_dataptr_after_references <= t_end_of_data);
    t_WriteFileRecordResponse__size = t_dataptr_after_references - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_WriteFileRecordResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_WriteFileRecordResponse__size) <= t_end_of_data);
    return t_WriteFileRecordResponse__size;
}

MaskWriteRegisterRequest::MaskWriteRegisterRequest(ModbusTCP_TransportHeader* header) {
    address_ = 0;
    and_mask_ = 0;
    or_mask_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

MaskWriteRegisterRequest::~MaskWriteRegisterRequest() {
}

int MaskWriteRegisterRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "MaskWriteRegisterRequest"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MaskWriteRegisterRequest",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "address"
    address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "and_mask"
    and_mask_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "or_mask"
    or_mask_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_MaskWriteRegisterRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}

MaskWriteRegisterResponse::MaskWriteRegisterResponse(ModbusTCP_TransportHeader* header) {
    address_ = 0;
    and_mask_ = 0;
    or_mask_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

MaskWriteRegisterResponse::~MaskWriteRegisterResponse() {
}

int MaskWriteRegisterResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "MaskWriteRegisterResponse"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MaskWriteRegisterResponse",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "address"
    address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "and_mask"
    and_mask_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "or_mask"
    or_mask_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_MaskWriteRegisterResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}

ReadWriteMultipleRegistersRequest::ReadWriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header) {
    read_start_address_ = 0;
    read_quantity_ = 0;
    write_start_address_ = 0;
    write_quantity_ = 0;
    write_byte_count_ = 0;
    write_register_values_ = nullptr;
    write_register_values__elem_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadWriteMultipleRegistersRequest::~ReadWriteMultipleRegistersRequest() {
    delete write_register_values_;
}

int ReadWriteMultipleRegistersRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadWriteMultipleRegistersRequest:write_byte_count"
    if ( (t_begin_of_data + 8) + (1) > t_end_of_data || (t_begin_of_data + 8) + (1) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersRequest:write_byte_count",
        	(8) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "read_start_address"
    read_start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "read_quantity"
    read_quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "write_start_address"
    write_start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "write_quantity"
    write_quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "write_byte_count"
    write_byte_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));

    // Parse "write_register_values"
    int t_write_register_values__size;
    t_write_register_values__size = write_byte_count();
    // Checking out-of-bound for "ReadWriteMultipleRegistersRequest:write_register_values"
    if ( (t_begin_of_data + 9) + (t_write_register_values__size) > t_end_of_data || (t_begin_of_data + 9) + (t_write_register_values__size) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersRequest:write_register_values",
        	(9) + (t_write_register_values__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 9) + t_write_register_values__size;
        int t_write_register_values__arraylength;
        t_write_register_values__arraylength = write_quantity();
        if ( t_write_register_values__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersRequest:write_register_values",
              t_write_register_values__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: ReadWriteMultipleRegistersRequest:write_register_values
        if ( t_write_register_values__arraylength > ((t_end_of_data - (t_begin_of_data + 9)) / 2) )
            throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersRequest:write_register_values",
              t_write_register_values__arraylength, (t_end_of_data) - ((t_begin_of_data + 9)));
        write_register_values__elem_ = 0;
        int t_write_register_values__elem__it;
        t_write_register_values__elem__it = 0;
        write_register_values_ = new vector<uint16>;
        write_register_values_->reserve(t_write_register_values__arraylength);
        const_byteptr t_write_register_values__elem__dataptr = (t_begin_of_data + 9);
        for (; t_write_register_values__elem__it < t_write_register_values__arraylength; ++t_write_register_values__elem__it) {
            write_register_values__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_write_register_values__elem__dataptr)));
            write_register_values_->push_back(write_register_values__elem_);
            t_write_register_values__elem__dataptr += 2;
            BINPAC_ASSERT(t_write_register_values__elem__dataptr <= t_end_of_data);
        }
    end_of_write_register_values: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_ReadWriteMultipleRegistersRequest__size;
    const_byteptr const t_dataptr_after_write_register_values = (t_begin_of_data + 9) + (t_write_register_values__size);
    BINPAC_ASSERT(t_dataptr_after_write_register_values <= t_end_of_data);
    t_ReadWriteMultipleRegistersRequest__size = t_dataptr_after_write_register_values - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadWriteMultipleRegistersRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadWriteMultipleRegistersRequest__size) <= t_end_of_data);
    return t_ReadWriteMultipleRegistersRequest__size;
}

ReadWriteMultipleRegistersResponse::ReadWriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    registers_ = nullptr;
    registers__elem_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadWriteMultipleRegistersResponse::~ReadWriteMultipleRegistersResponse() {
    delete registers_;
}

int ReadWriteMultipleRegistersResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadWriteMultipleRegistersResponse:byte_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersResponse:byte_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "registers"
    int t_registers__size;
    t_registers__size = byte_count();
    // Checking out-of-bound for "ReadWriteMultipleRegistersResponse:registers"
    if ( (t_begin_of_data + 1) + (t_registers__size) > t_end_of_data || (t_begin_of_data + 1) + (t_registers__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersResponse:registers",
        	(1) + (t_registers__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_registers__size;
        int t_registers__arraylength;
        t_registers__arraylength = byte_count() / 2;
        if ( t_registers__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersResponse:registers",
              t_registers__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: ReadWriteMultipleRegistersResponse:registers
        if ( t_registers__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 2) )
            throw binpac::ExceptionOutOfBound("ReadWriteMultipleRegistersResponse:registers",
              t_registers__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
        registers__elem_ = 0;
        int t_registers__elem__it;
        t_registers__elem__it = 0;
        registers_ = new vector<uint16>;
        registers_->reserve(t_registers__arraylength);
        const_byteptr t_registers__elem__dataptr = (t_begin_of_data + 1);
        for (; t_registers__elem__it < t_registers__arraylength; ++t_registers__elem__it) {
            registers__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_registers__elem__dataptr)));
            registers_->push_back(registers__elem_);
            t_registers__elem__dataptr += 2;
            BINPAC_ASSERT(t_registers__elem__dataptr <= t_end_of_data);
        }
    end_of_registers: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_ReadWriteMultipleRegistersResponse__size;
    const_byteptr const t_dataptr_after_registers = (t_begin_of_data + 1) + (t_registers__size);
    BINPAC_ASSERT(t_dataptr_after_registers <= t_end_of_data);
    t_ReadWriteMultipleRegistersResponse__size = t_dataptr_after_registers - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadWriteMultipleRegistersResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadWriteMultipleRegistersResponse__size) <= t_end_of_data);
    return t_ReadWriteMultipleRegistersResponse__size;
}

ReadFIFOQueueRequest::ReadFIFOQueueRequest(ModbusTCP_TransportHeader* header) {
    start_address_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadFIFOQueueRequest::~ReadFIFOQueueRequest() {
}

int ReadFIFOQueueRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadFIFOQueueRequest"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadFIFOQueueRequest",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_address"
    start_address_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadFIFOQueueRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

ReadFIFOQueueResponse::ReadFIFOQueueResponse(ModbusTCP_TransportHeader* header) {
    byte_count_ = 0;
    fifo_count_ = 0;
    register_data_ = nullptr;
    register_data__elem_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

ReadFIFOQueueResponse::~ReadFIFOQueueResponse() {
    delete register_data_;
}

int ReadFIFOQueueResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "ReadFIFOQueueResponse:fifo_count"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadFIFOQueueResponse:fifo_count",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "fifo_count"
    fifo_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "register_data"
    int t_register_data__size;
    t_register_data__size = fifo_count() * 2;
    // Checking out-of-bound for "ReadFIFOQueueResponse:register_data"
    if ( (t_begin_of_data + 4) + (t_register_data__size) > t_end_of_data || (t_begin_of_data + 4) + (t_register_data__size) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReadFIFOQueueResponse:register_data",
        	(4) + (t_register_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_register_data__size;
        int t_register_data__arraylength;
        t_register_data__arraylength = fifo_count();
        if ( t_register_data__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("ReadFIFOQueueResponse:register_data",
              t_register_data__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: ReadFIFOQueueResponse:register_data
        if ( t_register_data__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 2) )
            throw binpac::ExceptionOutOfBound("ReadFIFOQueueResponse:register_data",
              t_register_data__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
        register_data__elem_ = 0;
        int t_register_data__elem__it;
        t_register_data__elem__it = 0;
        register_data_ = new vector<uint16>;
        register_data_->reserve(t_register_data__arraylength);
        const_byteptr t_register_data__elem__dataptr = (t_begin_of_data + 4);
        for (; t_register_data__elem__it < t_register_data__arraylength; ++t_register_data__elem__it) {
            register_data__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_register_data__elem__dataptr)));
            register_data_->push_back(register_data__elem_);
            t_register_data__elem__dataptr += 2;
            BINPAC_ASSERT(t_register_data__elem__dataptr <= t_end_of_data);
        }
    end_of_register_data: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_ReadFIFOQueueResponse__size;
    const_byteptr const t_dataptr_after_register_data = (t_begin_of_data + 4) + (t_register_data__size);
    BINPAC_ASSERT(t_dataptr_after_register_data <= t_end_of_data);
    t_ReadFIFOQueueResponse__size = t_dataptr_after_register_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_ReadFIFOQueueResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReadFIFOQueueResponse__size) <= t_end_of_data);
    return t_ReadFIFOQueueResponse__size;
}

EncapInterfaceTransportRequest::EncapInterfaceTransportRequest(ModbusTCP_TransportHeader* header) {
    mei_type_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

EncapInterfaceTransportRequest::~EncapInterfaceTransportRequest() {
    data_.free();
}

int EncapInterfaceTransportRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "EncapInterfaceTransportRequest:mei_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EncapInterfaceTransportRequest:mei_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "mei_type"
    mei_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 1));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:412", t_data_string_length);
    data_.init((t_begin_of_data + 1), t_data_string_length);

    int t_EncapInterfaceTransportRequest__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 1) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_EncapInterfaceTransportRequest__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_EncapInterfaceTransportRequest(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_EncapInterfaceTransportRequest__size) <= t_end_of_data);
    return t_EncapInterfaceTransportRequest__size;
}

EncapInterfaceTransportResponse::EncapInterfaceTransportResponse(ModbusTCP_TransportHeader* header) {
    mei_type_ = 0;
    header_ = header;
    byteorder_ = bigendian;
    deliver_ = false;
}

EncapInterfaceTransportResponse::~EncapInterfaceTransportResponse() {
    data_.free();
}

int EncapInterfaceTransportResponse::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context) {
    // Checking out-of-bound for "EncapInterfaceTransportResponse:mei_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EncapInterfaceTransportResponse:mei_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "mei_type"
    mei_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 1));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:420", t_data_string_length);
    data_.init((t_begin_of_data + 1), t_data_string_length);

    int t_EncapInterfaceTransportResponse__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 1) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_EncapInterfaceTransportResponse__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deliver_ = t_context->flow()->deliver_EncapInterfaceTransportResponse(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_EncapInterfaceTransportResponse__size) <= t_end_of_data);
    return t_EncapInterfaceTransportResponse__size;
}

ModbusTCP_Flow::ModbusTCP_Flow(ModbusTCP_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

ModbusTCP_Flow::~ModbusTCP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void ModbusTCP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new ModbusTCP_PDU(is_orig());
                flow_buffer_->NewFrame(0, false);
                context_ = new ContextModbusTCP(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            while ( ! t_dataunit_parsing_complete && flow_buffer_->ready() ) {
                const_byteptr t_begin_of_data = flow_buffer()->begin();
                const_byteptr t_end_of_data = flow_buffer()->end();
                t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
                if ( t_dataunit_parsing_complete ) {
                }
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void ModbusTCP_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void ModbusTCP_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool ModbusTCP_Flow::deliver_message(ModbusTCP_TransportHeader* header) {

		if ( ::modbus_message )
			{
			zeek::BifEvent::enqueue_modbus_message(connection()->zeek_analyzer(),
			                                 connection()->zeek_analyzer()->Conn(),
			                                 HeaderToVal(header),
			                                 is_orig());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ModbusTCP_PDU(ModbusTCP_PDU* message) {

		// We will assume that if an entire PDU from both sides
		// is successfully parsed then this is definitely modbus.
		connection()->SetPDU(message->is_orig());

		if ( ! connection()->IsConfirmed() )
			{
			connection()->SetConfirmed();
			connection()->zeek_analyzer()->AnalyzerConfirmation();
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_Exception(ModbusTCP_TransportHeader* header, ModbusTCP_ExceptResponse* message) {

		if ( ::modbus_exception )
			{
			zeek::BifEvent::enqueue_modbus_exception(connection()->zeek_analyzer(),
			                                   connection()->zeek_analyzer()->Conn(),
			                                   HeaderToVal(header),
			                                   message->code());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadCoilsRequest(ModbusTCP_TransportHeader* header, ReadCoilsRequest* message) {

		if ( ::modbus_read_coils_request )
			{
			zeek::BifEvent::enqueue_modbus_read_coils_request(connection()->zeek_analyzer(),
			                                            connection()->zeek_analyzer()->Conn(),
			                                            HeaderToVal(header),
			                                            message->start_address(),
			                                            message->quantity());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadCoilsResponse(ModbusTCP_TransportHeader* header, ReadCoilsResponse* message) {

		if ( ::modbus_read_coils_response )
			{
			zeek::BifEvent::enqueue_modbus_read_coils_response(connection()->zeek_analyzer(),
			                                             connection()->zeek_analyzer()->Conn(),
			                                             HeaderToVal(header),
			                                             bytestring_to_coils(message->bits(), message->bits().length()*8));
			}
		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadDiscreteInputsRequest(ModbusTCP_TransportHeader* header, ReadDiscreteInputsRequest* message) {

		if ( ::modbus_read_discrete_inputs_request )
			{
			zeek::BifEvent::enqueue_modbus_read_discrete_inputs_request(connection()->zeek_analyzer(),
			                                                      connection()->zeek_analyzer()->Conn(),
			                                                      HeaderToVal(header),
			                                                      message->start_address(), message->quantity());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadDiscreteInputsResponse(ModbusTCP_TransportHeader* header, ReadDiscreteInputsResponse* message) {

		if ( ::modbus_read_discrete_inputs_response )
			{
			zeek::BifEvent::enqueue_modbus_read_discrete_inputs_response(connection()->zeek_analyzer(),
			                                                       connection()->zeek_analyzer()->Conn(),
			                                                       HeaderToVal(header),
			                                                       bytestring_to_coils(message->bits(), message->bits().length()*8));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadHoldingRegistersRequest(ModbusTCP_TransportHeader* header, ReadHoldingRegistersRequest* message) {

		if ( ::modbus_read_holding_registers_request )
			{
			zeek::BifEvent::enqueue_modbus_read_holding_registers_request(connection()->zeek_analyzer(),
			                                                        connection()->zeek_analyzer()->Conn(),
			                                                        HeaderToVal(header),
			                                                        message->start_address(), message->quantity());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadHoldingRegistersResponse(ModbusTCP_TransportHeader* header, ReadHoldingRegistersResponse* message) {

		if ( message->byte_count() % 2 != 0 )
			{
			connection()->zeek_analyzer()->AnalyzerViolation(
			    zeek::util::fmt("invalid value for modbus read holding register response byte count %d", message->byte_count()));
			return false;
			}

		if ( ::modbus_read_holding_registers_response )
			{
			auto t = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusRegisters);

			for ( unsigned int i=0; i < message->registers()->size(); ++i )
				{
				auto r = zeek::val_mgr->Count((*(message->registers()))[i]);
				t->Assign(i, r);
				}

			zeek::BifEvent::enqueue_modbus_read_holding_registers_response(connection()->zeek_analyzer(),
			                                                         connection()->zeek_analyzer()->Conn(),
			                                                         HeaderToVal(header),
			                                                         std::move(t));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadInputRegistersRequest(ModbusTCP_TransportHeader* header, ReadInputRegistersRequest* message) {

		if ( ::modbus_read_input_registers_request )
			{
			zeek::BifEvent::enqueue_modbus_read_input_registers_request(connection()->zeek_analyzer(),
			                                                      connection()->zeek_analyzer()->Conn(),
			                                                      HeaderToVal(header),
			                                                      message->start_address(), message->quantity());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadInputRegistersResponse(ModbusTCP_TransportHeader* header, ReadInputRegistersResponse* message) {

		if ( message->byte_count() % 2 != 0 )
			{
			connection()->zeek_analyzer()->AnalyzerViolation(
			    zeek::util::fmt("invalid value for modbus read input register response byte count %d", message->byte_count()));
			return false;
			}

		if ( ::modbus_read_input_registers_response )
			{
			auto t = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusRegisters);

			for ( unsigned int i=0; i < (message->registers())->size(); ++i )
				{
				auto r = zeek::val_mgr->Count((*(message->registers()))[i]);
				t->Assign(i, r);
				}

			zeek::BifEvent::enqueue_modbus_read_input_registers_response(connection()->zeek_analyzer(),
			                                                       connection()->zeek_analyzer()->Conn(),
			                                                       HeaderToVal(header),
			                                                       std::move(t));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteSingleCoilRequest(ModbusTCP_TransportHeader* header, WriteSingleCoilRequest* message) {

		if ( ::modbus_write_single_coil_request )
			{
			int val;
			if ( message->value() == 0x0000 )
				val = 0;
			else if ( message->value() == 0xFF00 )
				val = 1;
			else
				{
				connection()->zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("invalid value for modbus write single coil request %d",
				                                                    message->value()));
				return false;
				}

			zeek::BifEvent::enqueue_modbus_write_single_coil_request(connection()->zeek_analyzer(),
			                                                   connection()->zeek_analyzer()->Conn(),
			                                                   HeaderToVal(header),
			                                                   message->address(),
			                                                   val);
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteSingleCoilResponse(ModbusTCP_TransportHeader* header, WriteSingleCoilResponse* message) {

		if ( ::modbus_write_single_coil_response )
			{
			int val;
			if ( message->value() == 0x0000 )
				val = 0;
			else if ( message->value() == 0xFF00 )
				val = 1;
			else
				{
				connection()->zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("invalid value for modbus write single coil response %d",
				                                                    message->value()));
				return false;
				}

			zeek::BifEvent::enqueue_modbus_write_single_coil_response(connection()->zeek_analyzer(),
			                                                    connection()->zeek_analyzer()->Conn(),
			                                                    HeaderToVal(header),
			                                                    message->address(),
			                                                    val);
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteSingleRegisterRequest(ModbusTCP_TransportHeader* header, WriteSingleRegisterRequest* message) {

		if ( ::modbus_write_single_register_request )
			{
			zeek::BifEvent::enqueue_modbus_write_single_register_request(connection()->zeek_analyzer(),
			                                                       connection()->zeek_analyzer()->Conn(),
			                                                       HeaderToVal(header),
			                                                       message->address(), message->value());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteSingleRegisterResponse(ModbusTCP_TransportHeader* header, WriteSingleRegisterResponse* message) {

		if ( ::modbus_write_single_register_response )
			{
			zeek::BifEvent::enqueue_modbus_write_single_register_response(connection()->zeek_analyzer(),
			                                                        connection()->zeek_analyzer()->Conn(),
			                                                        HeaderToVal(header),
			                                                        message->address(), message->value());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_DiagnosticsRequest(ModbusTCP_TransportHeader* header, DiagnosticsRequest* message) {

		if ( ::modbus_diagnostics_request )
			{
			auto data = to_stringval(message->data());

			// Data should always be a multiple of two bytes. For everything except
			// "Return Query Data (0x00)" it should be two bytes long.
			if ( data->Len() < 2 || data->Len() % 2 != 0 ||
			     (message->subfunction() != DIAGNOSTICS_RETURN_QUERY_DATA && data->Len() != 2) )
				{
				zeek::reporter->Weird("modbus_diag_invalid_request_data",
				                      zeek::util::fmt("%s", data->CheckString()));
				return false;
				}

			switch (message->subfunction())
				{
				case DIAGNOSTICS_RESTART_COMMUNICATIONS_OPTION:
					// For "Restart Communications Option" it's either 0x0000 or 0xFF00.
					if ( ( data->Bytes()[0] != 0x00 && data->Bytes()[0] != 0xFF ) ||
					     data->Bytes()[1] != 0x00 )
						{
						zeek::reporter->Weird("modbus_diag_invalid_request_data",
						                      zeek::util::fmt("%s", data->CheckString()));
						}
					break;
				case DIAGNOSTICS_RETURN_DIAGNOSTIC_REGISTER:
				case DIAGNOSTICS_FORCE_LISTEN_ONLY_MODE:
				case DIAGNOSTICS_CLEAR_COUNTERS_AND_DIAGNOSTIC_REGISTER:
				case DIAGNOSTICS_RETURN_BUS_MESSAGE_COUNT:
				case DIAGNOSTICS_RETURN_BUS_COMMUNICATION_ERROR_COUNT:
				case DIAGNOSTICS_RETURN_BUS_EXCEPTION_ERROR_COUNT:
				case DIAGNOSTICS_RETURN_SERVER_MESSAGE_COUNT:
				case DIAGNOSTICS_RETURN_SERVER_NO_RESPONSE_COUNT:
				case DIAGNOSTICS_RETURN_SERVER_NAK_COUNT:
				case DIAGNOSTICS_RETURN_SERVER_BUSY_COUNT:
				case DIAGNOSTICS_RETURN_BUS_CHARACTER_OVERRUN_COUNT:
				case DIAGNOSTICS_CLEAR_OVERRUN_COUNTER_AND_FLAG:
					// For all of these subfunctions, the data should be 0x0000.
					if ( data->Bytes()[0] != 0x00 || data->Bytes()[1] != 0x00 )
						{
						zeek::reporter->Weird("modbus_diag_invalid_request_data",
						                      zeek::util::fmt("%s", data->CheckString()));
						}
					break;

				case DIAGNOSTICS_CHANGE_ASCII_INPUT_DELIMITER:
					// For "Change ASCII Input Delimiter", it should be an ascii character
					// followed by a zero.
					if ( ! isascii(data->Bytes()[0]) || data->Bytes()[1] != 0x00 )
						{
						zeek::reporter->Weird("modbus_diag_invalid_request_data",
						                      zeek::util::fmt("%s", data->CheckString()));
						}
					break;

				default:
					zeek::reporter->Weird("modbus_diag_unknown_request_subfunction",
					                      zeek::util::fmt("%d", message->subfunction()));
					break;
				}

			zeek::BifEvent::enqueue_modbus_diagnostics_request(connection()->zeek_analyzer(),
			                                                   connection()->zeek_analyzer()->Conn(),
			                                                   HeaderToVal(header),
			                                                   message->subfunction(), to_stringval(message->data()));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_DiagnosticsResponse(ModbusTCP_TransportHeader* header, DiagnosticsResponse* message) {

		if ( ::modbus_diagnostics_response )
			{
			zeek::BifEvent::enqueue_modbus_diagnostics_response(connection()->zeek_analyzer(),
			                                                    connection()->zeek_analyzer()->Conn(),
			                                                    HeaderToVal(header),
			                                                    message->subfunction(), to_stringval(message->data()));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteMultipleCoilsRequest(ModbusTCP_TransportHeader* header, WriteMultipleCoilsRequest* message) {

		if ( ::modbus_write_multiple_coils_request )
			{
			zeek::BifEvent::enqueue_modbus_write_multiple_coils_request(connection()->zeek_analyzer(),
			                                                      connection()->zeek_analyzer()->Conn(),
			                                                      HeaderToVal(header),
			                                                      message->start_address(),
			                                                      bytestring_to_coils(message->coils(), message->quantity()));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteMultipleCoilsResponse(ModbusTCP_TransportHeader* header, WriteMultipleCoilsResponse* message) {

		if ( ::modbus_write_multiple_coils_response )
			{
			zeek::BifEvent::enqueue_modbus_write_multiple_coils_response(connection()->zeek_analyzer(),
			                                                       connection()->zeek_analyzer()->Conn(),
			                                                       HeaderToVal(header),
			                                                       message->start_address(), message->quantity());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header, WriteMultipleRegistersRequest* message) {

		if ( message->byte_count() % 2 != 0 )
			{
			connection()->zeek_analyzer()->AnalyzerViolation(
			    zeek::util::fmt("invalid value for modbus write multiple registers request byte count %d", message->byte_count()));
			return false;
			}

		if ( ::modbus_write_multiple_registers_request )
			{
			auto t = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusRegisters);

			for ( unsigned int i = 0; i < (message->registers()->size()); ++i )
				{
				auto r = zeek::val_mgr->Count((*(message->registers()))[i]);
				t->Assign(i, r);
				}

				zeek::BifEvent::enqueue_modbus_write_multiple_registers_request(connection()->zeek_analyzer(),
				                                                          connection()->zeek_analyzer()->Conn(),
				                                                          HeaderToVal(header),
				                                                          message->start_address(), std::move(t));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header, WriteMultipleRegistersResponse* message) {

		if ( ::modbus_write_multiple_registers_response )
			{
			zeek::BifEvent::enqueue_modbus_write_multiple_registers_response(connection()->zeek_analyzer(),
			                                                           connection()->zeek_analyzer()->Conn(),
			                                                           HeaderToVal(header),
			                                                           message->start_address(), message->quantity());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadFileRecordRequest(ModbusTCP_TransportHeader* header, ReadFileRecordRequest* message) {

		if ( ::modbus_read_file_record_request )
			{
			auto vect = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusFileRecordRequests);

			for ( const auto& ref : *(message->references()) )
				{
				auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::ModbusFileRecordRequest);

				r->Assign(0, zeek::val_mgr->Count(ref->ref_type()));
				r->Assign(1, zeek::val_mgr->Count(ref->file_num()));
				r->Assign(2, zeek::val_mgr->Count(ref->record_num()));
				r->Assign(3, zeek::val_mgr->Count(ref->record_len()));

				vect->Append(r);
				}

			zeek::BifEvent::enqueue_modbus_read_file_record_request(connection()->zeek_analyzer(),
			                                                connection()->zeek_analyzer()->Conn(),
			                                                HeaderToVal(header), message->byte_count(), vect);
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadFileRecordResponse(ModbusTCP_TransportHeader* header, ReadFileRecordResponse* message) {

		if ( ::modbus_read_file_record_response )
			{
			auto vect = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusFileRecordResponses);

			for ( const auto& ref : *(message->references()) )
				{
				auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::ModbusFileRecordResponse);

				r->Assign(0, zeek::val_mgr->Count(ref->file_len()));
				r->Assign(1, zeek::val_mgr->Count(ref->ref_type()));
				r->Assign(2, to_stringval(ref->record_data()));

				vect->Append(r);
				}

			zeek::BifEvent::enqueue_modbus_read_file_record_response(connection()->zeek_analyzer(),
			                                                   connection()->zeek_analyzer()->Conn(),
			                                                   HeaderToVal(header), message->byte_count(), vect);
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteFileRecordRequest(ModbusTCP_TransportHeader* header, WriteFileRecordRequest* message) {

		if ( ::modbus_write_file_record_request )
			{
			auto vect = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusFileReferences);

			for ( const auto& ref : *(message->references()) )
				{
				auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::ModbusFileReference);
				r->Assign(0, zeek::val_mgr->Count(ref->ref_type()));
				r->Assign(1, zeek::val_mgr->Count(ref->file_num()));
				r->Assign(2, zeek::val_mgr->Count(ref->record_num()));
				r->Assign(3, zeek::val_mgr->Count(ref->record_length()));
				r->Assign(4, to_stringval(ref->record_data()));

				vect->Append(r);
				}

			zeek::BifEvent::enqueue_modbus_write_file_record_request(connection()->zeek_analyzer(),
			                                                   connection()->zeek_analyzer()->Conn(),
			                                                   HeaderToVal(header), message->byte_count(), vect);
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_WriteFileRecordResponse(ModbusTCP_TransportHeader* header, WriteFileRecordResponse* message) {

		if ( ::modbus_write_file_record_response )
			{
			auto vect = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusFileReferences);

			for ( const auto& ref : *(message->references()) )
				{
				auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::ModbusFileReference);
				r->Assign(0, zeek::val_mgr->Count(ref->ref_type()));
				r->Assign(1, zeek::val_mgr->Count(ref->file_num()));
				r->Assign(2, zeek::val_mgr->Count(ref->record_num()));
				r->Assign(3, zeek::val_mgr->Count(ref->record_length()));
				r->Assign(4, to_stringval(ref->record_data()));

				vect->Append(r);
				}

			zeek::BifEvent::enqueue_modbus_write_file_record_response(connection()->zeek_analyzer(),
			                                                    connection()->zeek_analyzer()->Conn(),
			                                                    HeaderToVal(header), message->byte_count(), vect);
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_MaskWriteRegisterRequest(ModbusTCP_TransportHeader* header, MaskWriteRegisterRequest* message) {

		if ( ::modbus_mask_write_register_request )
			{
			zeek::BifEvent::enqueue_modbus_mask_write_register_request(connection()->zeek_analyzer(),
			                                                     connection()->zeek_analyzer()->Conn(),
			                                                     HeaderToVal(header),
			                                                     message->address(),
			                                                     message->and_mask(), message->or_mask());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_MaskWriteRegisterResponse(ModbusTCP_TransportHeader* header, MaskWriteRegisterResponse* message) {

		if ( ::modbus_mask_write_register_response )
			{
			zeek::BifEvent::enqueue_modbus_mask_write_register_response(connection()->zeek_analyzer(),
			                                                      connection()->zeek_analyzer()->Conn(),
			                                                      HeaderToVal(header),
			                                                      message->address(),
			                                                      message->and_mask(), message->or_mask());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadWriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header, ReadWriteMultipleRegistersRequest* message) {

		if ( message->write_byte_count() % 2 != 0 )
			{
			connection()->zeek_analyzer()->AnalyzerViolation(
			    zeek::util::fmt("invalid value for modbus read write multiple registers request write byte count %d", message->write_byte_count()));
			return false;
			}

		if ( ::modbus_read_write_multiple_registers_request )
			{
			auto t = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusRegisters);

			for ( unsigned int i = 0; i < message->write_register_values()->size(); ++i )
				{
				auto r = zeek::val_mgr->Count((*(message->write_register_values()))[i]);
				t->Assign(i, r);
				}

			zeek::BifEvent::enqueue_modbus_read_write_multiple_registers_request(connection()->zeek_analyzer(),
			                                                               connection()->zeek_analyzer()->Conn(),
			                                                               HeaderToVal(header),
			                                                               message->read_start_address(),
			                                                               message->read_quantity(),
			                                                               message->write_start_address(),
			                                                               std::move(t));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadWriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header, ReadWriteMultipleRegistersResponse* message) {

		if ( message->byte_count() % 2 != 0 )
			{
			connection()->zeek_analyzer()->AnalyzerViolation(
			    zeek::util::fmt("invalid value for modbus read write multiple registers response byte count %d", message->byte_count()));
			return false;
			}

		if ( ::modbus_read_write_multiple_registers_response )
			{
			auto t = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusRegisters);

			for ( unsigned int i = 0; i < message->registers()->size(); ++i )
				{
				auto r = zeek::val_mgr->Count((*(message->registers()))[i]);
				t->Assign(i, r);
				}

			zeek::BifEvent::enqueue_modbus_read_write_multiple_registers_response(connection()->zeek_analyzer(),
			                                                                connection()->zeek_analyzer()->Conn(),
			                                                                HeaderToVal(header),
			                                                                std::move(t));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadFIFOQueueRequest(ModbusTCP_TransportHeader* header, ReadFIFOQueueRequest* message) {

		if ( ::modbus_read_fifo_queue_request )
			{
			zeek::BifEvent::enqueue_modbus_read_fifo_queue_request(connection()->zeek_analyzer(),
			                                                 connection()->zeek_analyzer()->Conn(),
			                                                 HeaderToVal(header),
			                                                 message->start_address());
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_ReadFIFOQueueResponse(ModbusTCP_TransportHeader* header, ReadFIFOQueueResponse* message) {

		if ( message->byte_count() % 2 != 0 )
			{
			connection()->zeek_analyzer()->AnalyzerViolation(
			    zeek::util::fmt("invalid value for modbus read FIFO queue response byte count %d", message->byte_count()));
			return false;
			}

		if ( ::modbus_read_fifo_queue_response )
			{
			auto t = create_vector_of_count();

			for ( unsigned int i = 0; i < (message->register_data())->size(); ++i )
				{
				auto r = zeek::val_mgr->Count((*(message->register_data()))[i]);
				t->Assign(i, r);
				}

			zeek::BifEvent::enqueue_modbus_read_fifo_queue_response(connection()->zeek_analyzer(),
			                                                  connection()->zeek_analyzer()->Conn(),
			                                                  HeaderToVal(header),
			                                                  std::move(t));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_EncapInterfaceTransportRequest(ModbusTCP_TransportHeader* header, EncapInterfaceTransportRequest* message) {

		if ( ::modbus_encap_interface_transport_request )
			{
			zeek::BifEvent::enqueue_modbus_encap_interface_transport_request(
			    connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
			    HeaderToVal(header), message->mei_type(), to_stringval(message->data()));
			}

		return true;
		
}

bool ModbusTCP_Flow::deliver_EncapInterfaceTransportResponse(ModbusTCP_TransportHeader* header, EncapInterfaceTransportResponse* message) {

		if ( ::modbus_encap_interface_transport_response )
			{
			zeek::BifEvent::enqueue_modbus_encap_interface_transport_response(
			    connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
			    HeaderToVal(header), message->mei_type(), to_stringval(message->data()));
			}

		return true;
		
}


	zeek::VectorValPtr bytestring_to_coils(const bytestring& coils, uint quantity)
		{
		auto modbus_coils = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::ModbusCoils);

		for ( uint i = 0; i < quantity && (i/8) < static_cast<uint>(coils.length()); i++ )
			{
			char currentCoil = (coils[i/8] >> (i % 8)) % 2;
			modbus_coils->Assign(i, zeek::val_mgr->Bool(currentCoil));
			}

		return modbus_coils;
		}

	zeek::RecordValPtr HeaderToVal(ModbusTCP_TransportHeader* header)
		{
		auto modbus_header = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::ModbusHeaders);
		modbus_header->Assign(0, header->tid());
		modbus_header->Assign(1, header->pid());
		modbus_header->Assign(2, header->uid());
		modbus_header->Assign(3, header->fc());
		modbus_header->Assign(4, header->len());
		return modbus_header;
		}

	zeek::VectorValPtr create_vector_of_count()
		{
		auto vt = zeek::make_intrusive<zeek::VectorType>(zeek::base_type(zeek::TYPE_COUNT));
		auto vv = zeek::make_intrusive<zeek::VectorVal>(std::move(vt));
		return vv;
		}

	
} // namespace ModbusTCP
}  // namespace binpac
