// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/mqtt/mqtt.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/mqtt/mqtt_pac.h"

namespace binpac {






namespace MQTT {
ContextMQTT::ContextMQTT(MQTT_Conn* connection, MQTT_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

ContextMQTT::~ContextMQTT() {
}

MQTT_Conn::MQTT_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new MQTT_Flow(this, true);
    downflow_ = new MQTT_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

MQTT_Conn::~MQTT_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void MQTT_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void MQTT_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void MQTT_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

uint32 MQTT_Conn::calc_header_length(vector<uint8>* vals) {

		int multiplier = 1;
		uint32_t value = 0;

		if ( vals->size() > 4 )
			{
			this->zeek_analyzer()->AnalyzerViolation("malformed MQTT 'remaining length': too many bytes");
			return 0;
			}

		for ( auto encoded_byte: *vals )
			{
			value += (encoded_byte & 127) * multiplier;
			multiplier *= 128;
			if ( multiplier > 128*128*128 )
				{
				// This is definitely a protocol violation
				this->zeek_analyzer()->AnalyzerViolation("malformed MQTT 'remaining length': too large");
				return 0;
				}
			}

		return value;
		
}

MQTT_string::MQTT_string() {
    len_ = 0;
}

MQTT_string::~MQTT_string() {
    str_.free();
}

int MQTT_string::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "MQTT_string:len"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_string:len",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "str"
    int t_str__size;
    t_str__size = len();
    // Checking out-of-bound for "MQTT_string:str"
    if ( (t_begin_of_data + 2) + (t_str__size) > t_end_of_data || (t_begin_of_data + 2) + (t_str__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_string:str",
        	(2) + (t_str__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_str__size;
        int t_str_string_length;
        t_str_string_length = len();
        // check for negative sizes
        if ( t_str_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/mqtt-protocol.pac:23", t_str_string_length);
        str_.init((t_begin_of_data + 2), t_str_string_length);
    }

    int t_MQTT_string__size;
    const_byteptr const t_dataptr_after_str = (t_begin_of_data + 2) + (t_str__size);
    BINPAC_ASSERT(t_dataptr_after_str <= t_end_of_data);
    t_MQTT_string__size = t_dataptr_after_str - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_string__size) <= t_end_of_data);
    return t_MQTT_string__size;
}

Command::Command(MQTT_PDU* pdu, uint8 msg_type) {
    val_case_index_ = -1;
    connect_ = nullptr;
    connack_ = nullptr;
    publish_ = nullptr;
    puback_ = nullptr;
    pubrec_ = nullptr;
    pubrel_ = nullptr;
    pubcomp_ = nullptr;
    subscribe_ = nullptr;
    suback_ = nullptr;
    unsuback_ = nullptr;
    unsubscribe_ = nullptr;
    disconnect_ = nullptr;
    pingreq_ = nullptr;
    pingresp_ = nullptr;
    pdu_ = pdu;
    msg_type_ = msg_type;
}

Command::~Command() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Clean up "connect"
            {
                delete connect_;
                connect_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "connack"
            {
                delete connack_;
                connack_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "publish"
            {
                delete publish_;
                publish_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "puback"
            {
                delete puback_;
                puback_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "pubrec"
            {
                delete pubrec_;
                pubrec_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "pubrel"
            {
                delete pubrel_;
                pubrel_ = nullptr;
            }
            break;
        case ((uint8)7):
            // Clean up "pubcomp"
            {
                delete pubcomp_;
                pubcomp_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "subscribe"
            {
                delete subscribe_;
                subscribe_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "suback"
            {
                delete suback_;
                suback_ = nullptr;
            }
            break;
        case ((uint8)11):
            // Clean up "unsuback"
            {
                delete unsuback_;
                unsuback_ = nullptr;
            }
            break;
        case ((uint8)10):
            // Clean up "unsubscribe"
            {
                delete unsubscribe_;
                unsubscribe_ = nullptr;
            }
            break;
        case ((uint8)14):
            // Clean up "disconnect"
            {
                delete disconnect_;
                disconnect_ = nullptr;
            }
            break;
        case ((uint8)12):
            // Clean up "pingreq"
            {
                delete pingreq_;
                pingreq_ = nullptr;
            }
            break;
        case ((uint8)13):
            // Clean up "pingresp"
            {
                delete pingresp_;
                pingresp_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Command::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Parse "connect"
            {
                connect_ = new MQTT_connect();
                int t_connect__size;
                t_connect__size = connect_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_connect__size;
            }
            break;
        case ((uint8)2):
            // Parse "connack"
            {
                connack_ = new MQTT_connack();
                connack_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 2;
            }
            break;
        case ((uint8)3):
            // Parse "publish"
            {
                publish_ = new MQTT_publish(pdu());
                int t_publish__size;
                t_publish__size = publish_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_publish__size;
            }
            break;
        case ((uint8)4):
            // Parse "puback"
            {
                puback_ = new MQTT_puback(pdu());
                puback_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        case ((uint8)5):
            // Parse "pubrec"
            {
                pubrec_ = new MQTT_pubrec(pdu());
                pubrec_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        case ((uint8)6):
            // Parse "pubrel"
            {
                pubrel_ = new MQTT_pubrel(pdu());
                pubrel_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        case ((uint8)7):
            // Parse "pubcomp"
            {
                pubcomp_ = new MQTT_pubcomp(pdu());
                pubcomp_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        case ((uint8)8):
            // Parse "subscribe"
            {
                subscribe_ = new MQTT_subscribe();
                int t_subscribe__size;
                t_subscribe__size = subscribe_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_subscribe__size;
            }
            break;
        case ((uint8)9):
            // Parse "suback"
            {
                suback_ = new MQTT_suback();
                suback_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 3;
            }
            break;
        case ((uint8)11):
            // Parse "unsuback"
            {
                unsuback_ = new MQTT_unsuback();
                unsuback_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        case ((uint8)10):
            // Parse "unsubscribe"
            {
                unsubscribe_ = new MQTT_unsubscribe();
                int t_unsubscribe__size;
                t_unsubscribe__size = unsubscribe_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_unsubscribe__size;
            }
            break;
        case ((uint8)14):
            // Parse "disconnect"
            {
                disconnect_ = new MQTT_disconnect();
                disconnect_->Parse(nullptr, nullptr, t_context);
                t_val__size = 0;
            }
            break;
        case ((uint8)12):
            // Parse "pingreq"
            {
                pingreq_ = new MQTT_pingreq();
                pingreq_->Parse(nullptr, nullptr, t_context);
                t_val__size = 0;
            }
            break;
        case ((uint8)13):
            // Parse "pingresp"
            {
                pingresp_ = new MQTT_pingresp();
                pingresp_->Parse(nullptr, nullptr, t_context);
                t_val__size = 0;
            }
            break;
        default:
            // Parse "unknown"
            {
                t_val__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

MQTT_PDU::MQTT_PDU(bool is_orig) {
    fixed_header_ = 0;
    remaining_length_ = nullptr;
    remaining_length__elem_ = 0;
    command_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    msg_type_ = 0;
    real_length_ = 0;
}

MQTT_PDU::~MQTT_PDU() {
    delete remaining_length_;
    delete command_;
    command_ = nullptr;
}

int MQTT_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context) {
    // Checking out-of-bound for "MQTT_PDU:fixed_header"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_PDU:fixed_header",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "fixed_header"
    fixed_header_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "remaining_length"
    int t_remaining_length__arraylength;
    t_remaining_length__arraylength = 0;
    remaining_length__elem_ = 0;
    int t_remaining_length__elem__it;
    t_remaining_length__elem__it = 0;
    int t_remaining_length__size;
    remaining_length_ = new vector<uint8>;
    const_byteptr t_remaining_length__elem__dataptr = (t_begin_of_data + 1);
    for (; /* forever */; ++t_remaining_length__elem__it) {
        // Check &until(remaining_length__elem__dataptr >= end_of_data)
        if ( t_remaining_length__elem__dataptr >= t_end_of_data ) {
            goto end_of_remaining_length;
        }
        // Checking out-of-bound for "MQTT_PDU:remaining_length__elem"
        if ( t_remaining_length__elem__dataptr + (1) > t_end_of_data || t_remaining_length__elem__dataptr + (1) < t_remaining_length__elem__dataptr ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("MQTT_PDU:remaining_length__elem",
            	((t_remaining_length__elem__dataptr - t_begin_of_data)) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        remaining_length__elem_ = *(reinterpret_cast<uint8 const*>(t_remaining_length__elem__dataptr));
        remaining_length_->push_back(remaining_length__elem_);
        t_remaining_length__elem__dataptr += 1;
        BINPAC_ASSERT(t_remaining_length__elem__dataptr <= t_end_of_data);
        // Check &until( (  ( $element & ((int) 0x80) )  != ((int) 0x80) ) )
        if (  (  ( remaining_length__elem_ & 0x80 )  != 0x80 )  ) {
            goto end_of_remaining_length;
        }
    }
end_of_remaining_length: ;
    t_remaining_length__size = t_remaining_length__elem__dataptr - ((t_begin_of_data + 1));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_remaining_length = (t_begin_of_data + 1) + (t_remaining_length__size);
    BINPAC_ASSERT(t_dataptr_after_remaining_length <= t_end_of_data);
    // Parse "command"
    msg_type_ =  ( fixed_header() >> 4 ) ;
    command_ = new Command(this, msg_type());
    int t_command__size;
    real_length_ = t_context->connection()->calc_header_length(remaining_length());
    t_command__size = real_length();
    // Checking out-of-bound for "MQTT_PDU:command"
    if ( t_dataptr_after_remaining_length + (t_command__size) > t_end_of_data || t_dataptr_after_remaining_length + (t_command__size) < t_dataptr_after_remaining_length ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_PDU:command",
        	((t_dataptr_after_remaining_length - t_begin_of_data)) + (t_command__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_remaining_length + t_command__size;
        command_->Parse(t_dataptr_after_remaining_length, t_end_of_data, t_context, byteorder());
    }

    int t_MQTT_PDU__size;
    const_byteptr const t_dataptr_after_command = t_dataptr_after_remaining_length + (t_command__size);
    BINPAC_ASSERT(t_dataptr_after_command <= t_end_of_data);
    t_MQTT_PDU__size = t_dataptr_after_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_PDU__size) <= t_end_of_data);
    return t_MQTT_PDU__size;
}

MQTT_Flow::MQTT_Flow(MQTT_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

MQTT_Flow::~MQTT_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void MQTT_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new MQTT_PDU(is_orig());
        context_ = new ContextMQTT(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e;
    }
}

void MQTT_Flow::NewGap(int gap_length) {
}
void MQTT_Flow::FlowEOF() {
}
bool MQTT_Flow::proc_mqtt_connect(MQTT_connect* msg) {

		if ( mqtt_connect )
			{
			auto m = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::MQTT::ConnectMsg);
			m->Assign(0, zeek::make_intrusive<zeek::StringVal>(msg->protocol_name()->str().length(),
			                           reinterpret_cast<const char*>(msg->protocol_name()->str().begin())));
			m->Assign(1, msg->protocol_version());
			m->Assign(2, zeek::make_intrusive<zeek::StringVal>(msg->client_id()->str().length(),
			                           reinterpret_cast<const char*>(msg->client_id()->str().begin())));
			m->AssignInterval(3, double(msg->keep_alive()));

			m->Assign(4, msg->clean_session());
			m->Assign(5, msg->will_retain());
			m->Assign(6, msg->will_qos());

			if ( msg->will_flag() )
				{
				m->Assign(7, zeek::make_intrusive<zeek::StringVal>(msg->will()->topic()->str().length(),
				                           reinterpret_cast<const char*>(msg->will()->topic()->str().begin())));
				m->Assign(8, zeek::make_intrusive<zeek::StringVal>(msg->will()->msg()->str().length(),
				                           reinterpret_cast<const char*>(msg->will()->msg()->str().begin())));
				}

			if ( msg->username() )
				{
				m->Assign(9, zeek::make_intrusive<zeek::StringVal>(msg->uname()->str().length(),
				                           reinterpret_cast<const char*>(msg->uname()->str().begin())));
				}
			if ( msg->password() )
				{
				m->Assign(10, zeek::make_intrusive<zeek::StringVal>(msg->pass()->str().length(),
				                            reinterpret_cast<const char*>(msg->pass()->str().begin())));
				}

			zeek::BifEvent::enqueue_mqtt_connect(connection()->zeek_analyzer(),
			                               connection()->zeek_analyzer()->Conn(),
			                               std::move(m));
			}

		// If a connect message was seen, let's say that confirms it.
		connection()->zeek_analyzer()->AnalyzerConfirmation();
		return true;
		
}

bool MQTT_Flow::proc_mqtt_connack(MQTT_connack* msg) {

		if ( mqtt_connack )
			{
			auto m = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::MQTT::ConnectAckMsg);
			m->Assign(0, msg->return_code());
			m->Assign(1, msg->session_present());
			zeek::BifEvent::enqueue_mqtt_connack(connection()->zeek_analyzer(),
			                               connection()->zeek_analyzer()->Conn(),
			                               std::move(m));
			}

		return true;
		
}

bool MQTT_Flow::proc_mqtt_publish(MQTT_publish* msg, MQTT_PDU* pdu) {

		if ( mqtt_publish )
			{
			auto m = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::MQTT::PublishMsg);
			m->Assign(0, msg->dup());
			m->Assign(1, msg->qos());
			m->Assign(2, msg->retain());
			m->Assign<zeek::StringVal>(3, msg->topic()->str().length(),
			                     reinterpret_cast<const char*>(msg->topic()->str().begin()));

			auto len = msg->payload().length();
			static auto max_payload_size = zeek::id::find("MQTT::max_payload_size");
			auto max = max_payload_size->GetVal()->AsCount();

			if ( len > static_cast<int>(max) )
				len = max;

			m->Assign<zeek::StringVal>(4, len,
			                     reinterpret_cast<const char*>(msg->payload().begin()));

			m->Assign(5, msg->payload().length());

			zeek::BifEvent::enqueue_mqtt_publish(connection()->zeek_analyzer(),
			                               connection()->zeek_analyzer()->Conn(),
			                               pdu->is_orig(),
			                               msg->qos() == 0 ? 0 : msg->msg_id(),
			                               std::move(m));
			}

		// If a publish message was seen, let's say that confirms it.
		connection()->zeek_analyzer()->AnalyzerConfirmation();

		return true;
		
}

bool MQTT_Flow::proc_mqtt_puback(MQTT_puback* msg, bool is_orig) {

		if ( mqtt_puback )
			{
			zeek::BifEvent::enqueue_mqtt_puback(connection()->zeek_analyzer(),
			                              connection()->zeek_analyzer()->Conn(),
			                              is_orig,
			                              msg->msg_id());
			}
		return true;
		
}

bool MQTT_Flow::proc_mqtt_pubrec(MQTT_pubrec* msg, bool is_orig) {

		if ( mqtt_pubrec )
			{
			zeek::BifEvent::enqueue_mqtt_pubrec(connection()->zeek_analyzer(),
			                              connection()->zeek_analyzer()->Conn(),
			                              is_orig,
			                              msg->msg_id());
			}
		return true;
		
}

bool MQTT_Flow::proc_mqtt_pubrel(MQTT_pubrel* msg, bool is_orig) {

		if ( mqtt_pubrel )
			{
			zeek::BifEvent::enqueue_mqtt_pubrel(connection()->zeek_analyzer(),
			                              connection()->zeek_analyzer()->Conn(),
			                              is_orig,
			                              msg->msg_id());
			}
		return true;
		
}

bool MQTT_Flow::proc_mqtt_pubcomp(MQTT_pubcomp* msg, bool is_orig) {

		if ( mqtt_pubcomp )
			{
			zeek::BifEvent::enqueue_mqtt_pubcomp(connection()->zeek_analyzer(),
			                               connection()->zeek_analyzer()->Conn(),
			                               is_orig,
			                               msg->msg_id());
			}
		return true;
		
}

bool MQTT_Flow::proc_mqtt_subscribe(MQTT_subscribe* msg) {

		if ( mqtt_subscribe )
			{
			auto topics = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);
			auto qos_levels = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

			for ( auto topic: *msg->topics() )
				{
				auto subscribe_topic = zeek::make_intrusive<zeek::StringVal>(topic->name()->str().length(),
				                                     reinterpret_cast<const char*>(topic->name()->str().begin()));
				auto qos = zeek::val_mgr->Count(topic->requested_QoS());
				topics->Assign(topics->Size(), std::move(subscribe_topic));
				qos_levels->Assign(qos_levels->Size(), std::move(qos));
				}

			zeek::BifEvent::enqueue_mqtt_subscribe(connection()->zeek_analyzer(),
			                                 connection()->zeek_analyzer()->Conn(),
			                                 msg->msg_id(),
			                                 std::move(topics),
			                                 std::move(qos_levels));
			}

		return true;
		
}

bool MQTT_Flow::proc_mqtt_suback(MQTT_suback* msg) {

		if ( mqtt_suback )
			{
			zeek::BifEvent::enqueue_mqtt_suback(connection()->zeek_analyzer(),
			                              connection()->zeek_analyzer()->Conn(),
			                              msg->msg_id(),
			                              msg->granted_QoS());
			}

		return true;
		
}

bool MQTT_Flow::proc_mqtt_unsuback(MQTT_unsuback* msg) {

		if ( mqtt_unsuback )
			{
			zeek::BifEvent::enqueue_mqtt_unsuback(connection()->zeek_analyzer(),
			                                connection()->zeek_analyzer()->Conn(),
			                                msg->msg_id());
			}

		return true;
		
}

bool MQTT_Flow::proc_mqtt_unsubscribe(MQTT_unsubscribe* msg) {

		if ( mqtt_unsubscribe )
			{
			auto topics = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);

			for ( auto topic: *msg->topics() )
				{
				auto unsubscribe_topic = zeek::make_intrusive<zeek::StringVal>(topic->str().length(),
				                                  reinterpret_cast<const char*>(topic->str().begin()));
				topics->Assign(topics->Size(), std::move(unsubscribe_topic));
				}

			zeek::BifEvent::enqueue_mqtt_unsubscribe(connection()->zeek_analyzer(),
			                                   connection()->zeek_analyzer()->Conn(),
			                                   msg->msg_id(),
			                                   std::move(topics));
			}

		return true;
		
}

bool MQTT_Flow::proc_mqtt_disconnect(MQTT_disconnect* msg) {

		if ( mqtt_disconnect )
			{
			zeek::BifEvent::enqueue_mqtt_disconnect(connection()->zeek_analyzer(),
			                                  connection()->zeek_analyzer()->Conn());
			}

		return true;
		
}

bool MQTT_Flow::proc_mqtt_pingreq(MQTT_pingreq* msg) {

		if ( mqtt_pingreq )
			{
			zeek::BifEvent::enqueue_mqtt_pingreq(connection()->zeek_analyzer(),
			                               connection()->zeek_analyzer()->Conn());
			}

		return true;
		
}

bool MQTT_Flow::proc_mqtt_pingresp(MQTT_pingresp* msg) {

		if ( mqtt_pingresp )
			{
			zeek::BifEvent::enqueue_mqtt_pingresp(connection()->zeek_analyzer(),
			                                connection()->zeek_analyzer()->Conn());
			}

		return true;
		
}

MQTT_will::MQTT_will() {
    topic_ = nullptr;
    msg_ = nullptr;
}

MQTT_will::~MQTT_will() {
    delete topic_;
    topic_ = nullptr;
    delete msg_;
    msg_ = nullptr;
}

int MQTT_will::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "topic"
    topic_ = new MQTT_string();
    int t_topic__size;
    t_topic__size = topic_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_topic = t_begin_of_data + (t_topic__size);
    BINPAC_ASSERT(t_dataptr_after_topic <= t_end_of_data);
    // Parse "msg"
    msg_ = new MQTT_string();
    int t_msg__size;
    t_msg__size = msg_->Parse(t_dataptr_after_topic, t_end_of_data, t_byteorder);

    int t_MQTT_will__size;
    const_byteptr const t_dataptr_after_msg = t_dataptr_after_topic + (t_msg__size);
    BINPAC_ASSERT(t_dataptr_after_msg <= t_end_of_data);
    t_MQTT_will__size = t_dataptr_after_msg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_will__size) <= t_end_of_data);
    return t_MQTT_will__size;
}

MQTT_connect::MQTT_connect() {
    protocol_name_ = nullptr;
    protocol_version_ = 0;
    connect_flags_ = 0;
    keep_alive_ = 0;
    client_id_ = nullptr;
    will_fields_case_index_ = -1;
    will_ = nullptr;
    username_fields_case_index_ = -1;
    uname_ = nullptr;
    password_fields_case_index_ = -1;
    pass_ = nullptr;
    username_ = false;
    password_ = false;
    will_retain_ = false;
    will_qos_ = 0;
    will_flag_ = false;
    clean_session_ = false;
    proc_ = false;
}

MQTT_connect::~MQTT_connect() {
    delete protocol_name_;
    protocol_name_ = nullptr;
    delete client_id_;
    client_id_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( will_fields_case_index() ) {
        case true:
            // Clean up "will"
            {
                delete will_;
                will_ = nullptr;
            }
            break;
        case false:
            // Clean up "nofield1"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( username_fields_case_index() ) {
        case true:
            // Clean up "uname"
            {
                delete uname_;
                uname_ = nullptr;
            }
            break;
        case false:
            // Clean up "nofield2"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( password_fields_case_index() ) {
        case true:
            // Clean up "pass"
            {
                delete pass_;
                pass_ = nullptr;
            }
            break;
        case false:
            // Clean up "nofield3"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int MQTT_connect::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Parse "protocol_name"
    protocol_name_ = new MQTT_string();
    int t_protocol_name__size;
    t_protocol_name__size = protocol_name_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_protocol_name = t_begin_of_data + (t_protocol_name__size);
    BINPAC_ASSERT(t_dataptr_after_protocol_name <= t_end_of_data);
    // Checking out-of-bound for "MQTT_connect:keep_alive"
    if ( (t_dataptr_after_protocol_name + 2) + (2) > t_end_of_data || (t_dataptr_after_protocol_name + 2) + (2) < (t_dataptr_after_protocol_name + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_connect:keep_alive",
        	(((t_dataptr_after_protocol_name + 2) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "protocol_version"
    protocol_version_ = *(reinterpret_cast<int8 const*>(t_dataptr_after_protocol_name));

    // Parse "connect_flags"
    connect_flags_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_protocol_name + 1)));

    // Parse "keep_alive"
    keep_alive_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_protocol_name + 2))));

    // Parse "client_id"
    client_id_ = new MQTT_string();
    int t_client_id__size;
    t_client_id__size = client_id_->Parse((t_dataptr_after_protocol_name + 4), t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_client_id = (t_dataptr_after_protocol_name + 4) + (t_client_id__size);
    BINPAC_ASSERT(t_dataptr_after_client_id <= t_end_of_data);
    // Parse "will_fields"
    int t_will_fields__size;
    will_flag_ =  ( connect_flags() & 0x04 )  != 0;
    will_fields_case_index_ = will_flag();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( will_fields_case_index() ) {
        case true:
            // Parse "will"
            {
                will_ = new MQTT_will();
                int t_will__size;
                t_will__size = will_->Parse(t_dataptr_after_client_id, t_end_of_data, t_byteorder);
                t_will_fields__size = t_will__size;
            }
            break;
        case false:
            // Parse "nofield1"
            {
                t_will_fields__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("MQTT_connect", (int64)will_fields_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_will_fields = t_dataptr_after_client_id + (t_will_fields__size);
    BINPAC_ASSERT(t_dataptr_after_will_fields <= t_end_of_data);
    // Parse "username_fields"
    int t_username_fields__size;
    username_ =  ( connect_flags() & 0x80 )  != 0;
    username_fields_case_index_ = username();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( username_fields_case_index() ) {
        case true:
            // Parse "uname"
            {
                uname_ = new MQTT_string();
                int t_uname__size;
                t_uname__size = uname_->Parse(t_dataptr_after_will_fields, t_end_of_data, t_byteorder);
                t_username_fields__size = t_uname__size;
            }
            break;
        case false:
            // Parse "nofield2"
            {
                t_username_fields__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("MQTT_connect", (int64)username_fields_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_username_fields = t_dataptr_after_will_fields + (t_username_fields__size);
    BINPAC_ASSERT(t_dataptr_after_username_fields <= t_end_of_data);
    // Parse "password_fields"
    int t_password_fields__size;
    password_ =  ( connect_flags() & 0x40 )  != 0;
    password_fields_case_index_ = password();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( password_fields_case_index() ) {
        case true:
            // Parse "pass"
            {
                pass_ = new MQTT_string();
                int t_pass__size;
                t_pass__size = pass_->Parse(t_dataptr_after_username_fields, t_end_of_data, t_byteorder);
                t_password_fields__size = t_pass__size;
            }
            break;
        case false:
            // Parse "nofield3"
            {
                t_password_fields__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("MQTT_connect", (int64)password_fields_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_MQTT_connect__size;
    const_byteptr const t_dataptr_after_password_fields = t_dataptr_after_username_fields + (t_password_fields__size);
    BINPAC_ASSERT(t_dataptr_after_password_fields <= t_end_of_data);
    t_MQTT_connect__size = t_dataptr_after_password_fields - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    will_retain_ =  ( connect_flags() & 0x20 )  != 0;
    will_qos_ =  ( connect_flags() & 0x18 )  >> 3;
    clean_session_ =  ( connect_flags() & 0x02 )  != 0;
    proc_ = t_context->flow()->proc_mqtt_connect(this);
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_connect__size) <= t_end_of_data);
    return t_MQTT_connect__size;
}

MQTT_connack::MQTT_connack() {
    flags_ = 0;
    return_code_ = 0;
    session_present_ = false;
    proc_ = false;
}

MQTT_connack::~MQTT_connack() {
}

int MQTT_connack::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context) {
    // Checking out-of-bound for "MQTT_connack"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_connack",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "return_code"
    return_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    session_present_ =  ( flags() & 0x01 )  != 0;
    proc_ = t_context->flow()->proc_mqtt_connack(this);
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

MQTT_publish::MQTT_publish(MQTT_PDU* pdu) {
    topic_ = nullptr;
    has_msg_id_case_index_ = -1;
    msg_id_ = 0;
    pdu_ = pdu;
    dup_ = false;
    qos_ = 0;
    retain_ = false;
    proc_ = false;
}

MQTT_publish::~MQTT_publish() {
    delete topic_;
    topic_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( has_msg_id_case_index() ) {
        case ((uint8)0):
            // Clean up "none"
            {
            }
            break;
        default:
            // Clean up "msg_id"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    payload_.free();
}

int MQTT_publish::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Parse "topic"
    topic_ = new MQTT_string();
    int t_topic__size;
    t_topic__size = topic_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_topic = t_begin_of_data + (t_topic__size);
    BINPAC_ASSERT(t_dataptr_after_topic <= t_end_of_data);
    // Parse "has_msg_id"
    int t_has_msg_id__size;
    qos_ =  ( pdu()->fixed_header() & 0x06 )  >> 1;
    has_msg_id_case_index_ = qos();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( has_msg_id_case_index() ) {
        case ((uint8)0):
            // Parse "none"
            {
                t_has_msg_id__size = 0;
            }
            break;
        default:
            // Parse "msg_id"
            {
                // Checking out-of-bound for "MQTT_publish:msg_id"
                if ( t_dataptr_after_topic + (2) > t_end_of_data || t_dataptr_after_topic + (2) < t_dataptr_after_topic ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("MQTT_publish:msg_id",
                    	((t_dataptr_after_topic - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_topic)));
                t_has_msg_id__size = 2;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_has_msg_id = t_dataptr_after_topic + (t_has_msg_id__size);
    BINPAC_ASSERT(t_dataptr_after_has_msg_id <= t_end_of_data);
    // Parse "payload"
    int t_payload_string_length;
    t_payload_string_length = (t_end_of_data) - (t_dataptr_after_has_msg_id);
    int t_payload__size;
    t_payload__size = t_payload_string_length;
    // check for negative sizes
    if ( t_payload_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/publish.pac:12", t_payload_string_length);
    payload_.init(t_dataptr_after_has_msg_id, t_payload_string_length);

    int t_MQTT_publish__size;
    const_byteptr const t_dataptr_after_payload = t_dataptr_after_has_msg_id + (t_payload__size);
    BINPAC_ASSERT(t_dataptr_after_payload <= t_end_of_data);
    t_MQTT_publish__size = t_dataptr_after_payload - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    dup_ =  ( pdu()->fixed_header() & 0x08 )  != 0;
    retain_ =  ( pdu()->fixed_header() & 0x01 )  != 0;
    proc_ = t_context->flow()->proc_mqtt_publish(this, pdu());
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_publish__size) <= t_end_of_data);
    return t_MQTT_publish__size;
}

MQTT_puback::MQTT_puback(MQTT_PDU* pdu) {
    msg_id_ = 0;
    pdu_ = pdu;
    proc_ = false;
}

MQTT_puback::~MQTT_puback() {
}

int MQTT_puback::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_puback"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_puback",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_puback(this, pdu()->is_orig());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

MQTT_pubrec::MQTT_pubrec(MQTT_PDU* pdu) {
    msg_id_ = 0;
    pdu_ = pdu;
    proc_ = false;
}

MQTT_pubrec::~MQTT_pubrec() {
}

int MQTT_pubrec::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_pubrec"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_pubrec",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_pubrec(this, pdu()->is_orig());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

MQTT_pubrel::MQTT_pubrel(MQTT_PDU* pdu) {
    msg_id_ = 0;
    pdu_ = pdu;
    proc_ = false;
}

MQTT_pubrel::~MQTT_pubrel() {
}

int MQTT_pubrel::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_pubrel"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_pubrel",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_pubrel(this, pdu()->is_orig());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

MQTT_pubcomp::MQTT_pubcomp(MQTT_PDU* pdu) {
    msg_id_ = 0;
    pdu_ = pdu;
    proc_ = false;
}

MQTT_pubcomp::~MQTT_pubcomp() {
}

int MQTT_pubcomp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_pubcomp"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_pubcomp",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_pubcomp(this, pdu()->is_orig());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

MQTT_subscribe_topic::MQTT_subscribe_topic() {
    name_ = nullptr;
    requested_QoS_ = 0;
}

MQTT_subscribe_topic::~MQTT_subscribe_topic() {
    delete name_;
    name_ = nullptr;
}

int MQTT_subscribe_topic::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "name"
    name_ = new MQTT_string();
    int t_name__size;
    t_name__size = name_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_name = t_begin_of_data + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Checking out-of-bound for "MQTT_subscribe_topic:requested_QoS"
    if ( t_dataptr_after_name + (1) > t_end_of_data || t_dataptr_after_name + (1) < t_dataptr_after_name ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_subscribe_topic:requested_QoS",
        	((t_dataptr_after_name - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "requested_QoS"
    requested_QoS_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_name));

    int t_MQTT_subscribe_topic__size;
    t_MQTT_subscribe_topic__size = (t_dataptr_after_name + 1) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_subscribe_topic__size) <= t_end_of_data);
    return t_MQTT_subscribe_topic__size;
}

MQTT_subscribe::MQTT_subscribe() {
    msg_id_ = 0;
    topics_ = nullptr;
    topics__elem_ = nullptr;
    proc_ = false;
}

MQTT_subscribe::~MQTT_subscribe() {
    delete topics__elem_;
    topics__elem_ = nullptr;
    if ( topics() ) {
        for ( auto* topics__elem_ : *topics() ) {
            delete topics__elem_;
            topics__elem_ = nullptr;
        }
    }
    delete topics_;
}

int MQTT_subscribe::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_subscribe:msg_id"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_subscribe:msg_id",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "topics"
    int t_topics__arraylength;
    t_topics__arraylength = 0;
    topics__elem_ = nullptr;
    int t_topics__elem__it;
    t_topics__elem__it = 0;
    int t_topics__size;
    topics_ = new vector<MQTT_subscribe_topic*>;
    const_byteptr t_topics__elem__dataptr = (t_begin_of_data + 2);
    for (; /* forever */; ++t_topics__elem__it) {
        // Check &until(topics__elem__dataptr >= end_of_data)
        if ( t_topics__elem__dataptr >= t_end_of_data ) {
            topics__elem_ = nullptr;
            goto end_of_topics;
        }
        topics__elem_ = new MQTT_subscribe_topic();
        int t_topics__elem__size;
        t_topics__elem__size = topics__elem_->Parse(t_topics__elem__dataptr, t_end_of_data, t_byteorder);
        topics_->push_back(topics__elem_);
        t_topics__elem__dataptr += t_topics__elem__size;
        BINPAC_ASSERT(t_topics__elem__dataptr <= t_end_of_data);
        topics__elem_ = nullptr;
    }
end_of_topics: ;
    t_topics__size = t_topics__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields

    int t_MQTT_subscribe__size;
    const_byteptr const t_dataptr_after_topics = (t_begin_of_data + 2) + (t_topics__size);
    BINPAC_ASSERT(t_dataptr_after_topics <= t_end_of_data);
    t_MQTT_subscribe__size = t_dataptr_after_topics - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_subscribe(this);
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_subscribe__size) <= t_end_of_data);
    return t_MQTT_subscribe__size;
}

MQTT_suback::MQTT_suback() {
    msg_id_ = 0;
    granted_QoS_ = 0;
    proc_ = false;
}

MQTT_suback::~MQTT_suback() {
}

int MQTT_suback::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_suback"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_suback",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "granted_QoS"
    granted_QoS_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_suback(this);
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

MQTT_unsuback::MQTT_unsuback() {
    msg_id_ = 0;
    proc_ = false;
}

MQTT_unsuback::~MQTT_unsuback() {
}

int MQTT_unsuback::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_unsuback"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_unsuback",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_unsuback(this);
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

MQTT_unsubscribe::MQTT_unsubscribe() {
    msg_id_ = 0;
    topics_ = nullptr;
    topics__elem_ = nullptr;
    proc_ = false;
}

MQTT_unsubscribe::~MQTT_unsubscribe() {
    delete topics__elem_;
    topics__elem_ = nullptr;
    if ( topics() ) {
        for ( auto* topics__elem_ : *topics() ) {
            delete topics__elem_;
            topics__elem_ = nullptr;
        }
    }
    delete topics_;
}

int MQTT_unsubscribe::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder) {
    // Checking out-of-bound for "MQTT_unsubscribe:msg_id"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MQTT_unsubscribe:msg_id",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_id"
    msg_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "topics"
    int t_topics__arraylength;
    t_topics__arraylength = 0;
    topics__elem_ = nullptr;
    int t_topics__elem__it;
    t_topics__elem__it = 0;
    int t_topics__size;
    topics_ = new vector<MQTT_string*>;
    const_byteptr t_topics__elem__dataptr = (t_begin_of_data + 2);
    for (; /* forever */; ++t_topics__elem__it) {
        // Check &until(topics__elem__dataptr >= end_of_data)
        if ( t_topics__elem__dataptr >= t_end_of_data ) {
            topics__elem_ = nullptr;
            goto end_of_topics;
        }
        topics__elem_ = new MQTT_string();
        int t_topics__elem__size;
        t_topics__elem__size = topics__elem_->Parse(t_topics__elem__dataptr, t_end_of_data, t_byteorder);
        topics_->push_back(topics__elem_);
        t_topics__elem__dataptr += t_topics__elem__size;
        BINPAC_ASSERT(t_topics__elem__dataptr <= t_end_of_data);
        topics__elem_ = nullptr;
    }
end_of_topics: ;
    t_topics__size = t_topics__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields

    int t_MQTT_unsubscribe__size;
    const_byteptr const t_dataptr_after_topics = (t_begin_of_data + 2) + (t_topics__size);
    BINPAC_ASSERT(t_dataptr_after_topics <= t_end_of_data);
    t_MQTT_unsubscribe__size = t_dataptr_after_topics - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_unsubscribe(this);
    BINPAC_ASSERT(t_begin_of_data + (t_MQTT_unsubscribe__size) <= t_end_of_data);
    return t_MQTT_unsubscribe__size;
}

MQTT_disconnect::MQTT_disconnect() {
    proc_ = false;
}

MQTT_disconnect::~MQTT_disconnect() {
}

int MQTT_disconnect::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context) {
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_disconnect(this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

MQTT_pingreq::MQTT_pingreq() {
    proc_ = false;
}

MQTT_pingreq::~MQTT_pingreq() {
}

int MQTT_pingreq::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context) {
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_pingreq(this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

MQTT_pingresp::MQTT_pingresp() {
    proc_ = false;
}

MQTT_pingresp::~MQTT_pingresp() {
}

int MQTT_pingresp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context) {
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_mqtt_pingresp(this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

} // namespace MQTT
}  // namespace binpac
