// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/mysql/mysql_pac.h"

namespace binpac {






namespace MySQL {
ContextMySQL::ContextMySQL(MySQL_Conn* connection, MySQL_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextMySQL::~ContextMySQL() {
}

MySQL_Conn::MySQL_Conn(MySQLAnalyzer const& zeek_analyzer) {
    upflow_ = new MySQL_Flow(this, true);
    downflow_ = new MySQL_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		version_ = 0;
		previous_seq_id_ = 0;
		state_ = CONNECTION_PHASE;
		expected_ = EXPECT_STATUS;
		conn_expected_ = EXPECT_HANDSHAKE;
		col_count_ = 0;
		remaining_cols_ = 0;
		results_seen_ = 0;
		deprecate_eof_ = false;
		server_query_attrs_ = false;
		client_query_attrs_ = false;
		client_capabilities_ = 0;
		query_attr_idx_ = 0;
	
}

MySQL_Conn::~MySQL_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void MySQL_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void MySQL_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void MySQL_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

uint8 MySQL_Conn::get_version() {

		return version_;
		
}

bool MySQL_Conn::set_version(uint8 v) {

		version_ = v;
		return true;
		
}

uint8 MySQL_Conn::get_previous_seq_id() {

		return previous_seq_id_;
		
}

bool MySQL_Conn::set_previous_seq_id(uint8 s) {

		previous_seq_id_ = s;
		return true;
		
}

int MySQL_Conn::get_state() {

		return state_;
		
}

bool MySQL_Conn::update_state(state s) {

		state_ = s;

		if ( s == COMMAND_PHASE )
			conn_expected_ = EXPECT_HANDSHAKE; // Reset connection phase expectation

		return true;
		
}

bool MySQL_Conn::get_deprecate_eof() {

		return deprecate_eof_;
		
}

bool MySQL_Conn::set_deprecate_eof(bool d) {

		deprecate_eof_ = d;
		return true;
		
}

bool MySQL_Conn::get_server_query_attrs() {

		return server_query_attrs_;
		
}

bool MySQL_Conn::set_server_query_attrs(bool q) {

		server_query_attrs_ = q;
		return true;
		
}

bool MySQL_Conn::get_client_query_attrs() {

		return client_query_attrs_;
		
}

bool MySQL_Conn::set_client_query_attrs(bool q) {

		client_query_attrs_ = q;
		return true;
		
}

bool MySQL_Conn::set_client_capabilities(uint32 c) {

		client_capabilities_ = c;
		return true;
		
}

uint32 MySQL_Conn::get_client_capabilities() {

		return client_capabilities_;
		
}

Expected MySQL_Conn::get_expectation() {

		return expected_;
		
}

bool MySQL_Conn::set_next_expected(Expected e) {

		expected_ = e;
		return true;
		
}

ConnectionExpected MySQL_Conn::get_conn_expectation() {

		return conn_expected_;
		
}

bool MySQL_Conn::set_next_conn_expected(ConnectionExpected c) {

		conn_expected_ = c;
		return true;
		
}

bool MySQL_Conn::set_next_expected_from_command(uint8 cmd) {

		switch ( cmd ) {
		case COM_SLEEP:
		case COM_QUIT:
		case COM_INIT_DB:
		case COM_CREATE_DB:
		case COM_DROP_DB:
		case COM_REFRESH:
		case COM_SHUTDOWN:
		case COM_CONNECT:
		case COM_PROCESS_KILL:
		case COM_DEBUG:
		case COM_PING:
		case COM_TIME:
		case COM_DELAYED_INSERT:
		case COM_DAEMON:
		case COM_RESET_CONNECTION:
			expected_ = EXPECT_STATUS;
			break;
		case COM_QUERY:
		case COM_PROCESS_INFO:
			expected_ = EXPECT_COLUMN_COUNT;
			break;
		case COM_FIELD_LIST:
			expected_ = EXPECT_COLUMN_DEFINITION_OR_EOF;
			break;
		case COM_STATISTICS:
			expected_ = EXPECT_REST_OF_PACKET;
			break;
		case COM_CHANGE_USER:
			update_state(CONNECTION_PHASE);
			break;
		case COM_BINLOG_DUMP:
		case COM_TABLE_DUMP:
		case COM_CONNECT_OUT:
		case COM_REGISTER_SLAVE:
		case COM_STMT_PREPARE:
		case COM_STMT_EXECUTE:
		case COM_STMT_SEND_LONG_DATA:
		case COM_STMT_CLOSE:
		case COM_STMT_RESET:
		case COM_SET_OPTION:
		case COM_STMT_FETCH:
		case COM_BINLOG_DUMP_GTID:
		default:
			expected_ = NO_EXPECTATION;
			break;
		}
		return true;
		
}

uint32 MySQL_Conn::get_col_count() {

		return col_count_;
		
}

bool MySQL_Conn::set_col_count(uint32 i) {

		col_count_ = i;
		return true;
		
}

uint32 MySQL_Conn::get_remaining_cols() {

		return remaining_cols_;
		
}

bool MySQL_Conn::set_remaining_cols(uint32 i) {

		remaining_cols_ = i;
		return true;
		
}

bool MySQL_Conn::dec_remaining_cols() {

		--remaining_cols_;
		return true;
		
}

uint32 MySQL_Conn::get_results_seen() {

		return results_seen_;
		
}

bool MySQL_Conn::set_results_seen(uint32 i) {

		results_seen_ = i;
		return true;
		
}

bool MySQL_Conn::inc_results_seen() {

		++results_seen_;
		return true;
		
}

int MySQL_Conn::query_attr_idx() {

		return query_attr_idx_;
		
}

bool MySQL_Conn::new_query_attrs() {

		query_attr_idx_ = 0;
		return true;
		
}

bool MySQL_Conn::next_query_attr() {

		query_attr_idx_++;
		return true;
		
}

uint24le::uint24le() {
    byte3_ = 0;
    byte2_ = 0;
    byte1_ = 0;
}

uint24le::~uint24le() {
}

int uint24le::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint24le"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint24le",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

LengthEncodedInteger::LengthEncodedInteger() {
    length_ = 0;
    integer_ = nullptr;
}

LengthEncodedInteger::~LengthEncodedInteger() {
    delete integer_;
    integer_ = nullptr;
}

int LengthEncodedInteger::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "LengthEncodedInteger:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("LengthEncodedInteger:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "integer"
    integer_ = new LengthEncodedIntegerLookahead(length());
    int t_integer__size;
    t_integer__size = integer_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);

    int t_LengthEncodedInteger__size;
    const_byteptr const t_dataptr_after_integer = (t_begin_of_data + 1) + (t_integer__size);
    BINPAC_ASSERT(t_dataptr_after_integer <= t_end_of_data);
    t_LengthEncodedInteger__size = t_dataptr_after_integer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_LengthEncodedInteger__size) <= t_end_of_data);
    return t_LengthEncodedInteger__size;
}

LengthEncodedIntegerArg::LengthEncodedIntegerArg(uint8 length) {
    integer_ = nullptr;
    length_ = length;
}

LengthEncodedIntegerArg::~LengthEncodedIntegerArg() {
    delete integer_;
    integer_ = nullptr;
}

int LengthEncodedIntegerArg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "integer"
    integer_ = new LengthEncodedIntegerLookahead(length());
    int t_integer__size;
    t_integer__size = integer_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    int t_LengthEncodedIntegerArg__size;
    const_byteptr const t_dataptr_after_integer = t_begin_of_data + (t_integer__size);
    BINPAC_ASSERT(t_dataptr_after_integer <= t_end_of_data);
    t_LengthEncodedIntegerArg__size = t_dataptr_after_integer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_LengthEncodedIntegerArg__size) <= t_end_of_data);
    return t_LengthEncodedIntegerArg__size;
}

LengthEncodedIntegerLookahead::LengthEncodedIntegerLookahead(uint8 length) {
    val_case_index_ = -1;
    i2_ = 0;
    i3_ = nullptr;
    i4_ = 0;
    length_ = length;
}

LengthEncodedIntegerLookahead::~LengthEncodedIntegerLookahead() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)251):
            // Clean up "i0"
            {
            }
            break;
        case ((uint8)252):
            // Clean up "i2"
            {
            }
            break;
        case ((uint8)253):
            // Clean up "i3"
            {
                delete i3_;
                i3_ = nullptr;
            }
            break;
        case ((uint8)254):
            // Clean up "i4"
            {
            }
            break;
        case ((uint8)255):
            // Clean up "err_packet"
            {
            }
            break;
        default:
            // Clean up "one"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int LengthEncodedIntegerLookahead::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "val"
    int t_val__size;
    val_case_index_ = length();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)251):
            // Parse "i0"
            {
                t_val__size = 0;
            }
            break;
        case ((uint8)252):
            // Parse "i2"
            {
                // Checking out-of-bound for "LengthEncodedIntegerLookahead:i2"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("LengthEncodedIntegerLookahead:i2",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                i2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
                t_val__size = 2;
            }
            break;
        case ((uint8)253):
            // Parse "i3"
            {
                i3_ = new uint24le();
                i3_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = 3;
            }
            break;
        case ((uint8)254):
            // Parse "i4"
            {
                // Checking out-of-bound for "LengthEncodedIntegerLookahead:i4"
                if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("LengthEncodedIntegerLookahead:i4",
                    	(0) + (8), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                i4_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_begin_of_data)));
                t_val__size = 8;
            }
            break;
        case ((uint8)255):
            // Parse "err_packet"
            {
                t_val__size = 0;
            }
            break;
        default:
            // Parse "one"
            {
                t_val__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_LengthEncodedIntegerLookahead__size;
    const_byteptr const t_dataptr_after_val = t_begin_of_data + (t_val__size);
    BINPAC_ASSERT(t_dataptr_after_val <= t_end_of_data);
    t_LengthEncodedIntegerLookahead__size = t_dataptr_after_val - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_LengthEncodedIntegerLookahead__size) <= t_end_of_data);
    return t_LengthEncodedIntegerLookahead__size;
}

LengthEncodedString::LengthEncodedString() {
    len_ = nullptr;
}

LengthEncodedString::~LengthEncodedString() {
    delete len_;
    len_ = nullptr;
    val_.free();
}

int LengthEncodedString::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "len"
    len_ = new LengthEncodedInteger();
    int t_len__size;
    t_len__size = len_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_len = t_begin_of_data + (t_len__size);
    BINPAC_ASSERT(t_dataptr_after_len <= t_end_of_data);
    // Parse "val"
    int t_val__size;
    t_val__size = to_int()(len());
    // Checking out-of-bound for "LengthEncodedString:val"
    if ( t_dataptr_after_len + (t_val__size) > t_end_of_data || t_dataptr_after_len + (t_val__size) < t_dataptr_after_len ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("LengthEncodedString:val",
        	((t_dataptr_after_len - t_begin_of_data)) + (t_val__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_len + t_val__size;
        int t_val_string_length;
        t_val_string_length = to_int()(len());
        // check for negative sizes
        if ( t_val_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:37", t_val_string_length);
        val_.init(t_dataptr_after_len, t_val_string_length);
    }

    int t_LengthEncodedString__size;
    const_byteptr const t_dataptr_after_val = t_dataptr_after_len + (t_val__size);
    BINPAC_ASSERT(t_dataptr_after_val <= t_end_of_data);
    t_LengthEncodedString__size = t_dataptr_after_val - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_LengthEncodedString__size) <= t_end_of_data);
    return t_LengthEncodedString__size;
}

LengthEncodedStringArg::LengthEncodedStringArg(uint8 first_byte) {
    len_ = nullptr;
    first_byte_ = first_byte;
}

LengthEncodedStringArg::~LengthEncodedStringArg() {
    delete len_;
    len_ = nullptr;
    val_.free();
}

int LengthEncodedStringArg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "len"
    len_ = new LengthEncodedIntegerArg(first_byte());
    int t_len__size;
    t_len__size = len_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_len = t_begin_of_data + (t_len__size);
    BINPAC_ASSERT(t_dataptr_after_len <= t_end_of_data);
    // Parse "val"
    int t_val__size;
    t_val__size = to_int()(len());
    // Checking out-of-bound for "LengthEncodedStringArg:val"
    if ( t_dataptr_after_len + (t_val__size) > t_end_of_data || t_dataptr_after_len + (t_val__size) < t_dataptr_after_len ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("LengthEncodedStringArg:val",
        	((t_dataptr_after_len - t_begin_of_data)) + (t_val__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_len + t_val__size;
        int t_val_string_length;
        t_val_string_length = to_int()(len());
        // check for negative sizes
        if ( t_val_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:42", t_val_string_length);
        val_.init(t_dataptr_after_len, t_val_string_length);
    }

    int t_LengthEncodedStringArg__size;
    const_byteptr const t_dataptr_after_val = t_dataptr_after_len + (t_val__size);
    BINPAC_ASSERT(t_dataptr_after_val <= t_end_of_data);
    t_LengthEncodedStringArg__size = t_dataptr_after_val - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_LengthEncodedStringArg__size) <= t_end_of_data);
    return t_LengthEncodedStringArg__size;
}

Date::Date() {
    year_ = 0;
    month_ = 0;
    day_ = 0;
}

Date::~Date() {
}

int Date::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "Date"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Date",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "year"
    year_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int16 const*>(t_begin_of_data)));

    // Parse "month"
    month_ = *(reinterpret_cast<int8 const*>((t_begin_of_data + 2)));

    // Parse "day"
    day_ = *(reinterpret_cast<int8 const*>((t_begin_of_data + 3)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

Time::Time() {
    hour_ = 0;
    minute_ = 0;
    second_ = 0;
}

Time::~Time() {
}

int Time::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Time"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Time",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "hour"
    hour_ = *(reinterpret_cast<int8 const*>(t_begin_of_data));

    // Parse "minute"
    minute_ = *(reinterpret_cast<int8 const*>((t_begin_of_data + 1)));

    // Parse "second"
    second_ = *(reinterpret_cast<int8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

BinaryDate::BinaryDate() {
    len_ = 0;
    have_date_case_index_ = -1;
    date_ = nullptr;
    have_time_case_index_ = -1;
    time_ = nullptr;
    have_micros_case_index_ = -1;
    micros_ = 0;
}

BinaryDate::~BinaryDate() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_date_case_index() ) {
        case ((int)1):
            // Clean up "date"
            {
                delete date_;
                date_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "none_1"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_time_case_index() ) {
        case ((int)1):
            // Clean up "time"
            {
                delete time_;
                time_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "none_2"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_micros_case_index() ) {
        case ((int)1):
            // Clean up "micros"
            {
            }
            break;
        case ((int)0):
            // Clean up "none_3"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int BinaryDate::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "BinaryDate:len"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinaryDate:len",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
    // Evaluate '&enforce' attribute
    if (! ( len() == 0 || len() == 4 || len() == 7 || len() == 11 ) ) {
        throw binpac::ExceptionEnforceViolation("BinaryDate:len");
    }

    // Parse "have_date"
    int t_have_date__size;
    have_date_case_index_ =  ( len() > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_date_case_index() ) {
        case ((int)1):
            // Parse "date"
            {
                date_ = new Date();
                date_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_have_date__size = 4;
            }
            break;
        case ((int)0):
            // Parse "none_1"
            {
                t_have_date__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("BinaryDate", (int64)have_date_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_date = (t_begin_of_data + 1) + (t_have_date__size);
    BINPAC_ASSERT(t_dataptr_after_have_date <= t_end_of_data);
    // Parse "have_time"
    int t_have_time__size;
    have_time_case_index_ =  ( len() > 4 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_time_case_index() ) {
        case ((int)1):
            // Parse "time"
            {
                time_ = new Time();
                time_->Parse(t_dataptr_after_have_date, t_end_of_data);
                t_have_time__size = 3;
            }
            break;
        case ((int)0):
            // Parse "none_2"
            {
                t_have_time__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("BinaryDate", (int64)have_time_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_time = t_dataptr_after_have_date + (t_have_time__size);
    BINPAC_ASSERT(t_dataptr_after_have_time <= t_end_of_data);
    // Parse "have_micros"
    int t_have_micros__size;
    have_micros_case_index_ =  ( len() > 7 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_micros_case_index() ) {
        case ((int)1):
            // Parse "micros"
            {
                // Checking out-of-bound for "BinaryDate:micros"
                if ( t_dataptr_after_have_time + (4) > t_end_of_data || t_dataptr_after_have_time + (4) < t_dataptr_after_have_time ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryDate:micros",
                    	((t_dataptr_after_have_time - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                micros_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int32 const*>(t_dataptr_after_have_time)));
                t_have_micros__size = 4;
            }
            break;
        case ((int)0):
            // Parse "none_3"
            {
                t_have_micros__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("BinaryDate", (int64)have_micros_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_BinaryDate__size;
    const_byteptr const t_dataptr_after_have_micros = t_dataptr_after_have_time + (t_have_micros__size);
    BINPAC_ASSERT(t_dataptr_after_have_micros <= t_end_of_data);
    t_BinaryDate__size = t_dataptr_after_have_micros - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_BinaryDate__size) <= t_end_of_data);
    return t_BinaryDate__size;
}

DurationTime::DurationTime() {
    is_negative_ = 0;
    days_ = 0;
    time_ = nullptr;
}

DurationTime::~DurationTime() {
    delete time_;
    time_ = nullptr;
}

int DurationTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "DurationTime"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DurationTime",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "is_negative"
    is_negative_ = *(reinterpret_cast<int8 const*>(t_begin_of_data));
    // Evaluate '&enforce' attribute
    if (! ( is_negative() == 0 || is_negative() == 1 ) ) {
        throw binpac::ExceptionEnforceViolation("DurationTime:is_negative");
    }

    // Parse "days"
    days_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Parse "time"
    time_ = new Time();
    time_->Parse((t_begin_of_data + 5), t_end_of_data);

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

BinaryTime::BinaryTime() {
    len_ = 0;
    have_time_case_index_ = -1;
    time_ = nullptr;
    have_micros_case_index_ = -1;
    micros_ = 0;
}

BinaryTime::~BinaryTime() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_time_case_index() ) {
        case ((int)1):
            // Clean up "time"
            {
                delete time_;
                time_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "none_1"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_micros_case_index() ) {
        case ((int)1):
            // Clean up "micros"
            {
            }
            break;
        case ((int)0):
            // Clean up "none_2"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int BinaryTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "BinaryTime:len"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinaryTime:len",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
    // Evaluate '&enforce' attribute
    if (! ( len() == 0 || len() == 8 || len() == 12 ) ) {
        throw binpac::ExceptionEnforceViolation("BinaryTime:len");
    }

    // Parse "have_time"
    int t_have_time__size;
    have_time_case_index_ =  ( len() > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_time_case_index() ) {
        case ((int)1):
            // Parse "time"
            {
                time_ = new DurationTime();
                time_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_have_time__size = 8;
            }
            break;
        case ((int)0):
            // Parse "none_1"
            {
                t_have_time__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("BinaryTime", (int64)have_time_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_time = (t_begin_of_data + 1) + (t_have_time__size);
    BINPAC_ASSERT(t_dataptr_after_have_time <= t_end_of_data);
    // Parse "have_micros"
    int t_have_micros__size;
    have_micros_case_index_ =  ( len() > 8 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_micros_case_index() ) {
        case ((int)1):
            // Parse "micros"
            {
                // Checking out-of-bound for "BinaryTime:micros"
                if ( t_dataptr_after_have_time + (4) > t_end_of_data || t_dataptr_after_have_time + (4) < t_dataptr_after_have_time ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryTime:micros",
                    	((t_dataptr_after_have_time - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                micros_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int32 const*>(t_dataptr_after_have_time)));
                t_have_micros__size = 4;
            }
            break;
        case ((int)0):
            // Parse "none_2"
            {
                t_have_micros__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("BinaryTime", (int64)have_micros_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_BinaryTime__size;
    const_byteptr const t_dataptr_after_have_micros = t_dataptr_after_have_time + (t_have_micros__size);
    BINPAC_ASSERT(t_dataptr_after_have_micros <= t_end_of_data);
    t_BinaryTime__size = t_dataptr_after_have_micros - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_BinaryTime__size) <= t_end_of_data);
    return t_BinaryTime__size;
}

BinaryValue::BinaryValue(uint16 type) {
    value_case_index_ = -1;
    decimal_val_ = nullptr;
    tiny_val_ = 0;
    short_val_ = 0;
    long_val_ = 0;
    timestamp_val_ = nullptr;
    longlong_val_ = 0;
    int24_val_ = 0;
    date_val_ = nullptr;
    time_val_ = nullptr;
    datetime_val_ = nullptr;
    year_val_ = 0;
    varchar_val_ = nullptr;
    bit_val_ = nullptr;
    timestamp2_val_ = nullptr;
    json_val_ = nullptr;
    newdecimal_val_ = nullptr;
    enum_val_ = nullptr;
    set_val_ = nullptr;
    tinyblob_val_ = nullptr;
    mediumblob_val_ = nullptr;
    longblob_val_ = nullptr;
    blob_val_ = nullptr;
    varstring_val_ = nullptr;
    string_val_ = nullptr;
    geometry_val_ = nullptr;
    type_ = type;
}

BinaryValue::~BinaryValue() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( value_case_index() ) {
        case ((uint16)0):
            // Clean up "decimal_val"
            {
                delete decimal_val_;
                decimal_val_ = nullptr;
            }
            break;
        case ((uint16)1):
            // Clean up "tiny_val"
            {
            }
            break;
        case ((uint16)2):
            // Clean up "short_val"
            {
            }
            break;
        case ((uint16)3):
            // Clean up "long_val"
            {
            }
            break;
        case ((uint16)4):
            // Clean up "float_val"
            {
                float_val_.free();
            }
            break;
        case ((uint16)5):
            // Clean up "double_val"
            {
                double_val_.free();
            }
            break;
        case ((uint16)6):
            // Clean up "null_val"
            {
            }
            break;
        case ((uint16)7):
            // Clean up "timestamp_val"
            {
                delete timestamp_val_;
                timestamp_val_ = nullptr;
            }
            break;
        case ((uint16)8):
            // Clean up "longlong_val"
            {
            }
            break;
        case ((uint16)9):
            // Clean up "int24_val"
            {
            }
            break;
        case ((uint16)10):
            // Clean up "date_val"
            {
                delete date_val_;
                date_val_ = nullptr;
            }
            break;
        case ((uint16)11):
            // Clean up "time_val"
            {
                delete time_val_;
                time_val_ = nullptr;
            }
            break;
        case ((uint16)12):
            // Clean up "datetime_val"
            {
                delete datetime_val_;
                datetime_val_ = nullptr;
            }
            break;
        case ((uint16)13):
            // Clean up "year_val"
            {
            }
            break;
        case ((uint16)15):
            // Clean up "varchar_val"
            {
                delete varchar_val_;
                varchar_val_ = nullptr;
            }
            break;
        case ((uint16)16):
            // Clean up "bit_val"
            {
                delete bit_val_;
                bit_val_ = nullptr;
            }
            break;
        case ((uint16)17):
            // Clean up "timestamp2_val"
            {
                delete timestamp2_val_;
                timestamp2_val_ = nullptr;
            }
            break;
        case ((uint16)245):
            // Clean up "json_val"
            {
                delete json_val_;
                json_val_ = nullptr;
            }
            break;
        case ((uint16)246):
            // Clean up "newdecimal_val"
            {
                delete newdecimal_val_;
                newdecimal_val_ = nullptr;
            }
            break;
        case ((uint16)247):
            // Clean up "enum_val"
            {
                delete enum_val_;
                enum_val_ = nullptr;
            }
            break;
        case ((uint16)248):
            // Clean up "set_val"
            {
                delete set_val_;
                set_val_ = nullptr;
            }
            break;
        case ((uint16)249):
            // Clean up "tinyblob_val"
            {
                delete tinyblob_val_;
                tinyblob_val_ = nullptr;
            }
            break;
        case ((uint16)250):
            // Clean up "mediumblob_val"
            {
                delete mediumblob_val_;
                mediumblob_val_ = nullptr;
            }
            break;
        case ((uint16)251):
            // Clean up "longblob_val"
            {
                delete longblob_val_;
                longblob_val_ = nullptr;
            }
            break;
        case ((uint16)252):
            // Clean up "blob_val"
            {
                delete blob_val_;
                blob_val_ = nullptr;
            }
            break;
        case ((uint16)253):
            // Clean up "varstring_val"
            {
                delete varstring_val_;
                varstring_val_ = nullptr;
            }
            break;
        case ((uint16)254):
            // Clean up "string_val"
            {
                delete string_val_;
                string_val_ = nullptr;
            }
            break;
        case ((uint16)255):
            // Clean up "geometry_val"
            {
                delete geometry_val_;
                geometry_val_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int BinaryValue::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "value"
    int t_value__size;
    value_case_index_ =  ( type() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( value_case_index() ) {
        case ((uint16)0):
            // Parse "decimal_val"
            {
                decimal_val_ = new LengthEncodedInteger();
                int t_decimal_val__size;
                t_decimal_val__size = decimal_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_decimal_val__size;
            }
            break;
        case ((uint16)1):
            // Parse "tiny_val"
            {
                // Checking out-of-bound for "BinaryValue:tiny_val"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:tiny_val",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                tiny_val_ = *(reinterpret_cast<int8 const*>(t_begin_of_data));
                t_value__size = 1;
            }
            break;
        case ((uint16)2):
            // Parse "short_val"
            {
                // Checking out-of-bound for "BinaryValue:short_val"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:short_val",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                short_val_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int16 const*>(t_begin_of_data)));
                t_value__size = 2;
            }
            break;
        case ((uint16)3):
            // Parse "long_val"
            {
                // Checking out-of-bound for "BinaryValue:long_val"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:long_val",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                long_val_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int32 const*>(t_begin_of_data)));
                t_value__size = 4;
            }
            break;
        case ((uint16)4):
            // Parse "float_val"
            {
                // Checking out-of-bound for "BinaryValue:float_val"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:float_val",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 4;
                    int t_float_val_string_length;
                    t_float_val_string_length = 4;
                    int t_float_val__size;
                    t_float_val__size = t_float_val_string_length;
                    float_val_.init(t_begin_of_data, t_float_val_string_length);
                }
                t_value__size = 4;
            }
            break;
        case ((uint16)5):
            // Parse "double_val"
            {
                // Checking out-of-bound for "BinaryValue:double_val"
                if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:double_val",
                    	(0) + (8), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 8;
                    int t_double_val_string_length;
                    t_double_val_string_length = 8;
                    int t_double_val__size;
                    t_double_val__size = t_double_val_string_length;
                    double_val_.init(t_begin_of_data, t_double_val_string_length);
                }
                t_value__size = 8;
            }
            break;
        case ((uint16)6):
            // Parse "null_val"
            {
                t_value__size = 0;
            }
            break;
        case ((uint16)7):
            // Parse "timestamp_val"
            {
                timestamp_val_ = new BinaryDate();
                int t_timestamp_val__size;
                t_timestamp_val__size = timestamp_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_timestamp_val__size;
            }
            break;
        case ((uint16)8):
            // Parse "longlong_val"
            {
                // Checking out-of-bound for "BinaryValue:longlong_val"
                if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:longlong_val",
                    	(0) + (8), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                longlong_val_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>(t_begin_of_data)));
                t_value__size = 8;
            }
            break;
        case ((uint16)9):
            // Parse "int24_val"
            {
                // Checking out-of-bound for "BinaryValue:int24_val"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:int24_val",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                int24_val_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int32 const*>(t_begin_of_data)));
                t_value__size = 4;
            }
            break;
        case ((uint16)10):
            // Parse "date_val"
            {
                date_val_ = new BinaryDate();
                int t_date_val__size;
                t_date_val__size = date_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_date_val__size;
            }
            break;
        case ((uint16)11):
            // Parse "time_val"
            {
                time_val_ = new BinaryTime();
                int t_time_val__size;
                t_time_val__size = time_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_time_val__size;
            }
            break;
        case ((uint16)12):
            // Parse "datetime_val"
            {
                datetime_val_ = new BinaryDate();
                int t_datetime_val__size;
                t_datetime_val__size = datetime_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_datetime_val__size;
            }
            break;
        case ((uint16)13):
            // Parse "year_val"
            {
                // Checking out-of-bound for "BinaryValue:year_val"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BinaryValue:year_val",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                year_val_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int16 const*>(t_begin_of_data)));
                t_value__size = 2;
            }
            break;
        case ((uint16)15):
            // Parse "varchar_val"
            {
                varchar_val_ = new LengthEncodedString();
                int t_varchar_val__size;
                t_varchar_val__size = varchar_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_varchar_val__size;
            }
            break;
        case ((uint16)16):
            // Parse "bit_val"
            {
                bit_val_ = new LengthEncodedString();
                int t_bit_val__size;
                t_bit_val__size = bit_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_bit_val__size;
            }
            break;
        case ((uint16)17):
            // Parse "timestamp2_val"
            {
                timestamp2_val_ = new BinaryDate();
                int t_timestamp2_val__size;
                t_timestamp2_val__size = timestamp2_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_timestamp2_val__size;
            }
            break;
        case ((uint16)245):
            // Parse "json_val"
            {
                json_val_ = new LengthEncodedString();
                int t_json_val__size;
                t_json_val__size = json_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_json_val__size;
            }
            break;
        case ((uint16)246):
            // Parse "newdecimal_val"
            {
                newdecimal_val_ = new LengthEncodedString();
                int t_newdecimal_val__size;
                t_newdecimal_val__size = newdecimal_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_newdecimal_val__size;
            }
            break;
        case ((uint16)247):
            // Parse "enum_val"
            {
                enum_val_ = new LengthEncodedString();
                int t_enum_val__size;
                t_enum_val__size = enum_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_enum_val__size;
            }
            break;
        case ((uint16)248):
            // Parse "set_val"
            {
                set_val_ = new LengthEncodedString();
                int t_set_val__size;
                t_set_val__size = set_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_set_val__size;
            }
            break;
        case ((uint16)249):
            // Parse "tinyblob_val"
            {
                tinyblob_val_ = new LengthEncodedString();
                int t_tinyblob_val__size;
                t_tinyblob_val__size = tinyblob_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_tinyblob_val__size;
            }
            break;
        case ((uint16)250):
            // Parse "mediumblob_val"
            {
                mediumblob_val_ = new LengthEncodedString();
                int t_mediumblob_val__size;
                t_mediumblob_val__size = mediumblob_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_mediumblob_val__size;
            }
            break;
        case ((uint16)251):
            // Parse "longblob_val"
            {
                longblob_val_ = new LengthEncodedString();
                int t_longblob_val__size;
                t_longblob_val__size = longblob_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_longblob_val__size;
            }
            break;
        case ((uint16)252):
            // Parse "blob_val"
            {
                blob_val_ = new LengthEncodedString();
                int t_blob_val__size;
                t_blob_val__size = blob_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_blob_val__size;
            }
            break;
        case ((uint16)253):
            // Parse "varstring_val"
            {
                varstring_val_ = new LengthEncodedString();
                int t_varstring_val__size;
                t_varstring_val__size = varstring_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_varstring_val__size;
            }
            break;
        case ((uint16)254):
            // Parse "string_val"
            {
                string_val_ = new LengthEncodedString();
                int t_string_val__size;
                t_string_val__size = string_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_string_val__size;
            }
            break;
        case ((uint16)255):
            // Parse "geometry_val"
            {
                geometry_val_ = new LengthEncodedString();
                int t_geometry_val__size;
                t_geometry_val__size = geometry_val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_value__size = t_geometry_val__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("BinaryValue", (int64)value_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_BinaryValue__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_BinaryValue__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_BinaryValue__size) <= t_end_of_data);
    return t_BinaryValue__size;
}

RegExMatcher NUL_String_re_001("[^\\0]*\\0");

RegExMatcher EmptyOrNUL_String_re_002("([^\\0]*\\0)?");

MySQL_PDU::MySQL_PDU(bool is_orig) {
    hdr_ = nullptr;
    msg_case_index_ = -1;
    server_msg_ = nullptr;
    client_msg_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
    state_ = 0;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

MySQL_PDU::~MySQL_PDU() {
    delete hdr_;
    hdr_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case false:
            // Clean up "server_msg"
            {
                delete server_msg_;
                server_msg_ = nullptr;
            }
            break;
        case true:
            // Clean up "client_msg"
            {
                delete client_msg_;
                client_msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool MySQL_PDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextMySQL* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(4, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "hdr"
            hdr_ = new Header();
            hdr_->Parse(t_begin_of_data, t_end_of_data);
            t_flow_buffer->GrowFrame(hdr()->len());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "msg"
                state_ = t_context->connection()->get_state();
                int t_msg__size;
                msg_case_index_ = is_orig();
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( msg_case_index() ) {
                    case false:
                        // Parse "server_msg"
                        {
                            server_msg_ = new Server_Message(hdr()->seq_id(), hdr()->len(), state());
                            int t_server_msg__size;
                            t_server_msg__size = server_msg_->Parse((t_begin_of_data + 4), t_end_of_data, t_context, byteorder());
                            t_msg__size = t_server_msg__size;
                        }
                        break;
                    case true:
                        // Parse "client_msg"
                        {
                            client_msg_ = new Client_Message(hdr()->len(), state());
                            int t_client_msg__size;
                            t_client_msg__size = client_msg_->Parse((t_begin_of_data + 4), t_end_of_data, t_context, byteorder());
                            t_msg__size = t_client_msg__size;
                        }
                        break;
                    default:
                        throw binpac::ExceptionInvalidCaseIndex("MySQL_PDU", (int64)msg_case_index());
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

Header::Header() {
    le_len_ = nullptr;
    seq_id_ = 0;
    len_ = 0;
}

Header::~Header() {
    delete le_len_;
    le_len_ = nullptr;
}

int Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Header"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Header",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 4;
        // Checking out-of-bound for "Header:seq_id"
        if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Header:seq_id",
            	(3) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "le_len"
        le_len_ = new uint24le();
        le_len_->Parse(t_begin_of_data, t_end_of_data);

        // Parse "seq_id"
        seq_id_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

        // Evaluate 'let' and 'withinput' fields
        len_ = to_int()(le_len()) + 4;
    }
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

Server_Message::Server_Message(uint8 seq_id, uint32 pkt_len, int state) {
    val_case_index_ = -1;
    connection_phase_ = nullptr;
    command_response_ = nullptr;
    seq_id_ = seq_id;
    pkt_len_ = pkt_len;
    state_ = state;
    is_initial_ = false;
    update_seq_id_ = false;
}

Server_Message::~Server_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Clean up "connection_phase"
            {
                delete connection_phase_;
                connection_phase_ = nullptr;
            }
            break;
        case ((int)1):
            // Clean up "command_response"
            {
                delete command_response_;
                command_response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Server_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    is_initial_ =  ( seq_id() == 0 )  &&  ( t_context->connection()->get_previous_seq_id() != 255 ) ;
    int t_val__size;
    val_case_index_ = state();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Parse "connection_phase"
            {
                connection_phase_ = new Server_Connection_Phase(is_initial());
                int t_connection_phase__size;
                t_connection_phase__size = connection_phase_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_connection_phase__size;
            }
            break;
        case ((int)1):
            // Parse "command_response"
            {
                command_response_ = new Command_Response(pkt_len());
                int t_command_response__size;
                t_command_response__size = command_response_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_command_response__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Server_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    update_seq_id_ = t_context->connection()->set_previous_seq_id(seq_id());
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Server_Connection_Phase::Server_Connection_Phase(bool is_initial) {
    val_case_index_ = -1;
    initial_handshake_ = nullptr;
    subsequent_handshake_ = nullptr;
    is_initial_ = is_initial;
}

Server_Connection_Phase::~Server_Connection_Phase() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "initial_handshake"
            {
                delete initial_handshake_;
                initial_handshake_ = nullptr;
            }
            break;
        case false:
            // Clean up "subsequent_handshake"
            {
                delete subsequent_handshake_;
                subsequent_handshake_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Server_Connection_Phase::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = is_initial();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "initial_handshake"
            {
                initial_handshake_ = new Initial_Handshake_Packet();
                int t_initial_handshake__size;
                t_initial_handshake__size = initial_handshake_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_initial_handshake__size;
            }
            break;
        case false:
            // Parse "subsequent_handshake"
            {
                subsequent_handshake_ = new Server_Connection_Phase_Packets();
                int t_subsequent_handshake__size;
                t_subsequent_handshake__size = subsequent_handshake_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_subsequent_handshake__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Server_Connection_Phase", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Initial_Handshake_Packet::Initial_Handshake_Packet() {
    version_ = 0;
    pkt_case_index_ = -1;
    handshake10_ = nullptr;
    handshake9_ = nullptr;
    error_ = nullptr;
    set_version_ = false;
    proc_ = 0;
}

Initial_Handshake_Packet::~Initial_Handshake_Packet() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pkt_case_index() ) {
        case ((uint8)10):
            // Clean up "handshake10"
            {
                delete handshake10_;
                handshake10_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "handshake9"
            {
                delete handshake9_;
                handshake9_ = nullptr;
            }
            break;
        default:
            // Clean up "error"
            {
                delete error_;
                error_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Initial_Handshake_Packet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "Initial_Handshake_Packet:version"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Initial_Handshake_Packet:version",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "pkt"
    int t_pkt__size;
    pkt_case_index_ = version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pkt_case_index() ) {
        case ((uint8)10):
            // Parse "handshake10"
            {
                handshake10_ = new Handshake_v10();
                int t_handshake10__size;
                t_handshake10__size = handshake10_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_pkt__size = t_handshake10__size;
            }
            break;
        case ((uint8)9):
            // Parse "handshake9"
            {
                handshake9_ = new Handshake_v9();
                int t_handshake9__size;
                t_handshake9__size = handshake9_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_pkt__size = t_handshake9__size;
            }
            break;
        default:
            // Parse "error"
            {
                error_ = new ERR_Packet();
                int t_error__size;
                t_error__size = error_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_pkt__size = t_error__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Initial_Handshake_Packet__size;
    const_byteptr const t_dataptr_after_pkt = (t_begin_of_data + 1) + (t_pkt__size);
    BINPAC_ASSERT(t_dataptr_after_pkt <= t_end_of_data);
    t_Initial_Handshake_Packet__size = t_dataptr_after_pkt - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    set_version_ = t_context->connection()->set_version(version());
    proc_ = t_context->flow()->proc_mysql_initial_handshake_packet(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Initial_Handshake_Packet__size) <= t_end_of_data);
    return t_Initial_Handshake_Packet__size;
}

Handshake_v10::Handshake_v10() {
    connection_id_ = 0;
    filler_1_ = 0;
    capability_flag_1_ = 0;
    character_set_ = 0;
    status_flags_ = 0;
    capability_flags_2_ = 0;
    auth_plugin_data_len_ = 0;
    have_plugin_case_index_ = -1;
    auth_plugin_data_part_2_len_ = 0;
    server_query_attrs_ = false;
}

Handshake_v10::~Handshake_v10() {
    server_version_.free();
    auth_plugin_data_part_1_.free();
    auth_plugin_data_part_2_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_plugin_case_index() ) {
        case ((int)524288):
            // Clean up "auth_plugin"
            {
                auth_plugin_.free();
            }
            break;
        case ((int)0):
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Handshake_v10::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "server_version"
    int t_server_version_string_length;
    t_server_version_string_length = 
        NUL_String_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_server_version_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:339", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_server_version__size;
    t_server_version__size = t_server_version_string_length;
    // check for negative sizes
    if ( t_server_version_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:339", t_server_version_string_length);
    server_version_.init(t_begin_of_data, t_server_version_string_length);

    const_byteptr const t_dataptr_after_server_version = t_begin_of_data + (t_server_version__size);
    BINPAC_ASSERT(t_dataptr_after_server_version <= t_end_of_data);
    // Checking out-of-bound for "Handshake_v10:connection_id"
    if ( t_dataptr_after_server_version + (4) > t_end_of_data || t_dataptr_after_server_version + (4) < t_dataptr_after_server_version ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_v10:connection_id",
        	((t_dataptr_after_server_version - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "connection_id"
    connection_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_server_version)));

    // Parse "auth_plugin_data_part_1"
    // Checking out-of-bound for "Handshake_v10:auth_plugin_data_part_1"
    if ( (t_dataptr_after_server_version + 4) + (8) > t_end_of_data || (t_dataptr_after_server_version + 4) + (8) < (t_dataptr_after_server_version + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_v10:auth_plugin_data_part_1",
        	(((t_dataptr_after_server_version + 4) - t_begin_of_data)) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_server_version + 4) + 8;
        int t_auth_plugin_data_part_1_string_length;
        t_auth_plugin_data_part_1_string_length = 8;
        int t_auth_plugin_data_part_1__size;
        t_auth_plugin_data_part_1__size = t_auth_plugin_data_part_1_string_length;
        auth_plugin_data_part_1_.init((t_dataptr_after_server_version + 4), t_auth_plugin_data_part_1_string_length);
    }

    const_byteptr const t_dataptr_after_auth_plugin_data_part_1 = (t_dataptr_after_server_version + 4) + (8);
    BINPAC_ASSERT(t_dataptr_after_auth_plugin_data_part_1 <= t_end_of_data);
    // Checking out-of-bound for "Handshake_v10:reserved"
    if ( (t_dataptr_after_auth_plugin_data_part_1 + 9) + (10) > t_end_of_data || (t_dataptr_after_auth_plugin_data_part_1 + 9) + (10) < (t_dataptr_after_auth_plugin_data_part_1 + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_v10:reserved",
        	(((t_dataptr_after_auth_plugin_data_part_1 + 9) - t_begin_of_data)) + (10), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "filler_1"
    filler_1_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_auth_plugin_data_part_1));

    // Parse "capability_flag_1"
    capability_flag_1_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_auth_plugin_data_part_1 + 1))));

    // Parse "character_set"
    character_set_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_auth_plugin_data_part_1 + 3)));

    // Parse "status_flags"
    status_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_auth_plugin_data_part_1 + 4))));

    // Parse "capability_flags_2"
    capability_flags_2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_auth_plugin_data_part_1 + 6))));

    // Parse "auth_plugin_data_len"
    auth_plugin_data_len_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_auth_plugin_data_part_1 + 8)));
    // Evaluate '&enforce' attribute
    if (! ( auth_plugin_data_len() == 0 || auth_plugin_data_len() >= 21 ) ) {
        throw binpac::ExceptionEnforceViolation("Handshake_v10:auth_plugin_data_len");
    }


    // Parse "auth_plugin_data_part_2"
    int t_auth_plugin_data_part_2__size;
    auth_plugin_data_part_2_len_ = auth_plugin_data_len() > 21 ? auth_plugin_data_len() - 8 : 13;
    t_auth_plugin_data_part_2__size = auth_plugin_data_part_2_len();
    // Checking out-of-bound for "Handshake_v10:auth_plugin_data_part_2"
    if ( (t_dataptr_after_auth_plugin_data_part_1 + 19) + (t_auth_plugin_data_part_2__size) > t_end_of_data || (t_dataptr_after_auth_plugin_data_part_1 + 19) + (t_auth_plugin_data_part_2__size) < (t_dataptr_after_auth_plugin_data_part_1 + 19) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_v10:auth_plugin_data_part_2",
        	(((t_dataptr_after_auth_plugin_data_part_1 + 19) - t_begin_of_data)) + (t_auth_plugin_data_part_2__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_auth_plugin_data_part_1 + 19) + t_auth_plugin_data_part_2__size;
        int t_auth_plugin_data_part_2_string_length;
        t_auth_plugin_data_part_2_string_length = auth_plugin_data_part_2_len();
        // check for negative sizes
        if ( t_auth_plugin_data_part_2_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:349", t_auth_plugin_data_part_2_string_length);
        auth_plugin_data_part_2_.init((t_dataptr_after_auth_plugin_data_part_1 + 19), t_auth_plugin_data_part_2_string_length);
    }

    const_byteptr const t_dataptr_after_auth_plugin_data_part_2 = (t_dataptr_after_auth_plugin_data_part_1 + 19) + (t_auth_plugin_data_part_2__size);
    BINPAC_ASSERT(t_dataptr_after_auth_plugin_data_part_2 <= t_end_of_data);
    // Parse "have_plugin"
    int t_have_plugin__size;
    have_plugin_case_index_ =  (  ( capability_flags_2() << 16 )  & CLIENT_PLUGIN_AUTH ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_plugin_case_index() ) {
        case ((int)524288):
            // Parse "auth_plugin"
            {
                int t_auth_plugin_string_length;
                t_auth_plugin_string_length = 
                    NUL_String_re_001.MatchPrefix(
                        t_dataptr_after_auth_plugin_data_part_2,
                        t_end_of_data - t_dataptr_after_auth_plugin_data_part_2);
                if ( t_auth_plugin_string_length < 0 ) {
                    throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:351", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_dataptr_after_auth_plugin_data_part_2), reinterpret_cast<const char*>(t_end_of_data)).c_str());
                }
                int t_auth_plugin__size;
                t_auth_plugin__size = t_auth_plugin_string_length;
                // check for negative sizes
                if ( t_auth_plugin_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:351", t_auth_plugin_string_length);
                auth_plugin_.init(t_dataptr_after_auth_plugin_data_part_2, t_auth_plugin_string_length);
                t_have_plugin__size = t_auth_plugin__size;
            }
            break;
        case ((int)0):
            // Parse "none"
            {
                t_have_plugin__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Handshake_v10", (int64)have_plugin_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Handshake_v10__size;
    const_byteptr const t_dataptr_after_have_plugin = t_dataptr_after_auth_plugin_data_part_2 + (t_have_plugin__size);
    BINPAC_ASSERT(t_dataptr_after_have_plugin <= t_end_of_data);
    t_Handshake_v10__size = t_dataptr_after_have_plugin - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    server_query_attrs_ = t_context->connection()->set_server_query_attrs( ( capability_flags_2() << 16 )  & CLIENT_QUERY_ATTRIBUTES);
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake_v10__size) <= t_end_of_data);
    return t_Handshake_v10__size;
}

Handshake_v9::Handshake_v9() {
    connection_id_ = 0;
}

Handshake_v9::~Handshake_v9() {
    server_version_.free();
    scramble_.free();
}

int Handshake_v9::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "server_version"
    int t_server_version_string_length;
    t_server_version_string_length = 
        NUL_String_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_server_version_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:366", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_server_version__size;
    t_server_version__size = t_server_version_string_length;
    // check for negative sizes
    if ( t_server_version_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:366", t_server_version_string_length);
    server_version_.init(t_begin_of_data, t_server_version_string_length);

    const_byteptr const t_dataptr_after_server_version = t_begin_of_data + (t_server_version__size);
    BINPAC_ASSERT(t_dataptr_after_server_version <= t_end_of_data);
    // Checking out-of-bound for "Handshake_v9:connection_id"
    if ( t_dataptr_after_server_version + (4) > t_end_of_data || t_dataptr_after_server_version + (4) < t_dataptr_after_server_version ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_v9:connection_id",
        	((t_dataptr_after_server_version - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "connection_id"
    connection_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_server_version)));

    // Parse "scramble"
    int t_scramble_string_length;
    t_scramble_string_length = 
        NUL_String_re_001.MatchPrefix(
            (t_dataptr_after_server_version + 4),
            t_end_of_data - (t_dataptr_after_server_version + 4));
    if ( t_scramble_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:368", "[^\\0]*\\0", string(reinterpret_cast<const char*>((t_dataptr_after_server_version + 4)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_scramble__size;
    t_scramble__size = t_scramble_string_length;
    // check for negative sizes
    if ( t_scramble_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:368", t_scramble_string_length);
    scramble_.init((t_dataptr_after_server_version + 4), t_scramble_string_length);

    int t_Handshake_v9__size;
    const_byteptr const t_dataptr_after_scramble = (t_dataptr_after_server_version + 4) + (t_scramble__size);
    BINPAC_ASSERT(t_dataptr_after_scramble <= t_end_of_data);
    t_Handshake_v9__size = t_dataptr_after_scramble - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake_v9__size) <= t_end_of_data);
    return t_Handshake_v9__size;
}

Server_Connection_Phase_Packets::Server_Connection_Phase_Packets() {
    pkt_type_ = 0;
    packet_case_index_ = -1;
    data_ok_ = nullptr;
    auth_more_data_ = nullptr;
    auth_switch_request_ = nullptr;
    data_err_ = nullptr;
}

Server_Connection_Phase_Packets::~Server_Connection_Phase_Packets() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( packet_case_index() ) {
        case ((uint8)0):
            // Clean up "data_ok"
            {
                delete data_ok_;
                data_ok_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "auth_more_data"
            {
                delete auth_more_data_;
                auth_more_data_ = nullptr;
            }
            break;
        case ((uint8)254):
            // Clean up "auth_switch_request"
            {
                delete auth_switch_request_;
                auth_switch_request_ = nullptr;
            }
            break;
        case ((uint8)255):
            // Clean up "data_err"
            {
                delete data_err_;
                data_err_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Server_Connection_Phase_Packets::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "Server_Connection_Phase_Packets:pkt_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Connection_Phase_Packets:pkt_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "pkt_type"
    pkt_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "packet"
    int t_packet__size;
    packet_case_index_ = pkt_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( packet_case_index() ) {
        case ((uint8)0):
            // Parse "data_ok"
            {
                data_ok_ = new OK_Packet();
                int t_data_ok__size;
                t_data_ok__size = data_ok_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_packet__size = t_data_ok__size;
            }
            break;
        case ((uint8)1):
            // Parse "auth_more_data"
            {
                auth_more_data_ = new AuthMoreData(false);
                int t_auth_more_data__size;
                t_auth_more_data__size = auth_more_data_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_packet__size = t_auth_more_data__size;
            }
            break;
        case ((uint8)254):
            // Parse "auth_switch_request"
            {
                auth_switch_request_ = new AuthSwitchRequest();
                int t_auth_switch_request__size;
                t_auth_switch_request__size = auth_switch_request_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_packet__size = t_auth_switch_request__size;
            }
            break;
        case ((uint8)255):
            // Parse "data_err"
            {
                data_err_ = new ERR_Packet();
                int t_data_err__size;
                t_data_err__size = data_err_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_packet__size = t_data_err__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Server_Connection_Phase_Packets", (int64)packet_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Server_Connection_Phase_Packets__size;
    const_byteptr const t_dataptr_after_packet = (t_begin_of_data + 1) + (t_packet__size);
    BINPAC_ASSERT(t_dataptr_after_packet <= t_end_of_data);
    t_Server_Connection_Phase_Packets__size = t_dataptr_after_packet - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Server_Connection_Phase_Packets__size) <= t_end_of_data);
    return t_Server_Connection_Phase_Packets__size;
}

Handshake_Response_Packet::Handshake_Response_Packet() {
    val_case_index_ = -1;
    v10_response_ = nullptr;
    v9_response_ = nullptr;
    version_ = 0;
    proc_ = 0;
}

Handshake_Response_Packet::~Handshake_Response_Packet() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)10):
            // Clean up "v10_response"
            {
                delete v10_response_;
                v10_response_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "v9_response"
            {
                delete v9_response_;
                v9_response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Handshake_Response_Packet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = t_context->connection()->get_version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)10):
            // Parse "v10_response"
            {
                v10_response_ = new Handshake_Response_Packet_v10();
                int t_v10_response__size;
                t_v10_response__size = v10_response_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_v10_response__size;
            }
            break;
        case ((uint8)9):
            // Parse "v9_response"
            {
                v9_response_ = new Handshake_Response_Packet_v9();
                int t_v9_response__size;
                t_v9_response__size = v9_response_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_v9_response__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Handshake_Response_Packet", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    version_ = t_context->connection()->get_version();
    proc_ = t_context->flow()->proc_mysql_handshake_response_packet(this);
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Handshake_Credentials_v10::Handshake_Credentials_v10() {
    password_ = nullptr;
}

Handshake_Credentials_v10::~Handshake_Credentials_v10() {
    username_.free();
    delete password_;
    password_ = nullptr;
}

int Handshake_Credentials_v10::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "username"
    int t_username_string_length;
    t_username_string_length = 
        NUL_String_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_username_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:394", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_username__size;
    t_username__size = t_username_string_length;
    // check for negative sizes
    if ( t_username_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:394", t_username_string_length);
    username_.init(t_begin_of_data, t_username_string_length);

    const_byteptr const t_dataptr_after_username = t_begin_of_data + (t_username__size);
    BINPAC_ASSERT(t_dataptr_after_username <= t_end_of_data);
    // Parse "password"
    password_ = new LengthEncodedString();
    int t_password__size;
    t_password__size = password_->Parse(t_dataptr_after_username, t_end_of_data, t_byteorder);

    int t_Handshake_Credentials_v10__size;
    const_byteptr const t_dataptr_after_password = t_dataptr_after_username + (t_password__size);
    BINPAC_ASSERT(t_dataptr_after_password <= t_end_of_data);
    t_Handshake_Credentials_v10__size = t_dataptr_after_password - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake_Credentials_v10__size) <= t_end_of_data);
    return t_Handshake_Credentials_v10__size;
}

Connection_Attribute::Connection_Attribute() {
    name_ = nullptr;
    value_ = nullptr;
}

Connection_Attribute::~Connection_Attribute() {
    delete name_;
    name_ = nullptr;
    delete value_;
    value_ = nullptr;
}

int Connection_Attribute::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "name"
    name_ = new LengthEncodedString();
    int t_name__size;
    t_name__size = name_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_name = t_begin_of_data + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Parse "value"
    value_ = new LengthEncodedString();
    int t_value__size;
    t_value__size = value_->Parse(t_dataptr_after_name, t_end_of_data, t_byteorder);

    int t_Connection_Attribute__size;
    const_byteptr const t_dataptr_after_value = t_dataptr_after_name + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_Connection_Attribute__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Connection_Attribute__size) <= t_end_of_data);
    return t_Connection_Attribute__size;
}

Handshake_Connection_Attributes::Handshake_Connection_Attributes() {
    length_ = 0;
    attrs_ = nullptr;
    attrs__elem_ = nullptr;
}

Handshake_Connection_Attributes::~Handshake_Connection_Attributes() {
    delete attrs__elem_;
    attrs__elem_ = nullptr;
    if ( attrs() ) {
        for ( auto* attrs__elem_ : *attrs() ) {
            delete attrs__elem_;
            attrs__elem_ = nullptr;
        }
    }
    delete attrs_;
}

int Handshake_Connection_Attributes::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_Handshake_Connection_Attributes__size;
    // Checking out-of-bound for "Handshake_Connection_Attributes:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_Connection_Attributes:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
    t_Handshake_Connection_Attributes__size = length() + 1;
    // Checking out-of-bound for "Handshake_Connection_Attributes"
    if ( t_begin_of_data + (t_Handshake_Connection_Attributes__size) > t_end_of_data || t_begin_of_data + (t_Handshake_Connection_Attributes__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_Connection_Attributes",
        	(0) + (t_Handshake_Connection_Attributes__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_Handshake_Connection_Attributes__size;

        // Parse "attrs"
        int t_attrs__arraylength;
        t_attrs__arraylength = 0;
        attrs__elem_ = nullptr;
        int t_attrs__elem__it;
        t_attrs__elem__it = 0;
        int t_attrs__size;
        attrs_ = new vector<Connection_Attribute*>;
        const_byteptr t_attrs__elem__dataptr = (t_begin_of_data + 1);
        for (; /* forever */; ++t_attrs__elem__it) {
            // Check &until(attrs__elem__dataptr >= end_of_data)
            if ( t_attrs__elem__dataptr >= t_end_of_data ) {
                attrs__elem_ = nullptr;
                goto end_of_attrs;
            }
            attrs__elem_ = new Connection_Attribute();
            int t_attrs__elem__size;
            t_attrs__elem__size = attrs__elem_->Parse(t_attrs__elem__dataptr, t_end_of_data, t_byteorder);
            attrs_->push_back(attrs__elem_);
            t_attrs__elem__dataptr += t_attrs__elem__size;
            BINPAC_ASSERT(t_attrs__elem__dataptr <= t_end_of_data);
            attrs__elem_ = nullptr;
        }
    end_of_attrs: ;
        t_attrs__size = t_attrs__elem__dataptr - ((t_begin_of_data + 1));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake_Connection_Attributes__size) <= t_end_of_data);
    return t_Handshake_Connection_Attributes__size;
}

Handshake_Plain_v10::Handshake_Plain_v10(uint32 cap_flags) {
    credentials_ = nullptr;
    have_db_case_index_ = -1;
    have_plugin_case_index_ = -1;
    have_attrs_case_index_ = -1;
    conn_attrs_ = nullptr;
    have_zstd_case_index_ = -1;
    zstd_compression_level_ = 0;
    cap_flags_ = cap_flags;
    update_conn_expectation_ = false;
    has_update_conn_expectation_ = false;
}

Handshake_Plain_v10::~Handshake_Plain_v10() {
    delete credentials_;
    credentials_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_db_case_index() ) {
        case ((int)8):
            // Clean up "database"
            {
                database_.free();
            }
            break;
        case ((int)0):
            // Clean up "none_1"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_plugin_case_index() ) {
        case ((int)524288):
            // Clean up "auth_plugin"
            {
                auth_plugin_.free();
            }
            break;
        case ((int)0):
            // Clean up "none_2"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_attrs_case_index() ) {
        case ((int)1048576):
            // Clean up "conn_attrs"
            {
                delete conn_attrs_;
                conn_attrs_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "none_3"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_zstd_case_index() ) {
        case ((int)67108864):
            // Clean up "zstd_compression_level"
            {
            }
            break;
        case ((int)0):
            // Clean up "none_4"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Handshake_Plain_v10::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "credentials"
    credentials_ = new Handshake_Credentials_v10();
    int t_credentials__size;
    t_credentials__size = credentials_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_credentials = t_begin_of_data + (t_credentials__size);
    BINPAC_ASSERT(t_dataptr_after_credentials <= t_end_of_data);
    // Parse "have_db"
    int t_have_db__size;
    have_db_case_index_ =  ( cap_flags() & CLIENT_CONNECT_WITH_DB ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_db_case_index() ) {
        case ((int)8):
            // Parse "database"
            {
                int t_database_string_length;
                t_database_string_length = 
                    NUL_String_re_001.MatchPrefix(
                        t_dataptr_after_credentials,
                        t_end_of_data - t_dataptr_after_credentials);
                if ( t_database_string_length < 0 ) {
                    throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:411", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_dataptr_after_credentials), reinterpret_cast<const char*>(t_end_of_data)).c_str());
                }
                int t_database__size;
                t_database__size = t_database_string_length;
                // check for negative sizes
                if ( t_database_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:411", t_database_string_length);
                database_.init(t_dataptr_after_credentials, t_database_string_length);
                t_have_db__size = t_database__size;
            }
            break;
        case ((int)0):
            // Parse "none_1"
            {
                t_have_db__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Handshake_Plain_v10", (int64)have_db_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_db = t_dataptr_after_credentials + (t_have_db__size);
    BINPAC_ASSERT(t_dataptr_after_have_db <= t_end_of_data);
    // Parse "have_plugin"
    int t_have_plugin__size;
    have_plugin_case_index_ =  ( cap_flags() & CLIENT_PLUGIN_AUTH ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_plugin_case_index() ) {
        case ((int)524288):
            // Parse "auth_plugin"
            {
                int t_auth_plugin_string_length;
                t_auth_plugin_string_length = 
                    EmptyOrNUL_String_re_002.MatchPrefix(
                        t_dataptr_after_have_db,
                        t_end_of_data - t_dataptr_after_have_db);
                if ( t_auth_plugin_string_length < 0 ) {
                    throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:415", "([^\\0]*\\0)?", string(reinterpret_cast<const char*>(t_dataptr_after_have_db), reinterpret_cast<const char*>(t_end_of_data)).c_str());
                }
                int t_auth_plugin__size;
                t_auth_plugin__size = t_auth_plugin_string_length;
                // check for negative sizes
                if ( t_auth_plugin_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:415", t_auth_plugin_string_length);
                auth_plugin_.init(t_dataptr_after_have_db, t_auth_plugin_string_length);
                t_have_plugin__size = t_auth_plugin__size;
            }
            break;
        case ((int)0):
            // Parse "none_2"
            {
                t_have_plugin__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Handshake_Plain_v10", (int64)have_plugin_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_plugin = t_dataptr_after_have_db + (t_have_plugin__size);
    BINPAC_ASSERT(t_dataptr_after_have_plugin <= t_end_of_data);
    // Parse "have_attrs"
    int t_have_attrs__size;
    have_attrs_case_index_ =  ( cap_flags() & CLIENT_CONNECT_ATTRS ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_attrs_case_index() ) {
        case ((int)1048576):
            // Parse "conn_attrs"
            {
                conn_attrs_ = new Handshake_Connection_Attributes();
                int t_conn_attrs__size;
                t_conn_attrs__size = conn_attrs_->Parse(t_dataptr_after_have_plugin, t_end_of_data, t_byteorder);
                t_have_attrs__size = t_conn_attrs__size;
            }
            break;
        case ((int)0):
            // Parse "none_3"
            {
                t_have_attrs__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Handshake_Plain_v10", (int64)have_attrs_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_attrs = t_dataptr_after_have_plugin + (t_have_attrs__size);
    BINPAC_ASSERT(t_dataptr_after_have_attrs <= t_end_of_data);
    // Parse "have_zstd"
    int t_have_zstd__size;
    have_zstd_case_index_ =  ( cap_flags() & CLIENT_ZSTD_COMPRESSION_ALGORITHM ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_zstd_case_index() ) {
        case ((int)67108864):
            // Parse "zstd_compression_level"
            {
                // Checking out-of-bound for "Handshake_Plain_v10:zstd_compression_level"
                if ( t_dataptr_after_have_attrs + (1) > t_end_of_data || t_dataptr_after_have_attrs + (1) < t_dataptr_after_have_attrs ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Handshake_Plain_v10:zstd_compression_level",
                    	((t_dataptr_after_have_attrs - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                zstd_compression_level_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_have_attrs));
                t_have_zstd__size = 1;
            }
            break;
        case ((int)0):
            // Parse "none_4"
            {
                t_have_zstd__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Handshake_Plain_v10", (int64)have_zstd_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Handshake_Plain_v10__size;
    const_byteptr const t_dataptr_after_have_zstd = t_dataptr_after_have_attrs + (t_have_zstd__size);
    BINPAC_ASSERT(t_dataptr_after_have_zstd <= t_end_of_data);
    t_Handshake_Plain_v10__size = t_dataptr_after_have_zstd - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    has_update_conn_expectation_ =  ( cap_flags() & CLIENT_PLUGIN_AUTH ) ;
    if ( has_update_conn_expectation() ) {
        update_conn_expectation_ = t_context->connection()->set_next_conn_expected(EXPECT_AUTH_DATA);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake_Plain_v10__size) <= t_end_of_data);
    return t_Handshake_Plain_v10__size;
}

Handshake_Response_Packet_v10::Handshake_Response_Packet_v10() {
    cap_flags_ = 0;
    max_pkt_size_ = 0;
    char_set_ = 0;
    use_ssl_case_index_ = -1;
    plain_ = nullptr;
    deprecate_eof_ = false;
    client_query_attrs_ = false;
    proc_cap_flags_ = false;
}

Handshake_Response_Packet_v10::~Handshake_Response_Packet_v10() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( use_ssl_case_index() ) {
        case ((int)2048):
            // Clean up "none"
            {
            }
            break;
        default:
            // Clean up "plain"
            {
                delete plain_;
                plain_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Handshake_Response_Packet_v10::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "Handshake_Response_Packet_v10:pad"
    if ( (t_begin_of_data + 9) + (23) > t_end_of_data || (t_begin_of_data + 9) + (23) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_Response_Packet_v10:pad",
        	(9) + (23), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cap_flags"
    cap_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "max_pkt_size"
    max_pkt_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "char_set"
    char_set_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));


    // Parse "use_ssl"
    int t_use_ssl__size;
    use_ssl_case_index_ =  ( cap_flags() & CLIENT_SSL ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( use_ssl_case_index() ) {
        case ((int)2048):
            // Parse "none"
            {
                t_use_ssl__size = 0;
            }
            break;
        default:
            // Parse "plain"
            {
                plain_ = new Handshake_Plain_v10(cap_flags());
                int t_plain__size;
                t_plain__size = plain_->Parse((t_begin_of_data + 32), t_end_of_data, t_context, t_byteorder);
                t_use_ssl__size = t_plain__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Handshake_Response_Packet_v10__size;
    const_byteptr const t_dataptr_after_use_ssl = (t_begin_of_data + 32) + (t_use_ssl__size);
    BINPAC_ASSERT(t_dataptr_after_use_ssl <= t_end_of_data);
    t_Handshake_Response_Packet_v10__size = t_dataptr_after_use_ssl - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    deprecate_eof_ = t_context->connection()->set_deprecate_eof(cap_flags() & CLIENT_DEPRECATE_EOF);
    client_query_attrs_ = t_context->connection()->set_client_query_attrs(cap_flags() & CLIENT_QUERY_ATTRIBUTES);
    proc_cap_flags_ = t_context->connection()->set_client_capabilities(cap_flags());
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake_Response_Packet_v10__size) <= t_end_of_data);
    return t_Handshake_Response_Packet_v10__size;
}

Handshake_Response_Packet_v9::Handshake_Response_Packet_v9() {
    cap_flags_ = 0;
    max_pkt_size_ = nullptr;
    have_db_case_index_ = -1;
}

Handshake_Response_Packet_v9::~Handshake_Response_Packet_v9() {
    delete max_pkt_size_;
    max_pkt_size_ = nullptr;
    username_.free();
    auth_response_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_db_case_index() ) {
        case ((int)8):
            // Clean up "database"
            {
                database_.free();
            }
            break;
        case ((int)0):
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    password_.free();
}

int Handshake_Response_Packet_v9::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "Handshake_Response_Packet_v9:max_pkt_size"
    if ( (t_begin_of_data + 2) + (3) > t_end_of_data || (t_begin_of_data + 2) + (3) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake_Response_Packet_v9:max_pkt_size",
        	(2) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cap_flags"
    cap_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "max_pkt_size"
    max_pkt_size_ = new uint24le();
    max_pkt_size_->Parse((t_begin_of_data + 2), t_end_of_data);

    // Parse "username"
    int t_username_string_length;
    t_username_string_length = 
        NUL_String_re_001.MatchPrefix(
            (t_begin_of_data + 5),
            t_end_of_data - (t_begin_of_data + 5));
    if ( t_username_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:451", "[^\\0]*\\0", string(reinterpret_cast<const char*>((t_begin_of_data + 5)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_username__size;
    t_username__size = t_username_string_length;
    // check for negative sizes
    if ( t_username_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:451", t_username_string_length);
    username_.init((t_begin_of_data + 5), t_username_string_length);

    const_byteptr const t_dataptr_after_username = (t_begin_of_data + 5) + (t_username__size);
    BINPAC_ASSERT(t_dataptr_after_username <= t_end_of_data);
    // Parse "auth_response"
    int t_auth_response_string_length;
    t_auth_response_string_length = 
        NUL_String_re_001.MatchPrefix(
            t_dataptr_after_username,
            t_end_of_data - t_dataptr_after_username);
    if ( t_auth_response_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:452", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_dataptr_after_username), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_auth_response__size;
    t_auth_response__size = t_auth_response_string_length;
    // check for negative sizes
    if ( t_auth_response_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:452", t_auth_response_string_length);
    auth_response_.init(t_dataptr_after_username, t_auth_response_string_length);

    const_byteptr const t_dataptr_after_auth_response = t_dataptr_after_username + (t_auth_response__size);
    BINPAC_ASSERT(t_dataptr_after_auth_response <= t_end_of_data);
    // Parse "have_db"
    int t_have_db__size;
    have_db_case_index_ =  ( cap_flags() & CLIENT_CONNECT_WITH_DB ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_db_case_index() ) {
        case ((int)8):
            // Parse "database"
            {
                int t_database_string_length;
                t_database_string_length = 
                    NUL_String_re_001.MatchPrefix(
                        t_dataptr_after_auth_response,
                        t_end_of_data - t_dataptr_after_auth_response);
                if ( t_database_string_length < 0 ) {
                    throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:454", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_dataptr_after_auth_response), reinterpret_cast<const char*>(t_end_of_data)).c_str());
                }
                int t_database__size;
                t_database__size = t_database_string_length;
                // check for negative sizes
                if ( t_database_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:454", t_database_string_length);
                database_.init(t_dataptr_after_auth_response, t_database_string_length);
                t_have_db__size = t_database__size;
            }
            break;
        case ((int)0):
            // Parse "none"
            {
                t_have_db__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Handshake_Response_Packet_v9", (int64)have_db_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_db = t_dataptr_after_auth_response + (t_have_db__size);
    BINPAC_ASSERT(t_dataptr_after_have_db <= t_end_of_data);
    // Parse "password"
    int t_password_string_length;
    t_password_string_length = (t_end_of_data) - (t_dataptr_after_have_db);
    int t_password__size;
    t_password__size = t_password_string_length;
    // check for negative sizes
    if ( t_password_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:457", t_password_string_length);
    password_.init(t_dataptr_after_have_db, t_password_string_length);

    int t_Handshake_Response_Packet_v9__size;
    const_byteptr const t_dataptr_after_password = t_dataptr_after_have_db + (t_password__size);
    BINPAC_ASSERT(t_dataptr_after_password <= t_end_of_data);
    t_Handshake_Response_Packet_v9__size = t_dataptr_after_password - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake_Response_Packet_v9__size) <= t_end_of_data);
    return t_Handshake_Response_Packet_v9__size;
}

Client_Message::Client_Message(uint32 pkt_len, int state) {
    val_case_index_ = -1;
    connection_phase_ = nullptr;
    command_phase_ = nullptr;
    pkt_len_ = pkt_len;
    state_ = state;
}

Client_Message::~Client_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Clean up "connection_phase"
            {
                delete connection_phase_;
                connection_phase_ = nullptr;
            }
            break;
        case ((int)1):
            // Clean up "command_phase"
            {
                delete command_phase_;
                command_phase_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Client_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = state();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Parse "connection_phase"
            {
                connection_phase_ = new Connection_Phase_Packets();
                int t_connection_phase__size;
                t_connection_phase__size = connection_phase_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_connection_phase__size;
            }
            break;
        case ((int)1):
            // Parse "command_phase"
            {
                command_phase_ = new Command_Request_Packet(pkt_len());
                int t_command_phase__size;
                t_command_phase__size = command_phase_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_command_phase__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Client_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Connection_Phase_Packets::Connection_Phase_Packets() {
    val_case_index_ = -1;
    handshake_resp_ = nullptr;
    auth_data_ = nullptr;
}

Connection_Phase_Packets::~Connection_Phase_Packets() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((ConnectionExpected)0):
            // Clean up "handshake_resp"
            {
                delete handshake_resp_;
                handshake_resp_ = nullptr;
            }
            break;
        case ((ConnectionExpected)1):
            // Clean up "auth_data"
            {
                delete auth_data_;
                auth_data_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Connection_Phase_Packets::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = t_context->connection()->get_conn_expectation();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((ConnectionExpected)0):
            // Parse "handshake_resp"
            {
                handshake_resp_ = new Handshake_Response_Packet();
                int t_handshake_resp__size;
                t_handshake_resp__size = handshake_resp_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_handshake_resp__size;
            }
            break;
        case ((ConnectionExpected)1):
            // Parse "auth_data"
            {
                auth_data_ = new AuthMoreData(true);
                int t_auth_data__size;
                t_auth_data__size = auth_data_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_auth_data__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Connection_Phase_Packets", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

AttributeTypeAndName::AttributeTypeAndName() {
    type_ = 0;
    unsigned_flag_ = 0;
    name_ = nullptr;
}

AttributeTypeAndName::~AttributeTypeAndName() {
    delete name_;
    name_ = nullptr;
}

int AttributeTypeAndName::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "AttributeTypeAndName:unsigned_flag"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AttributeTypeAndName:unsigned_flag",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "unsigned_flag"
    unsigned_flag_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "name"
    name_ = new LengthEncodedString();
    int t_name__size;
    t_name__size = name_->Parse((t_begin_of_data + 2), t_end_of_data, t_byteorder);

    int t_AttributeTypeAndName__size;
    const_byteptr const t_dataptr_after_name = (t_begin_of_data + 2) + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    t_AttributeTypeAndName__size = t_dataptr_after_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AttributeTypeAndName__size) <= t_end_of_data);
    return t_AttributeTypeAndName__size;
}

AttributeValue::AttributeValue(bool is_null, uint8 type) {
    null_case_index_ = -1;
    val_ = nullptr;
    is_null_ = is_null;
    type_ = type;
    done_ = 0;
}

AttributeValue::~AttributeValue() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( null_case_index() ) {
        case false:
            // Clean up "val"
            {
                delete val_;
                val_ = nullptr;
            }
            break;
        case true:
            // Clean up "null_val"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int AttributeValue::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "null"
    int t_null__size;
    null_case_index_ = is_null();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( null_case_index() ) {
        case false:
            // Parse "val"
            {
                val_ = new BinaryValue(type());
                int t_val__size;
                t_val__size = val_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_null__size = t_val__size;
            }
            break;
        case true:
            // Parse "null_val"
            {
                t_null__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("AttributeValue", (int64)null_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_AttributeValue__size;
    const_byteptr const t_dataptr_after_null = t_begin_of_data + (t_null__size);
    BINPAC_ASSERT(t_dataptr_after_null <= t_end_of_data);
    t_AttributeValue__size = t_dataptr_after_null - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    done_ = t_context->connection()->next_query_attr();
    BINPAC_ASSERT(t_begin_of_data + (t_AttributeValue__size) <= t_end_of_data);
    return t_AttributeValue__size;
}

Attributes::Attributes(int count) {
    send_types_to_server_ = 0;
    names_ = nullptr;
    names__elem_ = nullptr;
    values_ = nullptr;
    values__elem_ = nullptr;
    count_ = count;
}

Attributes::~Attributes() {
    null_bitmap_.free();
    delete names__elem_;
    names__elem_ = nullptr;
    if ( names() ) {
        for ( auto* names__elem_ : *names() ) {
            delete names__elem_;
            names__elem_ = nullptr;
        }
    }
    delete names_;
    delete values__elem_;
    values__elem_ = nullptr;
    if ( values() ) {
        for ( auto* values__elem_ : *values() ) {
            delete values__elem_;
            values__elem_ = nullptr;
        }
    }
    delete values_;
}

int Attributes::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "null_bitmap"
    int t_null_bitmap__size;
    t_null_bitmap__size =  ( count() + 7 )  / 8;
    // Checking out-of-bound for "Attributes:null_bitmap"
    if ( t_begin_of_data + (t_null_bitmap__size) > t_end_of_data || t_begin_of_data + (t_null_bitmap__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Attributes:null_bitmap",
        	(0) + (t_null_bitmap__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_null_bitmap__size;
        int t_null_bitmap_string_length;
        t_null_bitmap_string_length =  ( count() + 7 )  / 8;
        // check for negative sizes
        if ( t_null_bitmap_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:491", t_null_bitmap_string_length);
        null_bitmap_.init(t_begin_of_data, t_null_bitmap_string_length);
    }

    const_byteptr const t_dataptr_after_null_bitmap = t_begin_of_data + (t_null_bitmap__size);
    BINPAC_ASSERT(t_dataptr_after_null_bitmap <= t_end_of_data);
    // Checking out-of-bound for "Attributes:send_types_to_server"
    if ( t_dataptr_after_null_bitmap + (1) > t_end_of_data || t_dataptr_after_null_bitmap + (1) < t_dataptr_after_null_bitmap ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Attributes:send_types_to_server",
        	((t_dataptr_after_null_bitmap - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "send_types_to_server"
    send_types_to_server_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_null_bitmap));
    // Evaluate '&enforce' attribute
    if (! ( send_types_to_server() == 1 ) ) {
        throw binpac::ExceptionEnforceViolation("Attributes:send_types_to_server");
    }

    // Parse "names"
    int t_names__arraylength;
    t_names__arraylength = count();
    if ( t_names__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("Attributes:names",
          t_names__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: Attributes:names
    if ( t_names__arraylength > ((t_end_of_data - (t_dataptr_after_null_bitmap + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("Attributes:names",
          t_names__arraylength, (t_end_of_data) - ((t_dataptr_after_null_bitmap + 1)));
    names__elem_ = nullptr;
    int t_names__elem__it;
    t_names__elem__it = 0;
    int t_names__size;
    names_ = new vector<AttributeTypeAndName*>;
    names_->reserve(t_names__arraylength);
    const_byteptr t_names__elem__dataptr = (t_dataptr_after_null_bitmap + 1);
    for (; t_names__elem__it < t_names__arraylength; ++t_names__elem__it) {
        names__elem_ = new AttributeTypeAndName();
        int t_names__elem__size;
        t_names__elem__size = names__elem_->Parse(t_names__elem__dataptr, t_end_of_data, t_byteorder);
        names_->push_back(names__elem_);
        t_names__elem__dataptr += t_names__elem__size;
        BINPAC_ASSERT(t_names__elem__dataptr <= t_end_of_data);
        names__elem_ = nullptr;
    }
end_of_names: ;
    t_names__size = t_names__elem__dataptr - ((t_dataptr_after_null_bitmap + 1));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_names = (t_dataptr_after_null_bitmap + 1) + (t_names__size);
    BINPAC_ASSERT(t_dataptr_after_names <= t_end_of_data);
    // Parse "values"
    int t_values__arraylength;
    t_values__arraylength = 0;
    values__elem_ = nullptr;
    int t_values__elem__it;
    t_values__elem__it = 0;
    int t_values__size;
    values_ = new vector<AttributeValue*>;
    const_byteptr t_values__elem__dataptr = t_dataptr_after_names;
    for (; /* forever */; ++t_values__elem__it) {
        // Check &until( ( @@$context->connection@->query_attr_idx@() >= count ) )
        if (  ( t_context->connection()->query_attr_idx() >= count() )  ) {
            delete values__elem_;
            values__elem_ = nullptr;
            goto end_of_values;
        }
        // Check &until(values__elem__dataptr >= end_of_data)
        if ( t_values__elem__dataptr >= t_end_of_data ) {
            values__elem_ = nullptr;
            goto end_of_values;
        }
        values__elem_ = new AttributeValue( ( null_bitmap()[t_context->connection()->query_attr_idx() / 8] >>  ( t_context->connection()->query_attr_idx() % 8 )  )  & 0x01, (*(names()))[t_context->connection()->query_attr_idx()]->type());
        int t_values__elem__size;
        t_values__elem__size = values__elem_->Parse(t_values__elem__dataptr, t_end_of_data, t_context, t_byteorder);
        values_->push_back(values__elem_);
        t_values__elem__dataptr += t_values__elem__size;
        BINPAC_ASSERT(t_values__elem__dataptr <= t_end_of_data);
        values__elem_ = nullptr;
    }
end_of_values: ;
    t_values__size = t_values__elem__dataptr - (t_dataptr_after_names);
    // Evaluate 'let' and 'withinput' fields

    int t_Attributes__size;
    const_byteptr const t_dataptr_after_values = t_dataptr_after_names + (t_values__size);
    BINPAC_ASSERT(t_dataptr_after_values <= t_end_of_data);
    t_Attributes__size = t_dataptr_after_values - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Attributes__size) <= t_end_of_data);
    return t_Attributes__size;
}

Query_Attributes::Query_Attributes() {
    count_ = nullptr;
    set_count_ = nullptr;
    have_attr_case_index_ = -1;
    attrs_ = nullptr;
    attr_count_ = 0;
    new_query_attrs_ = 0;
}

Query_Attributes::~Query_Attributes() {
    delete count_;
    count_ = nullptr;
    delete set_count_;
    set_count_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_attr_case_index() ) {
        case ((int)1):
            // Clean up "attrs"
            {
                delete attrs_;
                attrs_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Query_Attributes::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "count"
    count_ = new LengthEncodedInteger();
    int t_count__size;
    t_count__size = count_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_count = t_begin_of_data + (t_count__size);
    BINPAC_ASSERT(t_dataptr_after_count <= t_end_of_data);
    // Parse "set_count"
    set_count_ = new LengthEncodedInteger();
    int t_set_count__size;
    t_set_count__size = set_count_->Parse(t_dataptr_after_count, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_set_count = t_dataptr_after_count + (t_set_count__size);
    BINPAC_ASSERT(t_dataptr_after_set_count <= t_end_of_data);
    // Parse "have_attr"
    new_query_attrs_ = t_context->connection()->new_query_attrs();
    int t_have_attr__size;
    attr_count_ = to_int()(count());
    have_attr_case_index_ =  ( attr_count() > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_attr_case_index() ) {
        case ((int)1):
            // Parse "attrs"
            {
                attrs_ = new Attributes(attr_count());
                int t_attrs__size;
                t_attrs__size = attrs_->Parse(t_dataptr_after_set_count, t_end_of_data, t_context, t_byteorder);
                t_have_attr__size = t_attrs__size;
            }
            break;
        case ((int)0):
            // Parse "none"
            {
                t_have_attr__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Query_Attributes", (int64)have_attr_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Query_Attributes__size;
    const_byteptr const t_dataptr_after_have_attr = t_dataptr_after_set_count + (t_have_attr__size);
    BINPAC_ASSERT(t_dataptr_after_have_attr <= t_end_of_data);
    t_Query_Attributes__size = t_dataptr_after_have_attr - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Query_Attributes__size) <= t_end_of_data);
    return t_Query_Attributes__size;
}

Command_Request_Packet::Command_Request_Packet(uint32 pkt_len) {
    command_ = 0;
    attrs_case_index_ = -1;
    query_attrs_ = nullptr;
    have_change_user_case_index_ = -1;
    change_user_ = nullptr;
    pkt_len_ = pkt_len;
    is_change_user_ = 0;
    update_expectation_ = false;
    proc_ = 0;
    proc_change_user_ = 0;
    has_proc_change_user_ = false;
}

Command_Request_Packet::~Command_Request_Packet() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( attrs_case_index() ) {
        case ((int)1):
            // Clean up "query_attrs"
            {
                delete query_attrs_;
                query_attrs_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_change_user_case_index() ) {
        case ((int)1):
            // Clean up "change_user"
            {
                delete change_user_;
                change_user_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "none_change_user"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    arg_.free();
}

int Command_Request_Packet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "Command_Request_Packet:command"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Command_Request_Packet:command",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "command"
    command_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "attrs"
    int t_attrs__size;
    attrs_case_index_ =  ( command() == COM_QUERY && t_context->connection()->get_client_query_attrs() && t_context->connection()->get_server_query_attrs() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( attrs_case_index() ) {
        case ((int)1):
            // Parse "query_attrs"
            {
                query_attrs_ = new Query_Attributes();
                int t_query_attrs__size;
                t_query_attrs__size = query_attrs_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_attrs__size = t_query_attrs__size;
            }
            break;
        case ((int)0):
            // Parse "none"
            {
                t_attrs__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Command_Request_Packet", (int64)attrs_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_attrs = (t_begin_of_data + 1) + (t_attrs__size);
    BINPAC_ASSERT(t_dataptr_after_attrs <= t_end_of_data);
    // Parse "have_change_user"
    int t_have_change_user__size;
    is_change_user_ = command() == COM_CHANGE_USER;
    have_change_user_case_index_ = is_change_user();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_change_user_case_index() ) {
        case ((int)1):
            // Parse "change_user"
            {
                change_user_ = new Change_User_Packet(pkt_len());
                int t_change_user__size;
                t_change_user__size = change_user_->Parse(t_dataptr_after_attrs, t_end_of_data, t_context, t_byteorder);
                t_have_change_user__size = t_change_user__size;
            }
            break;
        case ((int)0):
            // Parse "none_change_user"
            {
                t_have_change_user__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Command_Request_Packet", (int64)have_change_user_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_change_user = t_dataptr_after_attrs + (t_have_change_user__size);
    BINPAC_ASSERT(t_dataptr_after_have_change_user <= t_end_of_data);
    // Parse "arg"
    int t_arg_string_length;
    t_arg_string_length = (t_end_of_data) - (t_dataptr_after_have_change_user);
    int t_arg__size;
    t_arg__size = t_arg_string_length;
    // check for negative sizes
    if ( t_arg_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:529", t_arg_string_length);
    arg_.init(t_dataptr_after_have_change_user, t_arg_string_length);

    int t_Command_Request_Packet__size;
    const_byteptr const t_dataptr_after_arg = t_dataptr_after_have_change_user + (t_arg__size);
    BINPAC_ASSERT(t_dataptr_after_arg <= t_end_of_data);
    t_Command_Request_Packet__size = t_dataptr_after_arg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    update_expectation_ = t_context->connection()->set_next_expected_from_command(command());
    proc_ = t_context->flow()->proc_mysql_command_request_packet(this);
    has_proc_change_user_ =  ( is_change_user() ) ;
    if ( has_proc_change_user() ) {
        proc_change_user_ = t_context->flow()->proc_mysql_change_user_packet(change_user());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_Command_Request_Packet__size) <= t_end_of_data);
    return t_Command_Request_Packet__size;
}

Change_User_Packet::Change_User_Packet(uint32 pkt_len) {
    auth_plugin_data_len_ = 0;
    charset_ = 0;
    auth_plugin_name_case_case_index_ = -1;
    conn_attrs_case_case_index_ = -1;
    conn_attrs_ = nullptr;
    pkt_len_ = pkt_len;
    have_more_data_ = 0;
    have_auth_plugin_name_ = 0;
    have_conn_attrs_ = 0;
}

Change_User_Packet::~Change_User_Packet() {
    username_.free();
    auth_plugin_data_.free();
    database_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( auth_plugin_name_case_case_index() ) {
        case ((int)1):
            // Clean up "auth_plugin_name"
            {
                auth_plugin_name_.free();
            }
            break;
        case ((int)0):
            // Clean up "no_more_data1"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( conn_attrs_case_case_index() ) {
        case ((int)1):
            // Clean up "conn_attrs"
            {
                delete conn_attrs_;
                conn_attrs_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "no_conn_attrs"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Change_User_Packet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    sourcedata_ = const_bytestring(t_begin_of_data, t_end_of_data);
    // Parse "username"
    int t_username_string_length;
    t_username_string_length = 
        NUL_String_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_username_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:539", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_username__size;
    t_username__size = t_username_string_length;
    // check for negative sizes
    if ( t_username_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:539", t_username_string_length);
    username_.init(t_begin_of_data, t_username_string_length);

    const_byteptr const t_dataptr_after_username = t_begin_of_data + (t_username__size);
    BINPAC_ASSERT(t_dataptr_after_username <= t_end_of_data);
    // Checking out-of-bound for "Change_User_Packet:auth_plugin_data_len"
    if ( t_dataptr_after_username + (1) > t_end_of_data || t_dataptr_after_username + (1) < t_dataptr_after_username ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Change_User_Packet:auth_plugin_data_len",
        	((t_dataptr_after_username - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "auth_plugin_data_len"
    auth_plugin_data_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_username));

    // Parse "auth_plugin_data"
    int t_auth_plugin_data__size;
    t_auth_plugin_data__size = auth_plugin_data_len();
    // Checking out-of-bound for "Change_User_Packet:auth_plugin_data"
    if ( (t_dataptr_after_username + 1) + (t_auth_plugin_data__size) > t_end_of_data || (t_dataptr_after_username + 1) + (t_auth_plugin_data__size) < (t_dataptr_after_username + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Change_User_Packet:auth_plugin_data",
        	(((t_dataptr_after_username + 1) - t_begin_of_data)) + (t_auth_plugin_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_username + 1) + t_auth_plugin_data__size;
        int t_auth_plugin_data_string_length;
        t_auth_plugin_data_string_length = auth_plugin_data_len();
        // check for negative sizes
        if ( t_auth_plugin_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:541", t_auth_plugin_data_string_length);
        auth_plugin_data_.init((t_dataptr_after_username + 1), t_auth_plugin_data_string_length);
    }

    const_byteptr const t_dataptr_after_auth_plugin_data = (t_dataptr_after_username + 1) + (t_auth_plugin_data__size);
    BINPAC_ASSERT(t_dataptr_after_auth_plugin_data <= t_end_of_data);
    // Parse "database"
    int t_database_string_length;
    t_database_string_length = 
        NUL_String_re_001.MatchPrefix(
            t_dataptr_after_auth_plugin_data,
            t_end_of_data - t_dataptr_after_auth_plugin_data);
    if ( t_database_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:542", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_dataptr_after_auth_plugin_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_database__size;
    t_database__size = t_database_string_length;
    // check for negative sizes
    if ( t_database_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:542", t_database_string_length);
    database_.init(t_dataptr_after_auth_plugin_data, t_database_string_length);

    const_byteptr const t_dataptr_after_database = t_dataptr_after_auth_plugin_data + (t_database__size);
    BINPAC_ASSERT(t_dataptr_after_database <= t_end_of_data);
    // Checking out-of-bound for "Change_User_Packet:charset"
    if ( t_dataptr_after_database + (2) > t_end_of_data || t_dataptr_after_database + (2) < t_dataptr_after_database ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Change_User_Packet:charset",
        	((t_dataptr_after_database - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "charset"
    charset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_database)));

    // Parse "auth_plugin_name_case"
    int t_auth_plugin_name_case__size;
    have_more_data_ = ((t_dataptr_after_database + 2) - t_begin_of_data) < pkt_len();
    have_auth_plugin_name_ = have_more_data() &&  ( t_context->connection()->get_client_capabilities() & CLIENT_PLUGIN_AUTH )  == CLIENT_PLUGIN_AUTH;
    auth_plugin_name_case_case_index_ = have_auth_plugin_name();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( auth_plugin_name_case_case_index() ) {
        case ((int)1):
            // Parse "auth_plugin_name"
            {
                int t_auth_plugin_name_string_length;
                t_auth_plugin_name_string_length = 
                    NUL_String_re_001.MatchPrefix(
                        (t_dataptr_after_database + 2),
                        t_end_of_data - (t_dataptr_after_database + 2));
                if ( t_auth_plugin_name_string_length < 0 ) {
                    throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:546", "[^\\0]*\\0", string(reinterpret_cast<const char*>((t_dataptr_after_database + 2)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
                }
                int t_auth_plugin_name__size;
                t_auth_plugin_name__size = t_auth_plugin_name_string_length;
                // check for negative sizes
                if ( t_auth_plugin_name_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:546", t_auth_plugin_name_string_length);
                auth_plugin_name_.init((t_dataptr_after_database + 2), t_auth_plugin_name_string_length);
                t_auth_plugin_name_case__size = t_auth_plugin_name__size;
            }
            break;
        case ((int)0):
            // Parse "no_more_data1"
            {
                t_auth_plugin_name_case__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Change_User_Packet", (int64)auth_plugin_name_case_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_auth_plugin_name_case = (t_dataptr_after_database + 2) + (t_auth_plugin_name_case__size);
    BINPAC_ASSERT(t_dataptr_after_auth_plugin_name_case <= t_end_of_data);
    // Parse "conn_attrs_case"
    int t_conn_attrs_case__size;
    have_conn_attrs_ = have_more_data() &&  ( t_context->connection()->get_client_capabilities() & CLIENT_CONNECT_ATTRS )  == CLIENT_CONNECT_ATTRS;
    conn_attrs_case_case_index_ = have_conn_attrs();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( conn_attrs_case_case_index() ) {
        case ((int)1):
            // Parse "conn_attrs"
            {
                conn_attrs_ = new Handshake_Connection_Attributes();
                int t_conn_attrs__size;
                t_conn_attrs__size = conn_attrs_->Parse(t_dataptr_after_auth_plugin_name_case, t_end_of_data, t_byteorder);
                t_conn_attrs_case__size = t_conn_attrs__size;
            }
            break;
        case ((int)0):
            // Parse "no_conn_attrs"
            {
                t_conn_attrs_case__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Change_User_Packet", (int64)conn_attrs_case_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Change_User_Packet__size;
    const_byteptr const t_dataptr_after_conn_attrs_case = t_dataptr_after_auth_plugin_name_case + (t_conn_attrs_case__size);
    BINPAC_ASSERT(t_dataptr_after_conn_attrs_case <= t_end_of_data);
    t_Change_User_Packet__size = t_dataptr_after_conn_attrs_case - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    sourcedata_.set_end(t_begin_of_data + t_Change_User_Packet__size);
    BINPAC_ASSERT(t_begin_of_data + (t_Change_User_Packet__size) <= t_end_of_data);
    return t_Change_User_Packet__size;
}

Command_Response::Command_Response(uint32 pkt_len) {
    val_case_index_ = -1;
    col_count_meta_ = nullptr;
    col_def_ = nullptr;
    def_or_eof_ = nullptr;
    resultset_ = nullptr;
    status_ = nullptr;
    eof_ = nullptr;
    pkt_len_ = pkt_len;
}

Command_Response::~Command_Response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((Expected)4):
            // Clean up "col_count_meta"
            {
                delete col_count_meta_;
                col_count_meta_ = nullptr;
            }
            break;
        case ((Expected)2):
            // Clean up "col_def"
            {
                delete col_def_;
                col_def_ = nullptr;
            }
            break;
        case ((Expected)3):
            // Clean up "def_or_eof"
            {
                delete def_or_eof_;
                def_or_eof_ = nullptr;
            }
            break;
        case ((Expected)6):
            // Clean up "resultset"
            {
                delete resultset_;
                resultset_ = nullptr;
            }
            break;
        case ((Expected)7):
            // Clean up "rest"
            {
                rest_.free();
            }
            break;
        case ((Expected)1):
            // Clean up "status"
            {
                delete status_;
                status_ = nullptr;
            }
            break;
        case ((Expected)5):
            // Clean up "eof"
            {
                delete eof_;
                eof_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Command_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = t_context->connection()->get_expectation();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((Expected)4):
            // Parse "col_count_meta"
            {
                col_count_meta_ = new ColumnCountMeta();
                int t_col_count_meta__size;
                t_col_count_meta__size = col_count_meta_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_col_count_meta__size;
            }
            break;
        case ((Expected)2):
            // Parse "col_def"
            {
                col_def_ = new ColumnDefinition();
                int t_col_def__size;
                t_col_def__size = col_def_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_col_def__size;
            }
            break;
        case ((Expected)3):
            // Parse "def_or_eof"
            {
                def_or_eof_ = new ColumnDefinitionOrEOF(pkt_len());
                int t_def_or_eof__size;
                t_def_or_eof__size = def_or_eof_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_def_or_eof__size;
            }
            break;
        case ((Expected)6):
            // Parse "resultset"
            {
                resultset_ = new Resultset(pkt_len());
                int t_resultset__size;
                t_resultset__size = resultset_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_resultset__size;
            }
            break;
        case ((Expected)7):
            // Parse "rest"
            {
                int t_rest_string_length;
                t_rest_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_rest__size;
                t_rest__size = t_rest_string_length;
                // check for negative sizes
                if ( t_rest_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:567", t_rest_string_length);
                rest_.init(t_begin_of_data, t_rest_string_length);
                t_val__size = t_rest__size;
            }
            break;
        case ((Expected)1):
            // Parse "status"
            {
                status_ = new Command_Response_Status();
                int t_status__size;
                t_status__size = status_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_status__size;
            }
            break;
        case ((Expected)5):
            // Parse "eof"
            {
                eof_ = new EOFIfLegacyThenResultset(pkt_len());
                int t_eof__size;
                t_eof__size = eof_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_eof__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                t_val__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Command_Response_Status::Command_Response_Status() {
    pkt_type_ = 0;
    response_case_index_ = -1;
    data_ok_ = nullptr;
    data_eof_ = nullptr;
    data_err_ = nullptr;
}

Command_Response_Status::~Command_Response_Status() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( response_case_index() ) {
        case ((uint8)0):
            // Clean up "data_ok"
            {
                delete data_ok_;
                data_ok_ = nullptr;
            }
            break;
        case ((uint8)254):
            // Clean up "data_eof"
            {
                delete data_eof_;
                data_eof_ = nullptr;
            }
            break;
        case ((uint8)255):
            // Clean up "data_err"
            {
                delete data_err_;
                data_err_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Command_Response_Status::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "Command_Response_Status:pkt_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Command_Response_Status:pkt_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "pkt_type"
    pkt_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "response"
    int t_response__size;
    response_case_index_ = pkt_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( response_case_index() ) {
        case ((uint8)0):
            // Parse "data_ok"
            {
                data_ok_ = new OK_Packet();
                int t_data_ok__size;
                t_data_ok__size = data_ok_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_response__size = t_data_ok__size;
            }
            break;
        case ((uint8)254):
            // Parse "data_eof"
            {
                data_eof_ = new EOF_Packet(EOF_END);
                data_eof_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_response__size = 4;
            }
            break;
        case ((uint8)255):
            // Parse "data_err"
            {
                data_err_ = new ERR_Packet();
                int t_data_err__size;
                t_data_err__size = data_err_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_response__size = t_data_err__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                t_response__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Command_Response_Status__size;
    const_byteptr const t_dataptr_after_response = (t_begin_of_data + 1) + (t_response__size);
    BINPAC_ASSERT(t_dataptr_after_response <= t_end_of_data);
    t_Command_Response_Status__size = t_dataptr_after_response - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Command_Response_Status__size) <= t_end_of_data);
    return t_Command_Response_Status__size;
}

ColumnCountMeta::ColumnCountMeta() {
    byte_ = 0;
    pkt_type_case_index_ = -1;
    ok_ = nullptr;
    err_ = nullptr;
    col_count_ = nullptr;
}

ColumnCountMeta::~ColumnCountMeta() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pkt_type_case_index() ) {
        case ((uint8)0):
            // Clean up "ok"
            {
                delete ok_;
                ok_ = nullptr;
            }
            break;
        case ((uint8)255):
            // Clean up "err"
            {
                delete err_;
                err_ = nullptr;
            }
            break;
        default:
            // Clean up "col_count"
            {
                delete col_count_;
                col_count_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ColumnCountMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "ColumnCountMeta:byte"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ColumnCountMeta:byte",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte"
    byte_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "pkt_type"
    int t_pkt_type__size;
    pkt_type_case_index_ = byte();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pkt_type_case_index() ) {
        case ((uint8)0):
            // Parse "ok"
            {
                ok_ = new OK_Packet();
                int t_ok__size;
                t_ok__size = ok_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_pkt_type__size = t_ok__size;
            }
            break;
        case ((uint8)255):
            // Parse "err"
            {
                err_ = new ERR_Packet();
                int t_err__size;
                t_err__size = err_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_pkt_type__size = t_err__size;
            }
            break;
        default:
            // Parse "col_count"
            {
                col_count_ = new ColumnCount(byte());
                int t_col_count__size;
                t_col_count__size = col_count_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_pkt_type__size = t_col_count__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ColumnCountMeta__size;
    const_byteptr const t_dataptr_after_pkt_type = (t_begin_of_data + 1) + (t_pkt_type__size);
    BINPAC_ASSERT(t_dataptr_after_pkt_type <= t_end_of_data);
    t_ColumnCountMeta__size = t_dataptr_after_pkt_type - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ColumnCountMeta__size) <= t_end_of_data);
    return t_ColumnCountMeta__size;
}

ColumnCount::ColumnCount(uint8 byte) {
    le_column_count_ = nullptr;
    byte_ = byte;
    col_num_ = 0;
    update_col_num_ = false;
    update_remain_ = false;
    update_expectation_ = false;
}

ColumnCount::~ColumnCount() {
    delete le_column_count_;
    le_column_count_ = nullptr;
}

int ColumnCount::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "le_column_count"
    le_column_count_ = new LengthEncodedIntegerLookahead(byte());
    int t_le_column_count__size;
    t_le_column_count__size = le_column_count_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    int t_ColumnCount__size;
    const_byteptr const t_dataptr_after_le_column_count = t_begin_of_data + (t_le_column_count__size);
    BINPAC_ASSERT(t_dataptr_after_le_column_count <= t_end_of_data);
    t_ColumnCount__size = t_dataptr_after_le_column_count - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    col_num_ = to_int()(le_column_count());
    update_col_num_ = t_context->connection()->set_col_count(col_num());
    update_remain_ = t_context->connection()->set_remaining_cols(col_num());
    update_expectation_ = t_context->connection()->set_next_expected(EXPECT_COLUMN_DEFINITION);
    BINPAC_ASSERT(t_begin_of_data + (t_ColumnCount__size) <= t_end_of_data);
    return t_ColumnCount__size;
}

ColumnDefinition::ColumnDefinition() {
    dummy_ = 0;
    def_ = nullptr;
    update_remain_ = false;
    update_expectation_ = false;
}

ColumnDefinition::~ColumnDefinition() {
    delete def_;
    def_ = nullptr;
}

int ColumnDefinition::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "ColumnDefinition:dummy"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ColumnDefinition:dummy",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dummy"
    dummy_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "def"
    def_ = new ColumnDefinition41(dummy());
    int t_def__size;
    t_def__size = def_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);

    int t_ColumnDefinition__size;
    const_byteptr const t_dataptr_after_def = (t_begin_of_data + 1) + (t_def__size);
    BINPAC_ASSERT(t_dataptr_after_def <= t_end_of_data);
    t_ColumnDefinition__size = t_dataptr_after_def - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    update_remain_ = t_context->connection()->dec_remaining_cols();
    update_expectation_ = t_context->connection()->set_next_expected(t_context->connection()->get_remaining_cols() > 0 ? EXPECT_COLUMN_DEFINITION : EXPECT_EOF_THEN_RESULTSET);
    BINPAC_ASSERT(t_begin_of_data + (t_ColumnDefinition__size) <= t_end_of_data);
    return t_ColumnDefinition__size;
}

EOFOrOK::EOFOrOK(uint32 pkt_len) {
    val_case_index_ = -1;
    eof_ = nullptr;
    ok_ = nullptr;
    pkt_len_ = pkt_len;
}

EOFOrOK::~EOFOrOK() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Clean up "eof"
            {
                delete eof_;
                eof_ = nullptr;
            }
            break;
        case ((int)1):
            // Clean up "ok"
            {
                delete ok_;
                ok_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int EOFOrOK::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ =  ( t_context->connection()->get_deprecate_eof() || pkt_len() > 13 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Parse "eof"
            {
                eof_ = new EOF_Packet(EOF_END);
                eof_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 4;
            }
            break;
        case ((int)1):
            // Parse "ok"
            {
                ok_ = new OK_Packet();
                int t_ok__size;
                t_ok__size = ok_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_ok__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("EOFOrOK", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ColumnDefinitionOrEOF::ColumnDefinitionOrEOF(uint32 pkt_len) {
    marker_ = 0;
    def_or_eof_case_index_ = -1;
    eof_ = nullptr;
    def_ = nullptr;
    pkt_len_ = pkt_len;
    is_eof_or_ok_ = false;
}

ColumnDefinitionOrEOF::~ColumnDefinitionOrEOF() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( def_or_eof_case_index() ) {
        case true:
            // Clean up "eof"
            {
                delete eof_;
                eof_ = nullptr;
            }
            break;
        case false:
            // Clean up "def"
            {
                delete def_;
                def_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ColumnDefinitionOrEOF::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "ColumnDefinitionOrEOF:marker"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ColumnDefinitionOrEOF:marker",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "marker"
    marker_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "def_or_eof"
    is_eof_or_ok_ =  ( marker() == 0xfe ) ;
    int t_def_or_eof__size;
    def_or_eof_case_index_ = is_eof_or_ok();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( def_or_eof_case_index() ) {
        case true:
            // Parse "eof"
            {
                eof_ = new EOFOrOK(pkt_len());
                int t_eof__size;
                t_eof__size = eof_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_def_or_eof__size = t_eof__size;
            }
            break;
        case false:
            // Parse "def"
            {
                def_ = new ColumnDefinition41(marker());
                int t_def__size;
                t_def__size = def_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_def_or_eof__size = t_def__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ColumnDefinitionOrEOF", (int64)def_or_eof_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ColumnDefinitionOrEOF__size;
    const_byteptr const t_dataptr_after_def_or_eof = (t_begin_of_data + 1) + (t_def_or_eof__size);
    BINPAC_ASSERT(t_dataptr_after_def_or_eof <= t_end_of_data);
    t_ColumnDefinitionOrEOF__size = t_dataptr_after_def_or_eof - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ColumnDefinitionOrEOF__size) <= t_end_of_data);
    return t_ColumnDefinitionOrEOF__size;
}

EOFIfLegacyThenResultset::EOFIfLegacyThenResultset(uint32 pkt_len) {
    val_case_index_ = -1;
    eof_ = nullptr;
    resultset_ = nullptr;
    pkt_len_ = pkt_len;
    update_result_seen_ = false;
    update_expectation_ = false;
    has_update_expectation_ = false;
}

EOFIfLegacyThenResultset::~EOFIfLegacyThenResultset() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case false:
            // Clean up "eof"
            {
                delete eof_;
                eof_ = nullptr;
            }
            break;
        case true:
            // Clean up "resultset"
            {
                delete resultset_;
                resultset_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int EOFIfLegacyThenResultset::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = t_context->connection()->get_deprecate_eof();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case false:
            // Parse "eof"
            {
                eof_ = new EOF_Packet_With_Marker(EOF_INTERMEDIATE);
                eof_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 5;
            }
            break;
        case true:
            // Parse "resultset"
            {
                resultset_ = new Resultset(pkt_len());
                int t_resultset__size;
                t_resultset__size = resultset_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_resultset__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("EOFIfLegacyThenResultset", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    update_result_seen_ = t_context->connection()->set_results_seen(0);
    has_update_expectation_ =  ( ! t_context->connection()->get_deprecate_eof() ) ;
    if ( has_update_expectation() ) {
        update_expectation_ = t_context->connection()->set_next_expected(EXPECT_RESULTSET);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Resultset::Resultset(uint32 pkt_len) {
    marker_ = 0;
    row_or_eof_case_index_ = -1;
    eof_ = nullptr;
    row_ = nullptr;
    pkt_len_ = pkt_len;
    is_eof_or_ok_ = false;
    update_result_seen_ = false;
    update_expectation_ = false;
    proc_ = 0;
}

Resultset::~Resultset() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( row_or_eof_case_index() ) {
        case true:
            // Clean up "eof"
            {
                delete eof_;
                eof_ = nullptr;
            }
            break;
        case false:
            // Clean up "row"
            {
                delete row_;
                row_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Resultset::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "Resultset:marker"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Resultset:marker",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "marker"
    marker_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "row_or_eof"
    is_eof_or_ok_ =  ( marker() == 0xfe ) ;
    int t_row_or_eof__size;
    row_or_eof_case_index_ = is_eof_or_ok();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( row_or_eof_case_index() ) {
        case true:
            // Parse "eof"
            {
                eof_ = new EOFOrOK(pkt_len());
                int t_eof__size;
                t_eof__size = eof_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_row_or_eof__size = t_eof__size;
            }
            break;
        case false:
            // Parse "row"
            {
                row_ = new ResultsetRow(marker());
                int t_row__size;
                t_row__size = row_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_row_or_eof__size = t_row__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Resultset", (int64)row_or_eof_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Resultset__size;
    const_byteptr const t_dataptr_after_row_or_eof = (t_begin_of_data + 1) + (t_row_or_eof__size);
    BINPAC_ASSERT(t_dataptr_after_row_or_eof <= t_end_of_data);
    t_Resultset__size = t_dataptr_after_row_or_eof - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    update_result_seen_ = t_context->connection()->inc_results_seen();
    update_expectation_ = t_context->connection()->set_next_expected(is_eof_or_ok() ? NO_EXPECTATION : EXPECT_RESULTSET);
    proc_ = t_context->flow()->proc_resultset(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Resultset__size) <= t_end_of_data);
    return t_Resultset__size;
}

ResultsetRow::ResultsetRow(uint8 first_byte) {
    first_field_ = nullptr;
    fields_ = nullptr;
    fields__elem_ = nullptr;
    first_byte_ = first_byte;
}

ResultsetRow::~ResultsetRow() {
    delete first_field_;
    first_field_ = nullptr;
    delete fields__elem_;
    fields__elem_ = nullptr;
    if ( fields() ) {
        for ( auto* fields__elem_ : *fields() ) {
            delete fields__elem_;
            fields__elem_ = nullptr;
        }
    }
    delete fields_;
}

int ResultsetRow::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "first_field"
    first_field_ = new LengthEncodedStringArg(first_byte());
    int t_first_field__size;
    t_first_field__size = first_field_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_first_field = t_begin_of_data + (t_first_field__size);
    BINPAC_ASSERT(t_dataptr_after_first_field <= t_end_of_data);
    // Parse "fields"
    int t_fields__arraylength;
    t_fields__arraylength = t_context->connection()->get_col_count() - 1;
    if ( t_fields__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ResultsetRow:fields",
          t_fields__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: ResultsetRow:fields
    if ( t_fields__arraylength > ((t_end_of_data - t_dataptr_after_first_field) / 1) )
        throw binpac::ExceptionOutOfBound("ResultsetRow:fields",
          t_fields__arraylength, (t_end_of_data) - (t_dataptr_after_first_field));
    fields__elem_ = nullptr;
    int t_fields__elem__it;
    t_fields__elem__it = 0;
    int t_fields__size;
    fields_ = new vector<LengthEncodedString*>;
    fields_->reserve(t_fields__arraylength);
    const_byteptr t_fields__elem__dataptr = t_dataptr_after_first_field;
    for (; t_fields__elem__it < t_fields__arraylength; ++t_fields__elem__it) {
        fields__elem_ = new LengthEncodedString();
        int t_fields__elem__size;
        t_fields__elem__size = fields__elem_->Parse(t_fields__elem__dataptr, t_end_of_data, t_byteorder);
        fields_->push_back(fields__elem_);
        t_fields__elem__dataptr += t_fields__elem__size;
        BINPAC_ASSERT(t_fields__elem__dataptr <= t_end_of_data);
        fields__elem_ = nullptr;
    }
end_of_fields: ;
    t_fields__size = t_fields__elem__dataptr - (t_dataptr_after_first_field);
    // Evaluate 'let' and 'withinput' fields

    int t_ResultsetRow__size;
    const_byteptr const t_dataptr_after_fields = t_dataptr_after_first_field + (t_fields__size);
    BINPAC_ASSERT(t_dataptr_after_fields <= t_end_of_data);
    t_ResultsetRow__size = t_dataptr_after_fields - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ResultsetRow__size) <= t_end_of_data);
    return t_ResultsetRow__size;
}

ColumnDefinition41::ColumnDefinition41(uint8 first_byte) {
    catalog_ = nullptr;
    schema_ = nullptr;
    table_ = nullptr;
    org_table_ = nullptr;
    name_ = nullptr;
    org_name_ = nullptr;
    next_len_ = nullptr;
    char_set_ = 0;
    col_len_ = 0;
    type_ = 0;
    flags_ = 0;
    decimals_ = 0;
    first_byte_ = first_byte;
}

ColumnDefinition41::~ColumnDefinition41() {
    delete catalog_;
    catalog_ = nullptr;
    delete schema_;
    schema_ = nullptr;
    delete table_;
    table_ = nullptr;
    delete org_table_;
    org_table_ = nullptr;
    delete name_;
    name_ = nullptr;
    delete org_name_;
    org_name_ = nullptr;
    delete next_len_;
    next_len_ = nullptr;
}

int ColumnDefinition41::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "catalog"
    catalog_ = new LengthEncodedStringArg(first_byte());
    int t_catalog__size;
    t_catalog__size = catalog_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_catalog = t_begin_of_data + (t_catalog__size);
    BINPAC_ASSERT(t_dataptr_after_catalog <= t_end_of_data);
    // Parse "schema"
    schema_ = new LengthEncodedString();
    int t_schema__size;
    t_schema__size = schema_->Parse(t_dataptr_after_catalog, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_schema = t_dataptr_after_catalog + (t_schema__size);
    BINPAC_ASSERT(t_dataptr_after_schema <= t_end_of_data);
    // Parse "table"
    table_ = new LengthEncodedString();
    int t_table__size;
    t_table__size = table_->Parse(t_dataptr_after_schema, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_table = t_dataptr_after_schema + (t_table__size);
    BINPAC_ASSERT(t_dataptr_after_table <= t_end_of_data);
    // Parse "org_table"
    org_table_ = new LengthEncodedString();
    int t_org_table__size;
    t_org_table__size = org_table_->Parse(t_dataptr_after_table, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_org_table = t_dataptr_after_table + (t_org_table__size);
    BINPAC_ASSERT(t_dataptr_after_org_table <= t_end_of_data);
    // Parse "name"
    name_ = new LengthEncodedString();
    int t_name__size;
    t_name__size = name_->Parse(t_dataptr_after_org_table, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_name = t_dataptr_after_org_table + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Parse "org_name"
    org_name_ = new LengthEncodedString();
    int t_org_name__size;
    t_org_name__size = org_name_->Parse(t_dataptr_after_name, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_org_name = t_dataptr_after_name + (t_org_name__size);
    BINPAC_ASSERT(t_dataptr_after_org_name <= t_end_of_data);
    // Parse "next_len"
    next_len_ = new LengthEncodedInteger();
    int t_next_len__size;
    t_next_len__size = next_len_->Parse(t_dataptr_after_org_name, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_next_len = t_dataptr_after_org_name + (t_next_len__size);
    BINPAC_ASSERT(t_dataptr_after_next_len <= t_end_of_data);
    // Checking out-of-bound for "ColumnDefinition41:filler"
    if ( (t_dataptr_after_next_len + 10) + (2) > t_end_of_data || (t_dataptr_after_next_len + 10) + (2) < (t_dataptr_after_next_len + 10) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ColumnDefinition41:filler",
        	(((t_dataptr_after_next_len + 10) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "char_set"
    char_set_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_next_len)));

    // Parse "col_len"
    col_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_next_len + 2))));

    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_next_len + 6)));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_next_len + 7))));

    // Parse "decimals"
    decimals_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_next_len + 9)));


    int t_ColumnDefinition41__size;
    t_ColumnDefinition41__size = (t_dataptr_after_next_len + 12) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ColumnDefinition41__size) <= t_end_of_data);
    return t_ColumnDefinition41__size;
}

AuthMoreData::AuthMoreData(bool is_orig) {
    is_orig_ = is_orig;
    proc_ = 0;
}

AuthMoreData::~AuthMoreData() {
    data_.free();
}

int AuthMoreData::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:673", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_AuthMoreData__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_AuthMoreData__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_auth_more_data(this);
    BINPAC_ASSERT(t_begin_of_data + (t_AuthMoreData__size) <= t_end_of_data);
    return t_AuthMoreData__size;
}

AuthSwitchRequest::AuthSwitchRequest() {
    update_conn_expectation_ = false;
    update_expectation_ = false;
    proc_ = 0;
}

AuthSwitchRequest::~AuthSwitchRequest() {
    name_.free();
    data_.free();
}

int AuthSwitchRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context) {
    // Parse "name"
    int t_name_string_length;
    t_name_string_length = 
        NUL_String_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_name_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:677", "[^\\0]*\\0", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_name__size;
    t_name__size = t_name_string_length;
    // check for negative sizes
    if ( t_name_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:677", t_name_string_length);
    name_.init(t_begin_of_data, t_name_string_length);

    const_byteptr const t_dataptr_after_name = t_begin_of_data + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_dataptr_after_name);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:678", t_data_string_length);
    data_.init(t_dataptr_after_name, t_data_string_length);

    int t_AuthSwitchRequest__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_name + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_AuthSwitchRequest__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    update_conn_expectation_ = t_context->connection()->set_next_conn_expected(EXPECT_AUTH_DATA);
    update_expectation_ = t_context->connection()->set_next_expected(EXPECT_STATUS);
    proc_ = t_context->flow()->proc_auth_switch_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_AuthSwitchRequest__size) <= t_end_of_data);
    return t_AuthSwitchRequest__size;
}

ColumnDefinition320::ColumnDefinition320() {
    table_ = nullptr;
    name_ = nullptr;
    length_of_col_len_ = nullptr;
    col_len_ = nullptr;
    type_len_ = nullptr;
    type_ = 0;
}

ColumnDefinition320::~ColumnDefinition320() {
    delete table_;
    table_ = nullptr;
    delete name_;
    name_ = nullptr;
    delete length_of_col_len_;
    length_of_col_len_ = nullptr;
    delete col_len_;
    col_len_ = nullptr;
    delete type_len_;
    type_len_ = nullptr;
}

int ColumnDefinition320::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "table"
    table_ = new LengthEncodedString();
    int t_table__size;
    t_table__size = table_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_table = t_begin_of_data + (t_table__size);
    BINPAC_ASSERT(t_dataptr_after_table <= t_end_of_data);
    // Parse "name"
    name_ = new LengthEncodedString();
    int t_name__size;
    t_name__size = name_->Parse(t_dataptr_after_table, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_name = t_dataptr_after_table + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Parse "length_of_col_len"
    length_of_col_len_ = new LengthEncodedInteger();
    int t_length_of_col_len__size;
    t_length_of_col_len__size = length_of_col_len_->Parse(t_dataptr_after_name, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_length_of_col_len = t_dataptr_after_name + (t_length_of_col_len__size);
    BINPAC_ASSERT(t_dataptr_after_length_of_col_len <= t_end_of_data);
    // Checking out-of-bound for "ColumnDefinition320:col_len"
    if ( t_dataptr_after_length_of_col_len + (3) > t_end_of_data || t_dataptr_after_length_of_col_len + (3) < t_dataptr_after_length_of_col_len ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ColumnDefinition320:col_len",
        	((t_dataptr_after_length_of_col_len - t_begin_of_data)) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "col_len"
    col_len_ = new uint24le();
    col_len_->Parse(t_dataptr_after_length_of_col_len, t_end_of_data);

    // Parse "type_len"
    type_len_ = new LengthEncodedInteger();
    int t_type_len__size;
    t_type_len__size = type_len_->Parse((t_dataptr_after_length_of_col_len + 3), t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_type_len = (t_dataptr_after_length_of_col_len + 3) + (t_type_len__size);
    BINPAC_ASSERT(t_dataptr_after_type_len <= t_end_of_data);
    // Checking out-of-bound for "ColumnDefinition320:type"
    if ( t_dataptr_after_type_len + (1) > t_end_of_data || t_dataptr_after_type_len + (1) < t_dataptr_after_type_len ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ColumnDefinition320:type",
        	((t_dataptr_after_type_len - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_type_len));

    int t_ColumnDefinition320__size;
    t_ColumnDefinition320__size = (t_dataptr_after_type_len + 1) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ColumnDefinition320__size) <= t_end_of_data);
    return t_ColumnDefinition320__size;
}

OK_Packet::OK_Packet() {
    le_rows_ = nullptr;
    rows_ = 0;
    update_state_ = false;
    proc_ = 0;
}

OK_Packet::~OK_Packet() {
    delete le_rows_;
    le_rows_ = nullptr;
    todo_.free();
}

int OK_Packet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Parse "le_rows"
    le_rows_ = new LengthEncodedInteger();
    int t_le_rows__size;
    t_le_rows__size = le_rows_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_le_rows = t_begin_of_data + (t_le_rows__size);
    BINPAC_ASSERT(t_dataptr_after_le_rows <= t_end_of_data);
    // Parse "todo"
    int t_todo_string_length;
    t_todo_string_length = (t_end_of_data) - (t_dataptr_after_le_rows);
    int t_todo__size;
    t_todo__size = t_todo_string_length;
    // check for negative sizes
    if ( t_todo_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:696", t_todo_string_length);
    todo_.init(t_dataptr_after_le_rows, t_todo_string_length);

    int t_OK_Packet__size;
    const_byteptr const t_dataptr_after_todo = t_dataptr_after_le_rows + (t_todo__size);
    BINPAC_ASSERT(t_dataptr_after_todo <= t_end_of_data);
    t_OK_Packet__size = t_dataptr_after_todo - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    rows_ = to_int()(le_rows());
    update_state_ = t_context->connection()->update_state(COMMAND_PHASE);
    proc_ = t_context->flow()->proc_ok_packet(this);
    BINPAC_ASSERT(t_begin_of_data + (t_OK_Packet__size) <= t_end_of_data);
    return t_OK_Packet__size;
}

ERR_Packet::ERR_Packet() {
    code_ = 0;
    update_state_ = false;
    proc_ = 0;
}

ERR_Packet::~ERR_Packet() {
    state_.free();
    msg_.free();
}

int ERR_Packet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "ERR_Packet:code"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ERR_Packet:code",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "code"
    code_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "state"
    // Checking out-of-bound for "ERR_Packet:state"
    if ( (t_begin_of_data + 2) + (6) > t_end_of_data || (t_begin_of_data + 2) + (6) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ERR_Packet:state",
        	(2) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + 6;
        int t_state_string_length;
        t_state_string_length = 6;
        int t_state__size;
        t_state__size = t_state_string_length;
        state_.init((t_begin_of_data + 2), t_state_string_length);
    }

    const_byteptr const t_dataptr_after_state = (t_begin_of_data + 2) + (6);
    BINPAC_ASSERT(t_dataptr_after_state <= t_end_of_data);
    // Parse "msg"
    int t_msg_string_length;
    t_msg_string_length = (t_end_of_data) - (t_dataptr_after_state);
    int t_msg__size;
    t_msg__size = t_msg_string_length;
    // check for negative sizes
    if ( t_msg_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:705", t_msg_string_length);
    msg_.init(t_dataptr_after_state, t_msg_string_length);

    int t_ERR_Packet__size;
    const_byteptr const t_dataptr_after_msg = t_dataptr_after_state + (t_msg__size);
    BINPAC_ASSERT(t_dataptr_after_msg <= t_end_of_data);
    t_ERR_Packet__size = t_dataptr_after_msg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    update_state_ = t_context->connection()->update_state(COMMAND_PHASE);
    proc_ = t_context->flow()->proc_err_packet(this);
    BINPAC_ASSERT(t_begin_of_data + (t_ERR_Packet__size) <= t_end_of_data);
    return t_ERR_Packet__size;
}

EOF_Packet::EOF_Packet(EOFType typ) {
    warnings_ = 0;
    status_ = 0;
    typ_ = typ;
    proc_ = 0;
}

EOF_Packet::~EOF_Packet() {
}

int EOF_Packet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "EOF_Packet"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EOF_Packet",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "warnings"
    warnings_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "status"
    status_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_eof_packet(this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

EOF_Packet_With_Marker::EOF_Packet_With_Marker(EOFType typ) {
    marker_ = 0;
    payload_ = nullptr;
    typ_ = typ;
    update_state_ = false;
}

EOF_Packet_With_Marker::~EOF_Packet_With_Marker() {
    delete payload_;
    payload_ = nullptr;
}

int EOF_Packet_With_Marker::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder) {
    // Checking out-of-bound for "EOF_Packet_With_Marker"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EOF_Packet_With_Marker",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "marker"
    marker_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "payload"
    payload_ = new EOF_Packet(typ());
    payload_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);

    // Evaluate 'let' and 'withinput' fields
    update_state_ = t_context->connection()->update_state(COMMAND_PHASE);
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

MySQL_Flow::MySQL_Flow(MySQL_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

MySQL_Flow::~MySQL_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void MySQL_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new MySQL_PDU(is_orig());
                flow_buffer_->NewFrame(0, false);
                context_ = new ContextMySQL(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            while ( ! t_dataunit_parsing_complete && flow_buffer_->ready() ) {
                const_byteptr t_begin_of_data = flow_buffer()->begin();
                const_byteptr t_end_of_data = flow_buffer()->end();
                t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
                if ( t_dataunit_parsing_complete ) {
                }
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void MySQL_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void MySQL_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool MySQL_Flow::proc_mysql_initial_handshake_packet(Initial_Handshake_Packet* msg) {

		if ( mysql_server_version )
			{
			if ( msg->version() == 10 )
				zeek::BifEvent::enqueue_mysql_server_version(connection()->zeek_analyzer(),
				                                       connection()->zeek_analyzer()->Conn(),
				                                       zeek::make_intrusive<zeek::StringVal>(c_str(msg->handshake10()->server_version())));
			if ( msg->version() == 9 )
				zeek::BifEvent::enqueue_mysql_server_version(connection()->zeek_analyzer(),
				                                       connection()->zeek_analyzer()->Conn(),
				                                       zeek::make_intrusive<zeek::StringVal>(c_str(msg->handshake9()->server_version())));
			}

		if ( mysql_auth_plugin )
			{
			if ( msg->version() == 10 && (msg->handshake10()->capability_flags_2() << 16) & CLIENT_PLUGIN_AUTH )
				{
				auto auth_plugin = zeek::make_intrusive<zeek::StringVal>(c_str(msg->handshake10()->auth_plugin()));
				auto data_part_1 = msg->handshake10()->auth_plugin_data_part_1();
				auto data_part_2 = msg->handshake10()->auth_plugin_data_part_2();
				std::vector<zeek::data_chunk_t> data_parts = {
					zeek::data_chunk_t{data_part_1.length(), reinterpret_cast<const char*>(data_part_1.begin())},
					zeek::data_chunk_t{data_part_2.length(), reinterpret_cast<const char*>(data_part_2.begin())},
				};
				auto data = zeek::make_intrusive<zeek::StringVal>(zeek::concatenate(data_parts));

				zeek::BifEvent::enqueue_mysql_auth_plugin(connection()->zeek_analyzer(),
				                                          connection()->zeek_analyzer()->Conn(),
				                                          false /*is_orig*/,
				                                          std::move(auth_plugin),
				                                          std::move(data));
				}
			}

		return true;
		
}

bool MySQL_Flow::proc_mysql_handshake_response_packet(Handshake_Response_Packet* msg) {

		if ( msg->version() == 9 || msg->version() == 10 )
			connection()->zeek_analyzer()->AnalyzerConfirmation();

		// If the client requested SSL and didn't provide credentials, switch to SSL
		if ( msg->version() == 10 && ( msg->v10_response()->cap_flags() & CLIENT_SSL ))
			{
			connection()->zeek_analyzer()->StartTLS();

			if ( mysql_ssl_request )
				zeek::BifEvent::enqueue_mysql_ssl_request(connection()->zeek_analyzer(),
				                                          connection()->zeek_analyzer()->Conn());
			return true;
			}

		if ( mysql_handshake )
			{
			if ( msg->version() == 10 )
				zeek::BifEvent::enqueue_mysql_handshake(connection()->zeek_analyzer(),
				                                  connection()->zeek_analyzer()->Conn(),
				                                  zeek::make_intrusive<zeek::StringVal>(c_str(msg->v10_response()->plain()->credentials()->username())));
			if ( msg->version() == 9 )
				zeek::BifEvent::enqueue_mysql_handshake(connection()->zeek_analyzer(),
				                                  connection()->zeek_analyzer()->Conn(),
				                                  zeek::make_intrusive<zeek::StringVal>(c_str(msg->v9_response()->username())));
			}

		if ( mysql_auth_plugin )
			{
			if ( msg->version() == 10 && msg->v10_response()->plain()->cap_flags() & CLIENT_PLUGIN_AUTH )
				{
				auto auth_plugin = zeek::make_intrusive<zeek::StringVal>(c_str(msg->v10_response()->plain()->auth_plugin()));
				auto data = to_stringval(msg->v10_response()->plain()->credentials()->password()->val());
				zeek::BifEvent::enqueue_mysql_auth_plugin(connection()->zeek_analyzer(),
				                                          connection()->zeek_analyzer()->Conn(),
				                                          true /*is_orig*/,
				                                          std::move(auth_plugin),
				                                          std::move(data));
				}
			}

		return true;
		
}

bool MySQL_Flow::proc_mysql_command_request_packet(Command_Request_Packet* msg) {

		if ( mysql_command_request )
			{
			auto arg = to_stringval(msg->arg());

			// CHANGE_USER will have parsed away the arg,
			// restore it for backwards compat.
			if ( msg->command() == COM_CHANGE_USER )
				arg = to_stringval(msg->change_user()->sourcedata());

			zeek::BifEvent::enqueue_mysql_command_request(connection()->zeek_analyzer(),
			                                        connection()->zeek_analyzer()->Conn(),
			                                        msg->command(),
			                                        std::move(arg));
			}

		return true;
		
}

bool MySQL_Flow::proc_mysql_change_user_packet(Change_User_Packet* msg) {

		if ( mysql_change_user )
			zeek::BifEvent::enqueue_mysql_change_user(connection()->zeek_analyzer(),
			                                          connection()->zeek_analyzer()->Conn(),
			                                          zeek::make_intrusive<zeek::StringVal>(c_str(msg->username())));

		if ( mysql_auth_plugin )
			{
			auto data = to_stringval(msg->auth_plugin_data());
			auto auth_plugin = zeek::val_mgr->EmptyString();
			if ( msg->have_more_data() )
				auth_plugin = zeek::make_intrusive<zeek::StringVal>(c_str(msg->auth_plugin_name()));

			zeek::BifEvent::enqueue_mysql_auth_plugin(connection()->zeek_analyzer(),
								  connection()->zeek_analyzer()->Conn(),
								  true /*is_orig*/,
								  std::move(auth_plugin),
								  std::move(data));
			}

		return true;
		
}

bool MySQL_Flow::proc_err_packet(ERR_Packet* msg) {

		if ( mysql_error )
			zeek::BifEvent::enqueue_mysql_error(connection()->zeek_analyzer(),
			                              connection()->zeek_analyzer()->Conn(),
			                              msg->code(),
			                              to_stringval(msg->msg()));
		return true;
		
}

bool MySQL_Flow::proc_ok_packet(OK_Packet* msg) {

		if ( mysql_ok )
			zeek::BifEvent::enqueue_mysql_ok(connection()->zeek_analyzer(),
			                           connection()->zeek_analyzer()->Conn(),
			                           msg->rows());
		return true;
		
}

bool MySQL_Flow::proc_eof_packet(EOF_Packet* msg) {

		if ( mysql_eof )
			zeek::BifEvent::enqueue_mysql_eof(connection()->zeek_analyzer(),
			                                  connection()->zeek_analyzer()->Conn(),
			                                  msg->typ() == EOF_INTERMEDIATE);
		return true;
		
}

bool MySQL_Flow::proc_resultset(Resultset* msg) {

		if ( msg->is_eof_or_ok() )
			return true;  // Raised through proc_eof_packet() or proc_ok_packet()

		if ( ! mysql_result_row )
			return true;

		auto vt = zeek::id::string_vec;
		auto vv = zeek::make_intrusive<zeek::VectorVal>(std::move(vt));

		auto& bstring = msg->row()->first_field()->val();
		auto ptr = reinterpret_cast<const char*>(bstring.data());
		vv->Assign(vv->Size(), zeek::make_intrusive<zeek::StringVal>(bstring.length(), ptr));

		auto& fields = *msg->row()->fields();

		for ( auto& f : fields )
			{
			auto& bstring = f->val();
			auto ptr = reinterpret_cast<const char*>(bstring.data());
			vv->Assign(vv->Size(), zeek::make_intrusive<zeek::StringVal>(bstring.length(), ptr));
			}

		zeek::BifEvent::enqueue_mysql_result_row(connection()->zeek_analyzer(),
		                                   connection()->zeek_analyzer()->Conn(),
		                                   std::move(vv));

		return true;
		
}

bool MySQL_Flow::proc_auth_switch_request(AuthSwitchRequest* msg) {

		zeek::BifEvent::enqueue_mysql_auth_switch_request(connection()->zeek_analyzer(),
		                                                  connection()->zeek_analyzer()->Conn(),
		                                                  zeek::make_intrusive<zeek::StringVal>(c_str(msg->name())),
		                                                  to_stringval(msg->data()));
		return true;
		
}

bool MySQL_Flow::proc_auth_more_data(AuthMoreData* msg) {

		zeek::BifEvent::enqueue_mysql_auth_more_data(connection()->zeek_analyzer(),
		                                             connection()->zeek_analyzer()->Conn(),
		                                             is_orig(),
		                                             to_stringval(msg->data()));
		return true;
		
}

} // namespace MySQL
}  // namespace binpac
