// This file was automatically generated by bifcl from /build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif (plugin mode).


#include "functions.bif.h"
#include "zeek/Func.h"


#line 1 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"

#include "zeek/Reporter.h"

// Like toupper(), but avoid potential for locale-dependence.
static char netbios_toupper(char c)
	{
	if ( c >= 'a' && c <= 'z' )
		return c - 32;
	return c;
	}

#line 23 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"
zeek::ValPtr zeek::BifFunc::decode_netbios_name_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 24 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"
{
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("decode_netbios_name() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::StringVal* name = (zeek::StringVal*) ((*BiF_ARGS)[0].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 24 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"

	if ( name->Len() != 32 )
		return val_mgr->EmptyString();

	unsigned char buf[16];
	const u_char* s = name->Bytes();
	int length = 0;

	int j = 0;
	for ( int i = 0; i < 16; ++i ) // NOLINT(modernize-loop-convert)
		{
		char c0 = netbios_toupper(s[j++]);
		char c1 = netbios_toupper(s[j++]);

		if ( c0 < 'A' || c0 > 'P' || c1 < 'A' || c1 > 'P' )
			return val_mgr->EmptyString();

		buf[i] = ((c0 - 'A') << 4) + (c1 - 'A');

		if ( isalnum(buf[i]) || ispunct(buf[i]) || buf[i] == ' ' ||
		     // \x01\x02 is seen in at least one case as the first two bytes.
		     // I think that any \x01 and \x02 should always be passed through.
		     buf[i] < 3 )
			++length;
		else
			break;
		}


	// The 16th byte indicates the suffix/type, so don't include it
	if ( length == 16 )
		length = 15;

	// Walk back and remove any trailing spaces or nulls
	for ( ; ; )
		{
		if ( length == 0 )
			return val_mgr->EmptyString();

		auto c = buf[length - 1];

		if ( c != ' ' && c != 0 )
			break;

		--length;
		}

	return zeek::make_intrusive<zeek::StringVal>(length, reinterpret_cast<const char *>(buf));
	} // end of BifFunc::decode_netbios_name

#line 72 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"

#line 82 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"
zeek::ValPtr zeek::BifFunc::decode_netbios_name_type_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 83 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"
{
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("decode_netbios_name_type() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::StringVal* name = (zeek::StringVal*) ((*BiF_ARGS)[0].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 83 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"

	if ( name->Len() != 32 )
		return val_mgr->Count(256);

	const u_char* s = name->Bytes();

	for ( auto i = 0; i < 32; ++i )
		{
		char c = netbios_toupper(s[i]);

		if ( c < 'A' || c > 'P' )
			return val_mgr->Count(256);
		}

	char c0 = toupper(s[30]);
	char c1 = toupper(s[31]);
	char return_val = ((c0 - 'A') << 4) + (c1 - 'A');
	return zeek::val_mgr->Count(return_val);
	} // end of BifFunc::decode_netbios_name_type

#line 101 "/build/zeek/src/zeek/src/analyzer/protocol/netbios/functions.bif"
